#ifndef __UNZERR
#define __UNZERR

/* Error return values.  The values 0..4 and 12..18 follow the conventions
   of PKZIP.   The values 4..10 are all assigned to "insufficient memory"
   by PKZIP, so the codes 5..10 are used here for other purposes. */

#define ZE_MISS         -1      /* used by procname(), zipbare() */
#define ZE_OK           0       /* success */
#define ZE_EOF          2       /* unexpected end of zip file */
#define ZE_FORM         3       /* zip file structure error */
#define ZE_MEM          4       /* out of memory */
#define ZE_LOGIC        5       /* internal logic error */
#define ZE_BIG          6       /* entry too large to split */
#define ZE_NOTE         7       /* invalid comment format */
#define ZE_TEST         8       /* zip test (-T) failed or out of memory */
#define ZE_ABORT        9       /* user interrupt or termination */
#define ZE_TEMP         10      /* error using a temp file */
#define ZE_READ         11      /* read or seek error */
#define ZE_NONE         12      /* nothing to do */
#define ZE_NAME         13      /* missing or empty zip file */
#define ZE_WRITE        14      /* error writing to a file */
#define ZE_CREAT        15      /* couldn't open to write */
#define ZE_PARMS        16      /* bad command line */
#define ZE_OPEN         18      /* could not open a specified file to read */

#ifdef NO_UNZPRIV
#define PK_OK             0    /* no error */
#define PK_COOL           0    /* no error */
#define PK_GNARLY         0    /* no error */
#define PK_WARN           1    /* warning error */
#define PK_ERR            2    /* error in zipfile */
#define PK_BADERR         3    /* severe error in zipfile */
#define PK_MEM            4    /* insufficient memory */
#define PK_MEM2           5    /* insufficient memory */
#define PK_MEM3           6    /* insufficient memory */
#define PK_MEM4           7    /* insufficient memory */
#define PK_MEM5           8    /* insufficient memory */
#define PK_NOZIP          9    /* zipfile not found */
#define PK_PARAM          10   /* bad or illegal parameters specified */
#define PK_FIND           11   /* no files found */
#define PK_DISK           50   /* disk full */
#define PK_EOF            51   /* unexpected EOF */
#endif

#ifdef NO_CONSTS
char Far CentSigMsg[] =
  "error:  expected central file header signature not found (file #%u).\n";

char Far EndSigMsg[] = "\nnote:\
  didn't find end-of-central-dir signature at end of central dir.\n";

char Far SeekMsg[] =
  "error [%s]:  attempt to seek before beginning of zipfile\n%s";

char Far FilenameNotMatched[] = "caution: filename not matched:  %s\n";

char Far ExclFilenameNotMatched[] =
  "caution: excluded filename not matched:  %s\n";
#endif

#endif
