/* Port of util.c in ZIPDLL  I didn't like the MATCH.C for unzip. */
/* Eric W. Engler, Mar 5, 1997 */
/* match() is the function that we want, the rest is support. */
/* iswild() is also used from outside this module. */

// #define TEST_MODULE

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#include "unzip.h"

/* case mapping functions. case_map is used to ignore case in comparisons */
#define case_map(c) upper[(c) & 0xff]

/* Country-dependent case map table */
unsigned char upper[256], lower[256];

/* Local functions */
int recmatch (unsigned char *, unsigned char *);
int shmatch (unsigned char *, unsigned char *);
int count_args (char *);
char *isshexp(char *);
void init_upper(void);


/* EWE NOTE: a shell expression is just a wildcard for fspec */
/* If p is a sh expression, a pointer to the first special 
   character is returned.  Otherwise, NULL is returned. */
char *isshexp(char *p)
{
  for ( ; *p; p++)
    if (*p == '\\' && *(p+1))
      p++;
    else if (*p == '?' || *p == '*' || *p == '[')   /* unix/dos wildcards */
      return p;
  return NULL;  /* no wildcards found */
}

int iswild(p)   
    char *p;    
{ 
    for (; *p; ++p)
       {
       if (*p == '\\' && *(p+1))
          ++p;
       else if (*p == '?' || *p == '*' || *p == '[')
          return TRUE;
       }
    return FALSE;
} /* end function iswild() */

/* Recursively compare the sh pattern p, with the string s,
   and return 1 if they match, and 0 or 2 if they don't (or if 
   there is a syntax error in the pattern).  This routine 
   recurses on itself no deeper than the number of characters
   in the pattern. */
int recmatch(p, s)
unsigned char *p;    /* sh pattern to match (ex: *.*) */
unsigned char *s;    /* string to match it to (ex: FNAME.DAT) */
{
  unsigned int c;       /* pattern char or start of range in [-] loop */

  /* Get first character, the pattern for new recmatch calls follows */
  c = *p++;

  /* If that was the end of the pattern, match if string empty too */
  if (c == 0)
    return *s == 0;

  /* '?' matches any character (but not an empty string) */
  if (c == '?')
    return *s ? recmatch(p, s + 1) : 0;

  /* '*' matches any number of characters, including no char's! */
  /* EWE: todo: for MS-DOS/Win make sure it won't match period! */
  if (c == '*')
  {
    if (*p == 0)
      return 1;
    for ( ; *s; s++)
      if ((c = recmatch(p, s)) != 0)
        return (int)c;
    return 2;           /* 2 means give up--shmatch will return false */
  }

  /* If escape ('\'), just compare next character */
  if (c == '\\')
    if ((c = *p++) == 0)        /* if \ at end, then syntax error */
      return 0;

  /* Just a character--compare it */
  return case_map(c) == case_map(*s) ? recmatch(p, ++s) : 0;
}


/* Compare the sh pattern p with the string s and return true(1) 
   if they match, false(0) if they don't or if there is a syntax
   error in the pattern. */
/* sample args:  p=*.*(fspec user wants)  s=TEST.DAT(next file in dir) */
int shmatch(p, s)
unsigned char *p;                /* sh pattern to match */
unsigned char *s;                /* string to match it to */
{
  int ret;

  ret=recmatch((unsigned char *) p, (unsigned char *) s) == 1;
  return(ret);
}


/* This is based on dosmatch() of ZIPDLL */
/* Break the pattern and string into name and extension parts and match
   each separately using shmatch(). */
int match(s, p, i)
char *s;                /* filename to match against wildcard pattern */
char *p;                /* dos wildcard pattern to match */
int i;                  /* ignore this param - always case insensitive*/
{
  char *p1, *p2;        /* pattern sections */
  char *s1, *s2;        /* string sections */
  int plen = strlen(p); /* length of pattern */
  int r, r1, r2;        /* result */

  init_upper();

  // EWE: convert MS-DOS slashes to Unix convention:
  for (p1=s; p1 < (s+strlen(s)); p1++)
      if (*p1 == '\\')
         *p1='/';
  for (p1=p; p1 < (p+strlen(p)); p1++)
      if (*p1 == '\\')
         *p1='/';

  Trace((stderr, "match comparing pat=%s to fname=%s", p, s));

  if ((p1 = malloc(plen + 1)) == NULL ||
      (s1 = malloc(strlen(s) + 1)) == NULL)
  {
    if (p1 != NULL)
      free((void *)p1);
    return 0;
  }
  strcpy(p1, p);  /* pattern to match */
  strcpy(s1, s);  /* string to match */

  /* is there a period in pattern? */
  if ((p2 = strrchr(p1, '.')) != NULL)
    *p2++ = '\0';  /* yes - wipe out extension */

  else if (plen && p1[plen - 1] == '*')  // if fname part ended in *
    p2 = "*";      /* put a zero in place of extension */

  else
    p2 = "";       /* no wild extension */

  /* is there a period in string? */
  if ((s2 = strrchr(s1, '.')) != NULL)
    *s2++ = '\0';
  else
    s2 = "";

  r1 = shmatch(p2, s2);
  r2 = shmatch(p1, s1);
  r = r1 && r2;

  Trace((stderr, "match done.  r1=%d   r2=%d", r1, r2));

  free((void *)p1);
  free((void *)s1);
  return r;
}


void init_upper(void)
{
  int c;

  for (c = 0; c < sizeof(upper); c++) upper[c] = lower[c] = c;
  for (c = 'a'; c <= 'z';        c++) upper[c] = c - 'a' + 'A';
  for (c = 'A'; c <= 'Z';        c++) lower[c] = c - 'A' + 'a';
}



#ifdef TEST_MODULE
#define put(s) {fputs(s,stdout); fflush(stdout);}

void main(void)
{
    char pat[256], str[256];

    for (;;) {
        put("Wildcard Pattern (return to exit): ");
        gets(pat);
        if (!pat[0])
           break;
        for (;;) {
           put("String (return for new pattern): ");
           gets(str);
           if (!str[0])
              break;
           printf("Resulting match: %s\n\n",
              match(pat, str) ? "YES" : "NO");
        } /* end for */
    } /* end for */
}
#endif
