/* Modified Version for Delphi project, Eric W. Engler, Mar 5, 1997.
   I'm not using the unzip LIST functionality, so I took it out.
   The stuff still in this file is needed, anyway. */
/*---------------------------------------------------------------------------
  list.c
  This file contains the non-ZipInfo-specific listing routines for UnZip.
  Contains:  list_files()
             ratio()
             fnprint()
  ---------------------------------------------------------------------------*/
#define UNZIP_INTERNAL
#include "unzip.h"
#include <windows.h>

// EWE: lots of confusing code removed

int list_files(__G)    /* return PK-type error code */
    __GDEF
{  // dummy function
   return 0;
}

#ifdef TIMESTAMP
/*************************/
/* Function time_stamp() */
/*************************/
int time_stamp(__G)    /* return PK-type error code */
    __GDEF
{
    int do_this_file=FALSE, error, error_in_archive=PK_COOL;
#if (defined(USE_EF_UX_TIME) || defined(UNIX))
    ztimbuf z_utime;
#endif
    time_t last_modtime=0L;   /* assuming no zipfile data older than 1970 */
    ush j, members=0;
    min_info info;

/*---------------------------------------------------------------------------
    Unlike extract_or_test_files() but like list_files(), this function works
    on information in the central directory alone.  Thus we have a single,
    large loop through the entire directory, searching for the latest time
    stamp.
  ---------------------------------------------------------------------------*/
    G.pInfo = &info;
    for (j = 0; j < G.ecrec.total_entries_central_dir; ++j) {

        if (readbuf(__G__ G.sig, 4) == 0)
            return PK_EOF;
        if (strncmp(G.sig, G.central_hdr_sig, 4)) {  /* just to make sure */
            Info(slide, 0x401, ((char *)slide, LoadFarString(CentSigMsg), j));
            Info(slide, 0x401, ((char *)slide, LoadFarString(ReportMsg)));
            return PK_BADERR;
        }
        /* process_cdir_file_hdr() sets pInfo->lcflag: */
        if ((error = process_cdir_file_hdr(__G)) != PK_COOL)
            return error;       /* only PK_EOF defined */
        if ((error = do_string(__G__ G.crec.filename_length, DS_FN)) != PK_OK)
        {        /*  ^-- (uses pInfo->lcflag) */
            error_in_archive = error;
            if (error > PK_WARN)   /* fatal:  can't continue */
                return error;
        }
        if (G.extra_field != (uch *)NULL) {
            free(G.extra_field);
            G.extra_field = (uch *)NULL;
        }
        if ((error = do_string(__G__ G.crec.extra_field_length, EXTRA_FIELD))
            != 0)
        {
            error_in_archive = error;
            if (error > PK_WARN)      /* fatal */
                return error;
        }
        if (!G.process_all_files) {   /* check if specified on command line */
            char **pfn = G.pfnames-1;

            do_this_file = FALSE;
            while (*++pfn)
                if (match(G.filename, *pfn, G.C_flag)) {
                    do_this_file = TRUE;
                    break;       /* found match, so stop looping */
                }
            if (do_this_file) {  /* check if this is an excluded file */
                char **pxn = G.pxnames-1;

                while (*++pxn)
                    if (match(G.filename, *pxn, G.C_flag)) {
                        do_this_file = FALSE;  /* ^-- ignore case in match */
                        break;
                    }
            }
        }

        /* If current file was specified on command line, or if no names were
         * specified, check the time for this file.  Either way, get rid of the
         * file comment and go back for the next file.
         */
        if (G.process_all_files || do_this_file) {
#ifdef USE_EF_UX_TIME
            if (G.extra_field && ef_scan_for_izux(G.extra_field,
                G.crec.extra_field_length, &z_utime, NULL) > 0)
            {
                if (last_modtime < z_utime.modtime)
                    last_modtime = z_utime.modtime;
            } else
#endif /* USE_EF_UX_TIME */
            {
                time_t modtime = dos_to_unix_time(G.crec.last_mod_file_date,
                                                  G.crec.last_mod_file_time);

                if (last_modtime < modtime)
                    last_modtime = modtime;
            }
            ++members;
        }
        SKIP_(G.crec.file_comment_length)

    } /* end for-loop (j: files in central directory) */

/*---------------------------------------------------------------------------
    Set the modification (and access) time on the zipfile, assuming we have
    a modification time to set.
  ---------------------------------------------------------------------------*/
    if (members > 0) {
        z_utime.modtime = z_utime.actime = last_modtime;
        if (utime(G.zipfn, &z_utime))
            Info(slide, 0x201, ((char *)slide,
              "warning:  can't set time for %s\n", G.zipfn));
    }

/*---------------------------------------------------------------------------
    Double check that we're back at the end-of-central-directory record.
  ---------------------------------------------------------------------------*/
    if (readbuf(__G__ G.sig, 4) == 0)
        return PK_EOF;
    if (strncmp(G.sig, G.end_central_sig, 4)) {     /* just to make sure again */
        Info(slide, 0x401, ((char *)slide, LoadFarString(EndSigMsg)));
        error_in_archive = PK_WARN;
    }
    if (members == 0 && error_in_archive <= PK_WARN)
        error_in_archive = PK_FIND;
    return error_in_archive;
} /* end function time_stamp() */
#endif /* TIMESTAMP */

/********************/
/* Function ratio() */    /* also used by ZipInfo routines */
/********************/
int ratio(uc, c)
    ulg uc, c;
{
    ulg denom;

    if (uc == 0)
        return 0;
    if (uc > 2000000L) {    /* risk signed overflow if multiply numerator */
        denom = uc / 1000L;
        return ((uc >= c) ?
            (int) ((uc-c + (denom>>1)) / denom) :
          -((int) ((c-uc + (denom>>1)) / denom)));
    } else {             /* ^^^^^^^^ rounding */
        denom = uc;
        return ((uc >= c) ?
            (int) ((1000L*(uc-c) + (denom>>1)) / denom) :
          -((int) ((1000L*(c-uc) + (denom>>1)) / denom)));
    }                            /* ^^^^^^^^ rounding */
}

/************************/
/*  Function fnprint()  */    /* also used by ZipInfo routines */
/************************/
void fnprint(__G)    /* print filename (after filtering) and newline */
    __GDEF
{
    char *name = fnfilter(G.filename, slide);

    Trace((stderr,"%s", name));
} /* end function fnprint() */
