unit Tracking_Form;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TTrackingForm = class(TForm)
    Panel1: TPanel;
    T_info_box: TMemo;
    Panel2: TPanel;
    Label1: TLabel;
    Tr_X: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Tr_Y: TLabel;
    Tr_Z: TLabel;
    Tr_P: TLabel;
    T_extended: TCheckBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure T_extendedClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TrackingForm: TTrackingForm;

implementation

uses Main_form;

{$R *.DFM}

procedure TTrackingForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  CAD_Demo_Form.Track_mouse.checked := false;
end;

procedure TTrackingForm.T_extendedClick(Sender: TObject);
begin
  if T_extended.checked then begin
    Width := 312;
    T_info_box.visible := true;
  end else begin
    Width  := 128;
    Height := 112;
    T_info_box.visible := false;
  end;
end;

procedure TTrackingForm.FormShow(Sender: TObject);
const
  t = 16;
  ts : array[0..2] of integer = (32,32+t,32+t+t);
begin
  SendMessage(T_info_box.handle,EM_SetTabStops,3,integer(@ts));
end;

end.
