unit Main_form;

interface

uses
  { Borland }
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, ComCtrls, Math, Clipbrd,
  { Mine }
  ThinkBox, Zoomer, DXF_Structs, DXF_Utils, DXF_read, DXF_write;

type
  TCAD_Demo_Form = class(TForm)
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    LoadButton: TButton;
    SaveDialog1: TSaveDialog;
    Zoombox: Zoom_panel;
    Panel10: TPanel;
    Panel5: TPanel;
    Files_listbox: TListBox;
    Panel6: TPanel;
    Label3: TLabel;
    Label4: TLabel;
    Panel9: TPanel;
    Label1: TLabel;
    vert_lab: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    line_lab: TLabel;
    polyo_lab: TLabel;
    polyc_lab: TLabel;
    SaveButton: TButton;
    CopyClipButton: TButton;
    Panel3: TPanel;
    Repaint_button: TButton;
    Thick_lines: TCheckBox;
    draw_vertices: TCheckBox;
    Fill_closed: TCheckBox;
    Panel15: TPanel;
    delete: TButton;
    Track_mouse: TCheckBox;
    Track_timer: TTimer;
    C_remove_layers: TCheckBox;
    Panel2: TPanel;
    Messages: TListBox;
    Panel4: TPanel;
    Memo1: TMemo;
    procedure LoadButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Repaint_buttonClick(Sender: TObject);
    procedure ZoomboxPaint(Sender: TObject);
    procedure Files_listboxKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Files_listboxKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Files_listboxMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SaveButtonClick(Sender: TObject);
    procedure deleteClick(Sender: TObject);
    procedure CopyClipButtonClick(Sender: TObject);
    procedure Track_mouseClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Track_timerTimer(Sender: TObject);
    procedure ZoomboxMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Useful stuff fetched from DXF file }
    DXF_main    : DXF_Object;
    emax,emin   : Point3D;
    AspectRatio : double;
    { Bookkeeping }
    directory        : string;
    data_dir         : string;
    database_loaded  : boolean;
    { Mouse input }
    mouseX,mouseY    : integer;
    selection        : selection_lists;
    { Tracking }
    highlight_obj    : DXF_Entity;
    highlight_point  : Point3D;

    procedure read_dxf_file(name:string);
    procedure refresh_listbox(SelectAll:boolean);
    procedure update_selection;
  end;

var
  CAD_Demo_Form: TCAD_Demo_Form;

implementation

uses
  Tracking_Form;

{$R *.DFM}

function max(a,b:integer):integer; begin if a>b then result :=a else result:=b; end;
function min(a,b:integer):integer; begin if a>b then result :=b else result:=a; end;

procedure TCAD_Demo_Form.FormCreate(Sender: TObject);
begin
  directory        := ExtractFilePath(Application.Exename);
  data_dir         := directory +'data\';
  database_loaded  := false;
  selection        := selection_lists.create;
  emax.x           := -1E10;
  emax.y           := -1E10;
  emin.x           :=  1E10;
  emin.y           :=  1E10;
end;

procedure TCAD_Demo_Form.FormDestroy(Sender: TObject);
begin
  selection.Free;
end;

procedure TCAD_Demo_Form.read_dxf_file(name:string);
begin
  if DXF_main=nil then begin
    DXF_main    := DXF_Object.Create_from_file(name,messages.Items);
    emax        := DXF_main.get_max_extent;
    emin        := DXF_main.get_min_extent;
    AspectRatio := DXF_main.AspectRatio;
  end else showmessage('This version only handles a single file at a time');
end;

procedure TCAD_Demo_Form.LoadButtonClick(Sender: TObject);
var lp1 : integer;
begin
  OpenDialog1.InitialDir := data_dir;
  if not OpenDialog1.Execute then exit;
  if not fileexists(OpenDialog1.Filename) then begin
    showmessage('File not found'); exit;
  end;
  repaint;
  if      opendialog1.filterindex=1 then read_dxf_file(OpenDialog1.Filename);
  database_loaded := true;
  refresh_listbox(true);
  Zoombox.set_parameters(emin.x,emax.x,emin.y,emax.y, 20,20,AspectRatio);
  Zoombox.ClientArea.repaint;
end;

procedure TCAD_Demo_Form.Repaint_buttonClick(Sender: TObject);
begin
  Zoombox.ClientArea.repaint;
end;

procedure TCAD_Demo_Form.ZoomboxPaint(Sender: TObject);
var lp0        : integer;
    data_list  : Entity_List;
    metafile   : TMetaFile;
    metaCanvas : TMetaFileCanvas;
    drawcanvas : TCanvas;
begin
  if (sender = CopyClipButton) then begin
    metafile        := TMetaFile.Create;
    metafile.Height := Zoombox.ClientArea.height;
    metafile.width  := Zoombox.ClientArea.width;
    metaCanvas      := TMetafileCanvas.Create(metafile, 0);
    drawcanvas      := metaCanvas;
  end
  else drawcanvas := Zoombox.ClientArea.Canvas;

  drawcanvas.Font.name := 'FF_ROMAN';
  if Thick_lines.checked then drawcanvas.Pen.Width := 3
  else drawcanvas.Pen.Width := 1;
  drawcanvas.Pen.Color := clBlack;
  if Fill_closed.checked then begin
    drawcanvas.Brush.Style := bsSolid;
    drawcanvas.Brush.Color := clBlack;
  end
  else drawcanvas.Brush.Style := bsClear;

  for lp0:=0 to Files_listbox.Items.Count-1 do begin
    if (not Files_listbox.Selected[lp0]) then continue;
    if Files_listbox.Items.Objects[lp0] is Entity_List then begin
      data_list := Entity_List(Files_listbox.Items.Objects[lp0]);
      data_list.draw_primitives(drawcanvas,Zoombox.real_to_screen);
      if draw_vertices.checked then
        data_list.draw_vertices(drawcanvas,Zoombox.real_to_screen);
    end;
  end;
  if (sender = CopyClipButton) then begin
    metaCanvas.Free;
    ClipBoard.Assign(metafile);
    metafile.Destroy;
  end
end;

procedure TCAD_Demo_Form.Files_listboxKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if Key=VK_DELETE then deleteClick(nil);
end;

procedure TCAD_Demo_Form.refresh_listbox(SelectAll:boolean);
var lp1 : integer;
begin
  Files_listbox.Clear;
  if DXF_main<>nil then begin
    if C_remove_layers.Checked then DXF_main.remove_empty_layers_and_lists;
    DXF_main.copy_to_strings(Files_listbox.Items);
  end;
  if SelectAll then for lp1:=0 to Files_listbox.Items.count-1 do Files_listbox.Selected[lp1] := true;
  update_selection;
end;

procedure TCAD_Demo_Form.update_selection;
var lp1,vct,lct,pcto,pctc : integer;
begin
  vct := 0; lct := 0; pcto := 0; pctc := 0;
  selection.entity_lists.Clear;
  with Files_Listbox do begin
    for lp1:=Items.Count-1 downto 0 do with Items do begin
      if (Selected[lp1]) then begin
        if not (objects[lp1] is Entity_List) then Selected[lp1] := false
        else selection.entity_lists.Add(objects[lp1]);
      end;
    end;
    for lp1:=Items.Count-1 downto 0 do with Items do if Selected[lp1] then begin
      vct   :=   vct  + Entity_List(Objects[lp1]).count_points;
      lct   :=   lct  + Entity_List(Objects[lp1]).count_lines;
      pcto  :=   pcto + Entity_List(Objects[lp1]).count_polys_open;
      pctc  :=   pctc + Entity_List(Objects[lp1]).count_polys_closed;
    end;
  end;
  vert_lab.Caption  := IntToStr(vct);
  line_lab.Caption  := IntToStr(lct);
  polyo_lab.Caption := IntToStr(pcto);
  polyc_lab.Caption := IntToStr(pctc);
  // If data changes, we must clear the highlight_obj to prevent access violation
  highlight_obj     := nil;
  highlight_point   := aPoint3D(0,0,0);
end;

procedure TCAD_Demo_Form.Files_listboxKeyUp(Sender:TObject; var Key:Word; Shift:TShiftState);
begin
  update_selection;
end;

procedure TCAD_Demo_Form.Files_listboxMouseUp(Sender:TObject; Button:TMouseButton; Shift:TShiftState; X,Y:Integer);
begin
  update_selection;
end;

procedure TCAD_Demo_Form.SaveButtonClick(Sender: TObject);
var lp1   : integer;
    lists : TList;
    ft    : file_type;
begin
  if not SaveDialog1.Execute then exit;
  thinking(self,'Saving data');
  if SaveDialog1.filterindex=1 then begin
    if ExtractFileExt(SaveDialog1.Filename)<>'.dxf' then
      SaveDialog1.Filename := SaveDialog1.Filename +'.dxf';
    selection.save_to_DXF_file(SaveDialog1.FileName);
  end;
  stopped_thinking;
end;

procedure TCAD_Demo_Form.deleteClick(Sender: TObject);
var lp1 : integer;
begin
  with selection do
    for lp1:=0 to entity_lists.count-1 do
      DXF_Layer(Entity_list(entity_lists[lp1]).parent_layer).delete(Entity_list(entity_lists[lp1]).name,true);
  refresh_listbox(false);;
end;

procedure TCAD_Demo_Form.CopyClipButtonClick(Sender: TObject);
begin
  ZoomboxPaint(CopyClipButton);
end;

procedure TCAD_Demo_Form.Track_mouseClick(Sender: TObject);
begin
  if Track_mouse.checked then begin
    TrackingForm.Show;
    Track_timer.enabled := true;
  end
  else begin
    TrackingForm.Hide;
    Track_timer.enabled := false;
  end;
end;

procedure TCAD_Demo_Form.Track_timerTimer(Sender: TObject);
var p0        : Point2D;
    t         : TColor;
    old_obj   : DXF_Entity;
    old_point : Point3D;
begin
  if (not Track_mouse.checked) or (not database_loaded) then begin
    Track_timer.enabled := false;
    exit;
  end;
  old_obj   := highlight_obj;
  old_point := highlight_point;
  p0 := zoombox.screen_to_real(Point(mouseX,mouseY));
  highlight_point := selection.find_closest_2D_point(aPoint3D(p0.x,p0.y,0),highlight_obj);
  if (highlight_obj<>nil) and not p1_eq_p2_3D(highlight_point,old_point) then begin
    if old_obj<>nil then old_obj.draw(zoombox.clientarea.canvas,zoombox.real_to_screen);
    t := highlight_obj.colour;
    highlight_obj.colour := t XOR $00FFFFFF;
    highlight_obj.draw(zoombox.clientarea.canvas,zoombox.real_to_screen);
    highlight_obj.colour := t;
    with TrackingForm do begin
      Tr_X.Caption := FloatToStrF(highlight_point.x,ffGeneral,7,2);
      Tr_Y.Caption := FloatToStrF(highlight_point.y,ffGeneral,7,2);
      Tr_Z.Caption := FloatToStrF(highlight_point.z,ffGeneral,7,2);
      Tr_P.Caption := FloatToStr(highlight_obj.count_points);
      if T_extended.checked then T_info_box.Text := highlight_obj.details;
    end;
  end;
  // turn it off until the next mouse move
  Track_timer.enabled := false;
end;

procedure TCAD_Demo_Form.ZoomboxMouseMove(Sender:TObject; Shift:TShiftState; X,Y:Integer);
begin
  mouseX := X;
  mouseY := Y;
  if Track_mouse.checked then Track_timer.enabled := true;
end;

initialization
end.
