unit WSAPI;

{
    WSAPI support for Delphi 2.0
    Port by Paul Gallagher <paulpg@ozemail.com.au>
    Last updated 15-Aug-96

    This file is based on WSAPI.H (13-Apr-96). Note that I have included the
    original C source lines (commented out of course) for function calls so
    that you can examine the conversion.

    I have prefixed each C function call with either
      TESTED: meaning I have actually tested the Delphi version of the function
      UNTESTED: meaning I have written the conversion code but not tested it
      UNCONVERTED: not yet converted.
}

//========================================================================
// COPYRIGHT NOTICE:
//				Copyright (C) 1995, Robert B. Denny, Pasadena, California
//				All Rights Reserved
// PROPRIETARY RIGHTS NOTICE:
//				This source code is the property of Robert B. Denny of
//				Pasadena, California, and is furnished under license only.
//========================================================================
// TITLE:		WSAPI.H
//
// FACILITY:	WebSite Server for Windows NT and Windows 95
//
// ABSTRACT:	Definitions for WebSite Extension API (WSAPI)
//
// ENVIRONMENT:	WebSite 1.1 or later, WSAPI 0.1 (experimental)
//				Microsoft Windows Windows NT 3.5x, Windows 95
//				Developed under Microsoft Visual C++ Version 2.2
//
// AUTHOR:		Robert B. Denny
//
// Edit Log:
//
// When			Who		What
//----------	---		--------------------------------------------------
// 25-Aug-95	rbd		Initial edit
// 07-Sep-95	rbd		Remove useless routines, add new ones, rev minor
// 09-Sep-95	rbd		Name changes, rev minor version to 3
// 11-Sep-95	rbd		Add user_1, user_2, and S-HTTP fields to TCTX
//						rev minor version to 4.
// 19-Sep-95	rbd		Exposed RNG functions
// 26-Sep-95	rbd		Add port number to TCTX, define CONST to supress
//						in C++, add C++ wrappers, change name of socket
// 28-Sep-95	rbd		Export S-HTTP cert/key initializer callback, add
//						new S-HTTP op-code for request header cleanup.
//						Add CN and certificate for this identity to TCTX
//						Rev minor to 6.
// 11-Oct-95	rbd		Comment changes, change interface to url_to_file()
//						Rev minor to 7.
// 13-Oct-95	rbd		Expose evaluate_access(), rev to 8.
// 17-Oct-95	rbd		Add tp->params for byte range support. Rev to 9.
// 09-Nov-95	rbd		Add keep_alive to TCTX, rev 11
// 12-Nov-95	rbd		Enlarge content type/encoding in TCB/TCTX -> rev12
// 16-Nov-95	rbd		New byte ranging, changes to TCTX -> rev 13
// 02-Dec-95	rbd		Promote User-Agent to TCTX -> rev 14
// 15-Dec-95	rbd		Expand tp->params, tp->request_range to MAX size.
//						Adobe Amber generates large range requests. ->15
// 16-Feb-96	rbd		VC++ 4.0 -> 16
// 17-Feb-96	rbd		Back to Rev15 for SHTTP DLL
// 07-Mar-96	rbd		Add form decoder stuff
// 12-Mar-96	rbd		Exposed the MD5 routines. Version now 1.0
// 13-Apr-96	rbd		New get_server_variable(), Version 1.1
//========================================================================


interface

uses Sysutils, Windows;

{ supporting types not in WSAPI.H but needed in the Delphi version }
type
  LPVOID = Pointer;
  LPBYTE = PBYTE;
  PPBYTE = ^PBYTE;
  PDWORD = ^DWORD;
  HCONN = LPVOID;
  HANDLE = DWORD;
  SOCKET = DWORD;
  HINSTANCE = DWORD;
  T16Bytes = array[0..15] of BYTE;

// ===============
// VERSION CONTROL
// ===============		 |--->(in fact, don't edit this file at all!) (ha ha ha - paulg)
//			-----------------------------
// WARNING! DO NOT EDIT THESE DEFINITIONS! USE THEM IN THE
// CALL TO bind_wcgi(). IF YOU COMPILE YOUR HOOK WITH THIS
// HEADER FILE, IT HAS THE WSAPI VERSION INDICATED BELOW
//
Const
  MAJOR_VERSION	= 1;
  MINOR_VERSION = 1;

// ------
// Limits
// ------
Const
  MAX_TYPE_LEN = 64;				// Longest postproc content type
  MAX_PROC_DLLS = 32;				// Max # postprocessors
  MAX_NAME_LEN = 64;				// Longest CGI DLL name
  MAX_CGI_DLLS =32;				// MAX # CGI DLLs
  SML_STRING_LEN = 64 ;				// Small string buffer
  MED_STRING_LEN = 256 ;			// Medium string buffer
  MAX_STRING_LEN = 1024;			// Big string buffer
  HUGE_STRING_LEN = 8192 ;			// Very large string buffer
  MAX_EXT_HEADERS =100 ;			// Max extra request or CGI/1.1 headers


//-------------------
//	HTTP Result Codes
//-------------------
Const
  DOCUMENT_FOLLOWS=200;
  CREATED=201 ;
  ACCEPTED=202;
  PARTIAL_INFORMATION=203;
  NO_RESPONSE=204 ;
  DELETED=205 ;
  MODIFIED=206 ;
  MOVED=301 ;
  REDIRECT=302 ;
  USE_LOCAL_COPY=304;
  BAD_REQUEST=400;
  AUTH_REQUIRED=401 ;
  FORBIDDEN=403;
  NOT_FOUND=404;
  SERVER_ERROR=500;
  NOT_IMPLEMENTED=501;

//--------------------
//	Supported methods
//--------------------
//
// Numeric method codes used in some interfaces
//
Const
  M_GET=0;
  M_PUT=1;
  M_POST=2 ;
  M_DELETE=3;
  M_LINK=4;
  M_UNLINK=5;
  M_ANY=255;

//---------------
//	Object types
//---------------
//
// Returned by url_to_file()
//
Const
  REDIRECT_URL=	-1;
  STD_DOCUMENT=0;
  SCRIPT_DOS=1;		// Used as intfc parameter to exec_cgi_script
  SCRIPT_WIN=2;		// Used as intfc parameter to exec_cgi_script
  SCRIPT_SHELL=4;	// Used as intfc parameter to exec_cgi_script

// --------------------------------
// Authentication Hook Return Codes
// --------------------------------
Const
  AUTH_REJECT=0;		// Reject username/password
  AUTH_ACCEPT=1;		// Accept username/password
  AUTH_INTERNAL=2;		// Use internal authentication

//---------------------
//	Access option codes
//---------------------
Const
  SECOPT_OR_CLASS_USERS=1;			// "OR" logic for class/user access
  SECOPT_SSL_ONLY=1;					// Accessible via SSL only
  SECOPT_NO_BROWSE=1;				// Disable directory browsing

// ====================
// S-HTTP REQUEST CODES
// ====================
//
// Used in TCB to tell Terisa hook what to do
//
Const
  SHTTP_HANDLE_SECURE_METHOD = 1;
  SHTTP_PROCESS_REQUEST_HEADERS=2;
  SHTTP_HANDLE_SECURE_RESPONSE=3;
  SHTTP_TRANSACTION_CLEANUP=4;

// -----------
// FATAL Macro
// -----------
//
// Use this when you need to "bail out". It will generate
// an exception that will cause the server to alert and
// disable your hook DLL. Use it for "serious" errors that
// could compromise the DLL or the server. For "normal"
// errors, call the server-exported die() function or use
// the ABORT macro.
//
// UNCONVERTED: #define FATAL			RaiseException(0xE1000001, 0, 0, NULL)

// -----------
// ABORT Macro (UNCONVERTED)
// -----------
//
// Use this when you need to silently end the current request.
// Calling this will end the request, sending a TCP "reset"
// packet to the browser. It will not cause your DLL to be
// disabled.
//
// UNCONVERTED: #define ABORT			RaiseException(0xE100000F, 0, 0, NULL)

// ------------------------------------
// Message Digest 5 (MD5, see RFC 1321)
// ------------------------------------
type
  PMD5Context = ^MD5Context;
  MD5Context = packed record
    hash : array[0..3] of DWORD;
    bytes : array[0..1] of DWORD;
    input : array[0..15] of DWORD;
  end;

// ------------
// Form decoder
// ------------
type
  FORM_CTX = pointer;                   // Decoding context handle

type
  PFIELD = ^FIELD;
  FIELD = packed record                              // Field descriptor
    name : array[0..MED_STRING_LEN-1] of char;			// Field name
    data : PBYTE;							// -> field data
    len : DWORD;							// Field data length
    ctype : array[0..MED_STRING_LEN-1] of char;			// File content-type
    xftype : array[0..MED_STRING_LEN-1] of char;		// File content-transfer-encoding
    fname : array[0..MED_STRING_LEN-1] of char;			// Client's file name (file fields)
  end;

// -------------------------
// Extra header info in TCTX
// -------------------------
type
  xhdr = packed Record
    key : pointer;
    value : pointer;
  end;

//---------------------
//	Transaction Context
//---------------------
//
// This is the structure that holds all of the public
// per-transaction data
//

type
  PTCTX = ^TTCTX;
  TTCTX = packed Record

    link : pointer;					// Don't even THINK about this one
	//
	// Server Configuration
	//
    _hMainWnd : HWND;				// Server's Main window
    bService : BOOL;				// TRUE if running as NT service
    bTraceHook : BOOL;				// TRUE if want hook tracing
    temp_path : PChar;				// Path to server's temp directory
    server_version : PChar;			// Server's version string for headers
	//
	// Low-level
	//
    hSocket : SOCKET;  				// Client socket handle
    dwPort : DWORD;					// IP port for this request
    dwThreadID : DWORD;				// Current Thread ID
    dwStartTicks : DWORD;			// SystemTicks at thread start
    bSSL : BOOL;					// TRUE = Running on SSL
	//
	// Remote (client) identity
	//
    remote_host : PChar;			// Client's host name or NULL if not found
    remote_ip : PChar;				// Clients IP address (dotted quad)
    remote_name : PChar;			// Client's host name if found, else IP address
	//
	// Local (server) identity
	//
    local_name : PChar;				// Local (server) identity for multi-home
    url_prefix : PChar;				// Multi-home URL prefix
    local_CN : PChar;				// Local (server) cert Common Name (CN)
    cert : ^BYTE;			 	// Local (server) cert for this identity
    cert_len : DWORD;				// Length of local cert
	//
	// HTTP Request info - may be changed by pre/post processor
	//
    http_request : array[0..MED_STRING_LEN-1] of char;    // HTTP raw request line (1st 256 chars)
    http_09 : BOOL;					  // TRUE if HTTP/0.9 request
    method : array[0..SML_STRING_LEN-1] of char;	  // HTTP method
    url : array[0..MAX_STRING_LEN-1] of char;		  // HTTP URL (decoded)
    params : array[0..MAX_STRING_LEN-1] of char;	  // HTTP URL Parameters (';' delimited)
    args : array[0..MAX_STRING_LEN-1] of char;		  // HTTP arguments
    http_accept : array[0..MAX_STRING_LEN-1] of char;	  // HTTP "Accept" line
    if_mod_since : array[0..SML_STRING_LEN-1] of char;	  // HTTP "If-Modified-Since"
    request_range : array[0..MAX_STRING_LEN-1] of char;	  // HTTP "Request-Range"
    unl_mod_since : array[0..SML_STRING_LEN-1] of char;	  // HTTP "Unless-Modified-Since"
    referer : array[0..MAX_STRING_LEN-1] of char;	  // HTTP "Referer"
    from : array[0..MED_STRING_LEN-1] of char;		  // HTTP "From"
    user_agent : array[0..MED_STRING_LEN-1] of char;	  // HTTP "User-Agent"
    keep_alive : BOOL;					  // TRUE if request has Connection: Keep-Alive
	//
	// Access Control & Authentication	(HTTP "Authorization")
	//
    auth_line : array[0..MED_STRING_LEN-1] of char;     // "Authorization" line
    auth_type : PChar;					// "Authorization" type (strdup'd)
    auth_name : PChar;					// "Authorization" Realm (strdup'd)
    user : array[0..SML_STRING_LEN-1] of char;	   	// User name
    pass : array[0..SML_STRING_LEN-1] of char;	   	// Password
    allow_options : DWORD;				// Access options (SECOPT_ constants)
	//
	// Request content (if any), response content
	//
    content_length : longint;					// HTTP "Content-Length"
    content_type : array[0..MED_STRING_LEN-1] of char;		// HTTP "Content-Type"
    content_encoding : array[0..MED_STRING_LEN-1] of char;	// HTTP "Content-Encoding"
    location : array[0..MAX_STRING_LEN-1] of char;			// HTTP "Location"
    last_modified : array[0..SML_STRING_LEN-1] of char;		// HTTP "Last-Modified"
	//
	// Response status line
	//
    rsp_status : array[0..SML_STRING_LEN-1] of char;		// e.g., HTTP/1.0 200 OK
	//
	// Extra header tuples.
	//
    num_req_xhdr : longint;						// Number of request extra headers
    req_xhdr : array[0..MAX_EXT_HEADERS-1] of xhdr;			// Extra headers in request.
    num_rsp_xhdr : longint;						// Number of response extra headers
    rsp_xhdr : array[0..MAX_EXT_HEADERS-1] of xhdr;			// Extra headers for response.
	//
	// Authentication Info
	//
    user_to_check : array[0..SML_STRING_LEN-1] of char;	// Server checks this username
	//
	// Open file for response (postprocessing hooks only!)
	//
    hOutFile : HANDLE;
	//
	// Results (use only for logging!)
	//
    http_status : integer;				// HTTP/1.0 status code of trans.
    bytes : longint;					// #bytes sent, excluding header
	//
	// User contexts
	//
    user_1 : DWORD;
    user_2 : DWORD;
	//
	// S-HTTP support - RESERVED! DO NOT TOUCH!
	//
    bSHTTP : BOOL;						// TRUE = Is SHTTP transaction
    dwCryptRequest : DWORD;				// Terisa hook op-code (see defs above)
    TerisaCtx : pointer;					// Toolkit context pointer
    hUnwrappedReq : HANDLE; 				// Handle of unwrapped request in file
    hUnwrappedRsp : HANDLE;			// Handle of unwrapped response in file
  end;

// =========================
// SERVER_EXPORTED FUNCTIONS
// =========================
//
//
// Version binding
//
// TESTED: BOOL bind_wsapi(WORD major, WORD minor, BOOL strict);
function bind_wsapi(major, minor : WORD; strict : BOOL) : BOOL cdecl; external 'HTTPD32.EXE';

//
// URL <--> filespace mapping
//
// UNTESTED: int url_to_file(char *pathname, BOOL do_index, TCTX *tp);
function url_to_file(pathname : PChar; do_index : BOOL; tp : PTCTX): integer cdecl; external 'HTTPD32.EXE';
// UNTESTED: void file_to_url(char *pathname, TCTX *tp);
procedure file_to_url(pathname : PChar; tp : PTCTX) cdecl; external 'HTTPD32.EXE';

//
// Other URL operations
//
// UNTESTED: void construct_url(char *d, char *s, TCTX *tp);
procedure construct_url(d, s : PChar; tp : PTCTX) cdecl;  external 'HTTPD32.EXE';
// UNTESTED: BOOL normalize_url(char *path);
function  normalize_url(path : PChar) : BOOL cdecl; external 'HTTPD32.EXE';
// UNTESTED: void unescape_url(char *url);
procedure unescape_url(url : Pchar) cdecl; external 'HTTPD32.EXE';
// UNTESTED: void escape_url(char *url, TCTX *tp);
procedure escape_url(url : Pchar; tp : PTCTX) cdecl; external 'HTTPD32.EXE';
// UNTESTED: void plus_to_space(char *str);
procedure plus_to_space(str : Pchar) cdecl; external 'HTTPD32.EXE';
// UNTESTED: void space_to_plus(char *str);
procedure space_to_plus(str : Pchar) cdecl; external 'HTTPD32.EXE';
// UNTESTED: void evaluate_access(char *url, TCTX *tp);
procedure evaluate_access(url : Pchar; tp : PTCTX) cdecl; external 'HTTPD32.EXE';

//
// Content type
//
// UNTESTED: char *get_content_type(char *fn, TCTX *tp);
function get_content_type(fn : PChar; tp : PTCTX) : PChar cdecl; external 'HTTPD32.EXE';
// UNTESTED: void set_content_type(char *fn, TCTX *tp);
procedure set_content_type(fn : PChar; tp : PTCTX) cdecl; external 'HTTPD32.EXE';

//
// Response
//
// UNTESTED: void exec_cgi(char *m, char *file, char *args, int intfc, TCTX *tp);
procedure exec_cgi(m, sfile, args : PChar; intfc : integer; tp : PTCTX) cdecl; external 'HTTPD32.EXE';
// UNTESTED: void exec_cgi_to_file(char *m, char *file, char *args, int intfc, TCTX *tp);
procedure exec_cgi_to_file(m, sfile, args : PChar; intfc : integer; tp : PTCTX) cdecl; external 'HTTPD32.EXE';
// UNTESTED: void process_get(char *m, char *url, char *args, TCTX *tp);
procedure process_get(m, url, args : PChar; tp : PTCTX) cdecl; external 'HTTPD32.EXE';
// TESTED: void send_http_header(TCTX *tp, BOOL do_xhdr);
procedure send_http_header(tp : PTCTX; do_xhdr : BOOL) cdecl; external 'HTTPD32.EXE';
// UNTESTED: void do_imagemap(int method, char *map_name, char *coords, TCTX *tp);
procedure do_imagemap(method : integer; map_name, coords : Pchar; tp : PTCTX) cdecl; external 'HTTPD32.EXE';

//
// HTTP error handler (use above result code #defs)
//
// TESTED: void die(int http_status, char *string, TCTX *tp);
procedure die( http_status : longint; s : PChar; tp : PTCTX) cdecl; external 'HTTPD32.EXE';

//
// Network I/O
//
// TESTED: void nputs(char *buf, TCTX *tp);
procedure nputs(buf : PChar; tp : PTCTX) cdecl; external 'HTTPD32.EXE';
// TESTED: void nwrite(char *buf, int n, TCTX *tp);
procedure nwrite(buf : PChar; n : integer; tp : PTCTX) cdecl; external 'HTTPD32.EXE';
// UNTESTED: void nwritef(HANDLE hFile, DWORD dwStartPos, DWORD dwCount, TCTX *tp);
procedure nwritef(hFile : HANDLE;  dwStartPos, dwCount : DWORD; tp : PTCTX) cdecl; external 'HTTPD32.EXE';
// TESTED: void nflush(TCTX *tp);
procedure nflush(tp : PTCTX) cdecl; external 'HTTPD32.EXE';
// UNTESTED: void ngets(char *buf, int max, TCTX *tp);
procedure ngets(buf : PChar; max : integer;  tp : PTCTX) cdecl;  external 'HTTPD32.EXE';
// TESTED: void nread(char *buf, long nreq, TCTX *tp);
procedure nread(buf : PChar; nreq : longint; tp : PTCTX) cdecl; external 'HTTPD32.EXE';
// UNTESTED: void nreadf(HANDLE hFile, long nreq, TCTX *tp);
procedure nreadf(hFile : HANDLE; nreq : longint; tp : PTCTX) cdecl; external 'HTTPD32.EXE';

//
// Registry access
//
// UNCONVERTED: HKEY OpenRegKey(char *pszKey);
// UNCONVERTED: char *GetRegString(char *name, HKEY hKey);
// UNCONVERTED: DWORD GetRegBin(char *name, HKEY hKey);

//
// Form decoder
//
// TESTED: FORM_CTX open_form_decoder(BYTE *cont, DWORD clen, TCTX *tp);
function  open_form_decoder(cont : PBYTE; clen : DWORD; tp : PTCTX) : FORM_CTX cdecl; external 'HTTPD32.EXE';
// TESTED: void close_form_decoder(FORM_CTX ctx, TCTX *TP);
procedure close_form_decoder( ctx : FORM_CTX; tp : PTCTX) cdecl; external 'HTTPD32.EXE';
// TESTED: PFIELD decode_next_field(FORM_CTX ctx, TCTX *tp);
function  decode_next_field( ctx : FORM_CTX; tp : PTCTX) : PFIELD cdecl; external 'HTTPD32.EXE';

//
// Cryptographically Strong Random Number Generator
//
// UNTESTED: void TrueRandAddNoise(DWORD data);
procedure TrueRandAddNoise(data : DWORD) cdecl; external 'HTTPD32.EXE';
// UNTESTED: DWORD TrueRandEntropy(void);
function TrueRandEntropy : DWORD cdecl; external 'HTTPD32.EXE';
// UNTESTED: BYTE TrueRandGetByte(void);
function TrueRandGetByte : BYTE cdecl; external 'HTTPD32.EXE';
// UNTESTED: void TrueRandGetBytes(BYTE *buf, DWORD len);
procedure TrueRandGetBytes(buf : PBYTE; len : DWORD) cdecl;  external 'HTTPD32.EXE';

//
// MD5 Support
//
// UNTESTED: void MD5Init(MD5Context *context);
procedure MD5Init(context : PMD5Context) cdecl; external 'HTTPD32.EXE';
// UNTESTED: void MD5Update(MD5Context *context, BYTE *buf, DWORD len);
procedure MD5Update(context : PMD5Context; buf : PBYTE; len : DWORD) cdecl; external 'HTTPD32.EXE';
// UNTESTED: void MD5Final(BYTE digest[16], MD5Context *context);
procedure MD5Final(digest : T16Bytes; context : PMD5Context) cdecl; external 'HTTPD32.EXE';

//
// Utilities
//
// UNTESTED: BOOL later_than(char *t1, char *t2);
function later_than(t1, t2 : PChar ) : BOOL cdecl; external 'HTTPD32.EXE';
// UNCONVERTED: char *http_timestr(time_t t, char *buf, int len);
//function http_timestr(t : time_t; buf : PChar; len : integer) : PChar cdecl; external 'HTTPD32.EXE';
// TESTED: char *http_nt_timestr(LPSYSTEMTIME pst, char *buf, int len);
function http_nt_timestr(pst : PSystemTime; buf : PChar; len : integer) : PChar cdecl; external 'HTTPD32.EXE';
// UNTESTED: void get_temp_name(char *buf);
procedure get_temp_name(buf : PChar) cdecl; external 'HTTPD32.EXE';
// UNTESTED: void DbgDump (BYTE *buf, WORD len, char *label);
procedure DbgDump (buf : PBOOL; len : WORD; _label : PChar) cdecl; external 'HTTPD32.EXE';
// UNTESTED: void wsapi_log_event(HINSTANCE hInstance, char *message);
procedure wsapi_log_event( hInstance : HINSTANCE; _message : PChar) cdecl; external 'HTTPD32.EXE';
// TESTED: void *wsapi_malloc(long size, TCTX *tp);
function  wsapi_malloc(size : longint; tp : PTCTX) : pointer cdecl; external 'HTTPD32.EXE';
// UNTESTED: void *wsapi_realloc(void *ptr, long size, TCTX *tp);
function  wsapi_realloc(ptr : pointer; size : longint; tp : PTCTX) : pointer cdecl; external 'HTTPD32.EXE';
// UNTESTED: char *wsapi_strdup(char *str, TCTX *tp);
function  wsapi_strdup(str : Pchar; tp : PTCTX) : Pchar cdecl; external 'HTTPD32.EXE';
// TESTED: void wsapi_free(void *ptr);
procedure wsapi_free(ptr : pointer) cdecl; external 'HTTPD32.EXE';
// UNTESTED: BOOL get_server_variable(char *name, char *buf, DWORD size, TCTX *tp);
function  get_server_variable(name, buf : Pchar; size : DWORD; tp : PTCTX) : BOOL cdecl; external 'HTTPD32.EXE';

//
// S-HTTP only - Security initializer callback
//
// UNTESTED: void init_sec(BOOL(*get_cert_key)(char *cn, BYTE **cert, DWORD *cert_len,
//				BYTE **key, DWORD *key_len));
type
   get_cert_key_Function = Function(cn : PChar;
                                    cert : PPBYTE; cert_len : PDWORD;
                                    key : PPBYTE; key_len : PDWORD) : BOOL; cdecl;
procedure init_sec(get_cert_key : get_cert_key_Function); cdecl; external 'HTTPD32.EXE';

implementation

end.
