library unauth;
{
    This is a variant of the NOTFOUND example program included
    in the WSAPI developer's kit (as shipped with WebSite Pro).

    This is a custom error processor that specifically intercepts
    401 unauthorised access and provides a customised error page.

    Author: Paul Gallagher, 1997 <paulpg@ozemail.com.au>
}

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  View-Project Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the DELPHIMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using DELPHIMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
  SysUtils,
  Classes,
  Windows,
  Registry,
  WSAPI in '..\..\lib\WSAPI.pas';

function GetResponseBody(tp : PTCTX) : string; forward;
function GetErrorBodyFilename(http_status : integer) : string; forward;
function InStr(p : integer; sIn , sFind : string) : integer; forward;
function Subst(sIn , sFrom , sTo : String) : String; forward;

//========================================================================
//
// Process() - main entry point
//
// Return TRUE if all went well, otherwise FALSE. Do not call Die() !!!
// NOTE: This routine only handles 401 Unauthorised, but could be extended
// to handle a swag of errors. Nevertheless, it is a functional application
// for customising the 401 error message
//========================================================================
function Process(tp : PTCTX) : Boolean; export; cdecl;
var
  xhdrs : array[1..2,1..2,1..100] of char;
  buffer : string;
begin
  //
  //  set default - error not handled
  //
  Result := false;

  //
  //  Since this entry-point will get called for any and every
  //  non-200 status code generated by the browser
  //
  if (tp^.http_status <> AUTH_REQUIRED) then exit;

  //
  // get the HTML response for the particular error - if any
  //
  buffer := GetResponseBody(tp);

  //
  //  if no message body, normally would let server handle error
  //  but in this example we'll generate a default page
  //
  if buffer='' then begin
    buffer := '<HTML><HEAD><TITLE>401 Unauthorised Access</TITLE></HEAD>'#13#10;
    buffer := buffer + '<BODY BGCOLOR=#FFE0FF>'#13#10;
    buffer := buffer + '<H1>Not Authorised</H1>'#13#10;
    buffer := buffer + 'Access to following URL was denied: ' + tp^.url + #13#10;
    if length(tp^.referer)>0 then begin
      buffer := buffer + 'Return to the <A HREF=' + tp^.referer;
      buffer := buffer + '>referring document</A>.'#13#10;
    end;
      buffer := buffer + '<P><I>This was generated by a WSAPI/Delphi sample filter extension</i>'#13#10;
    buffer := buffer + '</BODY></HTML>'#13#10;
  end;

  //
  //  Now we must generate a properly formatted HTTP header
  //  before we can send content for the error message.
  //
  //  Set Unauthorised response information to get browser to prompt
  //  for password
  //
  StrPCopy(@xhdrs[1,1],'WWW-Authenticate');
  StrPCopy(@xhdrs[1,2],PChar(tp^.auth_type) + ' realm="' + PChar(tp^.auth_name) + '"');
  tp^.rsp_xhdr[tp^.num_rsp_xhdr].key := @xhdrs[1,1];
  tp^.rsp_xhdr[tp^.num_rsp_xhdr].value := @xhdrs[1,2];
  tp^.num_rsp_xhdr:=tp^.num_rsp_xhdr + 1;
  StrPCopy(tp^.rsp_status,'401 Unauthorised');

  //
  //  The Content-type field is set for a few browsers that
  //  don't assume HTML.  Also, notice that we make absolutely
  //  sure the Location field is blank, lest we wind up
  //  generating a 302 error.
  //
  tp^.content_length := length(buffer);
  StrPCopy(tp^.content_type,'text/html');
  tp^.location[0] := #0;

  //
  //  send header
  //
  send_http_header(tp, True);

  //
  // send message body
  //
  nwrite(PChar(buffer), length(buffer), tp);

  //
  //  flush - just in case
  //
  nflush(tp);

  //
  //  if we got here, then error handled OK
  //
  Result:=True;
end;

//========================================================================
//
//  GetResponsebody
//
//========================================================================
function GetResponseBody(tp : PTCTX) : string;
var
  F : TextFile;
  buffer, filename : string;
begin
  //
  //  get filename for error HTML file (from registry
  filename := GetErrorBodyFilename(tp^.http_status);
  //
  // if we got a filename, continue
  if filename<>'' then begin
    try
      AssignFile(F, filename);
      Reset(F);
      try
        while not Eof(F) do begin
          Readln(F, buffer);
          buffer := Subst(buffer,'%url%',tp^.url);
          buffer := Subst(buffer,'%referer%',tp^.referer);
          Result := Result + buffer + #13#10;
        end;
      finally
        // failed reading file
        CloseFile(F);
      end;
    except
      // hide all errors for this block
      filename:='';
    end;
  end;
end;

//========================================================================
//
//  GetErrorBodyFilename
//
//========================================================================
function GetErrorBodyFilename(http_status : integer) : string;
var
  registry : TRegistry;
begin
  Result:='';
  try
    registry:=TRegistry.Create;
    try
      registry.RootKey := HKEY_LOCAL_MACHINE;
      if registry.OpenKey('SOFTWARE\Denny\WebServer\CurrentVersion\ExtErrBodies',False) then begin
        try
          Result:=registry.ReadString(Format('%d',[http_status]));
        finally
          registry.CloseKey;
        end;
      end;
    finally
      registry.Free;
    end
  except
    //  suppress any errors in the registry routine
  end;
end;

{******************************************************************
' simulate VB InStr function
*******************************************************************}
function InStr(p : integer; sIn , sFind : string) : integer;
var
  sTemp : string;
  pFound : integer;
begin
  if sFind='' Then
    Result:=p
  else begin
    sTemp:=Copy(sIn, p, Length(sIn));
    pFound:=Pos(sFind,sTemp);
    if pFound>0 then
      Result:=pFound+p-1
    else
      Result:=0;
  end;
end;

{******************************************************************
' Simulate VB Subst routine
' Substritute all occurences of 'sFrom' in 'sin' to 'sTo'
*******************************************************************}
function Subst(sIn , sFrom , sTo : String) : String;
var
  sOut : string;
  p1, p2 : Integer;
begin
  // p2 is pointer to offending character
  p2 :=  InStr(1, sIn, sFrom);
  If p2 > 0 Then begin
    sOut:= '';
    p1 := 1;
    while p2 > 0 do begin
      sOut:=sOut + Copy(sIn, p1, p2 - p1) + sTo;
      p1:=p2 + Length(sFrom);
      p2:=InStr(p1, sIn, sFrom);
    end;
    Result:=sOut + Copy(sIn, p1, Length(sIn));
  end
  Else begin
    Result:= sIn;
  End;
End;

exports
  Process;

begin
  // module initialisation
  if not bind_wsapi(MAJOR_VERSION, MINOR_VERSION, FALSE) then
    ExitCode:=1; // cause DLL load to fail
end.
