library notfound;
{
    This is a port of the NOTFOUND example program included
    in the WSAPI developer's kit (as shipped with WebSite Pro).
    Port by Paul Gallagher, 1997 <paulpg@ozemail.com.au>
}

// TITLE:		NOTFOUND.C
//
// FACILITY:	Error handler extension for WebSite web server
//
// ABSTRACT:	This extension overrides the server's internal
//              logic with regards to 404 status codes.  Instead
//              of returning a page with the culpable URL path 
//              and subsequent physical mapping, only the URL
//              path is returned (as well as a link to the
//              referring document, where applicable).
//
// ENVIRONMENT:	WebSite 1.1 or later, WSAPI 0.15
//				Microsoft Windows NT 3.5x, Microsoft Windows 95
//				Developed under Microsoft Visual C++ Version 2.0
//
// AUTHOR:		Arsenio Santos   <arsenio@ora.com>
//
// Edit Log:
//
// When			Who		What
//----------	---		--------------------------------------------------
// 12-Mar-96	ars		Initial edit
// 13-Apr-96	rbd		Compute content-length for keep-alive.
// 26-Jan-97    paulg           Port to Delphi
//========================================================================

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  View-Project Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the DELPHIMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using DELPHIMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
  SysUtils,
  Classes,
  Windows,
  WSAPI in '..\..\lib\WSAPI.pas';

//========================================================================
//
// Process() - main entry point
//
// Return TRUE if all went well, otherwise FALSE. Do not call Die() !!!
// NOTE: This routine only handles 404 Not Found, but could be extended
// to handle a swag of errors. NOTE: This is really minimalist error
// handling and reporting. It _is_ an example...
//========================================================================
function Process(tp : PTCTX) : Boolean; export; cdecl;
var
  buffer : string;
begin

  //  Since this entry-point will get called for any and every
  //  non-200 status code generated by the browser, we need to
  //  let all but the 404 errors pass through.
  //
  if (tp^.http_status <> NOT_FOUND) then begin
    Result := false;   // Let server handle non-404
    exit;
  end;

  // 	*buffer will contain the entity body that we wish to
  //  use as an error message.  As we load up the variable,
  //  notice how we refer to the transaction context struct
  //  for information. By putting it all in a buffer, we can
  //  compute the content-length, thereby making keep-alive
  //  possible.
  //
  buffer := '<HTML><HEAD><TITLE>404 Not Found</TITLE></HEAD>'#13#10;
  buffer := buffer + '<BODY BGCOLOR=#FFE0FF>'#13#10;
  buffer := buffer + '<H1>Not Found</H1>'#13#10;
  buffer := buffer + 'The following URL was not found on your server:'#13#10'<P><CODE>   ';
  buffer := buffer + tp^.url;
  buffer := buffer + #13#10'<P>'#13#10'</CODE>'#13#10;
  if length(tp^.referer)>0 then begin
    buffer := buffer + 'Please return to the <A HREF=';
    buffer := buffer + tp^.referer;
    buffer := buffer + '>referring document</A>.'#13#10;
  end;
  buffer := buffer + '<P><I>This was generated by a WSAPI sample filter extension</i>'#13#10;
  buffer := buffer + '</BODY></HTML>'#13#10;

  //  Now we must generate a properly formatted HTTP header
  //  before we can send content for the error message.
  //  The Content-type field is set for a few browsers that
  //  don't assume HTML.  Also, notice that we make absolutely
  //  sure the Location field is blank, lest we wind up
  //  generating a 302 error.
  //
  tp^.location[0] := #0;
  tp^.content_length := length(buffer);
  StrPCopy(tp^.content_type,'text/html');
  send_http_header(tp, False);

  //  The final task, of course, is to output the buffer
  //  and indicate to the server that we've handled the
  //  404 error completely.
  //
  nwrite(PChar(buffer), length(buffer), tp);
  nflush(tp);								// Just in case!

  Result:=True;
end;

exports
  Process;

begin
  // module initialisation
  if not bind_wsapi(MAJOR_VERSION, MINOR_VERSION, FALSE) then
    ExitCode:=1; // cause DLL load to fail
end.
