library cookie;
{
    This is a port of the COOKIE example program included
    in the WSAPI developer's kit (as shipped with WebSite Pro).
    Port by Paul Gallagher, 1997 <paulpg@ozemail.com.au>
}
//========================================================================
// COPYRIGHT NOTICE:
//				Copyright (C) 1996, Robert B. Denny, Mesa, Arizona
//				All Rights Reserved
// PROPRIETARY RIGHTS NOTICE:
//				This source code is the property of Robert B. Denny of
//				Pasadena, California, and is furnished under license only.
//========================================================================
// TITLE:		COOKIE.C
//
// FACILITY:	Cookie-giver pre-processor for WSAPI
//
// ABSTRACT:	Checks the incoming transaction for the presence of an
//				HTTP cookie. If none is present, it generates one with
//				a unique name derived from the current date and time,
//				and with an expiration of 24 hours from now. This cookie
//				can be useful for logging "unique visitors" to the site
//				over the last day (via a WSAPI logging hook). The format 
//				for setting a cookie is:
//
//		Set-Cookie: <name>=<value>; expires=<date>; path=<path>; domain=<dom>
//
//				See the Netscape documentation on cookies for the meaning 
//				of the components. I assume you are now familiar with this...
//				We'll name the cookie "visitor" and set the value to an encoding
//				of the current date and time, approximating a unique value
//				(at least for the next 24 hours). Computing the MD5 digest
//				of some stuff would be better... but this _is_ a sample.
//				Set the path to '/' to we'll get the cookie back for
//				any URL in our web, and the domain to the local name of
//				this server. If we're multi-homing, separate cookies will
//				thus be used on each identity.
//
//				This is a sample preprocessor. Ideas for enhancements 
//				include:
//
//				(1) Making the cookie configurable, perhaps via settings
//				    kept in the registry
//
//				(2) Checking to see that the cookie is one of "ours" by
//				    looking for the name "visitor". This sample does not
//					give a cookie if there are ANY cookies in the request.
//
//				(3) Logging the gookies given out here, or counting the
//				    number of cookies given, or both.
//
// TO INSTALL:	Place a copy of cookie.dll in the same directory as the
//				WebSite Pro server. With the registry editor, open
//
//				HKEY_LOCAL_MACHINE\Software\Denny\WebServer\CurrentVersion
//
//				Change the value ExtPreDll to "cookie.dll" and the value
//				ExtPreEntry to GiveCookie. Restart the server.
//
// ENVIRONMENT:	WebSite Pro 1.1 or later, WSAPI 0.16 (experimental)
//				Microsoft Windows Windows NT 3.5x, Windows 95
//				Developed under Microsoft Visual C++ Version 4.0
//
// AUTHOR:		Robert B. Denny
//
// Edit Log:
//
// When			Who		What
//----------	---		--------------------------------------------------
// 11-Mar-96	rbd		Initial edit
// 26-Jan-97    paulg           Port to Delphi
//========================================================================

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  View-Project Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the DELPHIMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using DELPHIMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
  SysUtils,
  Classes,
  Windows,
  WSAPI in '..\..\lib\WSAPI.pas';


//========================================================================
//
// GiveCookie() - main entry point
//
//========================================================================
function GiveCookie(tp : PTCTX) : Boolean; export; cdecl;
var
  i : integer;
  l : DWORD;
  ft : TFileTime;
  st: TSystemTime;
  buf : string;
  tbuf : array[0..SML_STRING_LEN] of Char;
  bFound : boolean;
begin

  bFound := false;

  //  Search for cookie
  if (tp^.num_req_xhdr>0) then
    for i := 0 to tp^.num_req_xhdr-1 do begin
      if (StriComp(PChar(tp^.req_xhdr[i].key),'Cookie') = 0) then begin
        // Found a cookie!
        bFound := True;
      end;
    end;

  if not bFound then begin
    //
    // OK, we got past the cookie search so we need to add a cookie
    // to the response extra headers. Do some date/time hacking first.
    //
    GetSystemTime(st);				// Current date/time
    SystemTimeToFileTime(st, ft);			// (see below)
    //
    // Need a SYSTEMTIME for 24 hours from now. The FILETIME is a
    // 64-bit number of 100ns tix since Jan 1, 1601. We need to
    // add a day's worth of 100ns tix to that. This requires us
    // to do a multi-precision add with carry. In hex, the
    // number of 100ns tix in a day is [000000C92A69C000]
    // (8.64 x 10**11)  <-- (hey, remember FORTRAN?)
    //
    l := ft.dwLowDateTime;			        // Save original
    ft.dwLowDateTime := ft.dwLowDateTime + $2A69C000;	// Add low 32-bits
    if (ft.dwLowDateTime < l) then			// Overflow?
  	inc(ft.dwHighDateTime);				// (yes, carry a 1)
    ft.dwHighDateTime := ft.dwHighDateTime  + $000000C9;	// Add high 32-bits
    FileTimeToSystemTime(ft, st);           		// Now tomorrow's date/time (GMT)
    //
    // OK, we can format the cookie string now. http_nt_timestr() takes
    // care of generating the HTTP/1.0 compliant date/time string for
    // the expires header, and SystemTime is GMT, so we're all set.
    //
    buf := Format('visitor=%X%X; expires=%s; path=/; domain=%s',
  		[ft.dwLowDateTime,				// Identifier
  		ft.dwHighDateTime,				// ...
  		http_nt_timestr(@st, tbuf, sizeof(tbuf)),        // HTTP-compliant date
  		tp^.local_name]);				// Valid for this identity only

    //
    // Now add it as a response extra header, and that's it!
    //
    tp^.rsp_xhdr[tp^.num_rsp_xhdr].key := wsapi_strdup(PChar('Set-Cookie'), tp);
    tp^.rsp_xhdr[tp^.num_rsp_xhdr].value := wsapi_strdup(PChar(buf), tp);
    tp^.num_rsp_xhdr:=tp^.num_rsp_xhdr+1;
  end;

  // always return false
  Result := false;

end;

exports
  GiveCookie;

begin
  // module initialisation
  if not bind_wsapi(MAJOR_VERSION, MINOR_VERSION, FALSE) then
    ExitCode:=1; // cause DLL load to fail
end.
