unit dsprogrs;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, ExtCtrls;

type
  TDSProgress = class(TCustomControl)
  private
    fPerc:          integer;
    fMax:           integer;
    fPos:           integer;
    fPosition:      integer;
    fPColor:        TColor;
    fCaption:       string;
    procedure SetMax(Value: integer);
    procedure SetPosition(Value: integer);
    procedure SetPColor(Value: TColor);
    procedure SetCaption(Value: string);
    function  RecalcPercentage: boolean;
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
    property Percentage: integer read fPerc;
  published
    property Max: integer read fMax write SetMax;
    property Position: integer read fPosition write SetPosition;
    property ProgressColor: TColor read fPColor write SetPColor;
    property Caption: string read fCaption write SetCaption;
    property Color;
    property Font;
  end;

procedure Register;

implementation

constructor TDSProgress.Create(AOwner: TComponent);
begin
   width := 150;
   height := 17;
   fPerc := 0;
   fMax := 100;
   fPos := 0;
   fPosition := 0;
   fPColor := clWhite;
   inherited;
   RecalcPercentage;
end;

function TDSProgress.RecalcPercentage: boolean;
var
   lPerc: integer;
   lPos: integer;
begin
   lPerc := Round((fPosition / fMax) * 100);
   lPos := Round((fPosition / fMax) * (Width - 1));
   if (fPos <> lPos) or (fPerc <> lPerc) then begin
      fPos := lPos;
      fPerc := lPerc;
      Result := True;
   end
   else begin
      Result := False;
   end;
end;

procedure TDSProgress.SetCaption(Value: string);
begin
   if Value <> fCaption then begin
      fCaption := Value;
      Paint;
   end;
end;

procedure TDSProgress.SetMax(Value: integer);
begin
   if Value <> fMax then begin
      fMax := Value;
      if RecalcPercentage then invalidate;
   end;
end;

procedure TDSProgress.SetPosition(Value: integer);
begin
   if Value <> fPosition then begin
      fPosition := Value;
      if RecalcPercentage then Paint;
   end;
end;

procedure TDSProgress.SetPColor(Value: TColor);
begin
   if Value <> fPColor then begin
      fPColor := Value;
      Paint;
   end;
end;

procedure TDSProgress.Paint;
var
   w, h: integer;
   i:    integer;
   lBMP: TBitmap;
begin
   inherited;
   w := Width - 1;
   h := Height - 1;
   lBMP := TBitmap.Create;
   lBMP.Width := w + 1;
   lBMP.Height := h + 1;
   lBMP.Canvas.font.assign(Font);
   with lBMP.Canvas do begin
      brush.style := bsSolid;
      brush.color := Color;
      fillrect(rect(0,0,w,h));
      brush.color := fPColor;
      i := fPos;
      fillrect(rect(0,0,i,h-1));
      pen.style := psSolid;
      pen.color := clBtnShadow;
      moveto(0,h);
      lineto(0,0);
      lineto(w,0);
      pen.color := clBtnHighlight;
      lineto(w,h);
      lineto(0,h);
      pen.color := clBtnFace;
      moveto(1,h-1);
      lineto(w-1,h-1);
      lineto(w-1,1);
      brush.style := bsClear;
      pen.color := clBlack;
      if fCaption <> '' then
         textout(3, 1, fCaption + '   ' + inttostr(fPerc) + '%')
      else
         textout(3, 1, inttostr(fPerc) + '%');
   end;
   Canvas.Copyrect(rect(0, 0, w+1, h+1), lBMP.Canvas, rect(0, 0, w+1, h+1));
   lBMP.Free;
end;

procedure Register;
begin
  RegisterComponents('DigiS', [TDSProgress]);
end;

end.
