unit unUploadStat;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Placemnt, ExtCtrls, AABGraph, DB, DBTables;

type
   IntList=array[1..12,1995..2000] of Word;
  TfUploadStat = class(TForm)
    Inirtertdf: TFormStorage;
    Table1: TTable;
    AABsoftGraph1: TAABsoftGraph;
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fUploadStat: TfUploadStat;

implementation

{$R *.DFM}

procedure TfUploadStat.FormShow(Sender: TObject);
var
   Data:IntList;
   Year, Month, Day: Word;
   n,m:integer;
begin
   Screen.Cursor:=crHourGlass;
   Table1.Open;
   //Clear Array
   for m:=1995 to 2000 do
   begin
      for n:=1 to 12 do
      begin
        Data[n,m]:=0;
      end;
   end;
   //Counting files
   Table1.First;
   while not Table1.Eof do
   begin
      DecodeDate(Table1.FieldByName('UploadDate').Value,Year, Month, Day);
      Data[Month,Year]:=Data[Month,Year]+1;
      Table1.Next;
   end;
   //Display Data
   AABsoftGraph1.ResetGraphModule;
   for m:=1995 to 2000 do
   begin
      for n:=1 to 12 do
      begin
         AABsoftGraph1.SetValue(m-1995+1,n,Data[n,m]);
         AABsoftGraph1.SetXLegend(n,IntToStr(n));
      end;
   end;
   AABsoftGraph1.AutoFormatGraph;
   AABsoftGraph1.ShowAsBar;
   AABsoftGraph1.SetHeader('');
   AABsoftGraph1.SetSeriesLegend(1, '1995.');
   AABsoftGraph1.SetSeriesLegend(2, '1996.');
   AABsoftGraph1.SetSeriesLegend(3, '1997.');
   AABsoftGraph1.SetSeriesLegend(4, '1998.');
   AABsoftGraph1.SetSeriesLegend(5, '1999.');
   AABsoftGraph1.SetSeriesLegend(6, '2000.');
   AABsoftGraph1.UpdateGraphToScreen;
   Table1.Close;
   Screen.Cursor:=crDefault;
end;

procedure TfUploadStat.FormResize(Sender: TObject);
begin
   Screen.Cursor:=crHourGlass;
   AABsoftGraph1.UpdateGraphToScreen;
   Screen.Cursor:=crDefault;
end;

end.
