unit unMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DB, DBTables, ComCtrls, Grids, DBGrids, ExtCtrls,
  DBCtrls, Mask, DBCGrids, BtChkBox,
  DBUpdateControls, explbtn, DBfind3reg, Menus,
  GoToWeb, Buttons, Placemnt, RXSplit, StrHlder, IniFiles, IP;


type
  TfMain = class(TForm)
    Dialog1: TDBFind3;
    MainMenu1: TMainMenu;
    mAbout: TMenuItem;
    GoToWeb1: TGoToWeb;
    Options1: TMenuItem;
    mRemove: TMenuItem;
    mFilter: TMenuItem;
    tFiles: TTable;
    dsMirrors: TDataSource;
    dsFiles: TDataSource;
    tSites: TTable;
    tMirrors: TTable;
    Query1: TQuery;
    qHTML: TQuery;
    tFilesFileName: TStringField;
    tFilesStoredInDir: TIntegerField;
    tFilesFileType: TStringField;
    tFilesD10: TBooleanField;
    tFilesD20: TBooleanField;
    tFilesD30: TBooleanField;
    tFilesC10: TBooleanField;
    tFilesCategory: TIntegerField;
    tFilesDescription: TStringField;
    tFilesFileVersion: TStringField;
    tFilesUploadDate: TDateField;
    tFilesFileSize: TIntegerField;
    tFilesFileTxt: TStringField;
    tFilesDSP_support: TBooleanField;
    tFilesWithSource: TBooleanField;
    tFilesWithDemo: TBooleanField;
    tFilesCondition: TStringField;
    tFilesFileURL: TStringField;
    tFilesAuthorID: TIntegerField;
    tFilesAuthorName: TStringField;
    tFilesFileID: TAutoIncField;
    tFilesD10a: TStringField;
    tFilesD20a: TStringField;
    tFilesD30a: TStringField;
    tFilesC10a: TStringField;
    tFilesURL: TStringField;
    tFilesContactEMAIL: TStringField;
    mdbDown: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    PanelLeft: TPanel;
    StatusPanelNodes: TPanel;
    Bevel5: TBevel;
    TreeView1: TTreeView;
    RxSplitter1: TRxSplitter;
    PanelRight: TPanel;
    PanelFiles: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    oFileType: TLabel;
    oSize: TLabel;
    oWithSource: TBitCheckBox;
    oWithDemo: TBitCheckBox;
    oC10: TBitCheckBox;
    oD10: TBitCheckBox;
    oD20: TBitCheckBox;
    oD30: TBitCheckBox;
    PanelMain: TPanel;
    ctrLast: TExplorerButton;
    ctrNext: TExplorerButton;
    ctrPrior: TExplorerButton;
    ctrFirst: TExplorerButton;
    ctrFind: TExplorerButton;
    Bevel1: TBevel;
    ctrFile: TExplorerButton;
    ctrEMail: TExplorerButton;
    ctrURL: TExplorerButton;
    ctrFileMark: TExplorerButton;
    PanelStatus: TPanel;
    Bevel4: TBevel;
    LabelFilter: TLabel;
    oFilename: TDBEdit;
    DBEdit2: TDBEdit;
    oEMail: TDBEdit;
    oURL: TDBEdit;
    DBEdit5: TDBEdit;
    DBEdit6: TDBEdit;
    DBMemo1: TDBMemo;
    DBMemo2: TDBMemo;
    BitCheckBox1: TBitCheckBox;
    PanelMirrors: TPanel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Panel2: TPanel;
    Bevel2: TBevel;
    ctrProviderEMail: TExplorerButton;
    ctrDSPURL: TExplorerButton;
    ctrProviderURL: TExplorerButton;
    ctrDefaultSite: TExplorerButton;
    DBEdit1: TDBEdit;
    oDSPURL: TDBEdit;
    oProviderURL: TDBEdit;
    DBEdit8: TDBEdit;
    oProviderEMail: TDBEdit;
    DBEdit10: TDBEdit;
    DBEdit11: TDBEdit;
    PanelMasterSite: TPanel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Panel1: TPanel;
    Bevel3: TBevel;
    ctrProviderEMail2: TExplorerButton;
    ctrDSPURL2: TExplorerButton;
    ctrProviderURL2: TExplorerButton;
    ctrDefaultSite2: TExplorerButton;
    oDSPURL2: TEdit;
    oProviderURL2: TEdit;
    Edit3: TEdit;
    oProviderEMail2: TEdit;
    Edit5: TEdit;
    SL: TStrHolder;
    Directory: TStrHolder;
    Inirtertdf: TFormStorage;
    ImageList1: TImageList;
    View1: TMenuItem;
    mUploadStat: TMenuItem;
    N3: TMenuItem;
    mExit: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure CreateMasterNodes;
    procedure CheckFilesControls;

    procedure dsFilesDataChange(Sender: TObject; Field: TField);
    procedure ctrClick(Sender: TObject);
    procedure UpdatePanels(Node : TTreeNode);

    procedure AddDSPNodes;
    procedure AddFilesNodes(Node:TTreeNode);
    procedure AddAuthorsNodes(Node:TTreeNode);
    procedure AddMirrorsNodes;

    procedure AddAuthorFilesNodes(Node:TTreeNode);
    procedure OpenAuthorFilesSQL(Node:TTreeNode);
    procedure AddFilesFilesNodes(Node:TTreeNode);
    procedure OpenFilesFilesSQL(Node: TTreeNode);
    procedure dsMirrorsDataChange(Sender: TObject; Field: TField);
    procedure AddMarkedFilesNodes(Node:TTreeNode);
    procedure Jump(URL:String);
    procedure mClick(Sender: TObject);
    procedure TreeView1Expanding(Sender: TObject; Node: TTreeNode;
      var AllowExpansion: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SetBitmap(Node:TTreeNode; Folder:integer; Category:integer);

  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;


var
  fMain: TfMain;
  FieldList: TStringList;
  LastNode, SQLNode: TTreeNode;
  Ini:TIniFile;
implementation
uses TreeFunc, unAbout, unFilter, unUploadStat;

{$R *.DFM}

procedure TfMain.FormCreate(Sender: TObject);
begin
   try
      tFiles.Open;
      tSites.Open;
      qHTML.Open;
      tMirrors.Open;
   except
     if MessageDlg('DSP Tables not exists. Clicking the "Yes" yo will download dsp_db.zip. Then you need to UnZip dsp_db.zip to folder where you have DSP Explorer. After that you can restart DSP Explorer. Download?',
        mtInformation, [mbYes, mbNo], 0) = mrYes then mClick(mdbDown);
     Application.Terminate;
   end;
   //
   Ini:=TiniFile.Create('DSPExplr.INI');
      if Ini.ReadString('Settings','Version','')<>'1.1' then
      begin
         Ini.EraseSection('fMain.SL_Strings');
         Ini.WriteString('Settings','Version','1.1');
         SL.Strings.Clear;
      end;
   //
   PanelFiles.Align:=alClient;
   PanelMirrors.Align:=alClient;
   PanelMasterSite.Align:=alClient;
   //
   DateSeparator:='.';
   //
   dsFiles.Enabled:=False;
   Query1.Close;
   Query1.Filtered:=False;
   Query1.Filter:='';
   Query1.SQL.Clear;
   Query1.SQL.Add('SELECT DIR."ID" , DIR."Directory" FROM "DIR.DB" DIR ORDER BY DIR."ID" ');
   Directory.Strings.Add('yyy');
   Query1.Open;
   while not Query1.Eof do
   begin
        Directory.Strings.Add(Query1.FieldByName('Directory').AsString);
        Query1.Next;
        end;
   Query1.Close;
   //
   FieldList := TStringList.create;
   CreateMasterNodes;

   //make first record selected:
   //TreeView1.items[2].selected := true;
end;

procedure TfMain.TreeView1Change(Sender: TObject; Node: TTreeNode);
var
Parent: TTreeNode;
ANode: TTreeNode;
ListItem:TListItem;
S:string;
n:integer;
begin
   Screen.Cursor:=crHourglass;
   dsFiles.Enabled:=False;

   if  (Node.Level=2) and (Node.Parent.Text='Marked Files') then
   begin
      if dsFiles.Dataset<>tFiles then dsFiles.Dataset:=tFiles;
      tFiles.FindNearest([Node.Text]);
      dsFiles.enabled :=true;
   end;


   if  (Node.Level=3) and isSubChildS(node,'DSP\Authors') then
   begin
      if dsFiles.Dataset<>Query1 then dsFiles.Dataset:=Query1;
      if (SQLNode<>Node.Parent) then //and (LastNode<>Node.Parent) then
      begin
         SQLNode:=Node.parent;
         OpenAuthorFilesSQL(Node.parent);
      end;
      Query1.gotobookmark(node.data);
      dsFiles.enabled :=true; //Node.data <> nil;
    end;

   if  (Node.Level=4) and isSubChildS(node,'DSP\Files') then
   begin
      if dsFiles.Dataset<>Query1 then dsFiles.Dataset:=Query1;
      if (SQLNode<>Node.Parent)  then //and (LastNode<>Node.Parent) then
      begin
         SQLNode:=Node.parent;
         OpenFilesFilesSQL(Node.parent);
      end;
      Query1.gotobookmark(node.data);
      dsFiles.enabled := true;
   end;

   if  (Node.Level=4) and isSubChildS(Node,'DSP\Mirrors') then
   begin
      tMirrors.gotobookmark(node.data);
   end;

   if (Node.Level=1) and (Node.Text='Main Site') then
   begin
     if oDSPURL2.Text=Ini.ReadString('Settings','URL','') then
         ctrDefaultSite2.Enabled:=False
      else
      begin
         ctrDefaultSite2.Bitmap:=BitCheckBox1.UncheckedGlyph;
         ctrDefaultSite2.Enabled:=True;
      end;
   end;


   LastNode:=Node;
   UpdatePanels(Node);
   StatusPanelNodes.Caption:=' '+IntToStr(Node.Count)+' Object(s)';
   Screen.Cursor:=crDefault;
end;


procedure TfMain.UpdatePanels(Node : TTreeNode);
begin
   if (Node.Level=4) and isSubChildS(node,'DSP\Files') then
   begin
      CheckFilesControls;
      PanelFiles.Visible:=True;
      PanelMirrors.Visible:=False;
      PanelMasterSite.Visible:=False;
      ctrFind.Visible:=True;
   end
   else if ((Node.Level=3) and isSubChildS(node,'DSP\Authors')) then
   begin
      CheckFilesControls;
      PanelFiles.Visible:=True;
      PanelMirrors.Visible:=False;
      PanelMasterSite.Visible:=False;
      ctrFind.Visible:=True;
      LabelFilter.Caption:='All Files';
   end
   else if ((Node.Level=2) and (Node.Parent.Text='Marked Files')) then
   begin
      CheckFilesControls;
      PanelFiles.Visible:=True;
      PanelMirrors.Visible:=False;
      PanelMasterSite.Visible:=False;
      ctrFind.Visible:=False;
      LabelFilter.Caption:='All Files';
   end
   else if (Node.Level=4) and isSubChildS(node,'DSP\Mirrors') then
   begin
      PanelFiles.Visible:=False;
      PanelMirrors.Visible:=True;
      PanelMasterSite.Visible:=False;
   end
   else if (Node.Level=1) and (Node.Text='Main Site') then
   begin
      PanelFiles.Visible:=False;
      PanelMirrors.Visible:=False;
      PanelMasterSite.Visible:=True;
   end
   else
   begin
      PanelFiles.Visible:=False;
      PanelMirrors.Visible:=False;
      PanelMasterSite.Visible:=False;
   end;
end;

procedure TfMain.AddFilesFilesNodes(Node:TTreeNode);
var
ANode:TTreeNode;
folder,category:integer;
begin
   TreeView1.items.BeginUpdate;
   OpenFilesFilesSQL(Node);
   Query1.DisableControls;
   Query1.First;
   while not Query1.Eof do
   begin
      ANode:=TreeView1.items.AddChildObject(Node, Query1.FieldByName('FileName').asString, Query1.GetBookmark);
      try
      folder:= Query1.FieldByName('StoredInDir').Value;
      category:=Query1.FieldByName('Category').Value;
      SetBitmap(ANode,Folder,Category);
      finally end;
      Query1.Next;
   end;
   Query1.First;
   TreeView1.items.EndUpdate;
   Query1.EnableControls;
end;

procedure TfMain.OpenFilesFilesSQL(Node: TTreeNode);
var
_S1,_S2,_S3,a,s:String;
begin
   qHTML.First;
   while not qHTML.Eof do
   begin
      if (qHTML.FieldByName('PageTitle').AsString=Node.Parent.Text)
         and  (qHTML.FieldByName('PageSubTitle').AsString=Node.Text) then Break;
   qHTML.Next;
   end;
   _S1:=' SELECT FILES."FileName" , FILES."D10" ,'+
        ' FILES."D20" , FILES."D30" , FILES."C10" ,'+
        ' FILES."Description" , FILES."Category" ,'+
        ' FILES."FileType" , FILES."FileVersion" , FILES."StoredInDir" ,'+
        ' FILES."UploadDate" , FILES."FileSize" ,'+
        ' FILES."FileTxt" , FILES."DSP_support" ,'+
        ' FILES."WithSource" , FILES."WithDemo" ,'+
        ' FILES."Condition" , FILES."FileURL" ,'+
        ' FILES."AuthorID" , FILES."AuthorName" ,'+
        ' FILES."FileID" , FILES."D10a" ,'+
        ' FILES."D20a" , FILES."D30a" ,'+
        ' FILES."C10a" ,'+
        ' SITES."URL" , SITES."Contact-EMAIL"'+
        ' FROM "FILES.DB" FILES, "SITES.DB" SITES '+
        ' WHERE ( FILES.AuthorID = SITES.ID ) AND ';

    if qHTML.FieldByName('C10').Value=True then
      _S2:=' ( ( ( FILES."C10" = true ) AND '
    else if qHTML.FieldByName('D10').Value=True then
      _S2:=' ( ( ( FILES."D10" = true ) AND '
    else if qHTML.FieldByName('D20').Value=True then
      _S2:=' ( ( ( FILES."D20" = true ) AND '
    else if qHTML.FieldByName('D30').Value=True then
      _S2:=' ( ( ( FILES."D30" = true ) AND ';

    if qHTML.FieldByName('Category').IsNull then
       _S3:=' ( FILES."FileType" = "'+ qHTML.FieldByName('FileType').AsString +'" ) ) ) ORDER BY FILES."FileName"'
    else
    _S3:=' ( FILES."Category" = '+ IntToStr(qHTML.FieldByName('Category').Value) +' ) AND'+
         ' ( FILES."FileType" = "'+ qHTML.FieldByName('FileType').AsString +'" ) ) ) ORDER BY FILES."FileName"';

   //
   Query1.Close;
   //Filter
   Query1.Filtered:=False;
   if fFilter.BitCheckBox1.checked=True then
   begin
      Query1.Filter:='UploadDate>='+DateToStr(fFilter.DateEdit1.Date);
      Query1.Filtered:=True;
      LabelFilter.Caption:='Files From '+fFilter.DateEdit1.Text;
   end;
   //
   Query1.SQL.Clear;
   Query1.SQL.Add(_S1+_S2+_S3);
   Query1.Open;
   if Query1.RecordCount=0 then Node.HasChildren:=False;
end;

procedure TfMain.AddAuthorFilesNodes(Node:TTreeNode);
var
   ANode:TTreeNode;
   folder,category:integer;
begin
   TreeView1.items.BeginUpdate;
   OpenAuthorFilesSQL(Node);
   Query1.DisableControls;
   Query1.First;
   while not Query1.Eof do
   begin
      ANode:=TreeView1.items.AddChildObject(Node, Query1.FieldByName('FileName').asString, Query1.GetBookmark);
      try
         folder:= Query1.FieldByName('StoredInDir').Value;
         category:=Query1.FieldByName('Category').Value;
         SetBitmap(ANode,Folder,Category);
      finally
      end;
      Query1.Next;
   end;
   Query1.First;
   TreeView1.items.EndUpdate;
   Query1.EnableControls;
end;

procedure TfMain.OpenAuthorFilesSQL(Node:TTreeNode);
var
   SQL:String;
begin
   SQL:= ' SELECT FILES."AuthorName" , FILES."FileName" , '+
         ' FILES."StoredInDir" , FILES."FileType" ,  FILES."D10" , FILES."D20" , '+
         ' FILES."D30" , FILES."C10" , FILES."Category" , FILES."Description" , '+
         ' FILES."FileVersion" , FILES."UploadDate" , FILES."FileSize" , '+
         ' FILES."FileTxt" , FILES."DSP_support" ,  FILES."WithSource" , '+
         ' FILES."WithDemo" , FILES."Condition" , FILES."FileURL" , '+
         ' FILES."AuthorID" , FILES."FileID" ,  FILES."D10a" , FILES."D20a" , '+
         ' FILES."D30a" , FILES."C10a" , '+
         ' SITES."URL" , SITES."Contact-EMAIL" '+
         ' FROM "FILES.DB" FILES , "SITES.DB" SITES '+
         ' WHERE ( FILES.AuthorID = SITES.ID ) '+
         ' AND  ( ( FILES."AuthorName" = "'+Node.Text+'" ) ) ORDER BY FILES."FileName"  ';
   Query1.Close;
   //Filter
   Query1.Filtered:=False;
   Query1.Filter:='';
   Query1.SQL.Clear;
   Query1.SQL.Add(SQL);
   Query1.Open;
end;

procedure TfMain.CreateMasterNodes;
var
   Node:TTreeNode;
   ANode:TTreeNode;
begin
      TreeView1.items.BeginUpdate;
      FieldList.clear;
      Node:=nil;
      Node := TreeView1.Items.Add(Node, 'DSP');
      Node.ImageIndex:=0;
      Node.SelectedIndex:=0;
      ANode := TreeView1.Items.AddChild(Node, 'Marked Files');
      ANode.HasChildren:=True;
      ANode.ImageIndex:=3;
      ANode.SelectedIndex:=3;
      ANode := TreeView1.Items.AddChild(Node, 'Main Site');
      ANode.ImageIndex:=4;
      ANode.SelectedIndex:=4;
      ANode := TreeView1.Items.AddChild(Node, 'Mirrors');
      ANode.HasChildren:=True;
      ANode.ImageIndex:=2;
      ANode.SelectedIndex:=2;
      ANode := TreeView1.Items.AddChild(Node, 'Files');
      ANode.HasChildren:=True;
      ANode.ImageIndex:=1;
      ANode.SelectedIndex:=1;
      ANode := TreeView1.Items.AddChild(Node, 'Authors');
      ANode.HasChildren:=True;
      ANode.ImageIndex:=5;
      ANode.SelectedIndex:=5;
      TreeView1.Alphasort;
      TreeView1.items.Endupdate;
end;

procedure TfMain.AddFilesNodes(Node:TTreeNode);
var
ANode:TTreeNode;
begin
   TreeView1.items.BeginUpdate;
   qHTML.First;
   while not qHTML.Eof do
   begin
      FieldList.clear;
      FieldList.add('DSP');
      FieldList.add('Files');
      FieldList.add(qHTML.FieldByName('PageTitle').AsString);
      ANode:=TreeAddItem(TreeView1, FieldList, nil, True,True);
      ANode.ImageIndex:=1;
      ANode.SelectedIndex:=1;
      qHTML.Next;
   end;
      qHTML.First;
   while not qHTML.Eof do
   begin
      FieldList.clear;
      FieldList.add('DSP');
      FieldList.add('Files');
      FieldList.add(qHTML.FieldByName('PageTitle').AsString);
      FieldList.add(qHTML.FieldByName('PageSubTitle').AsString);
      ANode:=TreeAddItem(TreeView1, FieldList, nil, True,True);
      ANode.ImageIndex:=1;
      ANode.SelectedIndex:=1;
      qHTML.Next;
   end;

   TreeView1.items.Endupdate;
end;

procedure TfMain.AddAuthorsNodes(Node:TTreeNode);
var
SQL:String;
ANode:TTreeNode;
begin
   TreeView1.items.BeginUpdate;
   SQL:=' SELECT FILES."AuthorName" FROM "FILES.DB" FILES WHERE ( FILES."AuthorName" <> "" ) GROUP BY FILES."AuthorName" ORDER BY FILES."AuthorName" ';
   Query1.Close;
   Query1.Filtered:=False;
   Query1.Filter:='';
   Query1.SQL.Clear;
   Query1.SQL.Add(SQL);
   Query1.Open;
   Query1.DisableControls;
   while not Query1.Eof do
   begin
      ANode:=TreeView1.Items.AddChildObject(Node, Query1.FieldByName('AuthorName').asString, Query1.GetBookmark);
      ANode.ImageIndex:=6;
      ANode.SelectedIndex:=6;
      ANode.HasChildren:=True;
      Query1.Next;
   end;
   Query1.EnableControls;
   Query1.Close;
   TreeView1.items.Endupdate;
end;

procedure TfMain.AddDSPNodes;
var
   Node:TTreeNode;
begin
end;

procedure TfMain.dsFilesDataChange(Sender: TObject; Field: TField);
begin
if fMain.visible then
 begin
   if dsFiles.Dataset.FieldByName('D10').IsNull then oD10.Checked:=False else oD10.Checked:=dsFiles.Dataset.FieldByName('D10').Value;
   if dsFiles.Dataset.FieldByName('D20').IsNull then oD20.Checked:=False else oD20.Checked:=dsFiles.Dataset.FieldByName('D20').Value;
   if dsFiles.Dataset.FieldByName('D30').IsNull then oD30.Checked:=False else oD30.Checked:=dsFiles.Dataset.FieldByName('D30').Value;
   if dsFiles.Dataset.FieldByName('C10').IsNull then oC10.Checked:=False else oC10.Checked:=dsFiles.Dataset.FieldByName('C10').Value;
   if dsFiles.Dataset.FieldByName('WithDemo').IsNull then oWithDemo.Checked:=False else oWithDemo.Checked:=dsFiles.Dataset.FieldByName('WithDemo').Value;
   if dsFiles.Dataset.FieldByName('WithSource').IsNull then oWithSource.Checked:=False else oWithSource.Checked:=dsFiles.Dataset.FieldByName('WithSource').Value;
   if dsFiles.Dataset.FieldByName('FileType').AsString='free' then oFileType.Caption:='Freeware';
   if dsFiles.Dataset.FieldByName('FileType').AsString='share' then oFileType.Caption:='Shareware';
   if dsFiles.Dataset.FieldByName('FileType').AsString='docs' then oFileType.Caption:='Documents';
   if SLContains(SL.Strings,dsFiles.Dataset.FieldByName('FileName').AsString+','+dsFiles.Dataset.FieldByName('StoredInDir').AsString+','+dsFiles.Dataset.FieldByName('Category').AsString) then
   begin
      ctrFileMark.Bitmap:=BitCheckBox1.CheckedGlyph;
      BitCheckBox1.Checked:=True
   end
   else
   begin
      ctrFileMark.Bitmap:=BitCheckBox1.UncheckedGlyph;
      BitCheckBox1.Checked:=False;
   end;
   if dsFiles.Dataset.FieldByName('Contact-EMail').AsString='' then ctrEMail.Enabled:=False else ctrEMail.Enabled:=True;
   if dsFiles.Dataset.FieldByName('URL').AsString='' then ctrURL.Enabled:=False else ctrURL.Enabled:=True;
   oSize.Caption:=IntToStr(dsFiles.Dataset.FieldByName('FileSize').Value);
   end;
end;

procedure TfMain.ctrClick(Sender: TObject);
var
   aNode:TTreeNode;
   item:integer;
begin
   if Sender=ctrFind then
   begin
      Dialog1.Execute;
      aNode:=TreeFindItem(TreeView1, LastNode.Parent, oFilename.Text);
      if aNode<>nil then aNode.Selected:=True;
   end
   else if Sender=ctrFirst then
   begin
      aNode:=LastNode.Parent.GetFirstChild;
      if aNode<>nil then aNode.selected := true;
   end
   else if Sender=ctrPrior then
   begin
      aNode:=LastNode.Parent.GetPrevChild(LastNode);
      if aNode<>nil then aNode.selected := true
   end
   else if Sender=ctrNext then
   begin
      aNode:=LastNode.Parent.GetNextChild(LastNode);
      if aNode<>nil then aNode.selected := true
   end
   else if Sender=ctrLast then
   begin
      aNode:=LastNode.Parent.GetLastChild;
      if aNode<>nil then aNode.selected := true;
   end
   else if Sender=ctrFile then
   begin
     Jump(Ini.ReadString('Settings','URL','')+'ftp\'+Directory.Strings[dsFiles.Dataset.FieldByName('StoredInDir').Value]+'\'+oFileName.Text)
   end
   else if Sender=ctrEMail then Jump('MailTo:'+oEMail.Text)
   else if Sender=ctrURL then Jump(oURL.Text)
   else if Sender=ctrDSPURL then Jump(oDSPURL.Text)
   else if Sender=ctrProviderURL then Jump(oProviderURL.Text)
   else if Sender=ctrProviderURL2 then Jump(oProviderURL2.Text)
   else if Sender=ctrProviderEMail then Jump('MailTo:'+oProviderEMail.Text)
   else if Sender=ctrProviderEMail2 then Jump('MailTo:'+oProviderEMail2.Text)
   else if Sender=ctrFileMark then
   begin
      BitCheckBox1.Checked:=not BitCheckBox1.Checked;
      if BitCheckBox1.Checked then
      begin
         ctrFileMark.Bitmap:=BitCheckBox1.CheckedGlyph;
         SL.Strings.Add(dsFiles.Dataset.FieldByName('FileName').AsString+','+dsFiles.Dataset.FieldByName('StoredInDir').AsString+','+dsFiles.Dataset.FieldByName('Category').AsString);
      end
      else
      begin
         ctrFileMark.Bitmap:=BitCheckBox1.UncheckedGlyph;
         SLDelete(SL.Strings,dsFiles.Dataset.FieldByName('FileName').AsString+','+dsFiles.Dataset.FieldByName('StoredInDir').AsString+','+dsFiles.Dataset.FieldByName('Category').AsString);
      end;
   end
   else if Sender=ctrDefaultSite then
   begin
     Ini.WriteString('Settings','URL',tMirrors.FieldByName('URL').AsString);
      ctrDefaultSite.Enabled:=False;
   end
   else if Sender=ctrDefaultSite2 then
   begin
      Ini.WriteString('Settings','URL',oDSPURL2.Text);
      ctrDefaultSite2.Enabled:=False;
   end;

end;

procedure TfMain.CheckFilesControls;
var
   aNode:TTreeNode;
begin
   if (LastNode.Parent.GetFirstChild=LastNode.Parent.GetLastChild) then
   begin
      ctrFirst.Enabled:=False;
      ctrPrior.Enabled:=False;
      ctrNext.Enabled:=False;
      ctrLast.Enabled:=False;
      ctrFind.Enabled:=False;
   end
   else
   begin
      if LastNode=LastNode.Parent.GetFirstChild then
      begin
         ctrFirst.Enabled:=False;
         ctrPrior.Enabled:=False;
         ctrNext.Enabled:=True;
         ctrLast.Enabled:=True;
      end
      else if LastNode=LastNode.Parent.GetLastChild then
      begin
         ctrFirst.Enabled:=True;
         ctrPrior.Enabled:=True;
         ctrNext.Enabled:=False;
         ctrLast.Enabled:=False;
      end
      else
      begin
         ctrFirst.Enabled:=True;
         ctrPrior.Enabled:=True;
         ctrNext.Enabled:=True;
         ctrLast.Enabled:=True;
      end;
      ctrFind.Enabled:=True;
   end
end;

procedure TfMain.AddMirrorsNodes;
var
ANode:TTreeNode;
begin
   TreeView1.items.BeginUpdate;
   tMirrors.First;
   while not tMirrors.Eof do
   begin
      FieldList.clear;
      FieldList.add('DSP');
      FieldList.add('Mirrors');
      FieldList.add(tMirrors.FieldByName('Continent').AsString);
      ANode:=TreeAddItem(TreeView1, FieldList, tMirrors.GetBookmark, false,false);
      ANode.ImageIndex:=2;
      ANode.SelectedIndex:=2;
      tMirrors.Next;
   end;
      tMirrors.First;
   while not tMirrors.Eof do
   begin
      FieldList.clear;
      FieldList.add('DSP');
      FieldList.add('Mirrors');
      FieldList.add(tMirrors.FieldByName('Continent').AsString);
      FieldList.add(tMirrors.FieldByName('Country').AsString);
      ANode:=TreeAddItem(TreeView1, FieldList, tMirrors.GetBookmark, false,false);
      ANode.ImageIndex:=2;
      ANode.SelectedIndex:=2;
      tMirrors.Next;
   end;

   tMirrors.First;
   while not tMirrors.Eof do
   begin
      FieldList.clear;
      FieldList.add('DSP');
      FieldList.add('Mirrors');
      FieldList.add(tMirrors.FieldByName('Continent').AsString);
      FieldList.add(tMirrors.FieldByName('Country').AsString);
      FieldList.add(tMirrors.FieldByName('ProviderName').AsString);
      ANode:=TreeAddItem(TreeView1, FieldList, tMirrors.GetBookmark, false,false);
      ANode.ImageIndex:=4;
      ANode.SelectedIndex:=4;
      tMirrors.Next;
   end;

   TreeView1.items.Endupdate;
end;


procedure TfMain.dsMirrorsDataChange(Sender: TObject; Field: TField);
begin
if fMain.Visible then
 begin
   if tMirrors.FieldByName('URL').AsString=Ini.ReadString('Settings','URL','') then
   begin
      ctrDefaultSite.Enabled:=False;
   end
   else
   begin
      ctrDefaultSite.Bitmap:=BitCheckBox1.UncheckedGlyph;
      ctrDefaultSite.Enabled:=True;
   end;
   end;
end;

procedure TfMain.AddMarkedFilesNodes(Node:TTreeNode);
var
   n:integer;
   ANode:TTreeNode;
   S:string;
   p,folder,category:integer;
begin
   TreeView1.Items.BeginUpdate;
   Node.DeleteChildren;
   Node.HasChildren:=True;
   for n:=0 to (SL.Strings.Count-1) do
   begin
      S:=SL.Strings[n];
      ANode:=TreeView1.Items.AddChild(Node, ExtractS(S,','));
      Folder:=StrToInt(ExtractS(S,','));
      Category:=StrToInt(S);
      SetBitmap(ANode,folder,category);
   end;
   TreeView1.Items.EndUpdate;
end;

procedure TfMain.Jump(URL:String);
begin
   GoToWeb1.URL:=URL;
   GoToWeb1.Execute;
end;

procedure TfMain.mClick(Sender: TObject);
begin
   if Sender=mAbout then fAbout.ShowModal
   else if Sender=mRemove then SL.Clear
   else if Sender=mFilter then fFilter.ShowModal
   else if Sender=mdbDown then Jump('http://sunsite.icm.edu.pl/delphi/off-line/dsp_db.zip')
   else if Sender=mUploadStat then fUploadStat.ShowModal
   else if Sender=mExit then Close;
end;

procedure TfMain.TreeView1Expanding(Sender: TObject; Node: TTreeNode;
  var AllowExpansion: Boolean);
begin
   Screen.Cursor:=crHourglass;
   dsFiles.Enabled:=False;
   //
   if  (Node.Level=1) and (Node.Text='Files') and (not ReallyHasChildren(Node))then
      AddFilesNodes(Node)
   else if (Node.Level=1) and (Node.Text='Marked Files') then
      AddMarkedFilesNodes(Node)
   else if (Node.Level=1) and (Node.Text='Authors') and (not ReallyHasChildren(Node))then
   begin
      SQLNode:=Node;
      AddAuthorsNodes(Node)
   end
   else if (Node.Level=1) and (Node.Text='Mirrors') and (not ReallyHasChildren(Node))then
      AddMirrorsNodes
   else if (Node.Level=2) and isSubChildS(node,'DSP\Authors') and (not ReallyHasChildren(Node))then
   begin
      SQLNode:=Node;
      AddAuthorFilesNodes(Node)
   end
   else if (Node.Level=3) and (isSubChildS(node,'DSP\Files')) and (not ReallyHasChildren(Node))then
   begin
      SQLNode:=Node;
      AddFilesFilesNodes(Node)
   end
   ;
   LastNode:=Node;
   UpdatePanels(Node);
   StatusPanelNodes.Caption:=' '+IntToStr(Node.Count)+' Object(s)';

   Screen.Cursor:=crDefault;
end;

procedure TfMain.SetBitmap(Node:TTreeNode; Folder:integer; Category:integer);
var
ii:integer;
begin
   case folder of
      3,6,9,12: ii:=7;
      else
      begin
         case Category of
            5: ii:=8;
            6: ii:=9;
            14: ii:=10;
            11: ii:=11;
            8: ii:=12;
            1: ii:=13;
            16: ii:=14;
            10: ii:=15;
            3: ii:=16;
            15: ii:=17;
            9: ii:=18;
            13: ii:=19;
            4: ii:=20;
            12: ii:=21;
            2: ii:=22;
            7: ii:=23;
         end;
      end;
   end;
         Node.ImageIndex:=ii;
         Node.SelectedIndex:=ii;
end;

procedure TfMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   FieldList.Free;
   Ini.Free;
end;

end.
