unit TreeFunc;

interface

uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DB, DBTables, ComCtrls, Grids, DBGrids, ExtCtrls,
  DBCtrls, Mask, Wwquery, lmdctrl, Lmdsplta, lmdstdcS, Lmddbctr, Wwdbedit,
  Wwdatsrc, Wwtable, ABCdbCtl, Wwdbigrd, Wwdbgrid, DBCGrids, IP;
  
function TreeFindItem(Sender: TTreeView; NodeItem: TTreeNode; Name: String): TTreeNode;
function TreeAddItem(Sender: TTreeView; ItemList: TStrings; Bookmark: TBookmark; Resort: Boolean; HasC:Boolean): TTreeNode;
function  TreeGetItem(Sender: TTreeView; ItemList: TStrings): TTreeNode;
procedure TreeDeleteItem(Sender: TTreeView; ItemList: TStrings; Level: Integer);
//function GetList( Node: TTreeNode):TStringList;
//function isSubChildS(Node:TTreeNode; SubStr:String):Boolean;
//String List
procedure GetList( Node: TTreeNode; var Strings:TStrings);
function isSubChildS(Node:TTreeNode; SubStr:String):Boolean;
procedure SLAdd(var SL:TStrings; Str:String);
procedure SLDelete(SL:TStrings; Str:String);
function SLContains(SL:TStrings; Str:String):Boolean;
function ReallyHasChildren(Node:TTreeNode):Boolean;

implementation


function TreeAddItem(Sender: TTreeView; ItemList: TStrings; Bookmark: TBookmark; Resort: Boolean; HasC:Boolean): TTreeNode;
var
   ThisNode, Node: TTreeNode;
   I: Integer;
begin
     Node := nil;   //nil = level 0 has no parent node
                    //this is checked by TreeFindItem
     for I := 0 to Itemlist.count -1 do
     begin
          ThisNode := TreeFindItem(Sender, node, Itemlist[i]);
          if ThisNode <> nil then Node := ThisNode else
          begin
               if I < Itemlist.count -1 then
               begin
                    if I = 0 then Node := Sender.items.Add(Node, Itemlist[i])
                    else Node := Sender.items.AddChild(Node, Itemlist[i]);
               end
               else
               begin
                    if I = 0 then Node := Sender.items.AddObject(Node, Itemlist[i], Bookmark)
                    else Node := Sender.items.AddChildObject(Node, Itemlist[i], Bookmark);
               end;
               Node.stateIndex := Node.level + 1;
               if Resort and (Node.parent <> nil) then Node.parent.alphasort;

          end;
     end;
     if (Result<>nil) and (HasC=True) then Node.HasChildren:=True;
     Result := Node;
end;

function TreeFindItem(Sender: TTreeView; NodeItem: TTreeNode; Name: String): TTreeNode;
begin
     if NodeItem = nil then NodeItem := Sender.items.getfirstnode
     else NodeItem := NodeItem.getfirstchild;
//NodeItem is now the first item of the desired level
//if this level has no items, NodeItem is nil

     if (NodeItem <> nil) and (NodeItem.text <> Name) then
     repeat
           NodeItem := NodeItem.getnextsibling;
     until (NodeItem = nil) or (NodeItem.text = Name);
     Result := NodeItem;
end;

function TreeGetItem(Sender: TTreeView; ItemList: TStrings): TTreeNode;
begin
     Result := TreeAddItem(Sender, Itemlist, nil, false,false);
end;

procedure TreeDeleteItem(Sender: TTreeView; ItemList: TStrings; Level: Integer);
var
   Node, Parent: TTreeNode;
begin
     Node := TreeGetItem(Sender, ItemList);
     while Node.level >= Level do
     begin
          Parent := Node.parent;
          Node.delete;
          if (Parent = nil) or (Parent.hasChildren) then break;
          Node := Parent;
     end;
end;

procedure GetList( Node: TTreeNode; var Strings:TStrings);
var
   SL: TStrings;
   n:integer;
begin
      SL := TStringList.create;
      SL.Clear;
      Strings.Clear;
      SL.Add(Node.Text);
      while Node.level > 0 do
      begin
         Node := Node.parent;
         SL.Add(Node.Text);
      end;
      for n:=0 to SL.count-1 do
         Strings.Add(SL[SL.count-1-n]);
      SL.Clear;
end;

function isSubChildS(Node:TTreeNode; SubStr:String):Boolean;
label 1;
var
   SL:TStrings;
   n:integer;
   s:String;
   Res:Boolean;
begin
   Res:=False;
   SL:=TStringList.create;
   SL.Clear;
   GetList(Node,SL);
   if SL.count<2 then goto 1;
   for n:=0 to SL.count-2 do
      s:=s+SL[n]+'\';
   s:=LeftS(S,Length(S)-1);
   if pos(SubStr,s)=1 then Res:=True;
   1:
   Result:=Res;
   SL.Clear;
end;

{function GetList( Node: TTreeNode):TStringList;
var
   Parent: TTreeNode;
   a,b: TStringList;
   n:integer;
begin
   a := TStringList.create;
   b := TStringList.create;
      a.Add(Node.Text);
      while Node.level > 0 do
      begin
         Parent := Node.parent;
         a.Add(Parent.Text);
         Node := Parent;
      end;
      for n:=0 to a.count-1 do
         b.Add(a.strings[a.count-1-n]);
    result:=b;
end;

function isSubChildS(Node:TTreeNode; SubStr:String):Boolean;
label 1;
var
   StringList:TStringList;
   n:integer;
   s:String;
   Res:Boolean;
begin
   Res:=False;
   StringList:=TStringList.create;
   StringList:=GetList(Node);
   if StringList.count<2 then goto 1;
   for n:=0 to StringList.count-2 do
      s:=s+StringList[n]+'\';
   s:=LeftS(S,Length(S)-1);
   if pos(SubStr,s)=1 then Res:=True;
   1:
   Result:=Res;

end;   }



procedure SLAdd(var SL:TStrings; Str:String);
var
   n:integer;
   Found:Boolean;
begin
   Found:=False;
   for n:=0 to (SL.Count-1) do
   begin
      if SL[n]=Str then
      begin
      Found:=True;
      Break;
      end;
   end;
   if Found=False then
   begin
      SL.Add(Str);
   end;
end;

procedure SLDelete(SL:TStrings; Str:String);
var
   n:integer;
begin
   for n:=0 to (SL.Count-1) do
   begin
      if SL[n]=Str then
      begin
         SL.Delete(n);
         Break;
      end;
   end;
end;

function SLContains(SL:TStrings; Str:String):Boolean;
var
   n:integer;
   Found: Boolean;
begin
   Found:=False;
   for n:=0 to (SL.Count-1) do
   begin
      if SL[n]=Str then
      begin
         Found:=True;
         Break;
      end;
   end;
   Result:=Found;
end;

function ReallyHasChildren(Node:TTreeNode):Boolean;
begin
if Node.GetFirstChild=nil then Result:=False else Result:=True;
end;


end.
