unit IP;

interface

uses Math, SysUtils;

{INFOPLUS routines}

//String operations
function LeftS(S:String;n:integer):String;
function RightS(S:String;n:integer):String;
function MakeS(C:Char;FDecimals:integer):String;
function Slovima(Num:Double):String;
   function s1(C:Char):String;
   function s2(C:Char):String;
function ExtractS(var S:String; Symb: Char): string;
//Rounding
function RoundFF(Number:extended;FDecimals:integer):extended;
function RoundFS(Number:extended;FDecimals:integer;characters:integer):string;
           
{
   Postotni raun
   Matematiki model
   Vrijedi: a+b=c, a+a*p/100=c
   Izvedene formule: b=p*c/(100+p), p=100b/a , a=100c/(100+p), p=100c/a-100

   Primjer a b c
           6 3 9
           p=50
   ..
   a...broj bez vrijednosti postotka - BBVP
   b...vrijednost postotka - VP
   c...broj sa ukljucenom vrijednou postotka - BSUVP
   p...postotak - POS
}
function VUP(c:Double;p:Double):Double;
function POSTO(a:Double;b:Double):Double;
function VPAdd(a:Double;p:Double):Double;
function VPSub(a:Double;p:Double):Double;

implementation

function VUP(c:Double;p:Double):Double;
begin
VUP:=p*c/(100+p);
end;

function POSTO(a:Double;b:Double):Double;
begin
Result:=100*b/a;
end;

function VPAdd(a:Double;p:Double):Double;
begin
VPAdd:=a+a*p/100;
end;

function VPSub(a:Double;p:Double):Double;
begin
VPSub:=a-a*p/100;
end;

function LeftS(S:String;n:integer):String;
var
len:integer;
begin
len:=Length(S);
if n<0 then n:=0;
if n>len then n:=len;
LeftS:=Copy(S,1,n);
end;

function RightS(S:String;n:integer):String;
var
len:integer;
begin
len:=Length(S);
if n<0 then n:=0;
if n>len then n:=len;
RightS:=Copy(S,len-n+1,n);
end;

function MakeS(C:Char;FDecimals:integer):String;
begin
StringOfChar(C, FDecimals)
end;

function RoundFF(Number:extended;FDecimals:integer):extended;
begin
RoundFF:=StrToFloat(RoundFS(Number,FDecimals,0));
end;

function RoundFS(Number:extended;FDecimals:integer;Characters:integer):string;
var
FormatMask,S : string;
begin
  if FDecimals = 0 then
     FormatMask := '0'
  else
     FormatMask := '0.'+StringOfChar('0', FDecimals);
  S := FormatFloat(FormatMask, Number);
  if (Length(S)>Characters) and (Characters<>0) then
     RoundFS:=MakeS('-',Characters)
  else
      S:=MakeS(' ',Characters-Length(S))+S;
     RoundFS:=S;
end;

function Slovima(Num:Double):String;
label exit1,exit2,exit3,exit4;
var
S:string;
arS  : array[1..4] of String;
n:integer;
begin
S:=MakeS('0',20)+RoundFS(Num,2,0);
S:=RightS(S,12);
arS[1]:=Copy(S,1,3);
arS[2]:=Copy(S,4,3);
arS[3]:=Copy(S,7,3);
arS[4]:=Copy(S,11,2);
S:='';
//------------------------------------
if StrToInt(arS[1])=0 then goto exit1;
S:=S+s1(arS[1][1]);
case arS[1][2] of
'1': begin
     S:=S+s2(arS[1][3])+'miliona';
     goto exit1;
     end;
'2': S:=S+'dvadeset';
'3': S:=S+'trideset';
'4': S:=S+'etrdeset';
'5': S:=S+'pedeset';
'6': S:=S+'ezdeset';
'7': S:=S+'sedamdeset';
'8': S:=S+'osamdeset';
'9': S:=S+'devedeset';
end;

case arS[1][3] of
'0': S:=S+'miliona';
'1': S:=S+'jedanmilion';
'2': S:=S+'dvamiliona';
'3': S:=S+'trimiliona';
'4': S:=S+'etirimiliona';
'5': S:=S+'petmiliona';
'6': S:=S+'estmiliona';
'7': S:=S+'sedammiliona';
'8': S:=S+'osammiliona';
'9': S:=S+'devetmiliona';
end;
exit1:
//------------------------------------
if StrToInt(arS[2])=0 then goto exit2;
S:=S+s1(arS[2][1]);
case arS[2][2] of
'1': begin
     S:=S+s2(arS[2][3])+'tisua';
     goto exit2;
     end;
'2': S:=S+'dvadeset';
'3': S:=S+'trideset';
'4': S:=S+'etrdeset';
'5': S:=S+'pedeset';
'6': S:=S+'ezdeset';
'7': S:=S+'sedamdeset';
'8': S:=S+'osamdeset';
'9': S:=S+'devedeset';
end;

case arS[2][3] of
'0': S:=S+'tisua';
'1': S:=S+'jednatisua';
'2': S:=S+'dvijetisue';
'3': S:=S+'tritisue';
'4': S:=S+'etiritisue';
'5': S:=S+'pettisua';
'6': S:=S+'esttisua';
'7': S:=S+'sedamtisua';
'8': S:=S+'osamtisua';
'9': S:=S+'devettisua';
end;
exit2:

//------------------------------------
if StrToInt(arS[1]+arS[2]+arS[3])=0 then goto exit3;
S:=S+s1(arS[3][1]);
case arS[3][2] of
'1': begin
     S:=S+s2(arS[3][3])+'kuna';
     goto exit3;
     end;
'2': S:=S+'dvadeset';
'3': S:=S+'trideset';
'4': S:=S+'etrdeset';
'5': S:=S+'pedeset';
'6': S:=S+'ezdeset';
'7': S:=S+'sedamdeset';
'8': S:=S+'osamdeset';
'9': S:=S+'devedeset';
end;

case arS[3][3] of
'0': S:=S+'kuna';
'1': S:=S+'jednakuna';
'2': S:=S+'dvijekune';
'3': S:=S+'trikune';
'4': S:=S+'etirikune';
'5': S:=S+'petkuna';
'6': S:=S+'estkuna';
'7': S:=S+'sedamkuna';
'8': S:=S+'osamkuna';
'9': S:=S+'devetkuna';
end;
exit3:
//---------------------------------
if StrToInt(arS[4])=0 then goto exit4;
if StrToInt(arS[1]+arS[2]+arS[3])<>0 then S:=S+'i';
case arS[4][1] of
'1': begin
     S:=S+s2(arS[4][2])+'lipa';
     goto exit4;
     end;
'2': S:=S+'dvadeset';
'3': S:=S+'trideset';
'4': S:=S+'etrdeset';
'5': S:=S+'pedeset';
'6': S:=S+'ezdeset';
'7': S:=S+'sedamdeset';
'8': S:=S+'osamdeset';
'9': S:=S+'devedeset';
end;

case arS[4][2] of
'0': S:=S+'lipa';
'1': S:=S+'jednalipa';
'2': S:=S+'dvijelipe';
'3': S:=S+'trilipe';
'4': S:=S+'etirilipe';
'5': S:=S+'petlipa';
'6': S:=S+'estlipa';
'7': S:=S+'sedamlipa';
'8': S:=S+'osamlipa';
'9': S:=S+'devetlipa';
end;
exit4:
//---------------------------------
slovima:=S;
end;

function s1(C:Char):String;
var
S:String;
begin
     S:='';
     case C of
     '1': S:=S+'sto';
     '2': S:=S+'dvjesto';
     '3': S:=S+'tristo';
     '4': S:=S+'etristo';
     '5': S:=S+'petsto';
     '6': S:=S+'esto';
     '7': S:=S+'sedamsto';
     '8': S:=S+'osamsto';
     '9': S:=S+'devetsto';
    end;
s1:=S;
end;

function s2(C:Char):String;
var
S:String;
begin
     S:='';
     case C of
     '0': S:=S+'deset';
     '1': S:=S+'jedanaest';
     '2': S:=S+'dvanaest';
     '3': S:=S+'trinaest';
     '4': S:=S+'etrnaest';
     '5': S:=S+'petnaest';
     '6': S:=S+'estnaest';
     '7': S:=S+'sedamnaest';
     '8': S:=S+'osamnaest';
     '9': S:=S+'devetnaest';
     end;
s2:=S;
end;

function ExtractS(var S:String; Symb: Char): string;
var
   p:integer;
begin
   p:=POS(Symb,S);
   Result:=LeftS(S,p-1);
   S:=RightS(S,Length(S)-p);
end;

end.
