unit dbdial3;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls,db,dialogs, explbtn;

type
  TDBFinddialog3 = class(TForm)
    Panel1: TPanel;
    ctrFirst: TExplorerButton;
    ctrPrior: TExplorerButton;
    ctrNext: TExplorerButton;
    ctrLast: TExplorerButton;
    ctrCancel: TExplorerButton;
    PanelSearch: TPanel;
    Findwhat: TEdit;
    CBwhere: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    CBmatchcase: TCheckBox;
    Label4: TLabel;
    Label3: TLabel;
    BoxPosition: TComboBox;
    procedure Find;
    procedure FormShow(Sender: TObject);
    procedure ctrClick(Sender: TObject);
    procedure EnableButtons;
    procedure DisableButtons;
    procedure CBwhereChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DBFinddialog3: TDBFinddialog3;
  Direction : String;
  jump : Boolean;
  jumped : Boolean;
const
  breek: integer=0;
implementation

uses DBFind3reg;

{$R *.DFM}

procedure TDBFinddialog3.Find;
var
ToFind: string;         {String to find}
FindIn: string;         {String to search}
al: integer;
altext: string;
Found: integer;         {String found indicator}
Index: integer;         {Start pos. of found text}
FoundLen: integer;      {Length of found text}
myBookmark : TBookmark;
label 1;
const
i:integer=0;
             
begin
breek:=0;
STable.EnableControls;
i:=0;
DisableButtons;

1: if i=0 then  STable.DisableControls;

application.processmessages;

if breek=1 then begin
  EnableButtons;
  STable.EnableControls;
  i:=0;
  exit;
 end; 

jumped:=True;
if jump = false then begin
   if Direction='Up' then STable.prior else STable.next;
   jumped:=False;
end;
jump:=False;

if CBmatchcase.checked = true then ToFind := Findwhat.text else ToFind := LowerCase(Findwhat.text);     {User specified string in dialog}
try
begin
if CBwhere.text <> '(All columns)' then FindIn := STable.FieldByName(CBwhere.text).AsString      {Text to search for string}
  else
   begin
    altext:='';
    for al := 0 to STable.FieldCount - 1 do
     begin
      if STable.Fields[al].datatype<>ftGraphic then altext:=altext+STable.Fields[al].asstring;
     end;
    FindIn:=altext;
    end;
 end
except
  begin
  EnableButtons;
  STable.EnableControls;
  ShowMessage('DBFind error!');
  i:=0;
  if Direction='Up' then STable.next else STable.prior;
  exit;
  end;
 end;
  
if CBmatchcase.checked = true then Findin := Findin else Findin := LowerCase(Findin);     {User specified string in dialog}

Found := Pos(ToFind, FindIn);    {Search for string}

if ((Found=1) and (BoxPosition.ItemIndex=0)) or ((Found>=1) and (BoxPosition.ItemIndex=1)) then
  begin
  EnableButtons;
  STable.EnableControls;
  i:=0;
  beep;
  exit;
  end
else begin
     if jumped=True then begin
        i:=1;
        goto 1;
        end
     else if (STable.EOF) or (STable.BOF) then begin
        EnableButtons;
        STable.EnableControls;
        i:=0;
        showmessage('"'+Findwhat.text+'" not found!');
        exit;
     end;
   i:=1;
  goto 1;
  end;
end;

procedure TDBFinddialog3.FormShow(Sender: TObject);
var
i:integer;
begin
 Direction:='Down';
 CBwhere.items.clear;
 CBwhere.items.add('(All columns)');
 for i := 0 to STable.FieldCount - 1 do
 begin
  if STable.Fields[i].datatype<>ftGraphic then  CBwhere.items.add(STable.Fields[i].FieldName);
 end;
 CBwhere.ItemIndex:=0;
 CBwhereChange(CBwhere);
end;

procedure TDBFinddialog3.ctrClick(Sender: TObject);
begin
if sender=ctrFirst then begin
   jump:=true;
   STable.DisableControls;
   STable.First;
   Direction:='Down';
   Find;
   end
else if sender=ctrLast then begin
   jump:=true;
   STable.DisableControls;
   STable.Last;
   Direction:='Up';
   Find;
   end
else if sender=ctrPrior then begin
   jump:=False;
   Direction:='Up';
   Find;
   end
else if sender=ctrNext then begin
   jump:=False;
   Direction:='Down';
   Find;
   end
else if sender=ctrCancel then begin
   breek:=1;
   application.processmessages;
   close;
   end
end;

procedure TDBFinddialog3.EnableButtons;
begin
ctrFirst.enabled:=True;
ctrPrior.enabled:=True;
ctrNext.enabled:=True;
ctrLast.enabled:=True;
end;

procedure TDBFinddialog3.DisableButtons;
begin
ctrFirst.enabled:=False;
ctrPrior.enabled:=False;
ctrNext.enabled:=False;
ctrLast.enabled:=False;
end;

procedure TDBFinddialog3.CBwhereChange(Sender: TObject);
begin
if CBwhere.ItemIndex=0 then begin
BoxPosition.Enabled:=False; BoxPosition.ItemIndex:=1;
end else BoxPosition.Enabled:=True;
end;

end.
