unit DBUpdateControls;

interface

uses
  Windows,WinTypes, WinProcs, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Messages, StdCtrls, Buttons, dbconsts, DB, DBTables, Explbtn;

type
  TMyDataLink = class;
  TDBUpdateControls = class(TComponent)
  private
    { Private declarations }
   FDataLink: TMyDataLink;
   ctrTable : Tdataset;
   oFirst : TExplorerButton;
   oPrior : TExplorerButton;
   oNext : TExplorerButton;
   oLast : TExplorerButton;
   oNew : TExplorerButton;
   oDelete : TExplorerButton;
   oEdit : TExplorerButton;
   oSave : TExplorerButton;
   oCancel : TExplorerButton;
   oFind : TExplorerButton;
   oPrint : TExplorerButton;
   oMenu : TExplorerButton;
   oDuplicate : TExplorerButton;
   oStorno : TExplorerButton;
   procedure BrowseAndExist;
   function GetDataSource: TDataSource;
   procedure SetDataSource(Value: TDataSource);

  protected
    { Protected declarations }
    procedure DataChange;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure Loaded; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Refresh;
  published
    { Published declarations }
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property ControlDataset: Tdataset read ctrTable write ctrTable;
    property FirstButton: TExplorerButton  read oFirst write oFirst;
    property PriorButton: TExplorerButton  read oPrior write oPrior;
    property NextButton: TExplorerButton  read oNext write oNext;
    property LastButton: TExplorerButton  read oLast write oLast;
    property NewButton: TExplorerButton  read oNew write oNew;
    property DeleteButton: TExplorerButton  read oDelete write oDelete;
    property EditButton: TExplorerButton  read oEdit write oEdit;
    property SaveButton: TExplorerButton  read oSave write oSave;
    property CancelButton: TExplorerButton  read oCancel write oCancel;
    property FindButton: TExplorerButton  read oFind write oFind;
    property PrintButton: TExplorerButton  read oPrint write oPrint;
    property MenuButton: TExplorerButton  read oMenu write oMenu;
    property DuplicateButton: TExplorerButton  read oDuplicate write oDuplicate;
    property StornoButton: TExplorerButton  read oStorno write oStorno;

end;

{ TMyDataLink }
  TMyDataLink = class(TDataLink)
  private
    FState: TDBUpdateControls;
  protected
    procedure EditingChanged; override;
    procedure ActiveChanged; override;
    procedure DataSetChanged; override;
  public
    constructor Create(AState: TDBUpdateControls);
    destructor Destroy; override;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('InfoPlus', [TDBUpdateControls]);
end;

//=============================================================================
{ TMyDataLink }
constructor TMyDataLink.Create(AState: TDBUpdateControls);
begin
  inherited Create;
  FState := AState;
end;

destructor TMyDataLink.Destroy;
begin
  FState := nil;
  inherited Destroy;
end;

procedure TMyDataLink.EditingChanged;
begin
  if FState <> nil then FState.DataChange;
end;

procedure TMyDataLink.DataSetChanged;
begin
  if FState <> nil then FState.DataChange;
end;

procedure TMyDataLink.ActiveChanged;
begin
  if FState <> nil then FState.DataChange;
end;

// TDBUpdateControls ===========================================================
constructor TDBUpdateControls.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FDataLink := TMyDataLink.Create(Self);
 end;

destructor TDBUpdateControls.Destroy;
begin
  FDataLink.Free;
  inherited Destroy;
end;

procedure TDBUpdateControls.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (FDataLink <> nil) and (AComponent = DataSource) then DataSource := nil;
  if (Operation = opRemove) and (AComponent = ControlDataset) then ControlDataset := nil;
  if (Operation = opRemove) and (AComponent = FirstButton) then FirstButton := nil;
  if (Operation = opRemove) and (AComponent = PriorButton) then PriorButton := nil;
  if (Operation = opRemove) and (AComponent = NextButton) then NextButton := nil;
  if (Operation = opRemove) and (AComponent = LastButton) then LastButton := nil;
  if (Operation = opRemove) and (AComponent = NewButton) then NewButton := nil;
  if (Operation = opRemove) and (AComponent = DeleteButton) then DeleteButton := nil;
  if (Operation = opRemove) and (AComponent = EditButton) then EditButton := nil;
  if (Operation = opRemove) and (AComponent = SaveButton) then SaveButton := nil;
  if (Operation = opRemove) and (AComponent = CancelButton) then CancelButton := nil;
  if (Operation = opRemove) and (AComponent = FindButton) then FindButton := nil;
  if (Operation = opRemove) and (AComponent = PrintButton) then PrintButton := nil;
  if (Operation = opRemove) and (AComponent = MenuButton) then MenuButton := nil;
  if (Operation = opRemove) and (AComponent = DuplicateButton) then DuplicateButton := nil;
  if (Operation = opRemove) and (AComponent = StornoButton) then StornoButton := nil;

end;

procedure TDBUpdateControls.Loaded;
begin
  inherited Loaded;
  DataChange;
end;

procedure TDBUpdateControls.SetDataSource(Value: TDataSource);
begin
  FDataLink.DataSource := Value;
  if not (csLoading in ComponentState) then
    DataChange;
end;

function TDBUpdateControls.GetDataSource: TDataSource;
begin
  Result := FDataLink.DataSource;
end;

procedure TDBUpdateControls.DataChange;
begin
if (FDataLink <> nil) and (FDataLink.DataSource <> nil) then
      Refresh
end;


//=============================================================================

procedure TDBUpdateControls.Refresh;
begin
if (FDataLink.DataSet<>nil) and (FDataLink.DataSet.State<>dsInactive)then begin
if FDataLink.DataSet.State=dsBrowse then begin
     if FDataLink.DataSet.EOF and FDataLink.DataSet.BOF then begin //record count =0

                if (ctrTable<>nil) and (ctrTable.State=dsBrowse) then begin
                         if oNew<>nil then oNew.enabled:=false;
                end else if oNew<>nil then oNew.enabled:=true;

        if oDelete<>nil then oDelete.enabled:=false;
        if oEdit<>nil then oEdit.enabled:=false;
        if oSave<>nil then oSave.enabled:=false;
        if oCancel<>nil then oCancel.enabled:=false;
        if oFind<>nil then oFind.enabled:=false;
        if oPrint<>nil then oPrint.enabled:=false;
        if oMenu<>nil then oMenu.enabled:=false;
        if oDuplicate<>nil then oDuplicate.enabled:=false;
        if oStorno<>nil then oStorno.enabled:=false;
        if oFirst<>nil then oFirst.enabled:=false;
        if oPrior<>nil then oPrior.enabled:=false;
        if oNext<>nil then oNext.enabled:=false;
        if oLast<>nil then oLast.enabled:=false;
     end else if FDataLink.DataSet.BOF then begin
        BrowseAndExist;
        if oFirst<>nil then oFirst.enabled:=false;
        if oPrior<>nil then oPrior.enabled:=false;
        if oNext<>nil then oNext.enabled:=true;
        if oLast<>nil then oLast.enabled:=true;
    end else if FDataLink.DataSet.EOF then begin
        BrowseAndExist;
        if oFirst<>nil then oFirst.enabled:=true;
        if oPrior<>nil then oPrior.enabled:=true;
        if oNext<>nil then oNext.enabled:=false;
        if oLast<>nil then oLast.enabled:=false;
    end else begin //between BOF i EOF
        BrowseAndExist;
        if oFirst<>nil then oFirst.enabled:=true;
        if oPrior<>nil then oPrior.enabled:=true;
        if oNext<>nil then oNext.enabled:=true;
        if oLast<>nil then oLast.enabled:=true;
    end
end else if (FDataLink.DataSet.State=dsEdit) or (FDataLink.DataSet.State=dsInsert) then begin
        if oFirst<>nil then oFirst.enabled:=false;
        if oPrior<>nil then oPrior.enabled:=false;
        if oNext<>nil then oNext.enabled:=false;
        if oLast<>nil then oLast.enabled:=false;
        if oNew<>nil then oNew.enabled:=false;
        if oDelete<>nil then oDelete.enabled:=false;
        if oEdit<>nil then oEdit.enabled:=false;
        if oSave<>nil then oSave.enabled:=true;
        if oCancel<>nil then oCancel.enabled:=true;
        if oFind<>nil then oFind.enabled:=false;
        if oPrint<>nil then oPrint.enabled:=false;
        if oMenu<>nil then oMenu.enabled:=false;
        if oDuplicate<>nil then oDuplicate.enabled:=false;
        if oStorno<>nil then oStorno.enabled:=false;
end
end else begin
        if oNew<>nil then oNew.enabled:=false;
        if oEdit<>nil then oEdit.enabled:=false;
        if oDelete<>nil then oDelete.enabled:=false;
        if oSave<>nil then oSave.enabled:=false;
        if oCancel<>nil then oCancel.enabled:=false;
        if oFirst<>nil then oFirst.enabled:=false;
        if oPrior<>nil then oPrior.enabled:=false;
        if oNext<>nil then oNext.enabled:=false;
        if oLast<>nil then oLast.enabled:=false;
        if oFind<>nil then oFind.enabled:=false;
        if oPrint<>nil then oPrint.enabled:=false;
        if oMenu<>nil then oMenu.enabled:=false;
        if oDuplicate<>nil then oDuplicate.enabled:=false;
        if oStorno<>nil then oStorno.enabled:=false;
                
end;
end;

procedure TDBUpdateControls.BrowseAndExist;
begin
                if (ctrTable<>nil) and (ctrTable.State=dsBrowse) then begin
                        if (oNew<>nil) and (oNew.Enabled=True) then oNew.enabled:=false;
                        if (oDelete<>nil) and (oDelete.Enabled=True) then oDelete.enabled:=false;
                        if (oEdit<>nil) and (oEdit.Enabled=True) then oEdit.enabled:=false;
                end else begin
                        if (oNew<>nil) and (oNew.Enabled=False) then oNew.enabled:=true;
                        if (oDelete<>nil) and (oDelete.Enabled=False) then oDelete.enabled:=true;
                        if (oEdit<>nil) and (oEdit.Enabled=False) then oEdit.enabled:=true;
                end;


        if (oSave<>nil) and (oSave.Enabled=True) then oSave.enabled:=false;
        if (oCancel<>nil) and (oCancel.Enabled=True) then oCancel.enabled:=false;
        if (oFind<>nil) and (oFind.Enabled=False) then oFind.enabled:=true;
        if (oPrint<>nil) and (oPrint.Enabled=False) then oPrint.enabled:=true;
        if (oMenu<>nil) and (oMenu.Enabled=False) then oMenu.enabled:=true;
        if (oDuplicate<>nil) and (oDuplicate.Enabled=False) then oDuplicate.enabled:=true;
        if (oStorno<>nil) and (oStorno.Enabled=False) then oStorno.enabled:=true;

end;
 
end.
