unit TNTEditor;

interface

uses Windows, TreeNT, SysUtils, Graphics, Forms, TB97, Menus, 
     ExtCtrls, StdCtrls, Dialogs, Controls, Classes;
             
type
  TTreeNTEditor = class(TForm)
    CancelButton: TToolbarButton97;
    OKButton: TToolbarButton97;
    PopupMenu: TPopupMenu;
    AddItem: TMenuItem;
    N1: TMenuItem;
    DelItem: TMenuItem;
    Panel1: TPanel;
    Panel2: TPanel;
    ImageBox: TScrollBox;
    DupItem: TMenuItem;
    StateImageBox: TScrollBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    FontButton: TToolbarButton97;
    FontDialog: TFontDialog;
    ColorDialog: TColorDialog;
    Label4: TLabel;
    ColorButton: TToolbarButton97;
    Label5: TLabel;
    ParentFontBox: TCheckBox;
    ParentColorBox: TCheckBox;
    Tree: TTreeNT;
    SImageBox: TScrollBox;
    Label6: TLabel;
    AddChildItem: TMenuItem;
    procedure CancelButtonClick(Sender: TObject);
    procedure CopyChildren(Source, Destination: TTreeNTNode);
    procedure OKButtonClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure InsertItemClick(Sender: TObject);
    procedure SelectedImageClick(Sender: TObject);
    procedure StateImageClick(Sender: TObject);
    procedure UnselectedImageClick(Sender: TObject);
    procedure TreeMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure DupItemClick(Sender: TObject);
    procedure PopupMenuPopup(Sender: TObject);
    procedure TreeChange(Sender: TObject; Node: TTreeNTNode);
    procedure TreeDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure TreeDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure TreeStartDrag(Sender: TObject; var DragObject: TDragObject);
    procedure FontButtonClick(Sender: TObject);
    procedure ColorButtonClick(Sender: TObject);
    procedure ParentFontBoxClick(Sender: TObject);
    procedure ParentColorBoxClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure DelItemClick(Sender: TObject);
    procedure AddChildItemClick(Sender: TObject);
  private
    FirstSImageButton,
    FirstImageButton,
    FirstStateButton   : TToolbarButton97;
  end;

var TreeNTEditor: TTreeNTEditor;

function EditTreeViewItems(EditItems: TTreeNTNodes): Boolean;

//------------------------------------------------------------------------------

implementation

{$R *.DFM}

//------------------------------------------------------------------------------

function EditTreeViewItems(EditItems: TTreeNTNodes): Boolean;

var Editor: TTreeNTEditor;

begin
  Application.CreateForm(TTreeNTEditor,Editor);
  try
    with Editor.Tree do
    begin
      Color:=TTreeNT(EditItems.Owner).Color;
      Options:=TTreeNT(EditItems.Owner).Options;
      Indent:=TTreeNT(EditItems.Owner).Indent;
      ItemHeight:=TTreeNT(EditItems.Owner).ItemHeight;
      Font:=TTreeNT(EditItems.Owner).Font;
      Images:=TTreeNT(EditItems.Owner).Images;
      StateImages:=TTreeNT(EditItems.Owner).StateImages;
      if EditItems.Count > 0 then
      begin
        Items.BeginUpdate;
        Items.Assign(EditItems);
        Items.EndUpdate;
      end;
      Selected:=nil;
      OnChange(Editor.Tree,nil);
    end;
    if Editor.ShowModal = mrOK then
    begin
      EditItems.BeginUpdate;
      EditItems.Assign(Editor.Tree.Items);
      EditItems.EndUpdate;
      Result:=True;
    end
    else Result:=False;
  finally
    Editor.Free;
  end;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.AddChildItemClick(Sender: TObject);

begin
  Tree.Items.AddChild(Tree.Selected,'New Node').MakeVisible;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.CancelButtonClick(Sender: TObject);

begin
  ModalResult:=mrCancel;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.OKButtonClick(Sender: TObject);

begin
  ModalResult:=mrOK;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.FormKeyPress(Sender: TObject; var Key: Char);

begin
  if Key = #27 then ModalResult:=mrCancel;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.InsertItemClick(Sender: TObject);

var Node : TTreeNTNode;

begin
  Node:=Tree.Selected;
  if assigned(Node) then Node:=Tree.Items.Insert(Node,'New Node')
                    else Node:=Tree.Items.Add(nil,'New Node');
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.CopyChildren(Source, Destination: TTreeNTNode);

var I : Integer;
    Node : TTreeNTNode;

begin
  if Source.Count > 0 then
  with Tree.Items do
    for I:=0 to Source.Count-1 do
    begin
      Node:=AddChild(Destination,'');
      Node.Assign(Source[I]);
      CopyChildren(Source[I],Node);
    end;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.DupItemClick(Sender: TObject);

var Node, NewNode : TTreeNTNode;

begin
  Node:=Tree.Selected;
  NewNode:=Tree.Items.Insert(Node,'');
  NewNode.Assign(Node);
  CopyChildren(Node,NewNode);
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.PopupMenuPopup(Sender: TObject);

begin
  if assigned(Tree.Selected) then
  begin
    DupItem.enabled:=True;
    DelItem.Enabled:=True;
    AddChildItem.Enabled:=True;
  end
  else
  begin
    DupItem.enabled:=False;
    DelItem.Enabled:=False;
    AddChildItem.Enabled:=False;
  end;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.SelectedImageClick(Sender: TObject);

var Rect : TRect;

begin
  with Sender as TToolbarButton97 do
  if assigned(Tree.Selected) then
  begin
    if Down then Tree.Selected.SelectedIndex:=Tag
            else Tree.Selected.SelectedIndex:=-1;
    Rect:=Tree.Selected.DisplayRect(False);
    InvalidateRect(Tree.Handle,@Rect,False);
    Tree.Refresh;
  end;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.StateImageClick(Sender: TObject);

begin
  with Sender as TToolbarButton97 do
  if assigned(Tree.Selected) then
    if Down then Tree.Selected.StateIndex:=Tag
            else Tree.Selected.StateIndex:=-1;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.UnselectedImageClick(Sender: TObject);

begin
  with Sender as TToolbarButton97 do
  if assigned(Tree.Selected) then
    if Down then Tree.Selected.ImageIndex:=Tag
            else Tree.Selected.ImageIndex:=-1;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.TreeMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);

var Node : TTreeNTNode;

begin
  Node:=Tree.GetNodeAt(X,Y);
  if assigned(Node)
    then Node.Selected:=True // set selection with right mouse button too
    else if assigned(Tree.Selected) then Tree.Selected.Selected:=False;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.TreeChange(Sender: TObject; Node: TTreeNTNode);

var AButton : TToolbarButton97;

begin
  if assigned(Tree.Images) then
  begin
    AButton:=nil;
    if assigned(Node) then AButton:=FindComponent('I'+IntToStr(Node.ImageIndex)) as TToolbarButton97;
    if assigned(AButton) then AButton.Down:=True
                         else
      if assigned(FirstImageButton) then
      begin
        FirstImageButton.Down:=True;
        FirstImageButton.Down:=False;
      end;
    AButton:=nil;
    if assigned(Node) then AButton:=FindComponent('SI'+IntToStr(Node.SelectedIndex)) as TToolbarButton97;
    if assigned(AButton) then AButton.Down:=True
                         else
      if assigned(FirstSImageButton) then
      begin
        FirstSImageButton.Down:=True;
        FirstSImageButton.Down:=False;
      end
  end;

  if assigned(Tree.StateImages) then
  begin
    AButton:=nil;
    if assigned(Node) then AButton:=FindComponent('STI'+IntToStr(Node.StateIndex)) as TToolbarButton97;
    if assigned(AButton) then AButton.Down:=True
                         else
      if assigned(FirstStateButton) then
      begin
        FirstStateButton.Down:=True;
        FirstStateButton.Down:=False;
      end
  end;
  if assigned(Node) then
  begin
    ParentFontBox.Checked:=Node.ParentFont;
    ParentColorBox.Checked:=Node.ParentColor;
    FontButton.enabled:=True;
    ColorButton.enabled:=True;
    ParentFontBox.Enabled:=True;
    ParentColorBox.Enabled:=True;
  end
  else
  begin
    FontButton.enabled:=False;
    ColorButton.enabled:=False;
    ParentFontBox.Enabled:=False;
    ParentColorBox.Enabled:=False;
  end;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.TreeDragOver(Sender, Source: TObject; X,Y: Integer; State: TDragState; var Accept: Boolean);

var DestNode,
    SourceNode : TTreeNTNode;

begin
  DestNode:=Tree.GetNodeAT(X,Y);
  SourceNode:=Tree.Selected;
  if assigned(DestNode) then
    if not SourceNode.HasAsParent(DestNode) and
       not DestNode.HasAsParent(SourceNode) then Accept:=True
                                            else Accept:=False
                        else Accept:=True;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.TreeDragDrop(Sender, Source: TObject; X, Y: Integer);

var DestNode,
    SourceNode : TTreeNTNode;

begin
  DestNode:=Tree.GetNodeAT(X,Y);
  SourceNode:=Tree.Selected;
  if assigned(DestNode) then SourceNode.MoveTo(DestNode,naAddChild)
                        else SourceNode.MoveTo(nil,naAdd);
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.TreeStartDrag(Sender: TObject; var DragObject: TDragObject);

begin
  if Tree.Selected.Count > 0 then Tree.DragCursor:=crMultiDrag
                             else Tree.DragCursor:=crDrag;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.FontButtonClick(Sender: TObject);

begin
  FontDialog.Font:=Tree.Selected.Font;
  if FontDialog.Execute then Tree.Selected.Font:=FontDialog.Font;
  ParentFontBox.Checked:=Tree.Selected.ParentFont;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.ColorButtonClick(Sender: TObject);

begin
  with Tree.Selected do
  begin
    if ParentColor then ColorDialog.Color:=Tree.Color
                   else ColorDialog.Color:=Color;
    if ColorDialog.Execute then Tree.Selected.Color:=ColorDialog.Color;
  end;
  ParentColorBox.Checked:=Tree.Selected.ParentColor;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.ParentFontBoxClick(Sender: TObject);

begin
  if assigned(Tree.Selected) then Tree.Selected.ParentFont:=ParentFontBox.Checked;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.ParentColorBoxClick(Sender: TObject);

begin
  if assigned(Tree.Selected) then Tree.Selected.ParentColor:=ParentColorBox.Checked;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.FormShow(Sender: TObject);

var Button1,
    Button2  : TToolbarButton97;
    I        : Integer;
    ABitmap  : TBitmap;

begin
  ABitmap:=TBitmap.Create;
  if assigned(Tree.Images) then
    with Tree.Images do
    begin
      for I:=0 to Count-1 do
      begin
        // the form will own the buttons and destroy them
        // button for unselected image
        Button1:=TToolbarButton97.Create(Self);
        if I = 0 then FirstImageButton:=Button1;
        GetBitmap(I,ABitmap);
        with Button1 do
        begin
          Parent:=ImageBox;
          Width:=32;
          Height:=32;
          Glyph:=ABitmap;
          Top:=2;
          Left:=I*Width;
          GroupIndex:=1;
          Tag:=I;
          Name:='I'+IntToStr(I);
          AllowAllUp:=True;
          OnClick:=UnselectedImageClick;
        end;
        // button for the selected image
        Button2:=TToolbarButton97.Create(Self);
        if I = 0 then FirstSImageButton:=Button2;
        with Button2 do
        begin
          Parent:=SImageBox;
          Width:=32;
          Height:=32;
          Glyph:=ABitmap;
          Top:=2;
          Left:=I*Width;
          GroupIndex:=2;
          Tag:=I;
          Name:='SI'+IntToStr(I);
          AllowAllUp:=True;
          OnClick:=SelectedImageClick;
        end;
        ABitmap.Assign(nil);
      end;
      ImageBox.HorzScrollBar.Range:=Count*Button1.Width;
      SImageBox.HorzScrollBar.Range:=Count*Button2.Width;
    end;

  if assigned(Tree.StateImages) then
    with Tree.StateImages do
    begin
      for I:=0 to Count-1 do
      begin
        // the form will own the buttons and destroy them
        Button1:=TToolbarButton97.Create(Self);
        if I = 0 then FirstStateButton:=Button1;
        GetBitmap(I,ABitmap);
        with Button1 do
        begin
          Parent:=StateImageBox;
          Width:=32;
          Height:=32;
          Glyph:=ABitmap;
          Top:=2;
          Left:=I*Width;
          GroupIndex:=3;
          Tag:=I;
          Name:='STI'+IntToStr(I);
          AllowAllUp:=True;
          OnClick:=StateImageClick;
        end;
        ABitmap.Assign(nil);
      end;
      StateImageBox.HorzScrollBar.Range:=Count*Button1.Width;
    end;
  ABitmap.Free;
  ImageBox.Color:=Tree.Color;
  SImageBox.Color:=Tree.Color;
  StateImageBox.Color:=Tree.Color;
end;

//------------------------------------------------------------------------------

procedure TTreeNTEditor.DelItemClick(Sender: TObject);

begin
  Tree.Selected.DeleteChildren;
  Tree.Selected.Delete;
end;

//------------------------------------------------------------------------------

end.

