unit Main;

interface

uses Windows, Forms, StdCtrls, Buttons, Classes, Controls, TreeNT, ExtCtrls,
  ComCtrls, Graphics;

type
  TMainForm = class(TForm)
    BitBtn1: TBitBtn;
    ImageList1: TImageList;
    ImageList2: TImageList;
    Tree1: TTreeNT;
    Tree2: TTreeNT;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    Label4: TLabel;
    Panel1: TPanel;
    Tree3: TTreeNT;
    Timer1: TTimer;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure Tree3AfterItemPaint(Sender: TObject; Node: TTreeNTNode;
      Canvas: TCanvas; ItemRect: TRect; NodeStates: TNodeStates);
    procedure FormCreate(Sender: TObject);
    function Tree2Hint(Sender: TObject; Node: TTreeNTNode): string;
    procedure BitBtn3Click(Sender: TObject);
    function Tree3Hint(Sender: TObject; Node: TTreeNTNode): string;
    procedure Timer1Timer(Sender: TObject);
  private
  end;

var MainForm: TMainForm;                          

//------------------------------------------------------------------------------

implementation

uses CommCtrl, CommCtrlEx, TNTEditor, SysUtils;

{$R *.DFM}

var Counter : Integer;

//------------------------------------------------------------------------------

procedure TMainForm.BitBtn1Click(Sender: TObject);
begin
  EditTreeViewItems(Tree1.Items);
end;

//------------------------------------------------------------------------------

procedure TMainForm.BitBtn3Click(Sender: TObject);
begin
  EditTreeViewItems(Tree2.Items);
end;

//------------------------------------------------------------------------------

procedure TMainForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if key = #27 then Close;
end;

//------------------------------------------------------------------------------

procedure TMainForm.Tree3AfterItemPaint(Sender: TObject; Node: TTreeNTNode;
  Canvas: TCanvas; ItemRect: TRect; NodeStates: TNodeStates);
var BState : UINT;
    Edge   : UINT;

begin
  BState:=BF_RECT;
  if TreeNT.nsSelected in NodeStates then Edge:=BDR_SUNKENOUTER
                                     else Edge:=BDR_RAISEDINNER;
  if not (nsHot in NodeStates) then BState:=BState+BF_FLAT;
  if Node.Level > 0 then Node.Color:=clBtnHighlight
                    else DrawEdge(Canvas.Handle,Itemrect,Edge,BState);
end;

//------------------------------------------------------------------------------

procedure EnumFontCallback(lpelf: PEnumLogFont; lpntm: PNewTextMetric;
                           FontType: Integer; lParam: LPARAM); stdcall;

var Items : TTreeNTNodes;
    Node  : TTreeNTNode;
    AFont : TFont;
    Name  : String[32];
    Index : Integer;

begin
  Items:=TTreeNTNodes(lParam);
  AFont:=TFont.Create;
  AFont.Size:=0;
  try
    Name:=StrPas(lpelf.elfLogFont.lfFaceName);
    Node:=Items.Add(nil,name);
    if Random(100) < 25 then // just to bring a bit more fun into the list :-)
    begin
      Node.Color:=RGB(Random(180)+75,Random(180)+75,Random(180)+75);
      AFont.Color:=RGB(Random(180)+75,Random(180)+75,Random(180)+75);
    end;
    AFont.Name:=Name;
    Node.Font:=AFont;   // the use of a temporary font is needed to make
                        // the font manager realizing the new font
    Index:=6;
    if (FontType and TRUETYPE_FONTTYPE) > 0 then Index:=5;
    if (FontType and RASTER_FONTTYPE) > 0 then Index:=4;
    if (FontType and DEVICE_FONTTYPE) > 0 then Index:=6;
    Node.ImageIndex:=Index;
    Node.SelectedIndex:=Index;
  finally
    AFont.Free;
  end;
end;

//------------------------------------------------------------------------------

procedure TMainForm.FormCreate(Sender: TObject);

var I,J,K : Integer;
    Node1,
    Node2 : TTreeNTNode;
    AFont : TFont;

begin
  Randomize;
  with Tree1.Items do
  begin
    BeginUpdate;
    for I:=0 to 13 do
    begin
      Node1:=Add(nil,'Node '+IntToStr(I));
      Node1.BeginUpdate;
      for J:=0 to 13 do
      begin
        Node2:=AddChild(Node1,'Child1 '+IntTOStr(J));
        Node2.BeginUpdate;
        for K:=0 to 13 do AddChild(Node2,'Child2 '+IntToStr(K));
        Node2.EndUpdate;
      end;
      Node1.EndUpdate;
    end;
    //Tree1.FullExpand;
    EndUpdate;
  end;
  with Tree2 do // fill the second tree view
  begin
    Items.BeginUpdate;
    EnumFontFamilies(Canvas.Handle,nil,@EnumFontCallback,Longint(Items));
    Items.EndUpdate;
  end;
end;

//------------------------------------------------------------------------------

function TMainForm.Tree2Hint(Sender: TObject; Node: TTreeNTNode): string;
begin
  Result:=Node.Text;
  case Node.ImageIndex of
    4 : Result:=Result+' (this is actually a raster font)';
    5 : Result:=Result+' (this is actually a true type font)';
    6 : Result:=Result+' (this is actually a device font)';
  end;
end;

//------------------------------------------------------------------------------

function TMainForm.Tree3Hint(Sender: TObject; Node: TTreeNTNode): string;
begin
  case Node.Level of
    0 : Result:='on '+Node.Text+' visited pages';
    1 : Result:=Node.Text+' visited pages'
  else Result:=Node.Text+' ('+Node.Parent.Text+')';
  end;
end;

//------------------------------------------------------------------------------

procedure TMainForm.Timer1Timer(Sender: TObject);
begin
  Inc(Counter);
  if Counter = 10 then Counter:=0;
  Tree2.ShowInsertMark(Tree2.Items[Counter],False);
end;

//------------------------------------------------------------------------------

end.


