unit CommCtrlEx;

interface

uses CommCtrl, Windows;

const NM_CUSTOMDRAW      = NM_FIRST-12; // sub messages of WM_NOTIFY
      NM_HOVER           = NM_FIRST-13;
      NM_NCHITTEST       = NM_FIRST-14; // uses NMMOUSE struct
      NM_KEYDOWN         = NM_FIRST-15; // uses NMKEY struct
      NM_RELEASEDCAPTURE = NM_FIRST-16;
      NM_SETCURSOR       = NM_FIRST-17; // uses NMMOUSE struct
      NM_CHAR            = NM_FIRST-18; // uses NMCHAR struct

      TVN_GETINFOTIPA  = TVN_FIRST-13;
      TVN_GETINFOTIPW  = TVN_FIRST-14;
      TVN_GETINFOTIP   = TVN_GETINFOTIPA;

      TVN_SINGLEEXPAND = TVN_FIRST-15;

// The following values were taken from commtrl.h, since they aren't currently
// part of CommCtrl.pas.

      TVS_NOTOOLTIPS          = $0080;
      TVS_CHECKBOXES          = $0100;
      TVS_TRACKSELECT         = $0200;
      TVS_SINGLEEXPAND        = $0400;
      TVS_INFOTIP             = $0800;
      TVS_FULLROWSELECT       = $1000;
      TVS_NOSCROLL            = $2000;

      TVIS_EXPANDPARTIAL      = $0080;
      TVIS_CHECKED            = $2000;

      TVIF_INTEGRAL           = $0080;
      
      //==================== CUSTOM DRAW =======================================

      // custom draw return flags
      // values under = $00010000 are reserved for global custom draw values.
      // above that are for specific controls
      CDRF_DODEFAULT          = $00000000;
      CDRF_NEWFONT            = $00000002;
      CDRF_SKIPDEFAULT        = $00000004;

      CDRF_NOTIFYPOSTPAINT    = $00000010;
      CDRF_NOTIFYITEMDRAW     = $00000020;
      CDRF_NOTIFYSUBITEMDRAW  = $00000020; // flags are the same, we can distinguish by context
      CDRF_NOTIFYPOSTERASE    = $00000040;
      CDRF_NOTIFYITEMERASE    = $00000080;
      
      // treeview's customdraw return meaning don't draw images. valid on CDRF_NOTIFYITEMPREPAINT 
      TVCDRF_NOIMAGES         = $00010000;

      // drawstage flags
      // values under = $00010000 are reserved for global custom draw values.
      // above that are for specific controls
      CDDS_PREPAINT           = $00000001;
      CDDS_POSTPAINT          = $00000002;
      CDDS_PREERASE           = $00000003;
      CDDS_POSTERASE          = $00000004;
      // the = $000010000 bit means it's individual item specific
      CDDS_ITEM               = $00010000;
      CDDS_ITEMPREPAINT       = (CDDS_ITEM or CDDS_PREPAINT);
      CDDS_ITEMPOSTPAINT      = (CDDS_ITEM or CDDS_POSTPAINT);
      CDDS_ITEMPREERASE       = (CDDS_ITEM or CDDS_PREERASE);
      CDDS_ITEMPOSTERASE      = (CDDS_ITEM or CDDS_POSTERASE);
      CDDS_SUBITEM            = $00020000;

      // itemState flags 
      CDIS_SELECTED           = $0001;
      CDIS_GRAYED             = $0002;
      CDIS_DISABLED           = $0004;
      CDIS_CHECKED            = $0008;
      CDIS_FOCUS              = $0010;
      CDIS_DEFAULT            = $0020;
      CDIS_HOT                = $0040;
      CDIS_MARKED             = $0080;
      CDIS_INDETERMINATE      = $0100;

type PNMCustomDraw = ^TNMCustomDraw;
     TNMCustomDraw = record
                       hdr         : TNMHdr;
                       dwDrawStage : DWORD;  // see above
                       hdc         : HDC;    // drawing area for the specific item
                       rc          : TRect;  // the enclosing rect for the specific item
                       dwItemSpec  : DWORD;  // item number in the control
                       uItemState  : UINT;   // see above
                       lItemlParam : LPARAM; // item specific data
                     end;

     PNMTVCustomDraw = ^TNMTVCustomDraw;
     TNMTVCustomDraw = record
                         nmcd : TNMCustomDraw;
                         clrText   : COLORREF;
                         clrTextBk : COLORREF;
                         iLevel    : Integer;  // same as the Level property in TTreeNTNode
                       end;

     PNMTVGetInfoTipA = ^TNMTVGetInfoTipA;
     TNMTVGetInfoTipA = record
                          hdr: TNMHdr;
                          pszText: PChar;
                          cchTextMax: Integer;
                          hItem: HTREEITEM;
                          lParam: LPARAM;
                        end;
     PNMTVGetInfoTipW = ^TNMTVGetInfoTipW;
     TNMTVGetInfoTipW = record
                          hdr: TNMHdr;
                          pszText: PWideChar;
                          cchTextMax: Integer;
                          hItem: HTREEITEM;
                          lParam: LPARAM;
                        end;
     PNMTVGetInfoTip  = ^TNMTVGetInfoTip;
     TNMTVGetInfoTip  = TNMTVGetInfoTipA;


     // only used for Get and Set messages.  no notifies
     TTVItemExA       = record
                          mask: UINT;
                          hItem: HTREEITEM;
                          state: UINT;
                          stateMask: UINT;
                          pszText: PChar;
                          cchTextMax: Integer;
                          iImage: Integer;
                          iSelectedImage: Integer;
                          cChildren: Integer;
                          lParam: LPARAM;
                          iIntegral: Integer;
                        end;
     TTVItemExW       = record
                          mask: UINT;
                          hItem: HTREEITEM;
                          state: UINT;
                          stateMask: UINT;
                          pszText: PWideChar;
                          cchTextMax: Integer;
                          iImage: Integer;
                          iSelectedImage: Integer;
                          cChildren: Integer;
                          lParam: LPARAM;
                          iIntegral: Integer;
                        end;
     TTVItemEx        = TTVItemExA;

     TTVInsertStructA = record
                          hParent,
                          hInsertAfter :HTREEITEM;
                          case Boolean of
                            True : (itemex: TTVItemExA);
                            False: (item: TTVItemA);
                        end;

     TTVInsertStructW = record
                          hParent,
                          hInsertAfter :HTREEITEM;
                          case Boolean of
                            True : (itemex: TTVItemExW);
                            False: (item: TTVItemW);
                        end;
     TTVInsertStruct  = TTVInsertStructA;


const TVM_SETITEMHEIGHT = TV_FIRST + 27;
      TVM_GETITEMHEIGHT = TV_FIRST + 28;

      TVGN_LASTVISIBLE  = $000A;

function TreeView_GetItemHeight(hwnd: HWND): SHORT;
function TreeView_SetItemHeight(hwnd: HWND; const cyItem: SHORT): Bool;

function TreeView_InsertItem(hwnd: HWND; const lpis: TTVInsertStruct): HTreeItem;


const TVM_SETINSERTMARK = TV_FIRST+26;

function TreeView_SetInsertMark(hwnd: HWND; htiInsert: HTREEITEM; fAfter: Boolean): BOOL;


const TVM_SETTEXTCOLOR  = TV_FIRST+30;

function TreeView_SetTextColor(hwnd: HWND; clr: COLORREF): BOOL;

const TVM_SETBORDER     = TV_FIRST+35;
      TVSBF_XBORDER     = $00000001;
      TVSBF_YBORDER     = $00000002;

function TreeView_SetBorder(hwnd: HWND; dwFlags: Word; xBorder, yBorder: Word): BOOL;


const TVM_SETSCROLLTIME = TV_FIRST+33;
      TVM_GETSCROLLTIME = TV_FIRST+34;

function TreeView_SetScrollTime(hwnd: HWND; uTime: UINT): BOOL;
function TreeView_GetScrollTime(hwnd: HWND): UINT;

const TVM_SETINSERTMARKCOLOR = TV_FIRST+37;
      TVM_GETINSERTMARKCOLOR = TV_FIRST+38;

function TreeView_SetInsertMarkColor(hwnd: HWND; clr: COLORREF): COLORREF;
function TreeView_GetInsertMarkColor(hwnd: HWND): COLORREF;

//------------------------------------------------------------------------------

implementation

function TreeView_GetItemHeight(hwnd: HWND): SHORT;
begin
  Result:=SendMessage(hwnd,TVM_GETITEMHEIGHT,0,0);
end;

function TreeView_InsertItem(hwnd: HWND; const lpis: TTVInsertStruct): HTreeItem;
begin
  Result:=HTreeItem(SendMessage(hwnd,TVM_INSERTITEM,0,Longint(@lpis)));
end;

function TreeView_SetItemHeight(hwnd: HWND; const cyItem: SHORT): Bool;
begin
  Result:=Bool(SendMessage(hwnd,TVM_SETITEMHEIGHT,cyItem,0));
end;

function TreeView_SetInsertMark(hwnd: HWND; htiInsert: HTREEITEM; fAfter: Boolean): BOOL;
begin
  Result:=Bool(SendMessage(hwnd,TVM_SETINSERTMARK,Ord(fAfter),LPARAM(htiInsert)));
end;

function TreeView_SetTextColor(hwnd: HWND; clr: COLORREF): BOOL;
begin
  Result:=Bool(SendMessage(hwnd,TVM_SETTEXTCOLOR,0,LPARAM(clr)));
end;

function TreeView_SetBorder(hwnd: HWND; dwFlags: Word; xBorder, yBorder: Word): BOOL;
begin
  Result:=Bool(SendMessage(hwnd,TVM_SETBORDER,dwFlags,MakeLParam(xBorder,yBorder)));
end;

function TreeView_SetScrollTime(hwnd: HWND; uTime: UINT): BOOL;
begin
  Result:=BOOL(SendMessage(hwnd,TVM_SETSCROLLTIME,uTime,0));
end;

function TreeView_GetScrollTime(hwnd: HWND): UINT;
begin
  Result:=SendMessage(hwnd,TVM_GETSCROLLTIME,0,0);
end;

function TreeView_SetInsertMarkColor(hwnd: HWND; clr: COLORREF): COLORREF;
begin
  Result:=SendMessage(hwnd,TVM_SETINSERTMARKCOLOR,0,LPARAM(clr));
end;

function TreeView_GetInsertMarkColor(hwnd: HWND): COLORREF;
begin
  Result:=SendMessage(hwnd,TVM_GETINSERTMARKCOLOR,0,0);
end;

//------------------------------------------------------------------------------

end.

