{
TSlidePanel
by Pablo Pissanetzky

Freeware, but keep author name with all files.

pablo@neosoft.com
http://www.neosoft.com/~pablo

Enjoy.
}
unit SlidePan;

interface

uses
  WinTypes , WinProcs , Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

const
  Version = '1.00';

type

  THandlePosition = ( hpLeft , hpRight , hpTop , hpBottom );
  TSlideType = ( stLine , stFull );

  {----------------------------------------------------------------------------}
  { TSlide }
  { This is the panel shown when TSlideType is stLine. It overrides the Paint  }
  { method to show a checkerboard pattern                                      }

  TSlide = class( TPanel )
  private
    FBitmap : TBitmap;
  protected
    procedure Paint; override;
  public
    constructor Create( AOwner : Tcomponent ); override;
    destructor Destroy; override;
  end;

  {----------------------------------------------------------------------------}
  { TSlidePanel }
  { This is the panel component }

  TSlidePanel = class( TPanel)
  private

    FHP : TPanel;   { Handle panel                                      }
    FSP : TPanel;   { Sliding panel                                     }
    FPT : TPoint;   { Mouse down point                                  }
    FOF : TPoint;   { Offset from left and top of mouse down point      }
    FMN : Integer;  { Minimum size for current drag                     }
    FMX : Integer;  { Maximum size for current drag                     }

    FHandlePos      : ThandlePosition;
    FSlideType      : TSlideType;
    FMinSize        : Integer;
    FMaxSize        : Integer;
    FHandleVisible  : Boolean;
    FVersion        : string;

    procedure MouseDownOnHandle(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MouseUpOnHandle(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MouseMoveOnHandle(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    function DefaultMinSize : Integer;
    procedure SetHandlePos( NewPos : THandlePosition );
    procedure SetHandleVisible( NewVis : Boolean );
    procedure UpdateHandlePanel;

  public

    constructor Create( AOwner : TComponent ); override;

  published

    property HandlePosition : THandlePosition read FHandlePos write SetHandlePos;
    property SlideType : TSlideType read FSlideType write FSlideType;
    property MinSize : Integer read FMinSize write FMinSize;
    property MaxSize : Integer read FMaxSize write FMaxSize;
    property HandleVisible : Boolean read FHandleVisible write SetHandleVisible;
    property Version : string read FVersion;
  end;

procedure Register;

implementation

const
  CenterMargin  : Integer = 2;
  HandleWidth   : Integer = 6;
  SliderWidth   : Integer = 4;

{------------------------------------------------------------------------------}

procedure Register;
begin
  RegisterComponents('Standard', [TSlidePanel]);
end;

{------------------------------------------------------------------------------}
{ TSlide }

constructor TSlide.Create( AOwner : Tcomponent );
var
  X , Y , C : Integer;
begin
  inherited Create( AOwner );
  FBitmap := TBitmap.Create;
  FBitmap.Width := 8;
  FBitmap.Height := 8;
  C := 0;
  for X := 0 to 7 do
    for Y := 0 to 7 do
      begin
        if Odd( C ) then
          FBitmap.Canvas.Pixels[ X , Y ] := clBlack
        else
          FBitmap.Canvas.Pixels[ X , Y ] := clBtnFace;
        Inc( C );
      end;
end;

destructor TSlide.Destroy;
begin
  FBitmap.Free;
  inherited Destroy;
end;

procedure TSlide.Paint;
begin
  Canvas.Brush.Bitmap := FBitmap;
  Canvas.FillRect( Rect( 0 , 0 , Width , Height ) );
end;

{------------------------------------------------------------------------------}
{ TSlidePanel }

constructor TSlidePanel.Create( AOwner : TComponent );
begin
  inherited Create( AOwner );

  { Create the handle panel }
  FHP := TPanel.Create( Self );
  with FHP do
    begin
      Parent := Self;
      BevelOuter := bvNone;
      BorderWidth := 1;
      Visible := True;
      OnMouseDown := MouseDownOnHandle;
      OnMouseMove := MouseMoveOnHandle;
      OnMouseUp := MouseUpOnHandle;
    end;

  { Create the sliding 'bar' panel }
  FSP := TSlide.Create( Self );
  with FSP do
    begin
      Parent := Self.Parent;
      Visible := False;
      BevelInner := bvNone;
      BevelOuter := bvNone;
      Color := clBlack;
      Width := 4;
    end;

  { Set all properties to their default }
  HandlePosition := hpLeft;
  SlideType := stFull;
  MinSize := DefaultMinSize;
  MaxSize := 0;
  HandleVisible := True;
  UpdateHandlePanel;
  FVersion := Version;
end;

procedure TSlidePanel.MouseDownOnHandle(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if ( Button = mbLeft ) then
    begin
      FPT := Point( X - CenterMargin , Y - CenterMargin );
      FPT := Parent.ScreenToClient( FHP.ClientToScreen( FPT ) );
      FOF := Point( Left - FPT.X , Top - FPT.Y );
      FMN := DefaultMinSize;
      if MinSize > FMN then
        FMN := MinSize;

      case FHandlePos of
        hpLeft , hpRight : FMX := Parent.Width;
        hpTop , hpBottom : FMX := Parent.Height;
      end;

      if ( MaxSize > 0 ) and ( MaxSize >= MinSize ) and ( MaxSize < FMX ) then
        FMX := MaxSize;

      if SlideType = stLine then
        with FSP do
          begin
            Parent := Self.Parent;
            case FHandlePos of
              hpLeft , hpRight :
                begin
                  Left := FPT.X;
                  Top := Self.Top + FHP.Top ;
                  Height := FHP.Height;
                  Width := HandleWidth - 2;
                end;

              hpTop , hpBottom :
                begin
                  Top := FPT.Y;
                  Left := Self.Left + FHP.Left;
                  Width := FHP.Width;
                  Height := HandleWidth - 2;
                end;

            end;
            Visible := True;
          end;
    end;
end;

procedure TSlidePanel.MouseMoveOnHandle(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  PT : TPoint;
begin
  if ( ssLeft in Shift ) then
    begin
      PT := Point( X - CenterMargin , Y - CenterMargin );
      PT := Parent.ScreenToClient( FHP.ClientToScreen( PT ) );

      case FHandlePos of
        hpLeft :

          if ( ( Width + ( Left - ( PT.X + FOF.X ) ) ) >= FMN ) and
            ( PT.X > 0 ) and ( ( Width + ( Left - ( PT.X + FOF.X ) ) ) <= FMX ) then
            if SlideType = stLine then
              begin
                FSP.Left := PT.X;
                Parent.Update;
              end
            else
              begin
                Width := Width + ( Left - ( PT.X + FOF.X ) );
                Left := PT.X + FOF.X ;
              end;

        hpRight :

            if SlideType = stLine then
              begin
                if ( ( Width - ( Left - ( PT.X + FOF.X ) ) ) >= FMN )
                  and ( ( Width - ( Left - ( PT.X + FOF.X ) ) ) <= FMX )
                  and ( PT.X < ( Parent.Width - HandleWidth - CenterMargin ) ) then
                  begin
                    FSP.Left := PT.X;
                    Parent.Update;
                  end;
              end
            else if ( ( PT.X - Left + HandleWidth ) >= FMN )
              and ( ( PT.X - Left + HandleWidth ) <= FMX )
              and ( PT.X < ( Parent.Width - HandleWidth ) ) then
              Width := PT.X - Left + HandleWidth;


        hpTop :

          if ( ( Height + ( Top - ( PT.Y + FOF.Y ) ) ) >= FMN )
            and ( ( Height + ( Top - ( PT.Y + FOF.Y ) ) ) <= FMX )
            and ( PT.Y > 0 ) then
            if ( SlideType = stLine ) then
              begin
                FSP.Top := PT.Y;
                Parent.Update;
              end
            else
              begin
                Height := Height + ( Top - ( PT.Y + FOF.Y ) );
                Top := PT.Y + FOF.Y ;
                Parent.Update;
              end;

        hpBottom :

            if SlideType = stLine then
              begin
                if ( ( Height - ( Top - ( PT.Y + FOF.Y ) ) ) >= FMN )
                  and ( ( Height - ( Top - ( PT.Y + FOF.Y ) ) ) <= FMX )
                  and  ( PT.Y < ( Parent.Height - HandleWidth - CenterMargin ) ) then
                  begin
                    FSP.Top := PT.Y;
                    Parent.Update;
                  end;
              end
            else if ( ( PT.Y - Top + HandleWidth ) >= FMN )
              and ( ( PT.Y - Top + HandleWidth ) <= FMX )
              and  ( PT.Y < ( Parent.Height - HandleWidth ) ) then
              Height := PT.Y - Top + HandleWidth;
      end;
    end;
end;

procedure TSlidePanel.MouseUpOnHandle(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if ( Button = mbLeft ) and ( FSP.Visible ) and ( SlideType = stLine ) then
    begin
      case FHandlePos of

        hpLeft :

          begin
            Width := Width + ( Left - ( FSP.Left + FOF.X ) );
            Left := FSP.Left + FOF.X ;
          end;

        hpRight :

          Width := Width - ( Left - ( FSP.Left + FOF.X ) );

        hpTop :

          begin
            Height := Height + ( Top - ( FSP.Top + FOF.Y ) );
            Top := FSP.Top + FOF.Y ;
          end;

        hpBottom :

          Height := Height - ( Top - ( FSP.Top + FOF.Y ) );

      end;
      FSP.Visible := False;
    end;
end;

function TSlidePanel.DefaultMinSize : Integer;
begin
  Result := HandleWidth;
  Inc( Result , BorderWidth * 2 );
  if BevelOuter <> bvNone then
    Inc( Result , BevelWidth * 2 );
  if BevelInner <> bvNone then
    Inc( Result , BevelWidth * 2 );
end;

procedure TSlidePanel.SetHandlePos( NewPos : THandlePosition );
begin
  if NewPos <> FHandlePos then
    begin
      FHandlePos := NewPos;
      UpdateHandlePanel;
    end;
end;

procedure TSlidePanel.SetHandleVisible( NewVis : Boolean );
begin
  if NewVis <> FHandleVisible then
    begin
      FHandleVisible := NewVis;
      UpdateHandlePanel;
    end;
end;

procedure TSlidePanel.UpdateHandlePanel;
begin
  if FHandleVisible then
    FHP.BevelInner := bvRaised
  else
    FHP.BevelInner := bvNone;

  case FHandlePos of
    hpLeft    :
      begin
        FHP.Align := alLeft;
        FHP.Width := HandleWidth;
        FHP.cursor := crHSplit;
      end;
    hpRight   :
      begin
        FHP.Align := alRight;
        FHP.Width := HandleWidth;
        FHP.cursor := crHSplit;
      end;
    hpTop     :
      begin
        FHP.Align := alTop;
        FHP.Height:= HandleWidth;
        FHP.cursor := crVSplit;
      end;
    hpBottom  :
      begin
        FHP.Align := alBottom;
        FHP.Height:= HandleWidth;
        FHP.cursor := crVSplit;
      end;
  end;
end;

end.
