{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# UNZIP.PAS - TUnzipForm                                                                 #
# Entpacken (UnZip) mittels Unzip.dll                                                    #
#########################################################################################}

UNIT Unzip;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     StdCtrls, ExtCtrls, ComCtrls, FileCtrl, Buttons, Grids, Menus,
     NewStat, TB97, ZipMstr, ZipDir, SortGrid, Globals, Main;

Type
  TUnzipForm = class(TGradientForm)
    ZipMaster: TZipMaster;
    Panel_Step1: TPanel;
    Label2: TLabel;
    Label_Archivdatei: TLabel;
    Label3: TLabel;
    Label_Groesse: TLabel;
    Label4: TLabel;
    Label_Attribute: TLabel;
    EditZieldir: TEdit;
    Label1: TLabel;
    Button_ChangeZielDir: TToolbarButton97;
    SortGrid: TSortGrid;
    Panel_Step2: TPanel;
    Panel_Buttons: TPanel;
    Button_Entpacken: TBitBtn;
    Button_Testen: TBitBtn;
    Button_Abbrechen: TBitBtn;
    Button_Hilfe: TBitBtn;
    RichEdit: TRichEdit;
    ProgressBar: TProgressBar;
    Label_File: TLabel;
    StatusBar: TAStatusBar;
    RadioGroup_ObjektEntpack: TRadioGroup;
    CheckBox_InclusivSubdirs: TCheckBox;
    CheckBox_OverrideExists: TCheckBox;
    // Initialisieren
    procedure OnCreate(Sender: TObject);
    procedure OnActivate(Sender: TObject);
    // SortGrid
    procedure OnDrawCell(Sender: TObject; Col, Row: Longint; Rect: TRect; State: TGridDrawState);
    // Zielverzeichnis
    procedure EditZieldir_OnChange(Sender: TObject);
    procedure Button_ChangeZielDir_OnClick(Sender: TObject);
    // ZipMaster
    procedure ZipMaster_OnMessage(Sender: TObject; ErrCode: Integer; Message: string);
    procedure ZipMaster_OnProgress(Sender: TObject; ProgrType: ProgressType; Filename: string; FileSize: Longint);
    procedure Button_Hilfe_OnClick(Sender: TObject);
    procedure Button_Testen_OnClick(Sender: TObject);
    procedure Button_Entpacken_OnClick(Sender: TObject);
  end;

Const CancelAktion: boolean = false;

Var ZipArchiveCom: string;
    ZipDir: TZipDir;
    UnzipForm: TUnzipForm;

IMPLEMENTATION

Uses ChangeDir;

{$R *.DFM}

{------------------------------------------------------------------------------------------
Initialisieren
------------------------------------------------------------------------------------------}

// Initialisieren - OnCreate
PROCEDURE TUnzipForm.OnCreate(Sender: TObject);
begin
  // Prfen ob angegebene Archvidatei existiert
  If FileExists(ZipArchiveCom) then begin
    EditZieldir.Text:=Lowercase(ExtractFilePath(ZipArchiveCom));
  end else begin
    If DirectoryExists(ZipArchiveCom) then EditZieldir.Text:=LowerCase(ZipArchiveCom) else EditZieldir.Text:='c:\';
    ZipArchiveCom:='';
  end;
  // Weitere allgemeine Vorbereitungen
  If MainForm.MainMenu.Items[5].Items[5].Enabled then Button_Hilfe.Enabled:=true;
end;

// Initialisieren - OnActivate
PROCEDURE TUnzipForm.OnActivate(Sender: TObject);
var OA_Bool1: boolean; OA_Int1: integer; OA_Str1: string;
  // Setzt die berschriftsfelder (FixedRow) der SortGrid
  procedure SetSortGrid;
  begin
    With SortGrid do begin
      Cells[0,0]:='Name'; ColWidths[0]:=203;
      Cells[1,0]:='Gre'; ColWidths[1]:=78;
      Cells[2,0]:='Packrate'; ColWidths[2]:=49;
      Cells[3,0]:='Datum/Zeit'; ColWidths[3]:=90;
      FixedRows:=1;
    end;
  end;
begin
  Screen.Cursor:=crHourGlass;
  If Length(ZipArchiveCom)>0 then begin
    // <-> ZipMaster.ZipFilename:=ZipArchiveCom;
    // Dateieigenschaften der angegebenen Archivdatei einlesen und entspr. setzen
    Label_Archivdatei.Caption:=LowerCase(ZipArchiveCom);
    Label_Groesse.Caption:=FormatInteger(GetFileSizeInByte(ZipArchiveCom))+' Bytes';
    OA_Int1:=GetFileAttr(ZipArchiveCom); OA_Str1:='';
    If (OA_Int1 and faReadOnly>0) then OA_Str1:='Schreibgeschtzt ';
    If (OA_Int1 and faHidden>0) then OA_Str1:=OA_Str1+'Versteckt ';
    If (OA_Int1 and faSysFile>0) then OA_Str1:=OA_Str1+'Systemdatei ';
    If (OA_Int1 and faArchive>0) then OA_Str1:=OA_Str1+'Archivdatei ';
    Label_Attribute.Caption:=OA_Str1;
    Update;
    // berprfen ob angegebene Datei wirklich gltiges Zip-Archiv ist
    Try
      ZipDir:=TZipDir.Create(Self);
      ZipDir.ZipFilename:=ZipArchiveCom;
      OA_Bool1:=true;
    Except
      // FehlerMsg: Datei ist kein gltiges Zip-Archiv.
      OA_Bool1:=false;
      StatusBar.SimpleText:='Fehler: Datei ist kein gltiges Zip-Archive...';
      Try ZipDir.Free; Finally MainForm.MsgDlg(101); end;
    end;
    If OA_Bool1 then begin
      Caption:='Lese Archivinhalt ein. Bitte warten...';
      StatusBar.SimpleText:='Archivinhalt wird eingelesen...';
      // Gepackte Dateien des Archives einlesen und anzeigen
      With SortGrid do begin
        For OA_Int1:=0 to ZipDir.Count-1 do begin
          RowCount:=RowCount+1;
          If RowCount=2 then SetSortGrid;
          With ZipDirEntry(ZipDir.ZipContents[OA_Int1]^) do begin
            Cells[0,RowCount-1]:=FileName; // Name
            Cells[1,RowCount-1]:=FormatInteger(UncompressedSize); // Gre
            Cells[2,RowCount-1]:=IntToStr(GetProcent(UncompressedSize,CompressedSize))+'%'; // Packrate
            Cells[3,RowCount-1]:=FormatDateTime('ddddd  t',FileDateToDateTime(DateTime)); // Datum/Zeit
          end;
        end;
      end;
      StatusBar.SimplePanel:=false;
      StatusBar.Panels[0].Text:=IntToStr(ZipDir.Count)+' Objekt(e).';
      StatusBar.Panels[1].Text:=IntToStr(SortGrid.Selection.Top-SortGrid.Selection.Bottom)+' Objekt(e) markiert.';
      Try ZipDir.Free; Finally ZipMaster.ZipFilename:=ZipArchiveCom; end;
      Button_Entpacken.Enabled:=true; Button_Testen.Enabled:=true;
    end;
  end else begin
    // FehlerMsg: Archivdatei konnte nicht gefunden werden.
    StatusBar.SimpleText:='Fehler: Archivdatei konnte nicht gefunden werden...';
    MainForm.MsgDlg(100);
  end;
  Caption:='Entpacken - Unzip';
  Screen.Cursor:=crDefault;
end;

{------------------------------------------------------------------------------------------
SortGrid
------------------------------------------------------------------------------------------}

// SortGrid OnDrawCell
PROCEDURE TUnzipForm.OnDrawCell(Sender: TObject; Col, Row: Longint; Rect: TRect; State: TGridDrawState);
begin If not StatusBar.SimplePanel then StatusBar.Panels[1].Text:=IntToStr(SortGrid.Selection.Bottom-SortGrid.Selection.Top+1)+' Objekt(e) markiert.'; end;

{------------------------------------------------------------------------------------------
Zielverzeichnis
------------------------------------------------------------------------------------------}

// EditZieldir OnChange
PROCEDURE TUnzipForm.EditZieldir_OnChange(Sender: TObject);
begin
  If Length(Trim(EditZieldir.Text))>0 then begin
    If not Button_Entpacken.Enabled then If Button_Testen.Enabled then Button_Entpacken.Enabled:=true; end
  else begin If Button_Entpacken.Enabled then Button_Entpacken.Enabled:=false; end;
end;

// Button "Zielverzeichnis whlen" OnClick
PROCEDURE TUnzipForm.Button_ChangeZielDir_OnClick(Sender: TObject);
var BCZDOC_Str1: string;
begin
  With TChangeDirForm.Create(Self) do try
    Caption:='Zielverzeichnis whlen'; BCZDOC_Str1:=EditZieldir.Text;
    If not DirectoryExists(BCZDOC_Str1) then BCZDOC_Str1:=StartDir;
    DirectoryListBox.Directory:=BCZDOC_Str1;
    If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
    HelpContext:=215;
    If ShowModal=mrOk then EditZieldir.Text:=LowerCase(DirectoryListBox.Directory);
  finally Free; end;
end;

{------------------------------------------------------------------------------------------
ZipMaster
------------------------------------------------------------------------------------------}

// ZipMaster OnMessage
PROCEDURE TUnzipForm.ZipMaster_OnMessage(Sender: TObject; ErrCode: Integer; Message: string);
begin
  Try RichEdit.Lines.Insert(0,Message);
  Except RichEdit.Lines.Delete(RichEdit.Lines.Count-1); RichEdit.Lines.Insert(0,Message); end;
  If ErrCode>0 then MessageDlg('DLL-Fehler: '+Message,mtError,[mbOk]+[mbHelp],215);
end;

// ZipMaster OnProgress
PROCEDURE TUnzipForm.ZipMaster_OnProgress(Sender: TObject; ProgrType: ProgressType; Filename: string; FileSize: Longint);
begin
  If ProgrType=NewFile then begin
    Label_File.Caption:=FileName;
    With ProgressBar do begin
       Min:=1; Max:=10; Step:=1; Position:=Min;
       If (FileSize div 32768)>1 then Max:=FileSize div 32768 else Max:=1;
       if (FileSize<32768) then StepIt;
    end;
  end else
  If ProgrType=ProgressUpdate then begin
    With ProgressBar do If Position<Max then StepIt;
  end else
  If ProgrType=EndOfBatch then begin
    Label_File.Caption:='';
    With ProgressBar do begin Min:=1; Max:=10; Step:=1; Position:=Min; end;
  end;
  Application.ProcessMessages;
end;

{------------------------------------------------------------------------------------------
Button OnClick
------------------------------------------------------------------------------------------}

// Button "Hilfe" OnClick
PROCEDURE TUnzipForm.Button_Hilfe_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

// Button "Testen" OnClick
PROCEDURE TUnzipForm.Button_Testen_OnClick(Sender: TObject);
  // Nachbereitung
  procedure SetNachbereitungen;
  begin
    Panel_Step2.Visible:=false;
    Label_File.Caption:='';
    Panel_Buttons.Visible:=true;
    Caption:='Entpacken - Unzip';
    Screen.Cursor:=crDefault;
  end;
begin
  // Vorbereitung
  If ZipMaster.Count<1 then begin MainForm.MsgDlg(102); Exit; end;
  Screen.Cursor:=crHourGlass;
  RichEdit.Clear;
  Panel_Buttons.Visible:=false;
  Panel_Step2.Visible:=true;
  Caption:='Archiv wird getestet. Bitte warten...';
  // Archivdatei testen
  With ZipMaster do begin
    FSpecArgs.Clear;
    ExtrOptions:=ExtrOptions+[ExtrTest];
    FSpecArgs.Add('*.*');
    Try Extract; Except
      MessageDlg('Fataler interner DLL-Fehler.'+#13+'Test wird abgebrochen...',mtError,[mbok]+[mbHelp],215);
      SetNachbereitungen; Exit;
    end;
  end;
  With ZipMaster do begin
    If Count=SuccessCnt then MessageDlg('Alle '+IntToStr(Count)+' Dateien getestet.'+#13+'Archiv ist Okay...',mtInformation,[mbOk]+[mbHelp],215)
    else MessageDlg(IntToStr(Count-SuccessCnt)+' Dateien sind fehlerhaft oder wurden bersprungen !',mtWarning,[mbOk]+[mbHelp],215);
  end;
  // Nachbereitung
  SetNachbereitungen;
end;

// Button "Entpacken" OnClick
PROCEDURE TUnzipForm.Button_Entpacken_OnClick(Sender: TObject);
var BEOC_Int1: integer; 
  // Nachbereitung
  procedure SetNachbereitungen;
  begin
    Panel_Step2.Visible:=false;
    Label_File.Caption:='';
    Panel_Buttons.Visible:=true;
    Caption:='Entpacken - Unzip';
    Screen.Cursor:=crDefault;
  end;
begin
  // Vorbereitung
  If ZipMaster.Count<1 then begin MainForm.MsgDlg(102); Exit; end;
  If not DirectoryExists(Trim(EditZieldir.Text)) then begin // Ggf. Zielverzeichnis erstellen
    If not XMkDir(Trim(EditZieldir.Text)) then begin MainForm.MsgDlg(71); Exit; end;
  end;
  Screen.Cursor:=crHourGlass;
  RichEdit.Clear;
  Panel_Step2.Visible:=true;
  Panel_Buttons.Visible:=false;
  Caption:='Archiv wird entpackt. Bitte warten...';
  // Markierte Objekte prfen und ggf. entspr. setzen
  ZipMaster.FSpecArgs.Clear;
  With SortGrid do begin
    If RadioGroup_ObjektEntpack.ItemIndex=0 then begin
      For BEOC_Int1:=Selection.Top to Selection.Bottom do ZipMaster.FSpecArgs.Add(Cells[0,BEOC_Int1]);
      If ZipMaster.FSpecArgs.Count<1 then begin MainForm.MsgDlg(102); SetNachbereitungen; Exit; end;
    end;
  end;
  // Archiv entpacken
  With ZipMaster do begin
    ExtrBaseDir:=EditZieldir.Text;
    ExtrOptions:=[];
    If CheckBox_InclusivSubdirs.Checked then ExtrOptions:=ExtrOptions+[ExtrDirNames];
    If CheckBox_OverrideExists.Checked then ExtrOptions:=ExtrOptions+[ExtrOverwrite];
    Try Extract;
    Except MessageDlg('Fataler interner DLL-Fehler.'+#13+'Entpacken wird abgebrochen...',mtError,[mbok]+[mbHelp],215); SetNachbereitungen; Exit; end;
    If MessageDlg(IntToStr(SuccessCnt)+' Datei(en) erfolgreich entpackt.'+#13+'Entpacken beenden ?',mtInformation,[mbYes]+[mbNo]+[mbHelp],215)=idYes then ModalResult:=mrOk;
  end;
  // Nachbereitung
  SetNachbereitungen;
end;

END.
