{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# SYSTEMINFOS.PAS - TSystemInfosForm                                                     #
# Zeigt diverse Informationen ber Hard- und Software an.                                #
#########################################################################################}

UNIT SystemInfos;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     StdCtrls, ExtCtrls, Buttons, Gauges, Globals, Main, SysInf32;

Type
  TSystemInfosForm = class(TGradientForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label7: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Label9: TLabel;
    Label_LW: TLabel;
    Label11: TLabel;
    Button_Ok: TBitBtn;
    Button_Help: TBitBtn;
    Label_Prozessor: TLabel;
    Label_Betriebssystem: TLabel;
    Label_WinDir: TLabel;
    Label_UserName: TLabel;
    Label_UserFirma: TLabel;
    Label_UserSN: TLabel;
    Label_ArbeitsRam: TLabel;
    Label_FestRam: TLabel;
    Gauge_ArbeitsRam: TGauge;
    Gauge_FestRam: TGauge;
    Bevel4: TBevel;
    Label12: TLabel;
    Label_AnzahlCPU: TLabel;
    Label5: TLabel;
    Label_Tastatur: TLabel;
    Label_VolumeName: TLabel;
    SysInfo32: TSysInfo32;
    Label6: TLabel;
    Label_Login: TLabel;
    procedure OnCreate(Sender: TObject);
    procedure OnActivate(Sender: TObject);
    procedure Button_Help_OnClick(Sender: TObject);
  end;

Var SystemInfosForm: TSystemInfosForm;

IMPLEMENTATION

{$R *.DFM}

// Iniatalisieren - OnCreate
PROCEDURE TSystemInfosForm.OnCreate(Sender: TObject);
begin If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Help.Enabled:=true; end;

// Liefert die Anzahl der CPU's zurck
FUNCTION GetCpuAnzahl: integer;
var GCA_SystemInfo: tSystemInfo;
begin
  GetSystemInfo(GCA_SystemInfo);
  Result:=GCA_SystemInfo.dwNumberOfProcessors;
end;

// Liefert diverse Datentrger-Informationen zurck
FUNCTION GetVolumeInformation
     (lpRootPathName         : pANSIChar;
      lpVolumeNameBuffer     : pAnsiChar;
      nVolumeNameSize        : DWord;
  var lpVolumeSerialNumber,
      lpMaximumComponentLength,
      lpFileSystemFlags      : DWORD;
      lpFileSystemNameBuffer : pAnsiChar;
      nFileSystemNameSize    : DWORD): BOOL;
  STDCALL;  EXTERNAL kernel32
  NAME 'GetVolumeInformationA';

// Initialisieren - OnActivate, Werte entspr. setzen
PROCEDURE TSystemInfosForm.OnActivate(Sender: TObject);
var OA_Dword1, OA_Dword2, OA_Dword3: dword;
    OA_Pchar1: pchar; OA_PAnsiChar1: Pansichar; OA_Str1: string;
    OA_MemState: tMemoryStatus;
begin
  SysInfo32.Refresh;
  Label_Prozessor.Caption:=SysInfo32.ProcessorType+' '+SysInfo32.ProcessorLevel;
  Label_AnzahlCPU.Caption:=IntToStr(GetCpuAnzahl);
    Case GetKeyboardType(1) of
      1: OA_Str1:='IBM PC/XT oder kompatible (83-Tasten) Tastatur';
      2: OA_Str1:='Olivetti "ICO" (102-Tasten) Tastatur';
      3: OA_Str1:='IBM PC/AT (84-Tasteb) oder vergleichbare Tastatur';
      4: OA_Str1:='IBM Enhanced (101- oder 102-Tasten) Tastatur';
      5: OA_Str1:='Nokia 1050 oder vergleichbare Tastatur';
      6: OA_Str1:='Nokia 9140 oder vergleichbare Tastatur';
      7: OA_Str1:='Japanische Tastatur';
      else OA_Str1:='Tastatur der '+IntToStr(GetKeyboardType(0))+'er Reihe';
    end;
  Label_Tastatur.Caption:=OA_Str1;
  Label_Betriebssystem.Caption:=SysInfo32.OSplatform+' - Version '+SysInfo32.OSversion+'.'+SysInfo32.OSbuild;
    OA_Pchar1:=StrAlloc(255);
    GetWindowsDirectory(OA_Pchar1,255);
  Label_WinDir.Caption:=LowerCase(StrPas(OA_Pchar1));
    StrDispose(OA_Pchar1);
  Label_UserName.Caption:=SysInfo32.RegisteredOwner;
  Label_UserFirma.Caption:=SysInfo32.RegisteredOrganization;
  Label_UserSN.Caption:=SysInfo32.ProductId;
  Label_Login.Caption:=SysInfo32.LoginUserName;
    GlobalMemoryStatus(OA_MemState);
  Label_ArbeitsRam.Caption:=
    FormatFloat('#,###,###,### KB total',OA_MemState.dwTotalPhys/1024)+', '+
    FormatFloat('#,###,###,### KB belegt',(OA_MemState.dwTotalPhys-OA_MemState.dwAvailPhys)/1024)+', '+
    FormatFloat('#,###,###,### KB frei',OA_MemState.dwAvailPhys/1024);
  Gauge_ArbeitsRam.Progress:=OA_MemState.dwMemoryLoad;
  Gauge_ArbeitsRam.Visible:=true;
  Label_LW.Caption:='Festspeicher ['+StartDir[1]+':]:';
    OA_Pchar1:=StrAlloc(256); OA_PAnsiChar1:=StrAlloc(256);
    If GetVolumeInformation(pChar(StartDir[1]+':\'),OA_Pchar1,255,OA_Dword1,OA_Dword2,
      OA_Dword3,OA_PAnsiChar1,255) then OA_Str1:=StrPas(OA_Pchar1) else OA_Str1:='';
  Label_VolumeName.Caption:=OA_Str1;
    StrDispose(OA_Pchar1); StrDispose(OA_PAnsiChar1);
  Label_FestRam.Caption:=
    IntToStr((DiskSize(0) div 1024) div 1024)+' MB total, '+
    IntToStr(((DiskSize(0)-DiskFree(0)) div 1024) div 1024)+' MB belegt, '+
    IntToStr((DiskFree(0) div 1024) div 1024)+' MB frei';
  Gauge_FestRam.Progress:=100-(GetProcent(DiskSize(0),DiskFree(0)));;
  Gauge_FestRam.Visible:=true;
  Cursor:=crDefault; // Cursor zum Defaultwert setzen
end;

// Button "Hilfe" OnClick
PROCEDURE TSystemInfosForm.Button_Help_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

END.
