{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# SUCHEN.PAS - TSuchenForm                                                               #
# Begriff suchen, Main.PAS-MainMenu "Suchen" bzw. "Weitersuchen" OnClick                 #
#########################################################################################}

UNIT Suchen;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     StdCtrls, Buttons, ExtCtrls, Globals, Main;

Type
  TSuchenForm = class(TGradientForm)
    Button_Suchen: TBitBtn;
    Button_Abbrechen: TBitBtn;
    Button_Help: TBitBtn;
    GroupBox_Bereich: TGroupBox;
    CheckBox_BerCaption: TCheckBox;
    CheckBox_BerKommentar: TCheckBox;
    CheckBox_BerAktion: TCheckBox;
    CheckBox_GrossKleinBeachten: TCheckBox;
    Panel1: TPanel;
    Label1: TLabel;
    ComboBox_SuchBegriff: TComboBox;
    RadioGroup_Begin: TRadioGroup;
    procedure OnCreate(Sender: TObject);
    procedure ComboBox_SuchBegriff_OnChange(Sender: TObject);
    procedure Button_Suchen_OnClick(Sender: TObject);
    procedure Button_Help_OnClick(Sender: TObject);
  end;

Var SuchenForm: TSuchenForm;

IMPLEMENTATION

{$R *.DFM}

// Initialisieren
PROCEDURE TSuchenForm.OnCreate(Sender: TObject);
begin
  If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Help.Enabled:=true;
  If SearchStrings.Count>0 then begin
    ComboBox_SuchBegriff.Items:=SearchStrings;
    ComboBox_SuchBegriff.ItemIndex:=0;
  end;
  CheckBox_BerCaption.Checked:=Search_BerCaption;
  CheckBox_BerKommentar.Checked:=Search_BerKommentar;
  CheckBox_BerAktion.Checked:=Search_BerAktion;
  CheckBox_GrossKleinBeachten.Checked:=Search_GrossKlein;
  ComboBox_SuchBegriff_OnChange(Sender);
end;
         
// ComboBox_Suchbegriff OnChange
PROCEDURE TSuchenForm.ComboBox_SuchBegriff_OnChange(Sender: TObject);
begin
  If ComboBox_SuchBegriff.Text>'' then begin
    If (CheckBox_BerCaption.Checked)or(CheckBox_BerKommentar.Checked)or(CheckBox_BerAktion.Checked) then begin
      If not Button_Suchen.Enabled then Button_Suchen.Enabled:=true;
    end else Button_Suchen.Enabled:=false;
  end else If Button_Suchen.Enabled then Button_Suchen.Enabled:=false;
end;

// Button "Suchen" OnClick
PROCEDURE TSuchenForm.Button_Suchen_OnClick(Sender: TObject);
begin
  SearchStrings.Insert(0,ComboBox_SuchBegriff.Text);
  If SearchStrings.Count>10 then SearchStrings.Delete(10);
  ComboBox_SuchBegriff.Items:=SearchStrings;
  Search_BerCaption:=CheckBox_BerCaption.Checked;
  Search_BerKommentar:=CheckBox_BerKommentar.Checked;
  Search_BerAktion:=CheckBox_BerAktion.Checked;
  Search_GrossKlein:=CheckBox_GrossKleinBeachten.Checked;
end;

// Button "Hilfe" OnClick
PROCEDURE TSuchenForm.Button_Help_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

END.
