{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# STATISTIK.PAS - TStatistikForm                                                         #
# Statistik ber Projektdaten, wird von MainForm aufgerufen                              #
#########################################################################################}

UNIT Statistik;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     ExtCtrls, StdCtrls, Buttons,
     TreeNT, Globals, Main;

Type
  TStatistikForm = class(TGradientForm)
    Panel1: TPanel;
    Image1: TImage;
    Label_PrjTitle: TLabel;
    Label1: TLabel;
    Button_Ok: TBitBtn;
    Button_Help: TBitBtn;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label_IniDatei: TLabel;
    Label_HilfeDatei: TLabel;
    GroupBox_AktSelEintrag: TGroupBox;
    Bevel1: TBevel;
    GroupBox_AktSelEintrag_Position: TGroupBox;
    GroupBox_AktSelEintrag_Kommentar: TGroupBox;
    GroupBox_AktSelEintrag_Aktion: TGroupBox;
    Label5: TLabel;
    Label6: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label_AktSelEintrag_Position_Global: TLabel;
    Label_AktSelEintrag_Position_Ebene: TLabel;
    Label10: TLabel;
    Label_AktSelEintrag_Position_Level: TLabel;
    Label_AktSelEintrag_Kommentar_Zeichen: TLabel;
    Label_AktSelEintrag_Kommentar_Zeilen: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label_AktSelEintrag_Kommentar_ZeileNr_Kurz1: TLabel;
    Label_AktSelEintrag_Kommentar_ZeileNr_Lang1: TLabel;
    Label_AktSelEintrag_Kommentar_ZeileNr_Kurz2: TLabel;
    Label_AktSelEintrag_Kommentar_ZeileNr_Lang2: TLabel;
    Label7: TLabel;
    Label17: TLabel;
    Label_AktSelEintrag_Aktion_Nr: TLabel;
    Label_AktSelEintrag_Aktion_Str: TLabel;
    Memo_PrjError: TMemo;
    Label20: TLabel;
    Label_AnzahlEintraege: TLabel;
    procedure OnCreate(Sender: TObject);
    procedure OnActivate(Sender: TObject);
    procedure Button_Help_OnClick(Sender: TObject);
  end;

Var StatistikForm: TStatistikForm;

IMPLEMENTATION

{$R *.DFM}

// Initialisieren - OnCreate
PROCEDURE TStatistikForm.OnCreate(Sender: TObject);
begin
  If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Help.Enabled:=true;
end;

// Initialisieren - OnActivate
PROCEDURE TStatistikForm.OnActivate(Sender: TObject);
var OA_Int1, OA_Int2, OA_Int3, OA_Int4, OA_Int5, OA_Int6: integer; TSF_OA_TreeNode1: TTreeNtNode;
begin
  // -> Projekt-Titel
  If Fenster_Titel>'' then Label_PrjTitle.Caption:=Fenster_Titel else Label_PrjTitle.Caption:='<Unbenannt>';
  // -> Ini-Datei
  If IniFileComIstGeladen then begin
    If FileExists(IniFileCom) then Label_IniDatei.Caption:='"'+LowerCase(ExtractFileName(IniFileCom))+'"'
    else begin Label_IniDatei.Font.Color:=clRed; Label_IniDatei.Caption:='Fehler: Ini-Datei wurde eingeladen, jedoch nicht gefunden...'; end;
  end else Label_IniDatei.Caption:='Es wurde keine Ini-Datei geladen...';
  // -> Hilfe-Datei
  If MainForm.MainMenu.Items[5].Items[0].Enabled then begin
    If FileExists(HlpFileCom) then Label_HilfeDatei.Caption:='"'+LowerCase(ExtractFileName(HlpFileCom))+'"'
    else begin Label_HilfeDatei.Font.Color:=clRed; Label_HilfeDatei.Caption:='Fehler: Hilfedatei wurde eingebunden, jedoch nicht gefunden...'; end;
  end else Label_HilfeDatei.Caption:='Es wurde keine Hilfedatei eingebunden...';
  // -> Aktuell selektierter Projekteintrag
    // -> Position
    Label_AktSelEintrag_Position_Global.Caption:=IntToStr(MainForm.Tree.Selected.AbsoluteIndex+1);
    Label_AktSelEintrag_Position_Ebene.Caption:=IntToStr(MainForm.Tree.Selected.Index+1);
    Label_AktSelEintrag_Position_Level.Caption:=IntToStr(MainForm.Tree.Selected.Level);
    // -> Kommentar
    OA_Int2:=0;
    For OA_Int1:=0 to MainForm.KommentarEdit.Lines.Count-1 do inc(OA_Int2,Length(MainForm.KommentarEdit.Lines[OA_Int1]));
    Label_AktSelEintrag_Kommentar_Zeichen.Caption:=IntToStr(OA_Int2);
    Label_AktSelEintrag_Kommentar_Zeilen.Caption:=IntToStr(MainForm.KommentarEdit.Lines.Count);
    If MainForm.KommentarEdit.Lines.Count>0 then begin
      OA_Int2:=1; OA_Int3:=Length(MainForm.KommentarEdit.Lines[0]);
      OA_Int4:=1; OA_Int5:=Length(MainForm.KommentarEdit.Lines[0]);
      For OA_Int1:=1 to MainForm.KommentarEdit.Lines.Count-1 do begin
        OA_Int6:=Length(MainForm.KommentarEdit.Lines[OA_Int1]);
        If OA_Int6<OA_Int3 then begin OA_Int2:=OA_Int1+1; OA_Int3:=OA_Int6; end;
        If OA_Int6>OA_Int5 then begin OA_Int4:=OA_Int1+1; OA_Int5:=OA_Int6; end;
      end;
      Label_AktSelEintrag_Kommentar_ZeileNr_Kurz1.Caption:=IntToStr(OA_Int2); Label_AktSelEintrag_Kommentar_ZeileNr_Kurz2.Caption:=IntToStr(OA_Int3);
      Label_AktSelEintrag_Kommentar_ZeileNr_Lang1.Caption:=IntToStr(OA_Int4); Label_AktSelEintrag_Kommentar_ZeileNr_Lang2.Caption:=IntToStr(OA_Int5);
    end else begin
      Label_AktSelEintrag_Kommentar_ZeileNr_Kurz1.Caption:='-'; Label_AktSelEintrag_Kommentar_ZeileNr_Kurz2.Caption:='-';
      Label_AktSelEintrag_Kommentar_ZeileNr_Lang1.Caption:='-'; Label_AktSelEintrag_Kommentar_ZeileNr_Lang2.Caption:='-';
    end;
    // -> Verknpfte Aktion
    PrjRec:=MainForm.Tree.Selected.Data;
    If PrjRec=nil then begin
      Label_AktSelEintrag_Aktion_Nr.Caption:='Interner Fehler: Record des Eintrages zeigt auf NIL.';
      Label_AktSelEintrag_Aktion_Str.Caption:='Beenden und Starten sie DSM32 anschlieend von neuem...';
      Label_AktSelEintrag_Aktion_Nr.Font.Color:=clRed; Label_AktSelEintrag_Aktion_Str.Font.Color:=clRed;
    end else begin
      Label_AktSelEintrag_Aktion_Nr.Caption:=IntToStr(PrjRec.AktionNr);
      Label_AktSelEintrag_Aktion_Str.Caption:=PrjRec.AktionStr;
    end;
  // -> Ungltige bzw. fehlerhafte Projekteintrge
  Memo_PrjError.Clear;
  For OA_Int1:=0 to MainForm.Tree.Items.Count-1 do begin
    TSF_OA_TreeNode1:=MainForm.Tree.Items[OA_Int1];
    If TSF_OA_TreeNode1.Data=nil then Memo_PrjError.Lines.Add('-> Der Record des Eintrages Nummer '+IntToStr(TSF_OA_TreeNode1.AbsoluteIndex+1)+' zeigt auf NIL und besitzt somit keine Datenstruktur.') else begin
      PrjRec:=TSF_OA_TreeNode1.Data;
      If PrjRec.Kommentar=nil then Memo_PrjError.Lines.Add('-> Der Kommentartext des Eintrages Nummer '+IntToStr(TSF_OA_TreeNode1.AbsoluteIndex+1)+' zeigt auf NIL und wurde somit nicht initialisiert.');
    end;
  end;
  If Memo_PrjError.Lines.Count>0 then Memo_PrjError.Font.Color:=clRed else Memo_PrjError.Lines.Add('Keine Fehler...');
  // Anzahl der Projekteintrge
  Label_AnzahlEintraege.Caption:=IntToStr(MainForm.Tree.Items.Count);
  Cursor:=crDefault;
end;

PROCEDURE TStatistikForm.Button_Help_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

END.
