{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# MSG_INIFILENOTFOUND.PAS - TMsgIniFileNotFoundForm                                      #
# Message: "Ini-Datei konnte nicht gefunden werden", wird von MAIN.PAS aufgerufen.       #
#########################################################################################}

UNIT Msg_IniFileNotFound;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     StdCtrls, ExtCtrls, FileCtrl, Buttons;

Type
  TMsgIniFileNotFoundForm = class(TGradientForm)
    Panel1: TPanel;
    Image1: TImage;
    Label1: TLabel;
    LabelDateiname: TLabel;
    Label3: TLabel;
    Label2: TLabel;
    Button_New: TBitBtn;
    Button_Open: TBitBtn;
    Button_Abbrechen: TBitBtn;
    Button_Hilfe: TBitBtn;
    OpenDialog: TOpenDialog;
    procedure Button_New_OnClick(Sender: TObject);
    procedure Button_Open_OnClick(Sender: TObject);
    procedure Button_Hilfe_OnClick(Sender: TObject);
    procedure OnCreate(Sender: TObject);
  end;

Var MsgIniFileNotFoundForm: TMsgIniFileNotFoundForm;

IMPLEMENTATION

Uses Globals;

{$R *.DFM}

// Initialisieren
PROCEDURE TMsgIniFileNotFoundForm.OnCreate(Sender: TObject);
begin
  If FileExists(HlpFileCom) then begin
    Application.HelpFile:=ExpandFileName(HlpFileCom);
    Button_Hilfe.Enabled:=true;
  end;
  MessageBeep(MB_ICONQUESTION);
end;

// Button "Neues Projekt erffnen" OnClick
PROCEDURE TMsgIniFileNotFoundForm.Button_New_OnClick(Sender: TObject);
begin IniFileCom:=''; ModalResult:=mrNo; end;

// Button "Vorhandenes Projekt suchen" OnClick
PROCEDURE TMsgIniFileNotFoundForm.Button_Open_OnClick(Sender: TObject);
begin
  OpenDialog.InitialDir:=StartDir;
  If IniFileCom>'' then begin OpenDialog.Filename:=ExtractFileName(IniFileCom);
    If DirectoryExists(ExtractFilePath(IniFileCom)) then OpenDialog.InitialDir:=ExtractFilePath(IniFileCom);
  end;
  If OpenDialog.Execute then begin
    If IsGueltigeDSM32IniDatei(OpenDialog.Filename) then begin
      IniFileCom:=ExpandFileName(OpenDialog.Filename);
      ModalResult:=mrYes;
    end;
  end;
end;

// Button "Hilfe" OnClick
PROCEDURE TMsgIniFileNotFoundForm.Button_Hilfe_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

END.
