{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# MSGBOX.PAS - TMsgBoxForm                                                               #
# Erweiterte MessageBox                                                                  #
#########################################################################################}

UNIT MsgBox;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     ExtCtrls, StdCtrls, Buttons, Globals, Main;

Type
  TMsgBoxForm = class(TGradientForm)
    Panel1: TPanel;
    Image_Save: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Button_Ja: TBitBtn;
    Button_Nein: TBitBtn;
    Button_Abbrechen: TBitBtn;
    Button_Ok: TBitBtn;
    Button_Hilfe: TBitBtn;
    Image_PrjDelete: TImage;
    Image_UngueltigCom: TImage;
    Image_Search: TImage;
    Image_Net: TImage;
    Button_Wiederholen: TBitBtn;
    Image_Printer: TImage;
    Image_MkDir: TImage;
    Image_Info: TImage;
    Image_Question: TImage;
    Image_Stop: TImage;
    procedure OnCreate(Sender: TObject);
    procedure OnShow(Sender: TObject);
    procedure Button_Hilfe_OnClick(Sender: TObject);
    procedure OnClose(Sender: TObject; var Action: TCloseAction);
  end;

Var MsgBoxNr: byte;
    MsgBoxForm: TMsgBoxForm;

IMPLEMENTATION

{$R *.DFM}

// Initiailiseren - OnCreate
PROCEDURE TMsgBoxForm.OnCreate(Sender: TObject);
begin
  If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
end;

// Initialiseren - OnShow
PROCEDURE TMsgBoxForm.OnShow(Sender: TObject);
var OS_Beep: integer;
begin
  Case Int1 of
    0:  begin
          Caption:='nderungen speichern ?';
          Label1.Caption:='Die Projektdaten oder die Einstellungen wurden modifiziert.';
          Label2.Caption:='Sollen die nderungen in der Ini-Datei gespeichert werden ?';
          Label3.Caption:='';
          Width:=400;
          Image_Save.Visible:=true;
          Button_Ja.Visible:=true; Button_Ja.Left:=8; Button_Ja.Hint:='Ja, die nderungen werden gespeichert.';
          Button_Nein.Visible:=true; Button_Nein.Left:=104; Button_Nein.Hint:='Nein, die nderungen werden nicht gespeichert.';
          Button_Abbrechen.Visible:=true; Button_Abbrechen.Left:=200; Button_Abbrechen.Hint:='Abbrechen, DSM32 wird nicht beendet.';
          Button_Hilfe.Left:=296;
          ActiveControl:=Button_Ja; Button_Ja.Default:=true;
          HelpContext:=103;
          OS_Beep:=MB_ICONQUESTION;
        end;
    1:  begin
          Caption:='Neue Ini-Datei erstellen ?';
          Label1.Caption:='Es wurde keine Ini-Datei gefunden.';
          Label2.Caption:='Soll eine neue Ini-Datei erstellt werden ?';
          Label3.Caption:='';
          Width:=305;
          Image_Save.Visible:=true;
          Button_Ja.Visible:=true; Button_Ja.Left:=8; Button_Ja.Hint:='Ja, neue Ini-datei erstellen';
          Button_Nein.Visible:=true; Button_Nein.Left:=104; Button_Nein.Hint:='Nein, Speichern abbrechen';
          Button_Hilfe.Left:=200;
          ActiveControl:=Button_Ja; Button_Ja.Default:=true;
          HelpContext:=104;
          OS_Beep:=MB_ICONQUESTION;
        end;
    2:  begin
          Caption:='Fehler: Konnte Ini-Datei nicht schreiben...';
          Label1.Caption:='Die Ini-Datei "'+LowerCase(ExtractFileName(IniFileCom))+'"';
          Label2.Caption:='konnte nicht geschrieben werden.';
          Label3.Caption:='';
          Width:=352;
          Image_Save.Visible:=true;
          Button_Ok.Visible:=true; Button_Ok.Left:=8;
          Button_Hilfe.Left:=248;
          ActiveControl:=Button_Ok; Button_Ok.Default:=true;
          HelpContext:=105;
          OS_Beep:=MB_ICONHAND;
        end;
    5,6: begin
          Caption:='Fehler: OnLine-Verbindung fehlgeschlagen...';
          If Int1=5 then begin
            Label1.Caption:='Das verschicken einer E-Mail an den Autor ist zur';
            Label2.Caption:='Zeit nicht mglich, da keine OnLine-Verbindung';
          end else begin
            Label1.Caption:='Der Besuch der Homepage des Autors ist zur';
            Label2.Caption:='Zeit nicht mglich, da keine OnLine-Verbindung';
          end;
          Label3.Caption:='aufgebaut werden konnte.';
          Width:=345;
          Image_Net.Visible:=true;
          Button_Ok.Visible:=true; Button_Ok.Left:=8;
          Button_Hilfe.Left:=240;
          ActiveControl:=Button_Ok; Button_Ok.Default:=true;
          HelpContext:=124;
          OS_Beep:=MB_ICONHAND;
       end;
    10..13: begin
          Case Int1 of
            10:begin
                 Caption:='Eintrag entfernen ?';
                 Label1.Caption:='Soll der selektierte Projekteintrag';
                 Label2.Caption:='wirklich gelscht werden ?';
                 Label3.Caption:='';
                 Button_Ja.Hint:='Ja, Eintrag wirklich entfernen.';
                 HelpContext:=91;
               end;
            11:begin
                 Caption:='Eintrag entfernen ?';
                 Label1.Caption:='Soll der selektierte Projekteintrag und';
                 Label2.Caption:='alle seine vorhandenen Untereintrge';
                 Label3.Caption:='wirklich gelscht werden ?';
                 Button_Ja.Hint:='Ja, Eintrag und desen Untereintrge wirklich entfernen.';
                 HelpContext:=91;
               end;
            12:begin
                 Caption:='Eintrge entfernen ?';
                 Label1.Caption:='Sollen alle Untereintrge des';
                 Label2.Caption:='selektierten Projeteintrages';
                 Label3.Caption:='wirklich gelscht werden ?';
                 Button_Ja.Hint:='Ja, Alle Untereintrge wirklich entfernen.';
                 HelpContext:=91;
               end;
            13:begin
                 Caption:='Alle Eintrge entfernen ?';
                 Label1.Caption:='Sollen alle Projekteintrge';
                 Label2.Caption:='und deren Untereintrge';
                 Label3.Caption:='wirklich gelscht werden ?';
                 Button_Ja.Hint:='Ja, Alle Projekeintrge wirklich entfernen.';
                 HelpContext:=92;
               end;
          end;
          Width:=305;
          Image_PrjDelete.Visible:=true;
          Button_Ja.Visible:=true; Button_Ja.Left:=8;
          Button_Abbrechen.Visible:=true; Button_Abbrechen.Left:=104; Button_Abbrechen.Hint:='Abbrechen, Vorhaben verwerfen.';
          Button_Hilfe.Left:=200;
          ActiveControl:=Button_Ja; Button_Ja.Default:=true;
          OS_Beep:=MB_ICONQUESTION;
        end;
    30: begin
          Caption:='Fehler: Ungltige Datei-/Verzeichnisangabe...';
          Label1.Caption:='Das angegebene Verzeichnis/Datei konnte nicht verkrzt';
          Label2.Caption:='werden. Dadurch ist eine relative und datentrgerunab-';
          Label3.Caption:='hngige Angabe nicht mglich. Trotzdem fortsetzen ?';
          Width:=369;
          Image_UngueltigCom.Visible:=true;
          Button_Ja.Visible:=true; Button_Ja.Left:=8; Button_Ja.Hint:='Ja, genderte Angaben trotzdem bernehmen.';
          Button_Nein.Visible:=true; Button_Nein.Left:=104; Button_Nein.Hint:='Nein, genderte Angaben verwerfen.';
          Button_Hilfe.Left:=264;
          ActiveControl:=Button_Ja; Button_Ja.Default:=true;
          HelpContext:=110;
          OS_Beep:=MB_ICONHAND;
        end;
    40..42: begin
          Case Int1 of
            40:begin
                 Caption:='Fehler: Suche nicht mglich...';
                 Label1.Caption:='Es sind keine Projekteintrge vorhanden,';
                 Label2.Caption:='die Durchsucht werden knnten.';
                 Label3.Caption:='Eine Suche ist somit nicht mglich.';
                 HelpContext:=121;
                 OS_Beep:=MB_ICONHAND;
               end;
            41:begin
                 Caption:='Suche erfolgreich !';
                 Label1.Caption:='Der angegebene Suchbegriff wurde gefunden.';
                 Label2.Caption:='';
                 Label3.Caption:='';
                 HelpContext:=122;
                 OS_Beep:=MB_OK;
               end;
             42:begin
                 Caption:='Suche abgeschlossen !';
                 Label1.Caption:='Der angegebene Suchbegriff konnte nicht';
                 Label2.Caption:='gefunden werden.';
                 Label3.Caption:='';
                 HelpContext:=123;
                 OS_Beep:=MB_OK;
               end;
          end;
          Width:=305;
          Image_Search.Visible:=true;
          Button_Ok.Visible:=true; Button_Ok.Left:=8;
          Button_Hilfe.Left:=200;
          ActiveControl:=Button_Ok; Button_Ok.Default:=true;
        end;
    43: begin
          Caption:='Suche abgeschlossen !';
          Label1.Caption:='Das Ende der Projekteintrge wurde';
          Label2.Caption:='wurde erreicht.';
          Label3.Caption:='Neue Suche starten ?';
          Width:=305;
          Image_Search.Visible:=true;
          Button_Ja.Visible:=true; Button_Ja.Left:=8; Button_Ja.Hint:='Ja, Neue Suche starten.';
          Button_Nein.Visible:=true; Button_Nein.Left:=104; Button_Nein.Hint:='Nein, Suche beenden.';
          Button_Hilfe.Left:=200;
          ActiveControl:=Button_Ja; Button_Ja.Default:=true;
          HelpContext:=123;
          OS_Beep:=MB_ICONQUESTION;
        end;
    50: begin
          Caption:='Drucker beschftigt...';
          Label1.Caption:='Das drucken ist momentan nicht mglich, da';
          Label2.Caption:='zur Zeit bereits eine Druckerausgabe luft.';
          Label3.Caption:='Erneut versuchen ?';
          Width:=305;
          Image_Printer.Visible:=true;
          Button_Wiederholen.Visible:=true; Button_Wiederholen.Left:=8; Button_Wiederholen.Hint:='Drucken erneut versuchen';
          Button_Abbrechen.Visible:=true; Button_Abbrechen.Left:=104; Button_Abbrechen.Hint:='Druckauftrag abbrechen';
          Button_Hilfe.Left:=200;
          ActiveControl:=Button_Wiederholen; Button_Wiederholen.Default:=true;
          HelpContext:=126;
          OS_Beep:=MB_ICONQUESTION;
        end;
    60: begin
          Caption:='Fehler: Ungltige Aktion...';
          Label1.Caption:='Die angegebene Datei bzw. das angegebene';
          Label2.Caption:='Verzeichnis konnte nicht gefunden werden.';
          Label3.Caption:='Trotzdem fortsetzen ?';
          Width:=305;
          Image_UngueltigCom.Visible:=true;
          Button_Ja.Visible:=true; Button_Ja.Left:=8; Button_Ja.Hint:='Ja, Aktion dennoch ausfhren';
          Button_Abbrechen.Visible:=true; Button_Abbrechen.Left:=104; Button_Abbrechen.Hint:='Aktion abbrechen';
          Button_Hilfe.Left:=200;
          ActiveControl:=Button_Ja; Button_Ja.Default:=true;
          HelpContext:=127;
          OS_Beep:=MB_ICONQUESTION;
        end;
    70..72: begin
          Caption:='Fehler: Kann Verzeichnis nicht erstellen...';
          Case Int1 of
            70: begin
                  Label1.Caption:='Das angegebene Verzeichnis existiert bereits und';
                  Label2.Caption:='kann folglich auch nicht neu erstellt werden.';
                  Label3.Caption:='';
                end;
            71: begin
                  Label1.Caption:='Das angegebene Verzeichnis konnte nicht erstellt';
                  Label2.Caption:='werden.';
                  Label3.Caption:='berprfen sie ihre Verzeichnisangabe.';
                end;
            72: begin
                  Label1.Caption:='Der Verzeichnisname darf keines der folgenden';
                  Label2.Caption:='Zeichen enthalten:';
                  Label3.Caption:='/ \ : * ? " < > |';
                end;
          end;
          Width:=329;
          Image_MkDir.Visible:=true;
          Button_Ok.Visible:=true; Button_Ok.Left:=8;
          Button_Hilfe.Left:=224;
          ActiveControl:=Button_Ok; Button_Ok.Default:=true;
          HelpContext:=129;
          OS_Beep:=MB_ICONHAND;
        end;
    75: begin
          Caption:='Fehler: Ungengend Speicherplatz...';
          Label1.Caption:='Auf dem angegebenen Ziellaufwerk steht nicht';
          Label2.Caption:='genug freier Speicherplatz zur Verfgung.';
          Label3.Caption:='Trotzdem fortsetzen ?';
          Width:=305;
          Image_UngueltigCom.Visible:=true;
          Button_Ja.Visible:=true; Button_Ja.Left:=8; Button_Ja.Hint:='Ja, Vorhaben trotzdem fortsetzen.';
          Button_Nein.Visible:=true; Button_Nein.Left:=104; Button_Nein.Hint:='Nein, Vorhaben abbrechen.';
          Button_Hilfe.Left:=200;
          ActiveControl:=Button_Nein; Button_Nein.Default:=true;
          HelpContext:=131;
          OS_Beep:=MB_ICONQUESTION;
        end;
    76,77: begin
          Caption:='Fehler: Zielverzeichnis kann nicht erstellt werden...';
          Label1.Caption:='Das angegebene Zielverzeichnis existiert nicht und konnte';
          Label2.Caption:='auch nicht erstellt werden.';
          Case Int1 of
            76: Label3.Caption:='Kopieren nicht mglich.';
            77: Label3.Caption:='Verschieben nicht mglich.';
          end;
          Width:=377;
          Image_MkDir.Visible:=true;
          Button_Ok.Visible:=true; Button_Ok.Left:=8;
          Button_Hilfe.Left:=272;
          ActiveControl:=Button_Ok; Button_Ok.Default:=true;
          HelpContext:=132;
          OS_Beep:=MB_ICONHAND;
        end;
    80..85: begin
          Case Int1 of
            80: begin
                  Caption:='Kopieren abgebrochen...';
                  Label1.Caption:='Das kopieren der markierten';
                  Label2.Caption:='Objekte wurde abgebrochen.';
                  HelpContext:=208;
                end;
            81: begin
                  Caption:='Verschieben abgebrochen...';
                  Label1.Caption:='Das verschieben der markierten';
                  Label2.Caption:='Objekte wurde abgebrochen.';
                  HelpContext:=208;
                end;
            82: begin
                  Caption:='Kopieren beendet.';
                  Label1.Caption:='Die Objekte wurden erfolgreich';
                  Label2.Caption:='kopiert.';
                  HelpContext:=207;
                end;
            83: begin
                  Caption:='Verschieben beendet.';
                  Label1.Caption:='Die Objekte wurden erfolgreich';
                  Label2.Caption:='verschoben.';
                  HelpContext:=207;
                end;
            84: begin
                  Caption:='Kopieren beendet.';
                  Label1.Caption:='Die Objekte wurden teilweise';
                  Label2.Caption:='kopiert.';
                  HelpContext:=207;
                end;
            85: begin
                  Caption:='Verschieben beendet.';
                  Label1.Caption:='Die Objekte wurden teilweise';
                  Label2.Caption:='verschoben.';
                  HelpContext:=207;
                end;
          end;
          Label3.Caption:='';
          Width:=249;
          Image_Info.Visible:=true;
          Button_Ok.Visible:=true; Button_Ok.Left:=8;
          Button_Hilfe.Left:=144;
          ActiveControl:=Button_Ok; Button_Ok.Default:=true;
          OS_Beep:=MB_ICONINFORMATION;
        end;
    90,91: begin
          Case Int1 of
            90: begin
                  Caption:='Kopieren abbrechen ?';
                  Label1.Caption:='Wollen sie den Kopierproze';
                  Button_Ja.Hint:='Ja, Kopieren abbrechen';
                  Button_Nein.Hint:='Nein, Kopieren fortsetzen';
                end;
            91: begin
                  Caption:='Verschieben abbrechen ?';
                  Label1.Caption:='Wollen sie den Verschiebeproze';
                  Button_Ja.Hint:='Ja, Verschieben abbrechen';
                  Button_Nein.Hint:='Nein, Verschieben fortsetzen';
                end;
          end;
          Label2.Caption:='wirklich abbrechen ?';
          Label3.Caption:='';
          Width:=305;
          Image_Question.Visible:=true;
          Button_Ja.Visible:=true; Button_Ja.Left:=8;
          Button_Nein.Visible:=true; Button_Nein.Left:=104;
          Button_Hilfe.Left:=200;
          ActiveControl:=Button_Nein; Button_Nein.Default:=true;
          HelpContext:=208;
          OS_Beep:=MB_ICONQUESTION;
        end;
    100:begin
          Caption:='Fehler: Zip-Archiv wurde nicht gefunden...';
          Label1.Caption:='Die angegebene Archivdatei existiert nicht oder';
          Label2.Caption:='konnte nicht gefunden werden.';
          Label3.Caption:='';
          Width:=321;
          Image_Stop.Visible:=true;
          Button_Ok.Visible:=true; Button_Ok.Left:=8;
          Button_Hilfe.Left:=216;
          ActiveControl:=Button_Ok; Button_Ok.Default:=true;
          HelpContext:=140;
          OS_Beep:=MB_ICONHAND;
        end;
    101:begin
          Caption:='Fehler: Datei ist kein gltiges Zip-Archiv...';
          Label1.Caption:='Die angegebene Datei ist keine gltige';
          Label2.Caption:='Zip-Archivdatei oder fehlerhaft.';
          Label3.Caption:='';
          Width:=337;
          Image_Stop.Visible:=true;
          Button_Ok.Visible:=true; Button_Ok.Left:=8;
          Button_Hilfe.Left:=232;
          ActiveControl:=Button_Ok; Button_Ok.Default:=true;
          HelpContext:=141;
          OS_Beep:=MB_ICONHAND;
        end;
    102:begin
          Caption:='Leeres Zip-Archiv !';
          Label1.Caption:='Die Archivdatei besitzt keine';
          Label2.Caption:='Datei- oder Verzeichniseintrge.';
          Label3.Caption:='';
          Width:=257;
          Image_Info.Visible:=true;
          Button_Ok.Visible:=true; Button_Ok.Left:=8;
          Button_Hilfe.Left:=152;
          ActiveControl:=Button_Ok; Button_Ok.Default:=true;
          HelpContext:=142;
          OS_Beep:=MB_ICONINFORMATION;
        end;
    103:begin
          Caption:='Fehler: Zuerst eine Archivdatei whlen...';
          Label1.Caption:='Bevor eine gepackte Datei entpackt werden kann,';
          Label2.Caption:='mu eine betreffende Archivdatei ausgewhlt';
          Label3.Caption:='werden.';
          Width:=322;
          Image_Stop.Visible:=true;
          Button_Ok.Visible:=true; Button_Ok.Left:=8;
          Button_Hilfe.Left:=216;
          ActiveControl:=Button_Ok; Button_Ok.Default:=true;
          HelpContext:=143;
          OS_Beep:=MB_ICONINFORMATION;
        end;
    115,116:begin
          Caption:='Fehler: Umbenennen nicht mglich...';
          If Int1=115 then begin
            Label1.Caption:='Ein Datei- oder Verzeichnisname darf';
            Label2.Caption:='keines der folgenden Zeichen enthalten:';
            Label3.Caption:='/ \ : * ? " < > |';
          end else begin
            Label1.Caption:='Die Datei oder das Verzeichnis konnte';
            Label2.Caption:='nicht umbenannt werden.';
            Label3.Caption:='berprfen sie ihre Angabe.';
          end;
          Width:=297;
          Image_Stop.Visible:=true;
          Button_Ok.Visible:=true; Button_Ok.Left:=8;
          Button_Hilfe.Left:=192;
          ActiveControl:=Button_Ok; Button_Ok.Default:=true;
          HelpContext:=155;
          OS_Beep:=MB_ICONHAND;
        end;
  end;
  Hint:=Caption;
  Update;
  MessageBeep(OS_Beep);
end;

// OnClose
PROCEDURE TMsgBoxForm.OnClose(Sender: TObject; var Action: TCloseAction);
begin
  If Button_Ok.Visible then Button_Ok.Hide;
  If Button_Ja.Visible then Button_Ja.Hide;
  If Button_Nein.Visible then Button_Nein.Hide;
  If Button_Abbrechen.Visible then Button_Abbrechen.Hide;
  If Button_Wiederholen.Visible then Button_Wiederholen.Hide;
  If Image_PrjDelete.Visible then Image_PrjDelete.Hide;
  If Image_Net.Visible then Image_Net.Hide;
  If Image_Save.Visible then Image_Save.Hide;
  If Image_Search.Visible then Image_Search.Hide;
  If Image_UngueltigCom.Visible then Image_UngueltigCom.Hide;
  If Image_Printer.Visible then Image_Printer.Hide;
  If Image_MkDir.Visible then Image_MkDir.Hide;
  If Image_Info.Visible then Image_Info.Hide;
  If Image_Question.Visible then Image_Question.Hide;
  If Image_Stop.Visible then Image_Stop.Hide;
end;

// Button "Hilfe" OnClick
PROCEDURE TMsgBoxForm.Button_Hilfe_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

END.
