{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# MAIN.PAS - TMainForm                                                                   #
# Hauptformular und -unit.                                                               #
#########################################################################################}

UNIT Main;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     Menus, StdCtrls, ExtCtrls, ComCtrls, FileCtrl, IniFiles, Globals,
     TB97, NewStat, TreeNT, SlidePan, Gauges; // externe VCL-Komponenten

Type
  TMainForm = class(TGradientForm)
    // MainMenu
    MainMenu: TMainMenu;
      MainMenu_Projekt: TMenuItem;
        MainMenu_Projekt_Speichern: TMenuItem;
        MainMenu_Projekt_N1: TMenuItem;
        MainMenu_Projekt_Statistik: TMenuItem;
        MainMenu_Projekt_N2: TMenuItem;
        MainMenu_Projekt_Beenden: TMenuItem;
      MainMenu_Bearbeiten: TMenuItem;
        MainMenu_Bearbeiten_AlleVerzweigungenOeffnen: TMenuItem;
        MainMenu_Bearbeiten_AlleVerzweigungenSchliessen: TMenuItem;
        MainMenu_Bearbeiten_N1: TMenuItem;
        MainMenu_Bearbeiten_EintragHinzufuegen: TMenuItem;
        MainMenu_Bearbeiten_UntereintragHinzufuegen: TMenuItem;
        MainMenu_Bearbeiten_EintragVerschieben: TMenuItem;
        MainMenu_Bearbeiten_N2: TMenuItem;
        MainMenu_Bearbeiten_EintragVerschieben_Oben: TMenuItem;
          MainMenu_Bearbeiten_EintragVerschieben_Unten: TMenuItem;
          MainMenu_Bearbeiten_EintragVerschieben_N1: TMenuItem;
          MainMenu_Bearbeiten_EintragVerschieben_Anfang: TMenuItem;
          MainMenu_Bearbeiten_EintragVerschieben_Ende: TMenuItem;
        MainMenu_Bearbeiten_N3: TMenuItem;
        MainMenu_Bearbeiten_EintragEntfernen: TMenuItem;
        MainMenu_Bearbeiten_UntereintraegeEntfernen: TMenuItem;
        MainMenu_Bearbeiten_AlleEintraegeEntfernen: TMenuItem;
      MainMenu_Suchen: TMenuItem;
        MainMenu_Suchen_Suchen: TMenuItem;
        MainMenu_Suchen_Weitersuchen: TMenuItem;
      MainMenu_Exportieren: TMenuItem;
        MainMenu_Exportieren_Drucken: TMenuItem;
        MainMenu_Exportieren_Textdatei: TMenuItem;
        MainMenu_Exportieren_HTMLDokument: TMenuItem;
      MainMenu_Einstellungen: TMenuItem;
        MainMenu_Einstellungen_ButtonpanelAusblenden: TMenuItem;
        MainMenu_Einstellungen_StatuszeileAusblenden: TMenuItem;
        MainMenu_Einstellungen_N1: TMenuItem;
        MainMenu_Einstellungen_EinstellungenKonfigurieren: TMenuItem;
      MainMenu_Hilfe: TMenuItem;
        MainMenu_Hilfe_Hilfethemen: TMenuItem;
        MainMenu_Hilfe_Lizenzbestimmungen: TMenuItem;
        MainMenu_Hilfe_N1: TMenuItem;
        MainMenu_Hilfe_Systeminformationen: TMenuItem;
        MainMenu_Hilfe_N2: TMenuItem;
        MainMenu_Hilfe_Info: TMenuItem;
    // ButtonPanel
    ButtonPanel: TPanel;
    ButtonPanelImage: TImage;
    PanelButton_Beenden: TToolbarButton97;
    PanelButton_Save: TToolbarButton97;
    PanelButton_Statistik: TToolbarButton97;
    PanelButton_AlleVerzweigungenOefffnen: TToolbarButton97;
    PanelButton_AlleVerzweigungenSchliessen: TToolbarButton97;
    PanelButton_EintragHinzufuegen: TToolbarButton97;
    PanelButton_UntereintragHinzufuegen: TToolbarButton97;
    PanelButton_VerschiebenAnfang: TToolbarButton97;
    PanelButton_VerschiebenEnde: TToolbarButton97;
    PanelButton_VerschiebenUnten: TToolbarButton97;
    PanelButton_VerschiebenOben: TToolbarButton97;
    PanelButton_EintragEntfernen: TToolbarButton97;
    PanelButton_Suchen: TToolbarButton97;
    PanelButton_Weitersuchen: TToolbarButton97;
    PanelButton_Einstellungen: TToolbarButton97;
    PanelButton_Info: TToolbarButton97;
    PanelButton_Help: TToolbarButton97;
    // Tree
    Tree: TTreeNT;
    ImageList: TImageList;
      // Tree-PopupMenu
      PopupMenu_Tree: TPopupMenu;
        PopupMenu_Tree_AktionAusfuehren: TMenuItem;
        PopupMenu_Tree_N1: TMenuItem;
        PopupMenu_Tree_EintragHinzufuegen: TMenuItem;
        PopupMenu_Tree_UntereintragHinzufuegen: TMenuItem;
        PopupMenu_Tree_N2: TMenuItem;
        PopupMenu_Tree_EintragVerschieben: TMenuItem;
          PopupMenu_Tree_EintragVerschieben_Oben: TMenuItem;
          PopupMenu_Tree_EintragVerschieben_Unten: TMenuItem;
          PopupMenu_Tree_EintragVerschieben_N1: TMenuItem;
          PopupMenu_Tree_EintragVerschieben_Anfang: TMenuItem;
          PopupMenu_Tree_EintragVerschieben_Ende: TMenuItem;
        PopupMenu_Tree_N3: TMenuItem;
        PopupMenu_Tree_Entfernen: TMenuItem;
      // Tree-DragDrop-PopupMenu
      PopupMenu_DragDrop: TPopupMenu;
        PopupMenu_DragDrop_Abbrechen: TMenuItem;
        PopupMenu_DragDrop_N1: TMenuItem;
        PopupMenu_DragDrop_HierherKopieren: TMenuItem;
        PopupMenu_DragDrop_HierherVerschieben: TMenuItem;
    // Kommentarfeld
    KommentarSlidePanel: TSlidePanel;
    KommentarEdit: TRichEdit;
      // PopupMenu_Kommentar
      PopupMenu_Kommentar: TPopupMenu;
        PopupMenu_Kommentar_Ausschneiden: TMenuItem;
        PopupMenu_Kommentar_Kopieren: TMenuItem;
        PopupMenu_Kommentar_Einfuegen: TMenuItem;
        PopupMenu_Kommentar_Loeschen: TMenuItem;
        PopupMenu_Kommentar_N1: TMenuItem;
        PopupMenu_Kommentar_AllesMarkieren: TMenuItem;
    // Aktion
    AktionPanel: TPanel;
    AktionLabel: TLabel;
    AktionButton_Bearbeiten: TToolbarButton97;
    // StatusBar
    StatusBar: TAStatusBar;
    ProgressBar: TProgressBar;
    Timer_Uhrzeit: TTimer;
    // Allgemeine Routinen
    procedure OnClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer_Uhrzeit_OnTimer(Sender: TObject);
    procedure OnResize(Sender: TObject);
    procedure KommentarSlidePanel_OnResize(Sender: TObject);
    // Initialisieren
    procedure OnCreate(Sender: TObject);
    procedure OnActivate(Sender: TObject);
    // MainMenu-Behandlung
    procedure MainMenu_Projekt_Speichern_OnClick(Sender: TObject);
    procedure MainMenu_Projekt_Statistik_OnClick(Sender: TObject);
    procedure MainMenu_Projekt_Beenden_OnClick(Sender: TObject);
    procedure MainMenu_Bearbeiten_AlleVerzweigungenOeffnen_OnClick(Sender: TObject);
    procedure MainMenu_Bearbeiten_AlleVerzweigungenSchliessen_OnClick(Sender: TObject);
    procedure MainMenu_Bearbeiten_EintragHinzufuegen_OnClick(Sender: TObject);
    procedure MainMenu_Bearbeiten_UntereintragHinzufuegen_OnClick(Sender: TObject);
    procedure MainMenu_Bearbeiten_EintragVerschieben_Oben_OnClick(Sender: TObject);
    procedure MainMenu_Bearbeiten_EintragVerschieben_Unten_OnClick(Sender: TObject);
    procedure MainMenu_Bearbeiten_EintragVerschieben_Anfang_OnClick(Sender: TObject);
    procedure MainMenu_Bearbeiten_EintragVerschieben_Ende_OnClick(Sender: TObject);
    procedure MainMenu_Bearbeiten_EintragEntfernen_OnClick(Sender: TObject);
    procedure MainMenu_Bearbeiten_UntereintraegeEntfernen_OnClick(Sender: TObject);
    procedure MainMenu_Bearbeiten_AlleEintraegeEntfernen_OnClick(Sender: TObject);
    procedure MainMenu_Suchen_Suchen_OnClick(Sender: TObject);
    procedure MainMenu_Suchen_Weitersuchen_OnClick(Sender: TObject);
    procedure MainMenu_Exportieren_Drucken_OnClick(Sender: TObject);
    procedure MainMenu_Exportieren_Textdatei_OnClick(Sender: TObject);
    procedure MainMenu_Exportieren_HTMLDokument_OnClick(Sender: TObject);
    procedure MainMenu_Einstellungen_ButtonpanelAusblenden_OnClick(Sender: TObject);
    procedure MainMenu_Einstellungen_StatuszeileAusblenden_OnClick(Sender: TObject);
    procedure MainMenu_Einstellungen_EinstellungenKonfigurieren_OnClick(Sender: TObject);
    procedure MainMenu_Hilfe_Lizenzbestimmungen_OnClick(Sender: TObject);
    procedure MainMenu_Hilfe_Hilfethemen_OnClick(Sender: TObject);
    procedure MainMenu_Hilfe_Systeminformationen_OnClick(Sender: TObject);
    procedure MainMenu_Hilfe_Info_OnClick(Sender: TObject);
    // Tree-Behandlung
    procedure Tree_OnChange(Sender: TObject; Node: TTreeNTNode);
    procedure Tree_OnEdited(Sender: TObject; Node: TTreeNTNode; var S: string);
    procedure Tree_OnKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Tree_OnMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure Tree_OnDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure Tree_OnDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure PopupMenu_DragDrop_HierherKopieren_OnClick(Sender: TObject);
    procedure PopupMenu_DragDrop_HierherVerschieben_OnClick(Sender: TObject);
    // Kommentar-Behandlung
    procedure KommentarEdit_OnChange(Sender: TObject);
    procedure KommentarEdit_OnEnter(Sender: TObject);
    procedure KommentarEdit_OnExit(Sender: TObject);
    procedure PopupMenu_Kommentar_Ausschneiden_OnClick(Sender: TObject);
    procedure PopupMenu_Kommentar_Kopieren_OnClick(Sender: TObject);
    procedure PopupMenu_Kommentar_Einfuegen_OnClick(Sender: TObject);
    procedure PopupMenu_Kommentar_Loeschen_OnClick(Sender: TObject);
    procedure PopupMenu_Kommentar_AllesMarkieren_OnClick(Sender: TObject);
    procedure PopupMenu_Kommentar_OnPopup(Sender: TObject);
    // Aktion-Behandlung
    procedure AktionButton_Bearbeiten_OnClick(Sender: TObject);
    // StatusBar-Behandlung
    procedure StatusBar_OnMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure AktionAusfuehren(Sender: TObject);
  private
    // Private-Deklarationen
    function SaveIniFile: boolean;
    function FindStringInPrj(FindString: string; BerCaption, BerKommentar, BerAktion, GrossKleinBeachten: boolean): boolean;
  public
    // Public-Deklataionen
    procedure ShowHints(Sender: TObject);
    procedure ShowMouseXYPos(var Msg: TMsg; var Handled: boolean);
    procedure SetEnabledDisabledState(SetNr: integer);
    function MsgDlg(MsgNr: integer): integer;
  end;

Const Kommentar_Editiert: boolean = false;

Var Int1: integer;
    Kommentar_StringList, SearchStrings: Tstringlist;
    TreeNode1, TreeNode2, TreeNode3: TTreeNtNode;
    MainForm: TMainForm;

IMPLEMENTATION

Uses Splash, AktionEdit, Statistik, Suchen, ExportPrint, ExportText, ExportHTML,
     Einstellungen, SystemInfos, Informationen, Dateimanager, Unrar, Unzip,
     MsgBox, Msg_IniFileNotFound, Msg_IniFileSyntaxError;

{$R *.DFM}

{------------------------------------------------------------------------------------------
Allgemeine Routinen
------------------------------------------------------------------------------------------}

// OnClose - Bei beenden von DSM32
PROCEDURE TMainForm.OnClose(Sender: TObject; var Action: TCloseAction);
begin
  If MainMenu.Items[0].Items[0].Enabled then begin
    Case MsgDlg(0) of
      idYes: If not SaveIniFile then Action:=caNone;
      idCancel: Action:=caNone;
  end; end;
  If Action<>caNone then begin
    If Kommentar_StringList<>nil then Kommentar_StringList.Free;
    If SearchStrings<>nil then SearchStrings.Free;
  end;
end;

// Anzeige der Uhrzeit in der Statuszeile
PROCEDURE TMainForm.Timer_Uhrzeit_OnTimer(Sender: TObject);
begin If StatusBar.Panels[1].Text<>TimeToStr(Time) then StatusBar.Panels[1].Text:=TimeToStr(Time); end;

// OnResize des MainFormulares
PROCEDURE TMainForm.OnResize(Sender: TObject);
var OR_Int1, OR_Int2, OR_Int3, OR_Int4: integer;
begin
  If ButtonPanel.Visible then begin
    ButtonPanelImage.Width:=Width-8; PanelButton_Help.Left:=Width-37; PanelButton_Info.Left:=Width-63;
    If StatusBar.Visible then begin
      StatusBar.Panels[0].Width:=Width-190;
      OR_Int2:=119; OR_Int3:=87; OR_Int4:=85;
    end else begin OR_Int2:=99; OR_Int3:=67; OR_Int4:=65; end;
    OR_Int1:=33;
  end else begin
    If StatusBar.Visible then begin
      StatusBar.Panels[0].Width:=Width-190;
      OR_Int2:=87; OR_Int3:=87; OR_Int4:=85;
    end else begin OR_Int2:=67; OR_Int3:=67; OR_Int4:=65; end;
    OR_Int1:=1;
  end;
  Tree.SetBounds(0,OR_Int1,Width-8,Height-KommentarSlidePanel.Height-OR_Int2);
  KommentarSlidePanel.SetBounds(0,Height-KommentarSlidePanel.Height-OR_Int3,Width-8,KommentarSlidePanel.Height);
  AktionPanel.SetBounds(0,Height-OR_Int4,Width-35,19);
  AktionButton_Bearbeiten.SetBounds(Width-32,AktionPanel.Top,22,19);
end;

// OnResize des KommentarSlidePanel
PROCEDURE TMainForm.KommentarSlidePanel_OnResize(Sender: TObject);
var KSPOR_Int1: integer;
begin
  If ButtonPanel.Visible then begin
    If StatusBar.Visible then KSPOR_Int1:=119 else KSPOR_Int1:=99;
  end else begin
    If StatusBar.Visible then KSPOR_Int1:=87 else KSPOR_Int1:=67;
  end;
  Tree.Height:=Height-KommentarSlidePanel.Height-KSPOR_Int1;
end;

{------------------------------------------------------------------------------------------
Initialisieren
------------------------------------------------------------------------------------------}

// Initialisieren "OnCreate"
PROCEDURE TMainForm.OnCreate(Sender: TObject);
var OC_Bool1, OC_Bool2: boolean; OC_Int1: integer; OC_Str1, OC_Str2: string; OC_IniFile: TIniFile;
  // Auswerten der bergebenen Kommandozeilenparameter
  Procedure AuswertenDerKommanozeilenparameter;
  var ADKP_Int1: integer; ADKP_Str1: string;
  begin
    For ADKP_Int1:=1 to ParamCount do begin ADKP_Str1:=ParamStr(ADKP_Int1);
      If Length(ADKP_Str1)>0 then If ExpandFileCom(ADKP_Str1) then
        If IsGueltigeDSM32IniDatei(ADKP_Str1) then IniFileCom:=ADKP_Str1;
    end;
  end;
begin
  // Vorarbeit
  SplashForm.ProgressBar.Position:=6; SplashForm.Update;
  StartDir:=LowerCase(ExtractFilePath(Application.ExeName)); If StartDir[Length(StartDir)]<>'\' then StartDir:=StartDir+'\';
  If ParamCount>0 then AuswertenDerKommanozeilenparameter; // GGf. Kommandozeilenparameter auswerten
  // Ini-Datei suchen
  If ExpandFileCom(IniFileCom) then begin
    If IsGueltigeDSM32IniDatei(IniFileCom) then IniFileComIstGeladen:=true else IniFileComIstGeladen:=false;
  end else IniFileComIstGeladen:=false;
  IniFileCom:=LowerCase(IniFileCom);
  If not IniFileComIstGeladen then begin
    // Ini-Datei konnte nicht gefunden werden, entsprechende Fehlermessage zeigen
    With TMsgIniFileNotFoundForm.Create(Self) do try
      LabelDateiname.Caption:=LowerCase(IniFileCom);
      If not FileExists(IniFileCom) then Label3.Caption:='konnte nicht gefunden werden.';
      Int1:=ShowModal;
    finally Free; end;
    Case Int1 of mrYes: IniFileComIstGeladen:=true;
      mrCancel: try Close; finally Halt; end; end;
  end;
  SplashForm.ProgressBar.Position:=12; SplashForm.Update;
  // Ini-Datei "Allgemeine Einstellungen" einlesen (Unabhngig ob Ini-Datei vorhanden oder nicht)
  OC_IniFile:=TIniFile.Create(IniFileCom);
    // -> [Fenster]
    Fenster_Titel:=OC_IniFile.ReadString('Fenster','Titel',Fenster_Titel);
      If Fenster_Titel>'' then Caption:='Dipesh-SoftwareManager-32 '+Fenster_Titel;
    Fenster_Breite:=OC_IniFile.ReadInteger('Fenster','Breite',Fenster_Breite);
      If Fenster_Breite>0 then Width:=Fenster_Breite;
    Fenster_Hoehe:=OC_IniFile.ReadInteger('Fenster','Hoehe',Fenster_Hoehe);
      If Fenster_Hoehe>0 then Height:=Fenster_Hoehe;
    Fenster_ZentriertPositionieren:=OC_IniFile.ReadBool('Fenster','Zentriert positionieren',Fenster_ZentriertPositionieren);
      If not Fenster_ZentriertPositionieren then Position:=poDefault;
    Fenster_Status:=OC_IniFile.ReadInteger('Fenster','Status',Fenster_Status);
      Case Fenster_Status of 1: WindowState:=wsMaximized; 2: WindowState:=wsMinimized; else WindowState:=wsNormal; end;
    Fenster_KommentarfeldHoehe:=OC_IniFile.ReadInteger('Fenster','Kommentarfeldhoehe',KommentarEdit.Height);
      If Fenster_KommentarfeldHoehe>0 then KommentarEdit.Height:=Fenster_KommentarfeldHoehe;
    // -> [Exportieren]
    Export_BerCaption:=OC_IniFile.ReadBool('Exportieren','Feldbereich Bezeichnung',Export_BerCaption);
    Export_BerKommentar:=OC_IniFile.ReadBool('Exportieren','Feldbereich Kommentar',Export_BerKommentar);
    Export_BerAktion:=OC_IniFile.ReadBool('Exportieren','Feldbereich Aktion',Export_BerAktion);
      OC_Str1:='"'+Export_BerCaption_Trennzeichen+','+Export_BerKommentar_Trennzeichen+','+Export_BerAktion_Trennzeichen+'"';
    OC_Str1:=OC_IniFile.ReadString('Exportieren','Feldbereich Trennzeichen',OC_Str1);
      Trim(OC_Str1);
      If Length(OC_Str1)>2 then begin
        If OC_Str1[1]='"' then Delete(OC_Str1,1,1);
        If OC_Str1[Length(OC_Str1)]='"' then Delete(OC_Str1,Length(OC_Str1),1);
        OC_Int1:=Pos(',',OC_Str1);
        If OC_Int1<>0 then begin
          OC_Str2:=Copy(OC_Str1,0,OC_Int1-1);
          Delete(OC_Str1,1,OC_Int1);
          Export_BerCaption_Trennzeichen:=OC_Str2;
          OC_Int1:=Pos(',',OC_Str1);
          If OC_Int1<>0 then begin
            OC_Str2:=Copy(OC_Str1,0,OC_Int1-1);
            Delete(OC_Str1,1,OC_Int1);
            Export_BerKommentar_Trennzeichen:=OC_Str2;
            If Length(OC_Str1)>0 then Export_BerAktion_Trennzeichen:=OC_Str1;
          end;
        end;
      end;
    // -> [EXTERN]
    HlpFileCom:=OC_IniFile.ReadString('Extern','Hilfedatei',HlpFileCom);
      If ExpandFileCom(HlpFileCom) then begin
        Application.HelpFile:=HlpFileCom;
        SetEnabledDisabledState(0);
      end else HlpFileCom:='';
    Extern_ApplicationName:=OC_IniFile.ReadString('Extern','Aktionsprogramm Name',Extern_ApplicationName);
    Extern_ApplicationCom:=OC_IniFile.ReadString('Extern','Aktionsprogramm Com',Extern_ApplicationCom);
    // -> [Projekt]
    If OC_IniFile.ReadBool('Projekt','ImageIcons nutzen',false) then Tree.Images:=ImageList;
    OC_Bool1:=OC_IniFile.ReadBool('Projekt','InfoTips verwenden',false);
    OC_Bool2:=OC_IniFile.ReadBool('Projekt','ToolTips verwenden',false);
      If OC_Bool1 then begin
        If OC_Bool2 then Tree.Options:=[toFullRowSelect,toHotTrack,toInfoTip,toToolTips,toShowButtons,toShowLines,toShowRoot]
        else Tree.Options:=[toFullRowSelect,toHotTrack,toInfoTip,toShowButtons,toShowLines,toShowRoot];
      end else begin
        If OC_Bool2 then Tree.Options:=[toFullRowSelect,toHotTrack,toToolTips,toShowButtons,toShowLines,toShowRoot]
        else Tree.Options:=[toFullRowSelect,toHotTrack,toShowButtons,toShowLines,toShowRoot];
      end;
  OC_IniFile.Free;
  SplashForm.ProgressBar.Position:=18; SplashForm.Update;
  Application.OnMessage:=ShowMouseXYPos; // Mauskoordinaten in der Statuszeile anzeigen
  Application.OnHint:=ShowHints; // Kurzhinweise in der Statuszeile anzeigen
  Timer_Uhrzeit_OnTimer(Sender); // Uhrzeit in der Statuszeile anzeigen
  OnResize(Sender); Update; // Formular- und Elementengren entspr. anpassen & Ansicht aktualisieren
  SearchStrings:=Tstringlist.Create;
  SplashForm.ProgressBar.Position:=21; SplashForm.Update;
end;

// Initialisieren "OnActivate"
PROCEDURE TMainForm.OnActivate(Sender: TObject);
var OA_Bool1, OA_Bool2: boolean;
    Parent_Integer, Aktion_Integer: integer;
    Anzahl_PrjItems_Total, Anzahl_PrjItems_Aktuell: word;
    OA_Str1, Caption_String, Aktion_String: string;
    OA_StringList1: tstringlist; OA_IniFile: textfile; OA_TreeNode: TTreeNtNode;
  // Extraiert den BefehlsString aus einen String - BEGIN<>END
  Function Extract_BefehlStr(FullString: string): string;
  var ExtBS_Bool: boolean; ExtBS_Int: integer; ExtBS_Str: string;
  begin
    Result:='';
    If Length(FullString)>0 then begin ExtBS_Bool:=false;  ExtBS_Int:=0; ExtBS_Str:='';
      Repeat inc(ExtBS_Int);
        If FullString[ExtBS_Int]='=' then begin
          If ExtBS_Int>1 then begin Result:=ExtBS_Str; ExtBS_Bool:=true; end;
        end else ExtBS_Str:=ExtBS_Str+FullString[ExtBS_Int];
        If ExtBS_Int=Length(FullString) then ExtBS_Bool:=true;
      until ExtBS_Bool; end;
  end;
  // Extraiert den TextString aus einen String - BEGIN<>END
  Function Extract_TextStr(FullString: string; var Erfolgreich: boolean): string;
  var ExtTS_Bool: boolean;
  begin
    Result:=''; Erfolgreich:=false;
    If Length(FullString)>0 then begin ExtTS_Bool:=false;
      Repeat Delete(FullString,1,1);
        If Length(FullString)=0 then ExtTS_Bool:=true else
          If FullString[1]='=' then begin Delete(FullString,1,1); Result:=FullString; Erfolgreich:=true; ExtTS_Bool:=true; end;
      until ExtTS_Bool; end;
  end;
  // Wertet den angegebenen Projektdaten-String zwischen "BEGIN" und "END" aus
  Function StringAuswerten(FullString: string): boolean;
  var StrAusw_Bool1: boolean; StrAusw_Int1, StrAusw_Int2: integer; StrAusw_Str1, StrAusw_Str2: string;
  begin
    Result:=true;
    // -> "ITEM NEW"
    If UpperCase(FullString)='ITEM NEW' then begin
      If not OA_Bool2 then begin
        OA_StringList1.Add('-> Begriff "ITEM NEW" - voriger Eintrag wurde mit keinem "ITEM DONE" abgeschloen.'+#13);
        StringAuswerten('ITEM DONE'); // Rekursiv !
      end;
      inc(Anzahl_PrjItems_Aktuell);
      Try New(PrjRec); Parent_Integer:=-1; Caption_String:=''; Aktion_Integer:=-1; PrjRec.Kommentar:=Tstringlist.Create;
      Except OA_StringList1.Add('-> Interner Fehler bei Initialisierungsversuch eines Eintrag-Records ("ITEM NEW").'+#13); end;
      OA_Bool2:=false;
    end else
    // -> "ITEM DONE"
    If UpperCase(FullString)='ITEM DONE' then begin
      If OA_Bool2 then OA_StringList1.Add('-> Syntaxfehler: Begriff "ITEM DONE", keine Assoziastion mit einem "ITEM NEW" und demzufolge mit keinen Projektdaten.'+#13)
      else begin
        PrjRec.AktionNr:=Aktion_Integer;
        PrjRec.AktionStr:=LowerCase(Aktion_String);
        If (Parent_Integer<0)or(OA_TreeNode=nil) then begin
          OA_TreeNode:=Tree.Items.AddObject(nil,Caption_String,PrjRec);
        end else begin
          OA_TreeNode:=Tree.Items.AddChildObject(Tree.Items[Parent_Integer],Caption_String,PrjRec);
        end;
        OA_Bool2:=true;
      end;
    end else
    // -> "END"
    If UpperCase(FullString)='END' then begin
      If not OA_Bool2 then StringAuswerten('ITEM DONE');
      Result:=false;
    end else begin
      StrAusw_Str1:=Extract_BefehlStr(FullString);
      StrAusw_Str2:=Extract_TextStr(FullString,StrAusw_Bool1);
      If (Length(StrAusw_Str1)>=0)and(StrAusw_Bool1) then begin
        // -> "PARENT="
        If StrAusw_Str1='Parent' then begin Val(StrAusw_Str2,StrAusw_Int1,StrAusw_Int2);
          If StrAusw_Int2=0 then Parent_Integer:=StrAusw_Int1; end else
        // -> "CAPTION="
        If StrAusw_Str1='Caption' then Caption_String:=StrAusw_Str2 else
        // -> "AKTION="
        If StrAusw_Str1='Aktion' then begin
          If Length(StrAusw_Str2)>0 then begin
            If ((StrAusw_Str2[1]='-')or(StrAusw_Str2[1]='+'))and(Length(StrAusw_Str2)>1) then
              StrAusw_Str1:=StrAusw_Str2[1]+StrAusw_Str2[2] else StrAusw_Str1:=StrAusw_Str2[1];
            Val(StrAusw_Str1,StrAusw_Int1,StrAusw_Int2);
            If StrAusw_Int2=0 then begin
              Aktion_Integer:=StrAusw_Int1;
              Delete(StrAusw_Str2,1,Length(StrAusw_Str1));
              StrAusw_Str2:=Trim(StrAusw_Str2);
              If Length(StrAusw_Str2)>0 then If StrAusw_Str2[1]=',' then Delete(StrAusw_Str2,1,1);
              If (Aktion_Integer>0)and(Aktion_Integer<6)and(Length(StrAusw_Str2)>0) then begin
                If StrAusw_Str2[1]<>'\' then StrAusw_Str2:='\'+StrAusw_Str2;
                StrAusw_Str1:=StartDir[1]+':'+StrAusw_Str2;
                If not FileExists(StrAusw_Str1) then If not DirectoryExists(StrAusw_Str1) then begin
                  OA_StringList1.Add('-> Das angegebene Aktions-Verzeichnis bzw. -Datei des Projekteintrages Nummer '+IntToStr(Anzahl_PrjItems_Aktuell)+' konnte nicht gefunden werden.'+#13+'Standardwerte (1) wurden gesetzt.'+#13);
                  Aktion_Integer:=1; StrAusw_Str2:='';
                end;
                If (Aktion_Integer=2)or(Aktion_Integer=3)or(Aktion_Integer=4) then If not FileExists(StrAusw_Str1) then begin
                  OA_StringList1.Add('-> Bei dem Projekteintrag Nummer '+IntToStr(Anzahl_PrjItems_Aktuell)+
                    ' wurde eine Dateiaktion gewhlt, jedoch keine Datei sondern lediglich ein Verzeichnis definiert.'+#13+'Dateimanager (1) wurde als Aktion gesetzt.'+#13);
                  Aktion_Integer:=1;
                end;
              end;
            end;
          end else StrAusw_Int2:=-1;
          If StrAusw_Int2<>0 then begin
            OA_StringList1.Add('-> Der Projekteintrag Nummer '+IntToStr(Anzahl_PrjItems_Aktuell)+' enthlt keinen oder einen ungltigen Aktions-Wert.'+#13+'Es wurde keine Aktion (0) gesetzt.'+#13);
            Aktion_Integer:=0;
          end;
          Aktion_String:=StrAusw_Str2;
        end else
        // -> "KOMMENTAR="
        If StrAusw_Str1='Kommentar' then PrjRec.Kommentar.Add(StrAusw_Str2);
      end;
    end;
  end;
begin
  SplashForm.ProgressBar.Position:=87; SplashForm.Update;
  Anzahl_PrjItems_Total:=0; Anzahl_PrjItems_Aktuell:=0;
  OA_StringList1:=Tstringlist.Create;
  // Projektdaten einlesen
  If IniFileComIstGeladen then begin
    // Vorbereitung
    AssignFile(OA_IniFile,IniFileCom); Reset(OA_IniFile);
    If IoResult<>0 then begin
      OA_StringList1.Add('-> Die Ini-Datei '+UpperCase(ExtractFileName(IniFileCom))+' konnte nicht geffnet werden.'+#13+'Projektdaten wurden nicht eingelesen.'+#13);
      IniFileComIstGeladen:=false;
    end else If IniFileComIstGeladen then begin
      // Anzahl der Projektzeilen
      While not Eof(OA_IniFile) do begin
        ReadLn(OA_IniFile,OA_Str1);
        OA_Str1:=UpperCase(Trim(OA_Str1));
        If OA_Str1>'' then If Extract_BefehlStr(OA_Str1)='ITEM NEW' then inc(Anzahl_PrjItems_Total);
      end;
      CloseFile(OA_IniFile); AssignFile(OA_IniFile,IniFileCom); Reset(OA_IniFile);
      If (IoResult<>0)or(Eof(OA_IniFile)) then begin
        IniFileComIstGeladen:=false;
        OA_StringList1.Add('-> Die Ini-Datei '+UpperCase(ExtractFileName(IniFileCom))+' enthlt keine Projektdaten oder konnte nicht korrekt geffnet werden.'+#13+'Projektdaten wurden nicht eingelesen.'+#13);
      end;
      // Projektdaten berprfen
      If IniFileComIstGeladen then begin
        OA_Bool1:=false;
        While (not Eof(OA_IniFile))and(not OA_Bool1) do begin
          ReadLn(OA_IniFile,OA_Str1);
          If Uppercase(Trim(OA_Str1))='BEGIN' then OA_Bool1:=true;
        end;
        If not OA_Bool1 then begin
          IniFileComIstGeladen:=false;
          OA_StringList1.Add('-> Der Begriff "BEGIN", welcher den Anfang der Projektdaten kennzeichnet, wurde nicht gefunden.'+#13+'Projektdaten wurden nicht eingelesen.'+#13);
        end else If IniFileComIstGeladen then begin
          PrjRec:=nil; OA_TreeNode:=nil; OA_Bool2:=true;
          // Anfang Projektdaten einlesen
          While (not Eof(OA_IniFile))and(OA_Bool1) do begin
            ReadLn(OA_IniFile,OA_Str1); OA_Str1:=Trim(OA_Str1);
            If Length(OA_Str1)>0 then begin
              If not StringAuswerten(OA_Str1) then OA_Bool1:=false;
          end; end;
          // Ende Projektdaten einlesen
        end;
      end;
    end;
    CloseFile(OA_IniFile);
    If (IoResult<>0)and(IniFileComIstGeladen) then
      OA_StringList1.Add('-> Die Ini-Datei '+UpperCase(ExtractFileName(IniFileCom))+' konnte nicht korrekt geschloen werden.'+#13+'Projektdaten wurden trotzdem eingelesen.'+#13);
    // Ggf. ImageIcons einlesen und entsprechend setzen
    If Tree.Images<>nil then begin
      // Images aus Resourcendatei DSM32.RES in ImageList einlesen
      ImageList.ResourceLoad(rtBitmap,'TREE_DIR1',clTeal);
      ImageList.ResourceLoad(rtBitmap,'TREE_DIR2',clTeal);
      ImageList.ResourceLoad(rtBitmap,'TREE_ITEM',clTeal);
      // ImageIcons der TreeImages entsprechend setzen
      For Int1:=0 to Tree.Items.Count-1 do begin
        If Tree.Items[Int1].GetFirstChild=nil then begin Tree.Items[Int1].ImageIndex:=2; Tree.Items[Int1].SelectedIndex:=2;
        end else begin Tree.Items[Int1].ImageIndex:=0; Tree.Items[Int1].SelectedIndex:=1; end;
      end;
    end;
    // Nachbereitung
    KommentarEdit.Modified:=false;
  end;
  SplashForm.ProgressBar.Position:=100; SplashForm.Update;
  SplashForm.Hide; SplashForm.Free;
  // Fehlerauswertung
  If OA_StringList1.Count>0 then begin
    With TMsgIniFileSyntaxErrorForm.Create(Self) do try
      LabelDateiname.Caption:=LowerCase(IniFileCom);
      ErrorMemo.Lines:=OA_StringList1;
      Label4.Caption:=IntToStr(Tree.Items.Count);
      Label5.Caption:=IntToStr(Anzahl_PrjItems_Aktuell);
      Label6.Caption:=IntToStr(Anzahl_PrjItems_Total);
      Int1:=ShowModal;
    finally Free; end;
    If Int1<>mrOk then try Free; finally Halt; end;
  end;
  OA_StringList1.Free;
  If PrjRec=nil then begin New(PrjRec); PrjRec.Kommentar:=Tstringlist.Create; end;
end;

{------------------------------------------------------------------------------------------
MainMenu-Behandlung
------------------------------------------------------------------------------------------}

// MainMenu "Projekt/Speichern" OnClick
PROCEDURE TMainForm.MainMenu_Projekt_Speichern_OnClick(Sender: TObject);
var OldActiveControl: Twincontrol;
begin
  OldActiveControl:=ActiveControl;
  ActiveControl:=Tree;
  SaveIniFile;
  Kommentar_Editiert:=false;
  ActiveControl:=OldActiveControl;
end;

// MainMenu "Projekt/Statistik" OnClick
PROCEDURE TMainForm.MainMenu_Projekt_Statistik_OnClick(Sender: TObject);
begin With TStatistikForm.Create(Self) do try ShowModal; finally Free; end; end;

// MainMenu "Projekt/Beenden" OnClick
PROCEDURE TMainForm.MainMenu_Projekt_Beenden_OnClick(Sender: TObject);
begin Close; end;

// MainMenu "Bearbeiten/Alle Verzweigungen ffnen" OnClick
PROCEDURE TMainForm.MainMenu_Bearbeiten_AlleVerzweigungenOeffnen_OnClick(Sender: TObject);
begin Tree.FullExpand; end;

// MainMenu "Bearbeiten/Alle Verzweigungen schlieen" OnClick
PROCEDURE TMainForm.MainMenu_Bearbeiten_AlleVerzweigungenSchliessen_OnClick(Sender: TObject);
begin Tree.FullCollapse; end;

// MainMenu "Bearbeiten/Eintrag hinzufgen" OnClick
PROCEDURE TMainForm.MainMenu_Bearbeiten_EintragHinzufuegen_OnClick(Sender: TObject);
begin
  ActiveControl:=Tree;
  New(PrjRec); PrjRec.Kommentar:=Tstringlist.Create; PrjRec.AktionNr:=0; PrjRec.AktionStr:='';
  Tree.Selected:=Tree.Items.InsertObject(Tree.Selected,'UNBENANNT',PrjRec);
  Tree.Selected.ImageIndex:=2; Tree.Selected.SelectedIndex:=2;
  Tree.Refresh;
  New(PrjRec); PrjRec.Kommentar:=Tstringlist.Create;
  SetEnabledDisabledState(1);
end;

// MainMenu "Bearbeiten/Untereintrag hinzufgen" OnClick
PROCEDURE TMainForm.MainMenu_Bearbeiten_UntereintragHinzufuegen_OnClick(Sender: TObject);
begin
  If Tree.Selected<>nil then begin
    ActiveControl:=Tree;
    Tree.Selected.ImageIndex:=0; Tree.Selected.SelectedIndex:=1;
    New(PrjRec); PrjRec.Kommentar:=Tstringlist.Create; PrjRec.AktionNr:=0; PrjRec.AktionStr:='';
    Tree.Selected:=Tree.Items.AddChildObject(Tree.Selected,'UNBENANNT',PrjRec);
    Tree.Selected.ImageIndex:=2; Tree.Selected.SelectedIndex:=2;
    Tree.Refresh;
    New(PrjRec); PrjRec.Kommentar:=Tstringlist.Create;
    SetEnabledDisabledState(1);
  end;
end;

// MainMenu"Bearbeiten/Eintrag verschieben nach.../Um eine Position nach oben" OnClick
PROCEDURE TMainForm.MainMenu_Bearbeiten_EintragVerschieben_Oben_OnClick(Sender: TObject);
begin
  TreeNode1:=Tree.Selected.GetPrevSibling;
  If (Tree.Selected<>nil)and(TreeNode1<>nil)and(Tree.Selected<>TreeNode1) then begin
    ActiveControl:=Tree;
    Tree.Selected.MoveTo(TreeNode1,naInsert);
    SetEnabledDisabledState(1);
    Tree_OnChange(Sender,Tree.Selected);
  end;
end;

// MainMenu"Bearbeiten/Eintrag verschieben nach.../Um eine Position nach unten" OnClick
PROCEDURE TMainForm.MainMenu_Bearbeiten_EintragVerschieben_Unten_OnClick(Sender: TObject);
begin
  TreeNode1:=Tree.Selected.GetNextSibling;
  If (Tree.Selected<>nil)and(TreeNode1<>nil)and(Tree.Selected<>TreeNode1) then begin
    ActiveControl:=Tree;
    TreeNode2:=TreeNode1.GetNextSibling;
    If TreeNode2=nil then Tree.Selected.MoveTo(TreeNode1,naAdd) else Tree.Selected.MoveTo(TreeNode2,naInsert);
    SetEnabledDisabledState(1);
    Tree_OnChange(Sender,Tree.Selected);
  end;
end;

// MainMenu"Bearbeiten/Eintrag verschieben nach.../Zum Anfang der Ebene" OnClick
PROCEDURE TMainForm.MainMenu_Bearbeiten_EintragVerschieben_Anfang_OnClick(Sender: TObject);
begin
  If Tree.Selected<>nil then begin
    ActiveControl:=Tree;
    TreeNode1:=Tree.Selected;
    Repeat TreeNode2:=TreeNode1; TreeNode1:=TreeNode1.GetPrevSibling; until TreeNode1=nil;
    If Tree.Selected<>TreeNode2 then begin
      Tree.Selected.MoveTo(TreeNode2,naAddFirst);
      SetEnabledDisabledState(1);
      Tree_OnChange(Sender,Tree.Selected);
    end;
  end;
end;

// MainMenu"Bearbeiten/Eintrag verschieben nach.../Zum Ende der Ebene" OnClick
PROCEDURE TMainForm.MainMenu_Bearbeiten_EintragVerschieben_Ende_OnClick(Sender: TObject);
begin
  If Tree.Selected<>nil then begin
    ActiveControl:=Tree;
    TreeNode1:=Tree.Selected;
    Repeat TreeNode2:=TreeNode1; TreeNode1:=TreeNode1.GetNextSibling; until TreeNode1=nil;
    If Tree.Selected<>TreeNode2 then begin
      Tree.Selected.MoveTo(TreeNode2,naAdd);
      SetEnabledDisabledState(1);
      Tree_OnChange(Sender,Tree.Selected);
    end;
  end;
end;

// MainMenu "Bearbeiten/Eintrag entfernen" OnClick
PROCEDURE TMainForm.MainMenu_Bearbeiten_EintragEntfernen_OnClick(Sender: TObject);
begin
  If Tree.Selected<>nil then begin
    ActiveControl:=Tree;
    If Tree.Selected.HasChildren then Int1:=MsgDlg(11) else Int1:=MsgDlg(10);
    If Int1=idYes then begin
      TreeNode1:=Tree.Selected.Parent;
      Tree.Selected.Delete;
      If TreeNode1<>nil then If not TreeNode1.HasChildren then begin TreeNode1.ImageIndex:=2; TreeNode1.SelectedIndex:=2; Tree.Refresh; end;
      SetEnabledDisabledState(1);
    end;
  end;
end;

// MainMenu "Bearbeiten/Untereintrge entfernen" OnClick
PROCEDURE TMainForm.MainMenu_Bearbeiten_UntereintraegeEntfernen_OnClick(Sender: TObject);
begin
  If Tree.Selected<>nil then begin
    ActiveControl:=Tree;
    If MsgDlg(12)=idYes then begin
      Tree.Selected.DeleteChildren;
      Tree.Selected.ImageIndex:=2; Tree.Selected.SelectedIndex:=2;
      Tree.Refresh;
      SetEnabledDisabledState(1);
    end;
  end;
end;

// MainMenu "Bearbeiten/Alle Eintrge entfernen" OnClick
PROCEDURE TMainForm.MainMenu_Bearbeiten_AlleEintraegeEntfernen_OnClick(Sender: TObject);
begin
  ActiveControl:=Tree;
  If MsgDlg(13)=idYes then begin
    While Tree.Items.Count>0 do Tree.Items[0].Delete;
    AktionLabel.Caption:=''; KommentarEdit.Clear;
    SetEnabledDisabledState(1);
  end;
end;

// MainMenu "Suchen/Suchen" OnClick
PROCEDURE TMainForm.MainMenu_Suchen_Suchen_OnClick(Sender: TObject);
var MMSSOC_Bool1: boolean; MMSSOC_Int1: integer;
begin
  With TSuchenForm.Create(Self) do try Int1:=ShowModal; MMSSOC_Int1:=RadioGroup_Begin.ItemIndex; finally Free; end;
  If Int1=mrOk then begin
    ActiveControl:=Tree;
    If Tree.Items.Count<1 then MsgDlg(40) else begin
      If MMSSOC_Int1=0 then TreeNode1:=Tree.Items[0] else TreeNode1:=Tree.Selected;
      If FindStringInPrj(SearchStrings[0],Search_BerCaption,Search_BerKommentar,Search_BerAktion,Search_GrossKlein) then MsgDlg(41) else MsgDlg(42);
    end;
  end;
end;

// MainMenu "Suchen/Weitersuchen" OnClick
PROCEDURE TMainForm.MainMenu_Suchen_Weitersuchen_OnClick(Sender: TObject);
begin
  If (SearchStrings.Count>0)and(Tree.Items.Count>0)and(Tree.Selected<>nil) then begin
    If Tree.Selected.GetNext=nil then begin
      If MsgDlg(43)=mrYes then MainMenu_Suchen_Suchen_OnClick(Sender);
    end else begin
      ActiveControl:=Tree;
      TreeNode1:=Tree.Selected.GetNext;
      If FindStringInPrj(SearchStrings[0],Search_BerCaption,Search_BerKommentar,Search_BerAktion,Search_GrossKlein) then MsgDlg(41) else MsgDlg(42);
    end;
  end else MainMenu_Suchen_Suchen_OnClick(Sender);
end;

// MainMenu "Exportieren/Drucken" OnClick
PROCEDURE TMainForm.MainMenu_Exportieren_Drucken_OnClick(Sender: TObject);
begin
  With TExport_PrintForm.Create(Self) do try
    CheckBox_FeldBezeichnung.Checked:=Export_BerCaption;
    CheckBox_FeldKommentar.Checked:=Export_BerKommentar;
    CheckBox_FeldAktionCom.Checked:=Export_BerAktion;
    ShowModal;
  finally Free; end;
end;

// MainMenu "Exportieren/Textdatei" OnClick
PROCEDURE TMainForm.MainMenu_Exportieren_Textdatei_OnClick(Sender: TObject);
begin
  With TExportTextForm.Create(Self) do try
    {<->}
    ShowModal;
  finally Free; end;
end;

// MainMenu "Exportieren/HTML-Dokument" OnClick
PROCEDURE TMainForm.MainMenu_Exportieren_HTMLDokument_OnClick(Sender: TObject);
begin
  With TExportHTMLForm.Create(Self) do try
    {<->}
    ShowModal;
  finally Free; end;
end;

// MainMenu "Einstellungen/Buttonpanel ausblenden" OnClick
PROCEDURE TMainForm.MainMenu_Einstellungen_ButtonpanelAusblenden_OnClick(Sender: TObject);
begin
  If MainMenu.Items[4].Items[0].Checked then begin
    ButtonPanel.Visible:=true;
    MainMenu.Items[4].Items[0].Checked:=false;
  end else begin
    ButtonPanel.Visible:=false;
    MainMenu.Items[4].Items[0].Checked:=true;
  end;
  OnResize(Sender);
end;

// MainMenu "Einstellungen/Statuszeile ausblenden" OnClick
PROCEDURE TMainForm.MainMenu_Einstellungen_StatuszeileAusblenden_OnClick(Sender: TObject);
begin
  If MainMenu.Items[4].Items[1].Checked then begin
    StatusBar.Visible:=true;
    MainMenu.Items[4].Items[1].Checked:=false;
  end else begin
    StatusBar.Visible:=false;
    MainMenu.Items[4].Items[1].Checked:=true;
  end;
  OnResize(Sender);
end;

// MainMenu "Einstellungen/Einstellungen konfigurieren" OnClick
PROCEDURE TMainForm.MainMenu_Einstellungen_EinstellungenKonfigurieren_OnClick(Sender: TObject);
begin
  With TEinstellungenForm.Create(Self) do try Int1:=ShowModal; finally Free; end;
  If Int1=mrOk then SetEnabledDisabledState(1);
end;

// MainMenu "Hilfe/Hilfethemen" OnClick
PROCEDURE TMainForm.MainMenu_Hilfe_Hilfethemen_OnClick(Sender: TObject);
begin Application.HelpContext(1); end;

// MainMenu "Hilfe/Lizenzbestimmungen" OnClick
PROCEDURE TMainForm.MainMenu_Hilfe_Lizenzbestimmungen_OnClick(Sender: TObject);
begin Application.HelpContext(666); end;

// MainMenu "Hilfe/Systeminformationen" OnClick
PROCEDURE TMainForm.MainMenu_Hilfe_Systeminformationen_OnClick(Sender: TObject);
begin With TSystemInfosForm.Create(Self) do try ShowModal; finally Free; end; end;

// MainMenu "Hilfe/Info..." OnClick
PROCEDURE TMainForm.MainMenu_Hilfe_Info_OnClick(Sender: TObject);
begin With TInformationenForm.Create(Self) do try ShowModal; finally Free; end; end;

{------------------------------------------------------------------------------------------
Tree-Behandlung
------------------------------------------------------------------------------------------}

// Aktion gem. des AktionNr & AktionStr ausfhren
PROCEDURE TMainForm.AktionAusfuehren(Sender: TObject);
begin
  If Tree.Selected<>nil then begin
    PrjRec:=Tree.Selected.Data;
    Case PrjRec.AktionNr of
      1: begin // Dateimanager starten
           Dateimanager_Str1:=PrjRec.AktionStr;
           If Length(Dateimanager_Str1)>0 then begin
             If Dateimanager_Str1[1]<>'\' then Dateimanager_Str1:='\'+Dateimanager_Str1;
             Dateimanager_Str1:=StartDir[1]+':'+Dateimanager_Str1;
             If not FileExists(Dateimanager_Str1) then If not DirectoryExists(Dateimanager_Str1) then begin
               If MsgDlg(60)=mrYes then Dateimanager_Str1:=StartDir else Exit;
             end;
           end else If MsgDlg(60)=mrYes then Dateimanager_Str1:=StartDir else Exit;
           DateimanagerForm.ShowModal;
         end;
      2: begin // Datei ausfhren, starten
           ExecuteFile(PrjRec.AktionStr,'');
         end;
      3: begin // Datei mittels UnRar entpacken
           With TUnrarForm.Create(Self) do try
             RarArchiveFileCom:=StartDir[1]+':'+PrjRec.AktionStr;
             ShowModal;
           finally Free; end;
         end;
      4: begin // Datei mittels UnZip entpacken
           Screen.Cursor:=crHourGlass; ZipArchiveCom:=StartDir[1]+':'+PrjRec.AktionStr; 
           With TUnzipForm.Create(Self) do try ShowModal; finally Free; Screen.Cursor:=crDefault; end;
         end;
      5: begin // Datei bzw. Verzeichnis mit externer Application starten
           ExecuteFile(Extern_ApplicationCom,PrjRec.AktionStr);
         end;
    end;
  end;
end;

// Tree-OnChange
PROCEDURE TMainForm.Tree_OnChange(Sender: TObject; Node: TTreeNTNode);
begin
  If Tree.Selected<>nil then begin
    PrjRec:=Tree.Selected.Data;
    // Entsprechende Aktion anzeigen in Aktionspanel
    Case PrjRec.AktionNr of
      0: AktionLabel.Caption:='Keine Aktion';
      1: AktionLabel.Caption:='Dateimanager - "'+PrjRec.AktionStr+'"';
      2: AktionLabel.Caption:='Ausfhren - "'+PrjRec.AktionStr+'"';
      3: AktionLabel.Caption:='Unrar - "'+PrjRec.AktionStr+'"';
      4: AktionLabel.Caption:='Unzip - "'+PrjRec.AktionStr+'"';
      5: AktionLabel.Caption:='Extern ("'+Extern_ApplicationName+'") - "'+PrjRec.AktionStr+'"';
    else AktionLabel.Caption:='Undefiniert';
    end;
    // Entsprechenden Kommentartext anzeigen
    If KommentarEdit.Modified then begin
      // Bei modifizierten Kommentartext Werte fr "KommentarOnExit" entspr. setzen
      Kommentar_StringList:=Tstringlist.Create;
      Kommentar_StringList.AddStrings(KommentarEdit.Lines);
      Kommentar_Editiert:=true;
    end;
    KommentarEdit.Lines:=PrjRec.Kommentar;
    KommentarEdit.Modified:=false;
    // Positionsinformationen in Statusbar zeigen
    Tree.Hint:=IntToStr(Tree.Selected.AbsoluteIndex+1)+'/'+IntToStr(Tree.Items.Count);
    StatusBar.Panels[3].Text:=IntToStr(GetProcent(Tree.Items.Count,Tree.Selected.AbsoluteIndex+1))+'%';
    // Buttons und Meneintrge entspr. Enabeln/Disabeln
    If Tree.Selected=nil then SetEnabledDisabledState(3) else begin
      SetEnabledDisabledState(4);
      If Tree.Selected.HasChildren then SetEnabledDisabledState(6) else SetEnabledDisabledState(5);
      If Tree.Selected.GetPrevSibling=nil then SetEnabledDisabledState(7) else SetEnabledDisabledState(8);
      If Tree.Selected.GetNextSibling=nil then SetEnabledDisabledState(9) else SetEnabledDisabledState(10);
    end;
  end;
end;

// Tree-OnEdited - Bei modifizierten Eintrag (umbenannt)
PROCEDURE TMainForm.Tree_OnEdited(Sender: TObject; Node: TTreeNTNode; var S: string);
begin SetEnabledDisabledState(1); end;

// Tree-OnKeyDown - Innerhalb des Tree's wurde eine Taste gedrckt.
PROCEDURE TMainForm.Tree_OnKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin If Key=13 then AktionAusfuehren(Sender); end;

// Tree-OnMouseDown
PROCEDURE TMainForm.Tree_OnMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  TreeNode1:=Tree.GetNodeAt(X,Y);
  If TreeNode1<>nil then begin
    Tree.Selected:=TreeNode1;
    If Button=mbRight then begin
      If Tree.Selected.GetPrevSibling=nil then SetEnabledDisabledState(11) else SetEnabledDisabledState(12);
      If Tree.Selected.GetNextSibling=nil then SetEnabledDisabledState(13) else SetEnabledDisabledState(14);
      PopupMenu_Tree.Popup(Left+X+6,Top+Y+78);
    end;
  end;
end;

// Tree-OnDragOver - Drag N' Drop innerhalb des Tree's zulassen
PROCEDURE TMainForm.Tree_OnDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept:=true;
  TreeNode2:=Tree.GetNodeAt(X,Y);
  If TreeNode2<>nil then Tree.Selected:=TreeNode2;
end;

// Tree-OnDragDrop - Ein mittels Drag N' Drop abgelegtes Element (PopupMenu_DragDrop aufrufen)
PROCEDURE TMainForm.Tree_OnDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  TreeNode2:=Tree.Selected;
  If (TreeNode1<>TreeNode2)and(TreeNode1<>nil)and(TreeNode2<>nil) then PopupMenu_DragDrop.Popup(Left+X+6,Top+Y+78);
end;

// Tree-DragDrop-PopupMenu "Hierher kopieren" OnClick
PROCEDURE TMainForm.PopupMenu_DragDrop_HierherKopieren_OnClick(Sender: TObject);
var PMDDHK_StringList: Tstringlist;
begin
  PrjRec:=TreeNode1.Data;
  PMDDHK_StringList:=Tstringlist.Create;
  PMDDHK_StringList.AddStrings(PrjRec.Kommentar);
  New(PrjRec); PrjRec.Kommentar:=Tstringlist.Create;
  PrjRec.Kommentar.AddStrings(PMDDHK_StringList);
  PMDDHK_StringList.Free;
  TreeNode2:=Tree.Items.InsertObject(TreeNode2,TreeNode1.Text,PrjRec);
  TreeNode2.ImageIndex:=TreeNode1.ImageIndex;
  TreeNode2.SelectedIndex:=TreeNode1.SelectedIndex;
  Tree.Selected:=TreeNode2;
  New(PrjRec); PrjRec.Kommentar:=Tstringlist.Create;
  SetEnabledDisabledState(1);
end;

// Tree-DragDrop-PopupMenu "Hierher verschieben" OnClick
PROCEDURE TMainForm.PopupMenu_DragDrop_HierherVerschieben_OnClick(Sender: TObject);
begin
  TreeNode1.MoveTo(TreeNode2,naInsert);
  Tree.Selected:=TreeNode1;
  SetEnabledDisabledState(1);
end;

{------------------------------------------------------------------------------------------
Kommentar-Behanlung
------------------------------------------------------------------------------------------}

//  KommentarEdit OnChange - Informationen ber Kommentartext in Statuszeile anzeigen
PROCEDURE TMainForm.KommentarEdit_OnChange(Sender: TObject);
var KEOC_Int1: integer;
begin
  Int1:=0;
  For KEOC_Int1:=0 to KommentarEdit.Lines.Count-1 do inc(Int1,Length(KommentarEdit.Lines[KEOC_Int1]));
  KommentarEdit.Hint:='Zeilenanzahl: '+IntToStr(KommentarEdit.Lines.Count)+'   Zeichenanzahl: '+IntToStr(Int1);
end;

// KommentarEdit OnEnter (bei auswhlen des Kommentarfeldes)
PROCEDURE TMainForm.KommentarEdit_OnEnter(Sender: TObject);
begin
  KommentarEdit.Modified:=false;
  TreeNode3:=Tree.Selected;
end;

// KommentarEdit OnExit (bei verlassen des Kommentarfeldes), vorher wird ggf. "Tree_OnChange" ausgefhrt
PROCEDURE TMainForm.KommentarEdit_OnExit(Sender: TObject);
begin
  If ((Kommentar_Editiert)or(KommentarEdit.Modified))and(TreeNode3<>nil) then begin
    PrjRec:=TreeNode3.Data; PrjRec.Kommentar.Clear;
    If Kommentar_Editiert then begin
      PrjRec.Kommentar.AddStrings(Kommentar_StringList);
      Kommentar_StringList.Free;
    end else PrjRec.Kommentar.AddStrings(KommentarEdit.Lines);
    TreeNode3.Data:=PrjRec;
    New(PrjRec); PrjRec.Kommentar:=Tstringlist.Create;
    SetEnabledDisabledState(1);
  end;
  KommentarEdit.Modified:=false; Kommentar_Editiert:=false;
end;

// PopupMenu_Kommentar "Ausschneiden" OnClick
PROCEDURE TMainForm.PopupMenu_Kommentar_Ausschneiden_OnClick(Sender: TObject);
begin KommentarEdit.CutToClipboard; end;

// PopupMenu_Kommentar "Kopieren" OnClick
PROCEDURE TMainForm.PopupMenu_Kommentar_Kopieren_OnClick(Sender: TObject);
begin KommentarEdit.CopyToClipboard; end;

// PopupMenu_Kommentar "Einfgen" OnClick
PROCEDURE TMainForm.PopupMenu_Kommentar_Einfuegen_OnClick(Sender: TObject);
begin KommentarEdit.PasteFromClipboard; end;

// PopupMenu_Kommentar "Lschen" OnClick
PROCEDURE TMainForm.PopupMenu_Kommentar_Loeschen_OnClick(Sender: TObject);
begin KommentarEdit.ClearSelection; end;

// PopupMenu_Kommentar "Alles Markieren" OnClick
PROCEDURE TMainForm.PopupMenu_Kommentar_AllesMarkieren_OnClick(Sender: TObject);
begin KommentarEdit.SelectAll; end;

// PopupMenu_Kommentar OnPopup
PROCEDURE TMainForm.PopupMenu_Kommentar_OnPopup(Sender: TObject);
begin
  If KommentarEdit.SelLength>0 then begin
    PopupMenu_Kommentar_Ausschneiden.Enabled:=true;
    PopupMenu_Kommentar_Kopieren.Enabled:=true;
    PopupMenu_Kommentar_Loeschen.Enabled:=true;
  end else begin
    PopupMenu_Kommentar_Ausschneiden.Enabled:=false;
    PopupMenu_Kommentar_Kopieren.Enabled:=false;
    PopupMenu_Kommentar_Loeschen.Enabled:=false;
  end;
end;

{------------------------------------------------------------------------------------------
Aktion-Behandlung
------------------------------------------------------------------------------------------}

// Aktion-Button "Verknpfte Aktion bearbeiten" OnClick
PROCEDURE TMainForm.AktionButton_Bearbeiten_OnClick(Sender: TObject);
begin
  If Tree.Selected<>nil then With TAktionEditForm.Create(Self) do try
    If ShowModal=idOk then SetEnabledDisabledState(1);
  finally Free; end;
end;

{------------------------------------------------------------------------------------------
StatusBar-Behandlung
------------------------------------------------------------------------------------------}

// StatusBar OnMouseMove
PROCEDURE TMainForm.StatusBar_OnMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin StatusBar.Hint:=FormatDateTime('dddd"," dd". "mmmm" "yyyy',Date); end;

{------------------------------------------------------------------------------------------
Private-Deklataionen
------------------------------------------------------------------------------------------}

// Enabled/Disabled-Status der Bedienelemente setzen
PROCEDURE TMainForm.SetEnabledDisabledState(SetNr: integer);
begin
  Case SetNr of
    0: begin
         MainMenu.Items[5].Items[0].Enabled:=true;
         MainMenu.Items[5].Items[1].Enabled:=true;
         PanelButton_Help.Enabled:=true;
       end;
    1: If not MainMenu.Items[0].Items[0].Enabled then begin
         MainMenu.Items[0].Items[0].Enabled:=true;
         PanelButton_Save.Enabled:=true;
       end;
    2: If MainMenu.Items[0].Items[0].Enabled then begin
         MainMenu.Items[0].Items[0].Enabled:=false;
         PanelButton_Save.Enabled:=false;
       end;
    3: If MainMenu.Items[1].Items[3].Enabled then begin
         MainMenu.Items[1].Items[3].Enabled:=false;
         MainMenu.Items[1].Items[4].Enabled:=false;
         MainMenu.Items[1].Items[6].Items[0].Enabled:=false;
         MainMenu.Items[1].Items[6].Items[1].Enabled:=false;
         MainMenu.Items[1].Items[6].Items[3].Enabled:=false;
         MainMenu.Items[1].Items[6].Items[4].Enabled:=false;
         MainMenu.Items[1].Items[8].Enabled:=false;
         MainMenu.Items[1].Items[9].Enabled:=false;
         PanelButton_EintragHinzufuegen.Enabled:=false;
         PanelButton_UntereintragHinzufuegen.Enabled:=false;
         PanelButton_VerschiebenAnfang.Enabled:=false;
         PanelButton_VerschiebenEnde.Enabled:=false;
         PanelButton_VerschiebenOben.Enabled:=false;
         PanelButton_VerschiebenUnten.Enabled:=false;
         PanelButton_EintragEntfernen.Enabled:=false;
       end;
    4: If not MainMenu.Items[1].Items[3].Enabled then begin
         MainMenu.Items[1].Items[3].Enabled:=true;
         MainMenu.Items[1].Items[4].Enabled:=true;
         MainMenu.Items[1].Items[8].Enabled:=true;
         PanelButton_EintragHinzufuegen.Enabled:=true;
         PanelButton_UntereintragHinzufuegen.Enabled:=true;
         PanelButton_EintragEntfernen.Enabled:=true;
       end;
    5: If MainMenu.Items[1].Items[9].Enabled then MainMenu.Items[1].Items[9].Enabled:=true;
    6: If not MainMenu.Items[1].Items[9].Enabled then MainMenu.Items[1].Items[9].Enabled:=false;
    7: If MainMenu.Items[1].Items[6].Items[0].Enabled then begin
         MainMenu.Items[1].Items[6].Items[0].Enabled:=false;
         MainMenu.Items[1].Items[6].Items[3].Enabled:=false;
         PanelButton_VerschiebenAnfang.Enabled:=false;
         PanelButton_VerschiebenOben.Enabled:=false;
       end;
    8: If not MainMenu.Items[1].Items[6].Items[0].Enabled then begin
         MainMenu.Items[1].Items[6].Items[0].Enabled:=true;
         MainMenu.Items[1].Items[6].Items[3].Enabled:=true;
         PanelButton_VerschiebenAnfang.Enabled:=true;
         PanelButton_VerschiebenOben.Enabled:=true;
       end;
    9: If MainMenu.Items[1].Items[6].Items[1].Enabled then begin
         MainMenu.Items[1].Items[6].Items[1].Enabled:=false;
         MainMenu.Items[1].Items[6].Items[4].Enabled:=false;
         PanelButton_VerschiebenEnde.Enabled:=false;
         PanelButton_VerschiebenUnten.Enabled:=false;
       end;
    10:If not MainMenu.Items[1].Items[6].Items[1].Enabled then begin
         MainMenu.Items[1].Items[6].Items[1].Enabled:=true;
         MainMenu.Items[1].Items[6].Items[4].Enabled:=true;
         PanelButton_VerschiebenEnde.Enabled:=true;
         PanelButton_VerschiebenUnten.Enabled:=true;
       end;
    11:If PopupMenu_Tree.Items[5].Items[0].Enabled then begin
         PopupMenu_Tree.Items[5].Items[0].Enabled:=false;
         PopupMenu_Tree.Items[5].Items[3].Enabled:=false;
       end;
    12:If not PopupMenu_Tree.Items[5].Items[0].Enabled then begin
         PopupMenu_Tree.Items[5].Items[0].Enabled:=true;
         PopupMenu_Tree.Items[5].Items[3].Enabled:=true;
       end;
    13:If PopupMenu_Tree.Items[5].Items[1].Enabled then begin
         PopupMenu_Tree.Items[5].Items[1].Enabled:=false;
         PopupMenu_Tree.Items[5].Items[4].Enabled:=false;
       end;
    14:If not PopupMenu_Tree.Items[5].Items[1].Enabled then begin
         PopupMenu_Tree.Items[5].Items[1].Enabled:=true;
         PopupMenu_Tree.Items[5].Items[4].Enabled:=true;
       end;
  end;
end;

// Ini-Datei speichern, bei Erfolg Result=true ansonsten Result=false
FUNCTION TMainForm.SaveIniFile: boolean;
var SIF_Int1, SIF_Int2: integer; SIF_Str1: string; SIF_IniFile: textfile;
begin
  // Vorarbeit
  Result:=true;
  If not FileExists(IniFileCom) then begin
    If MsgDlg(1)=idYes then IniFileCom:=StartDir+'DSM32.ini' else Result:=false;
  end;
  If Result then begin
    ProgressBar.Position:=0; StatusBar.SimplePanel:=true; ProgressBar.Visible:=true;
    // Ini-Datei ffnen
    AssignFile(SIF_IniFile,IniFileCom); Rewrite(SIF_IniFile);
    If IoResult<>0 then begin MsgDlg(2); Result:=false; end;
    If Result then begin
      ProgressBar.Position:=20; ProgressBar.Refresh;
      // Einstellungen schreiben
      WriteLn(SIF_IniFile,IniFileCom_PruefString);
      WriteLn(SIF_IniFile);
      // -> [Fenster]
      WriteLn(SIF_IniFile,'[Fenster]');
      WriteLn(SIF_IniFile,'Titel='+Fenster_Titel);
      WriteLn(SIF_IniFile,'Breite='+IntToStr(Fenster_Breite));
      WriteLn(SIF_IniFile,'Hoehe='+IntToStr(Fenster_Hoehe));
        If Fenster_ZentriertPositionieren then SIF_Int1:=1 else SIF_Int1:=0;
      WriteLn(SIF_IniFile,'Zentriert positionieren='+IntToStr(SIF_Int1));
      WriteLn(SIF_IniFile,'Status='+IntToStr(Fenster_Status));
      WriteLn(SIF_IniFile,'Kommentarfeldhoehe='+IntToStr(Fenster_KommentarfeldHoehe));
      WriteLn(SIF_IniFile);
      // -> [Exportieren]
      WriteLn(SIF_IniFile,'[Exportieren]');
        If Export_BerCaption then SIF_Int1:=1 else SIF_Int1:=0;
      WriteLn(SIF_IniFile,'Feldbereich Bezeichnung='+IntToStr(SIF_Int1));
        If Export_BerKommentar then SIF_Int1:=1 else SIF_Int1:=0;
      WriteLn(SIF_IniFile,'Feldbereich Kommentar='+IntToStr(SIF_Int1));
        If Export_BerAktion then SIF_Int1:=1 else SIF_Int1:=0;
      WriteLn(SIF_IniFile,'Feldbereich Aktion='+IntToStr(SIF_Int1));
      WriteLn(SIF_IniFile,'Feldbereich Trennzeichen="'+Export_BerCaption_Trennzeichen+','+Export_BerKommentar_Trennzeichen+','+Export_BerAktion_Trennzeichen+'"');
      WriteLn(SIF_IniFile);
      // -> [Extern]
      WriteLn(SIF_IniFile,'[Extern]');
      SIF_Str1:=HlpFileCom;
      If FileExists(ExtractFilePath(ParamStr(0))+ExtractFileName(SIF_Str1)) then SIF_Str1:=ExtractFileName(SIF_Str1)
      else If SIF_Str1>'' then If not ExtractRelativCom(SIF_Str1) then SIF_Str1:=ExtractFileName(HlpFileCom);
      WriteLn(SIF_IniFile,'Hilfedatei='+SIF_Str1);
      WriteLn(SIF_IniFile,'Aktionsprogramm Name='+Extern_ApplicationName);
      WriteLn(SIF_IniFile,'Aktionsprogramm Com='+Extern_ApplicationCom);
      WriteLn(SIF_IniFile);
      ProgressBar.Position:=40; ProgressBar.Refresh;
      // -> [Projekt]
      WriteLn(SIF_IniFile,'[Projekt]');
        If MainForm.Tree.Images=nil then SIF_Int1:=0 else SIF_Int1:=1;
      WriteLn(SIF_IniFile,'ImageIcons nutzen='+IntToStr(SIF_Int1));
        If MainForm.Tree.Options=[toFullRowSelect,toHotTrack,toInfoTip,toShowButtons,toShowLines,toShowRoot] then begin SIF_Int1:=1; SIF_Int2:=0; end else
        If MainForm.Tree.Options=[toFullRowSelect,toHotTrack,toToolTips,toShowButtons,toShowLines,toShowRoot] then begin SIF_Int1:=0; SIF_Int2:=1 end else
        If MainForm.Tree.Options=[toFullRowSelect,toHotTrack,toShowButtons,toShowLines,toShowRoot] then begin SIF_Int1:=0; SIF_Int2:=0; end else begin SIF_Int1:=1; SIF_Int2:=1; end;
      WriteLn(SIF_IniFile,'InfoTips verwenden='+IntToStr(SIF_Int1));
      WriteLn(SIF_IniFile,'ToolTips verwenden='+IntToStr(SIF_Int2));
      WriteLn(SIF_IniFile);
      // Projektdaten schreiben
      WriteLn(SIF_IniFile,'BEGIN');
      ProgressBar.Position:=60; ProgressBar.Refresh;
      For SIF_Int1:=0 to MainForm.Tree.Items.Count-1 do begin
        TreeNode1:=MainForm.Tree.Items[SIF_Int1];
        If TreeNode1<>nil then begin
          PrjRec:=TreeNode1.Data;
          WriteLn(SIF_IniFile,'  Item New');
          WriteLn(SIF_IniFile,'    Nr='+IntToStr(SIF_Int1));
          TreeNode2:=TreeNode1.Parent;
          If TreeNode2=nil then SIF_Int2:=-1 else SIF_Int2:=TreeNode2.AbsoluteIndex;
          WriteLn(SIF_IniFile,'    Parent='+IntToStr(SIF_Int2));
          WriteLn(SIF_IniFile,'    Caption='+TreeNode1.Text);
          If PrjRec=nil then begin SIF_Int2:=0; SIF_Str1:=''; end else begin SIF_Int2:=PrjRec.AktionNr; SIF_Str1:=PrjRec.AktionStr; end;
          If Length(SIF_Str1)>0 then SIF_Str1:=','+SIF_Str1;
          WriteLn(SIF_IniFile,'    Aktion='+IntToStr(SIF_Int2)+SIF_Str1);
          If PrjRec<>nil then If PrjRec.Kommentar<>nil then
            For SIF_Int2:=0 to PrjRec.Kommentar.Count-1 do WriteLn(SIF_IniFile,'    Kommentar='+PrjRec.Kommentar.Strings[SIF_Int2]);
          WriteLn(SIF_IniFile,'  Item Done');
        end;
      end;
      ProgressBar.Position:=90; ProgressBar.Refresh;
      WriteLn(SIF_IniFile,'END'); WriteLn(SIF_IniFile);
      SetEnabledDisabledState(2);
    end;
    // Nacharbeit
    CloseFile(SIF_IniFile);
    ProgressBar.Position:=100; ProgressBar.Refresh; ProgressBar.Visible:=false; StatusBar.SimplePanel:=false;
  end;
end;

// String innerhalb der Projektdaten suchen und wenn gefunden dann Result=TRUE, ansonsten Result=FALSE
// Es sollte TreeNode1 als Anfangsposition zum Suchen bergeben werden (Wichtig!)
FUNCTION TMainForm.FindStringInPrj(FindString: string; BerCaption, BerKommentar, BerAktion, GrossKleinBeachten: boolean): boolean;
var FSIP_Bool1: boolean; FSIP_Str1: string;
  // Innerhalb der Bezeichnung bzw. des Aktionsfeldes suchen
  function SearchBerCaptionAktion(FullString: string): boolean;
  begin
    If GrossKleinBeachten then FullString:=UpperCase(FullString);
    If Pos(FindString,FullString)>0 then Result:=true else Result:=false;
  end;
  // Innerhalb des Kommentarfeldes suchen
  function SearchBerKommentar: boolean;
  var FSIPSBK_Int1: integer;
  begin
    FSIPSBK_Int1:=0; Result:=false;
    While (PrjRec.Kommentar.Count>=FSIPSBK_Int1+1)and(not Result) do begin
      FSIP_Str1:=PrjRec.Kommentar[FSIPSBK_Int1];
      If GrossKleinBeachten then FSIP_Str1:=UpperCase(FSIP_Str1);
      If Pos(FindString,FSIP_Str1)>0 then Result:=true;
      inc(FSIPSBK_Int1);
    end;
  end;
begin
  FSIP_Bool1:=true;
  If GrossKleinBeachten then FindString:=UpperCase(FindString);
  While FSIP_Bool1 do begin
    PrjRec:=TreeNode1.Data;
    If BerCaption then If SearchBerCaptionAktion(TreeNode1.Text) then FSIP_Bool1:=false;
    If (BerKommentar)and(FSIP_Bool1) then If SearchBerKommentar then FSIP_Bool1:=false;
    If (BerAktion)and(FSIP_Bool1) then If SearchBerCaptionAktion(PrjRec.AktionStr) then FSIP_Bool1:=false;
    If not FSIP_Bool1 then begin Tree.Selected:=TreeNode1; Result:=true; end else
    If TreeNode1.GetNext=nil then begin Tree.Selected:=TreeNode1; FSIP_Bool1:=false; Result:=false; end else TreeNode1:=TreeNode1.GetNext;
  end;
end;

{------------------------------------------------------------------------------------------
Public-Deklataionen
------------------------------------------------------------------------------------------}

// Anzeige der Hint-Kurzhinweise in der Statuszeile
PROCEDURE TMainForm.ShowHints(Sender: TObject);
begin StatusBar.Panels[0].Text:=Application.Hint; end;

// Mauskoordinaten in der Statuszeile zeigen
PROCEDURE TMainForm.ShowMouseXYPos(var Msg: TMsg; var Handled: boolean);
begin StatusBar.Panels[2].Text:=IntToStr(Msg.pt.x)+':'+IntToStr(Msg.pt.y); end;

// Sorgt fr die schnelle Darstellung von einfachen Meldungsfenstern
FUNCTION TMainForm.MsgDlg(MsgNr: integer): integer;
begin Int1:=MsgNr; Result:=MsgBoxForm.ShowModal; end;

END.
