{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# GLOBALS.PAS                                                                            #
# Globale Deklarationen, innerhalb aller Units gltig                                    #
#########################################################################################}

UNIT Globals;

INTERFACE

Uses Windows, Forms, SysUtils, Classes, ComCtrls, FileCtrl, ShellAPI;

Const DSM32_Version                            = '3.00.36 Alpha'; // DSM32-Version
      IniFileCom: string                       = 'DSM32.ini'; // Ini-Datei
      IniFileCom_PruefString                   = '<Dipesh-SoftwareManager-32 Version 3.xx Ini-Datei>'; // Ini-Datei Prf-String
      HlpFileCom: string                       = 'DSM32.hlp'; // Hilfe-Datei
      Fenster_Titel: string                    = ''; // Titel, erscheint in MainForm.Caption
      Fenster_Breite: integer                  = -1; // Width der MainForm beim Start
      Fenster_Hoehe: integer                   = -1; // Height der MainForm beim Start
      Fenster_ZentriertPositionieren: boolean  = true; // Position der MainForm beim Start
      Fenster_Status: byte                     = 0; // WinState der MainForm beim Start
      Fenster_KommentarfeldHoehe: integer      = -1; // Height des KommentarEdit der MainForm
      Extern_ApplicationName: string           = 'Windows-Explorer'; // Name der externen Application
      Extern_ApplicationCom: string            = 'explorer.exe'; // Befehlszeile der externen Application
      Search_BerCaption: boolean               = true; // Im Feldbereich "Bezeichnung" suchen
      Search_BerKommentar: boolean             = true; // Im Feldbereich "Kommentar" suchen
      Search_BerAktion: boolean                = true; // Im Feldbereich "Aktionsstring" suchen
      Search_GrossKlein: boolean               = true; // Gro- und Kleinschreibung bei der Suche beachten
      Export_BerCaption: boolean               = true; // Feldbereich "Bezeichnung" exportieren
      Export_BerKommentar: boolean             = false; // Feldbereich "Kommentar" exportieren
      Export_BerAktion: boolean                = false; // Feldbereich "Aktion" exportieren
      Export_BerCaption_Trennzeichen: string   = '  '; // Trennzeichen des Feldbereiches "Bezeichnung"
      Export_BerKommentar_Trennzeichen: string = ' T> '; // Trennzeichen des Feldbereiches "Kommentar"
      Export_BerAktion_Trennzeichen: string    = ' A> '; // Trennzeichen des Feldbereiches "Aktionsstring"
      Dateimanager_ShowIcon: tviewstyle        = vsList; // ViewStyle der FileList der DateimanagerForm
      
Type PPrjData = ^PrjData; PrjData = record
       AktionNr: byte;
       AktionStr: string;
       Kommentar: tstringlist;
     end;

Var IniFileComIstGeladen: boolean;
    StartDir: string;
    PrjRec: PPrjData;

Function GetProcent(BigInt, SmallInt: integer): integer;
Function ExpandFileCom(var FileCom: string): boolean;
Function ExtractRelativCom(var FileComPath: string): boolean;
Function IsGueltigeDSM32IniDatei(FileCom: string): boolean;
Function GetZeilenAnzahlOfTextFile(FileCom: string): longint;
Function GetFileAttr(FileCom: string): integer;
Function GetFileSizeInByte(FileCom: string): longint;
Function FormatInteger(FormatInt: longint): string;
Function FormatBytesInteger(FormatInt: longint): string;
Procedure ExecuteFile(ComToExecute,Parameter: string);
Function XMkDir(MkDirString: string): boolean;
Procedure DelTree(stDirectory: string);

IMPLEMENTATION

// Liefert das prozentuale Verhltnis zwischen beiden bergebenen Variablen zurck
FUNCTION GetProcent(BigInt, SmallInt: integer): integer;
var ExtReal1, ExtReal2: extended;
begin
  Try ExtReal1:=BigInt; ExtReal2:=SmallInt; Result:=Round((ExtReal2 * 100) / ExtReal1);
  Except Result:=0; end;
end;

// Expandiert einen relative angegebenen Dateinamen und desen Verzeichnis
FUNCTION ExpandFileCom(var FileCom: string): boolean;
begin
  If FileCom>'' then begin Result:=true;
    If FileExists(FileCom) then FileCom:=ExpandFileName(FileCom) else begin
      If FileCom[1]='\' then Delete(FileCom,1,1);
      If FileExists(StartDir+FileCom) then FileCom:=StartDir+FileCom else
      If FileExists(StartDir[1]+':\'+FileCom) then FileCom:=StartDir[1]+':\'+FileCom else
      If FileExists(StartDir+ExtractFileName(FileCom)) then FileCom:=StartDir+ExtractFileName(FileCom) else
      If FileExists(StartDir[1]+':\'+ExtractFileName(FileCom)) then FileCom:=StartDir[1]+':\'+ExtractFileName(FileCom) else Result:=false;
    end;
  end else Result:=false;
end;

// Liefert das relativen Verzeichnis/Datei eines vollangegebenen Strings
FUNCTION ExtractRelativCom(var FileComPath: string): boolean;
var ERFCP_Str1: string;
begin
  Result:=false;
  If Length(FileComPath)>3 then begin
    FileComPath:=LowerCase(FileComPath);
    If (StartDir[1]=FileComPath[1])and(StartDir[2]=FileComPath[2])and(StartDir[3]=FileComPath[3]) then begin
      If Length(FileComPath)>Length(StartDir) then begin
        ERFCP_Str1:=FileComPath;
        Delete(ERFCP_Str1,1,Length(StartDir));
        If ERFCP_Str1[1]='\' then Delete(ERFCP_Str1,1,1);
        If (FileExists(StartDir+ERFCP_Str1))or(DirectoryExists(StartDir+ERFCP_Str1)) then
          FileComPath:=ERFCP_Str1 else Delete(FileComPath,1,3);
      end else Delete(FileComPath,1,3);
      Result:=true;
    end;
  end;
end;

// berprft ob die angegebene Datei eine gltige DSM32 Ini-Datei ist
FUNCTION IsGueltigeDSM32IniDatei(FileCom: string): boolean;
var IGDID_Str1: string; IGDID_File: textfile;
begin
  Result:=false; AssignFile(IGDID_File,FileCom); Reset(IGDID_File);
  If IoResult=0 then begin
    While (not Eof(IGDID_File))and(not Result) do begin  ReadLn(IGDID_File,IGDID_Str1);
      If UpperCase(IGDID_Str1)=UpperCase(IniFileCom_PruefString) then Result:=true;
  end; end; CloseFile(IGDID_File);
end;

// Liefert die Anzahlen der Zeilen einer Textdatei zurck, liefert Result=-1 bei Fehler zurck
FUNCTION GetZeilenAnzahlOfTextFile(FileCom: string): longint;
var GZAOTF_LongInt: longint; GZAOTF_TextFile: textfile;
begin
  GZAOTF_LongInt:=0; Assign(GZAOTF_TextFile,FileCom); Reset(GZAOTF_TextFile);
  If IoResult=0 then begin While not Eof(GZAOTF_TextFile) do begin ReadLn(GZAOTF_TextFile); inc(GZAOTF_LongInt); end; end else Result:=-1;
  CloseFile(GZAOTF_TextFile); Result:=GZAOTF_LongInt;
end;

// Liefert die Dateiattribute einer Datei zurck, liefert Result=-1 bei Fehler zurck
FUNCTION GetFileAttr(FileCom: string): integer;
var GFA_TSR: TSearchRec;
begin
  If FindFirst(FileCom,faAnyFile,GFA_TSR)=0 then Result:=GFA_TSR.Attr else Result:=-1; FindClose(GFA_TSR);
end;

// Liefert die Gre einer Datei in Bytes zurck
FUNCTION GetFileSizeInByte(FileCom: string): longint;
var GFS_TSR: TSearchRec;
begin
  If FindFirst(FileCom,faAnyFile,GFS_TSR)=0 then Result:=GFS_TSR.Size else Result:=-1;
  FindClose(GFS_TSR);
end;

// Umwandlung eines Integerwertes in einen formatierten String (z.B. 12345678 zu 12.345.678)
FUNCTION FormatInteger(FormatInt: longint): string;
var FI_LongInt1: longint;
begin
  Result:=IntToStr(FormatInt); FI_LongInt1:=3;
  While Length(Result)>FI_LongInt1 do begin Insert('.',Result,Length(Result)-FI_LongInt1+1); inc(FI_LongInt1,4); end;
end;

// Wandelt einen Bytes-Angabe entsprechend in KB bzw. MB Angabe um
FUNCTION FormatBytesInteger(FormatInt: longint): string;
begin
  Case FormatInt of
    0..1023: Result:=FormatInteger(FormatInt)+' Bytes';
    1024..1048575: Result:=FormatInteger(FormatInt div 1024)+' KB';
    else Result:=FormatInteger(FormatInt div 1048576)+' MB';
  end;
end;

// Angegebene Datei ausfhren
PROCEDURE ExecuteFile(ComToExecute,Parameter: string);
var Open_Result: integer; zFileName, zParams, zDir: array[0..150] of Char;
begin
  StrPCopy(zFileName,ExtractFileName(ComToExecute)); StrPCopy(zParams,Parameter); StrPCopy(zDir,ExtractFilePath(ComToExecute));
  Try Open_Result:=ShellExecute(Application.MainForm.Handle,nil,zFileName,zParams,zDir,SW_SHOWNORMAL);
  Finally Case Open_Result of
    0: zFileName:='Nicht gengend freier Speicher bzw. freie Resourcen.';
    ERROR_FILE_NOT_FOUND: zFileName:='Datei konnte nicht gefunden werden.';
    ERROR_PATH_NOT_FOUND: zFileName:='Verzeichnis konnte nicht gefunden werden.';
    ERROR_BAD_FORMAT: zFileName:='Die EXE-Datei ist fehlerhaft oder ungltig.';
    SE_ERR_ACCESSDENIED: zFileName:='Das Betriebssystem hat keinen Zugriff auf die spezifizierte Datei.';
    SE_ERR_ASSOCINCOMPLETE: zFileName:='Der angegebene Dateiname ist ungltig oder unkomplet.';
    SE_ERR_DDEBUSY: zFileName:='DDE-Konversation schlug fehl, da z.Z. eine andere DDE-Transaktion aktiv ist.';
    SE_ERR_DDEFAIL: zFileName:='DDE-Konversation schlug fehl.';
    SE_ERR_DDETIMEOUT: zFileName:='DDE-Konversation schlug fehl, da zugestandene Zeit berschritten wurde.';
    SE_ERR_DLLNOTFOUND: zFileName:='Die spezifizierte Dynamik-Link-Library konnte nicht gefunden werden.';
    SE_ERR_NOASSOC: zFileName:='Dieser Dateierweiterung ist kein Programm zugeordnet.';
    SE_ERR_OOM: zFileName:='Nicht gengend freier Speicher um die Operation durchzufhren.';
    SE_ERR_SHARE: zFileName:='Unbekannter Fehler. Aktion konnte nicht Durchgefhrt werden.';
    else begin zFileName:=''; end;
  end; end;
  If zFileName>'' then MessageBox(0,zFileName,'Fehler:',MB_Ok+MB_IconStop+MB_ApplModal+MB_SetForeground);
end;

// Verzeichnis erstellen (nicht blo Unterverzeichnis wie bei dem MkDir-Vorbild)
FUNCTION XMkDir(MkDirString: string): boolean;
var MkDir_Pos, MkDir_Int: integer; MkDir_Str1, MkDir_Str2: string;
begin
  Result:=false; MkDir_Str1:=''; MkDir_Int:=0;
  Repeat Inc(MkDir_Int,1); MkDir_Str2:=Copy(MkDirString,MkDir_Int,1);
    If MkDir_Str2='\' then begin {$I-} MkDir(MkDir_Str1); {$I+} end;
    MkDir_Str1:=MkDir_Str1+MkDir_Str2;
  until MkDir_Str1=MkDirString;
  {$I-} MkDir(MkDirString); {$I+} If DirectoryExists(ExtractFilePath(MkDirString)) then Result:=true;
end;

// Verzeichnis inklusive aller Unterverzeichnisse lschen
PROCEDURE DelTree(stDirectory: string);
var inResult: integer; FileSearch: tsearchrec;
begin
  If DirectoryExists(stDirectory) then begin
    inResult:=FindFirst(stDirectory+'\*.*',faReadOnly OR faHidden OR faSysFile OR faDirectory OR faAnyFile,FileSearch);
    While inResult=0 do begin
      If (faDirectory AND FileSearch.Attr)=FileSearch.Attr then begin
        If not (FileSearch.Name[1]='.') then DelTree(stDirectory+'\'+FileSearch.Name); // Rekursiv !
      end else DeleteFile(stDirectory+'\'+FileSearch.Name);
      inResult:=FindNext(FileSearch);
    end;
    FindClose(FileSearch); RmDir(stDirectory);
  end;
end;

END.
