{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# EXPORTPRINT_EDIT.PAS - TExportPrint_EditForm                                           #
# Projektdaten ausdrucken - Text bearbeiten                                              #
#########################################################################################}

UNIT ExportPrint_Edit;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     StdCtrls, ComCtrls, Menus, Buttons, Main;

Type
  TExportPrint_EditForm = class(TGradientForm)
    Memo: TRichEdit;
    PopupMenu: TPopupMenu;
    Button_Uebernehmen: TBitBtn;
    Button_Abbrechen: TBitBtn;
    Button_Hilfe: TBitBtn;
    PopupMenu_Ausschneiden: TMenuItem;
    PopupMenu_Kopieren: TMenuItem;
    PopupMenu_Einfuegen: TMenuItem;
    PopupMenu_Loeschen: TMenuItem;
    PopupMenu_N1: TMenuItem;
    PopupMenu_AllesMarkieren: TMenuItem;
    procedure PopupMenu_Ausschneiden_OnClick(Sender: TObject);
    procedure PopupMenu_Kopieren_OnClick(Sender: TObject);
    procedure PopupMenu_Einfuegen_OnClick(Sender: TObject);
    procedure PopupMenu_Loeschen_OnClick(Sender: TObject);
    procedure PopupMenu_AllesMarkieren_OnClick(Sender: TObject);
    procedure Button_Hilfe_OnClick(Sender: TObject);
    procedure OnCreate(Sender: TObject);
  end;

Var ExportPrint_EditForm: TExportPrint_EditForm;

IMPLEMENTATION

{$R *.DFM}

// PopupMenu_Ausschneiden OnClick
PROCEDURE TExportPrint_EditForm.PopupMenu_Ausschneiden_OnClick(Sender: TObject);
begin Memo.CutToClipboard; end;

// PopupMenu_Kopieren OnClick
PROCEDURE TExportPrint_EditForm.PopupMenu_Kopieren_OnClick(Sender: TObject);
begin Memo.CopyToClipboard; end;

// PopupMenu_Einfuegen OnClick
PROCEDURE TExportPrint_EditForm.PopupMenu_Einfuegen_OnClick(Sender: TObject);
begin Memo.PasteFromClipboard; end;

// PopupMenu_Loeschen OnClick
PROCEDURE TExportPrint_EditForm.PopupMenu_Loeschen_OnClick(Sender: TObject);
begin Memo.ClearSelection; end;

// PopupMenu_AllesMarkieren OnClick
PROCEDURE TExportPrint_EditForm.PopupMenu_AllesMarkieren_OnClick(Sender: TObject);
begin Memo.SelectAll; end;

// Button "Hilfe" OnClick
PROCEDURE TExportPrint_EditForm.Button_Hilfe_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

// Initialiseren - OnCreate
PROCEDURE TExportPrint_EditForm.OnCreate(Sender: TObject);
begin If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true; end;

END.
