{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# EXPORTPRINT.PAS - TExport_PrintForm                                                    #
# Projektdaten ausdrucken                                                                #
#########################################################################################}

UNIT ExportPrint;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     StdCtrls, Buttons, PagePrnt, Mask, ComCtrls, ExtCtrls, Menus,
     Globals, Main;

Type
  TExport_PrintForm = class(TGradientForm)
    PagePrinter: TPagePrinter;
    Label1: TLabel;
    MaskEdit_Zoom: TMaskEdit;
    UpDown_Zoom: TUpDown;
    ComboBox_ZoomAusrichtung: TComboBox;
    Button_KopfFussZeile: TBitBtn;
    Button_DruckerEinrichten: TBitBtn;
    Button_Schriftart: TBitBtn;
    Label4: TLabel;
    Label5: TLabel;
    Label_Seitenanzahl: TLabel;
    CheckBox_AutoScroll: TCheckBox;
    PrinterSetupDialog: TPrinterSetupDialog;
    MaskEdit_AktuelleSeite: TMaskEdit;
    UpDown_AktuelleSeite: TUpDown;
    GroupBox_Seitenrand: TGroupBox;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    MaskEdit_Links: TMaskEdit;
    MaskEdit_Rechts: TMaskEdit;
    MaskEdit_Oben: TMaskEdit;
    MaskEdit_Unten: TMaskEdit;
    UpDown_Links: TUpDown;
    UpDown_Rechts: TUpDown;
    UpDown_Oben: TUpDown;
    UpDown_Unten: TUpDown;
    ComboBox_Format: TComboBox;
    GroupBox_Kopien: TGroupBox;
    MaskEdit_AnzahlKopien: TMaskEdit;
    UpDown_AnzahlKopien: TUpDown;
    CheckBox_Sortieren: TCheckBox;
    Label3: TLabel;
    Button_Starten: TBitBtn;
    Button_Abbrechen: TBitBtn;
    Button_Hilfe: TBitBtn;
    Label7: TLabel;
    Label_BreiteHoehe: TLabel;
    CheckBox_FarbverlaufZeigen: TCheckBox;
    Button_ZoomNorm: TSpeedButton;
    Button_ZoomOut: TSpeedButton;
    Button_ZoomIn: TSpeedButton;
    FontDialog: TFontDialog;
    Button_Seitenrahmen: TBitBtn;
    Button_TextBearbeiten: TBitBtn;
    CheckBox_ZeilenUmbrechen: TCheckBox;
    GroupBox_Feldbereiche: TGroupBox;
    CheckBox_FeldBezeichnung: TCheckBox;
    CheckBox_FeldKommentar: TCheckBox;
    CheckBox_FeldAktionCom: TCheckBox;
    PopupMenu: TPopupMenu;
    PopupMenu_Textbearbeiten: TMenuItem;
    PopupMenu_N1: TMenuItem;
    PopupMenu_ZoomIn: TMenuItem;
    PopupMenu_ZoomOut: TMenuItem;
    PopupMenu_ZoomNorm: TMenuItem;
    Schriftart1: TMenuItem;
    PopupMenu_KopfFusszeile: TMenuItem;
    Seitenrahmen1: TMenuItem;
    CheckBox_InDateiDrucken: TCheckBox;
    GroupBox_Druckbereich: TGroupBox;
    Label2: TLabel;
    Label6: TLabel;
    MaskEdit_Von: TMaskEdit;
    MaskEdit_Bis: TMaskEdit;
    UpDown_Von: TUpDown;
    UpDown_Bis: TUpDown;
    procedure OnCreate(Sender: TObject);
    procedure OnActivate(Sender: TObject);
    // OnChange
    procedure MaskEdit_Zoom_OnChange(Sender: TObject);
    procedure ComboBox_ZoomAusrichtung_OnChange(Sender: TObject);
    procedure ComboBox_Format_OnChange(Sender: TObject);
    procedure MaskEdit_Links_OnChange(Sender: TObject);
    procedure MaskEdit_Rechts_OnChange(Sender: TObject);
    procedure MaskEdit_Oben_OnChange(Sender: TObject);
    procedure MaskEdit_Unten_OnChange(Sender: TObject);
    procedure MaskEdit_AktuelleSeite_OnChange(Sender: TObject);
    // OnClick
    procedure Button_ZoomIn_OnClick(Sender: TObject);
    procedure Button_ZoomOut_OnClick(Sender: TObject);
    procedure Button_ZoomNorm_OnClick(Sender: TObject);
    procedure CheckBox_FarbverlaufZeigen_OnClick(Sender: TObject);
    procedure CheckBox_AutoScroll_OnClick(Sender: TObject);
    procedure Button_TextBearbeiten_OnClick(Sender: TObject);
    procedure Button_Schriftart_OnClick(Sender: TObject);
    procedure Button_KopfFussZeile_OnClick(Sender: TObject);
    procedure Button_Seitenrahmen_OnClick(Sender: TObject);
    procedure Button_DruckerEinrichten_OnClick(Sender: TObject);
    procedure CheckBox_ZeilenUmbrechen_OnClick(Sender: TObject);
    procedure GroupBox_Feldbereiche_OnClick(Sender: TObject);
    procedure Button_Starten_OnClick(Sender: TObject);
    procedure Button_Hilfe_OnClick(Sender: TObject);
  private
    procedure SetPaperBounds;
    procedure DoneEintraegeToPrintLines;
  end;

Var Export_PrintForm: TExport_PrintForm;

IMPLEMENTATION

Uses ExportPrint_Edit, ExportPrint_KFZ, ExportPrint_Rahmen, Msg_ExportPrintFile;

{$R *.DFM}

// Setzt die Labels "Breite" und "Hhe"
PROCEDURE TExport_PrintForm.SetPaperBounds;
var SPBL_Str1: string;
begin
  Label_BreiteHoehe.Caption:=FormatFloat('#####',PagePrinter.PrintableWidth)+' x '+FormatFloat('#####',PagePrinter.PrintableHeight)+' mm';
  With PagePrinter do begin BeginDoc; WriteLines(false); EndDoc; end;
  MaskEdit_AktuelleSeite.Text:=IntToStr(PagePrinter.PageNumber);
  SPBL_Str1:=IntToStr(PagePrinter.PageCount);
  If Label_Seitenanzahl.Caption<>SPBL_Str1 then Label_Seitenanzahl.Caption:=SPBL_Str1;
  MaskEdit_Von.Text:='1';
  MaskEdit_Bis.Text:=SPBL_Str1;
end;

// Liest die Projektdaten ein und setzt sie entspr. im Preview-Fenster (Kernroutine)
PROCEDURE TExport_PrintForm.DoneEintraegeToPrintLines;
var DETPL_Int1, DETPL_Int2: integer; DETPL_Str1, DETPL_Str2: string;
begin
  Cursor:=crHourGlass;
  PagePrinter.Lines.Clear;
  With MainForm.Tree do begin
    For DETPL_Int1:=0 to Items.Count-1 do begin
      TreeNode1:=Items[DETPL_Int1];
      If TreeNode1<>nil then begin
        DETPL_Str2:='';
        For DETPL_Int2:=0 to TreeNode1.Level-1 do DETPL_Str2:=DETPL_Str2+Export_BerCaption_Trennzeichen;
        // -> Feld "Bezeichnung"
        If CheckBox_FeldBezeichnung.Checked then begin
          DETPL_Str1:=TreeNode1.Text; Trim(DETPL_Str1);
          If DETPL_Str1>'' then PagePrinter.Lines.Add(DETPL_Str2+DETPL_Str1);
        end;
        PrjRec:=TreeNode1.Data;
        If PrjRec<>nil then begin
          // -> Feld "Kommentar"
          If CheckBox_FeldKommentar.Checked then begin
            For DETPL_Int2:=0 to PrjRec.Kommentar.Count-1 do begin
              DETPL_Str1:=PrjRec.Kommentar[DETPL_Int2];
              PagePrinter.Lines.Add(DETPL_Str2+Export_BerKommentar_Trennzeichen+DETPL_Str1);
            end;
          end;
          // -> Feld "Aktionspath"
          If CheckBox_FeldAktionCom.Checked then begin
            DETPL_Str1:=PrjRec.AktionStr;
            If DETPL_Str1>'' then PagePrinter.Lines.Add(DETPL_Str2+Export_BerAktion_Trennzeichen+DETPL_Str1);
          end;
        end;
      end;
    end;
  end;
  With PagePrinter do begin BeginDoc; WriteLines(false); EndDoc; end;
  SetPaperBounds;
  Cursor:=crDefault;
end;

{------------------------------------------------------------------------------------------
Initialisieren
------------------------------------------------------------------------------------------}

// Initialisieren - OnCreate
PROCEDURE TExport_PrintForm.OnCreate(Sender: TObject);
begin
  If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
  ComboBox_ZoomAusrichtung.ItemIndex:=0;
  ComboBox_Format.ItemIndex:=0;
  ComboBox_Format_OnChange(Sender);
  If Fenster_Titel>'' then PagePrinter.FriendlyHeader:='&c'+Fenster_Titel;
end;

// Initialisieren - OnActivate
PROCEDURE TExport_PrintForm.OnActivate(Sender: TObject);
begin
  Cursor:=crDefault;
  DoneEintraegeToPrintLines;
end;

{------------------------------------------------------------------------------------------
OnChange
------------------------------------------------------------------------------------------}

// MaskEdit_Zoom OnChange
PROCEDURE TExport_PrintForm.MaskEdit_Zoom_OnChange(Sender: TObject);
var MEZOC_Int1, MEZOC_Int2: integer;
begin
  Val(Trim(MaskEdit_Zoom.Text),MEZOC_Int1,MEZOC_Int2);
  If MEZOC_Int2=0 then begin
    PagePrinter.ZoomPercent:=MEZOC_Int1;
    UpDown_Zoom.Position:=MEZOC_Int1;
  end else MaskEdit_Zoom.Text:=IntToStr(PagePrinter.ZoomPercent);
end;

// ComboBox_ZoomAusrichtung OnChange
PROCEDURE TExport_PrintForm.ComboBox_ZoomAusrichtung_OnChange(Sender: TObject);
begin
  Case ComboBox_ZoomAusrichtung.ItemIndex of
    0: PagePrinter.ZoomLocation:=zlTopLeft;
    1: PagePrinter.ZoomLocation:=zlTopCenter;
    2: PagePrinter.ZoomLocation:=zlCenter;
  end;
end;

// ComboBox_Format OnChange
PROCEDURE TExport_PrintForm.ComboBox_Format_OnChange(Sender: TObject);
var CBFOC_Int1, CBFOC_Int2, CBFOC_Width, CBFOC_Height: integer;
begin
  MaskEdit_Links.Text:='7';
  MaskEdit_Rechts.Text:='7';
  MaskEdit_Oben.Text:='10';
  MaskEdit_Unten.Text:='10';
  If ComboBox_Format.ItemIndex>0 then begin
    CBFOC_Int1:=StrToInt(Trim(FormatFloat('#####',PagePrinter.PrintableWidth)));
    CBFOC_Int2:=StrToInt(Trim(FormatFloat('#####',PagePrinter.PrintableHeight)));
    Case ComboBox_Format.ItemIndex of
      1: begin CBFOC_Width:=72; CBFOC_Height:=53; end;      // Zip-Medium
      2: begin CBFOC_Width:=121; CBFOC_Height:=120; end;    // CD-Rom
    end;
    If CBFOC_Int1>CBFOC_Width then MaskEdit_Rechts.Text:=IntToStr(7+CBFOC_Int1-CBFOC_Width);
    If CBFOC_Int2>CBFOC_Height then MaskEdit_Unten.Text:=IntToStr(10+CBFOC_Int2-CBFOC_Height);
  end;
  SetPaperBounds;
end;

// MaskEdit_Links OnChange
PROCEDURE TExport_PrintForm.MaskEdit_Links_OnChange(Sender: TObject);
begin PagePrinter.MarginLeft:=StrToInt(Trim(MaskEdit_Links.Text)); SetPaperBounds; end;

// MaskEdit_Rechts OnChange
PROCEDURE TExport_PrintForm.MaskEdit_Rechts_OnChange(Sender: TObject);
begin PagePrinter.MarginRight:=StrToInt(Trim(MaskEdit_Rechts.Text)); SetPaperBounds; end;

// MaskEdit_Oben OnChange
PROCEDURE TExport_PrintForm.MaskEdit_Oben_OnChange(Sender: TObject);
begin PagePrinter.MarginTop:=StrToInt(Trim(MaskEdit_Oben.Text)); SetPaperBounds; end;

// MaskEdit_Unten OnChange
PROCEDURE TExport_PrintForm.MaskEdit_Unten_OnChange(Sender: TObject);
begin PagePrinter.MarginBottom:=StrToInt(Trim(MaskEdit_Unten.Text)); SetPaperBounds; end;

// MaskEdit_AktuelleSeite OnChange
PROCEDURE TExport_PrintForm.MaskEdit_AktuelleSeite_OnChange(Sender: TObject);
var MEASOC_Int1: integer;
begin
  MEASOC_Int1:=StrToInt(Trim(MaskEdit_AktuelleSeite.Text));
  If (MEASOC_Int1>0)and(MEASOC_Int1<=PagePrinter.PageCount) then PagePrinter.PageNumber:=MEASOC_Int1 else MaskEdit_AktuelleSeite.Text:=IntToStr(PagePrinter.PageNumber);
end;

{------------------------------------------------------------------------------------------
OnClick
------------------------------------------------------------------------------------------}

// Button "Zoom In" OnClick
PROCEDURE TExport_PrintForm.Button_ZoomIn_OnClick(Sender: TObject);
begin If UpDown_Zoom.Position<979 then MaskEdit_Zoom.Text:=IntToStr(UpDown_Zoom.Position+20) else MaskEdit_Zoom.Text:='999'; end;

// Button "Zoom Out" OnClick
PROCEDURE TExport_PrintForm.Button_ZoomOut_OnClick(Sender: TObject);
begin If UpDown_Zoom.Position>20 then MaskEdit_Zoom.Text:=IntToStr(UpDown_Zoom.Position-20) else MaskEdit_Zoom.Text:='0'; end;

// Button "Zoom 1:1" OnClick
PROCEDURE TExport_PrintForm.Button_ZoomNorm_OnClick(Sender: TObject);
begin MaskEdit_Zoom.Text:='100'; end;

// FarbverlaufZeigen OnClick
PROCEDURE TExport_PrintForm.CheckBox_FarbverlaufZeigen_OnClick(Sender: TObject);
begin PagePrinter.GradientBackground:=CheckBox_FarbverlaufZeigen.Checked end;

// CheckBox_AutoScroll OnClick
PROCEDURE TExport_PrintForm.CheckBox_AutoScroll_OnClick(Sender: TObject);
begin PagePrinter.AutoScroll:=CheckBox_AutoScroll.Checked; end;

// CheckBox_ZeilenUmbrechen OnClick
PROCEDURE TExport_PrintForm.CheckBox_ZeilenUmbrechen_OnClick(Sender: TObject);
begin PagePrinter.WordWrap:=CheckBox_ZeilenUmbrechen.Checked; SetPaperBounds; end;

// Button "Text bearbeiten" OnClick
PROCEDURE TExport_PrintForm.Button_TextBearbeiten_OnClick(Sender: TObject);
var BTBOC_Int1: integer;
begin
  With TExportPrint_EditForm.Create(Self) do try
    Memo.Font:=PagePrinter.Font;
    Memo.WordWrap:=CheckBox_ZeilenUmbrechen.Checked;
    Memo.Lines:=PagePrinter.Lines;
    BTBOC_Int1:=ShowModal;
    If BTBOC_Int1=mrOk then PagePrinter.Lines:=Memo.Lines;
  finally Free; end;
  If BTBOC_Int1=mrOk then With PagePrinter do begin BeginDoc; WriteLines(false); EndDoc; end;
end;

// Button "Schriftarten" OnClick
PROCEDURE TExport_PrintForm.Button_Schriftart_OnClick(Sender: TObject);
begin
  FontDialog.Font:=PagePrinter.Font;
  If FontDialog.Execute then begin
    With PagePrinter do begin Font:=FontDialog.Font; BeginDoc; WriteLines(false); EndDoc; end;
    SetPaperBounds;
  end;
end;

// Button "Kopf- und Fuzeile" OnClick
PROCEDURE TExport_PrintForm.Button_KopfFussZeile_OnClick(Sender: TObject);
var BKFZOC_Int1: integer;
begin
  With TExport_Print_KFZForm.Create(Self) do try
    Edit_Kopfzeile.Text:=PagePrinter.FriendlyHeader;
    Edit_Fusszeile.Text:=PagePrinter.FriendlyFooter;
    If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
    BKFZOC_Int1:=ShowModal;
    If BKFZOC_Int1=mrOk then begin
      PagePrinter.BeginDoc;
      PagePrinter.FriendlyHeader:=Edit_Kopfzeile.Text;
      PagePrinter.FriendlyFooter:=Edit_Fusszeile.Text;
      PagePrinter.EndDoc;
    end;
  finally Free; end;
  If BKFZOC_Int1=mrOk then begin
    PagePrinter.BeginDoc;
    PagePrinter.FriendlyHeader:=PagePrinter.FriendlyHeader;
    PagePrinter.FriendlyFooter:=PagePrinter.FriendlyFooter;
    PagePrinter.WriteLines(false);
    PagePrinter.EndDoc;
    SetPaperBounds;
  end;
end;

// Button "Seitenrahmen" OnClick
PROCEDURE TExport_PrintForm.Button_Seitenrahmen_OnClick(Sender: TObject);
begin
  With TExport_Print_RahmenForm.Create(Self) do try
    If pbLeft in PagePrinter.PageBorders then CheckBox_Links.Checked:=true;
    If pbRight in PagePrinter.PageBorders then CheckBox_Rechts.Checked:=true;
    If pbTop in PagePrinter.PageBorders then CheckBox_Oben.Checked:=true;
    If pbBottom in PagePrinter.PageBorders then CheckBox_Unten.Checked:=true;
    MaskEdit_Rahmendicke.Text:=FormatFloat('###',PagePrinter.PageBorderOffset);
    If ShowModal=mrOk then begin
      If CheckBox_Links.Checked then PagePrinter.PageBorders:=[pbLeft] else PagePrinter.PageBorders:=[];
      If CheckBox_Rechts.Checked then PagePrinter.PageBorders:=PagePrinter.PageBorders+[pbRight];
      If CheckBox_Oben.Checked then PagePrinter.PageBorders:=PagePrinter.PageBorders+[pbTop];
      If CheckBox_Unten.Checked then PagePrinter.PageBorders:=PagePrinter.PageBorders+[pbBottom];
      PagePrinter.PageBorderOffset:=StrToInt(Trim(MaskEdit_Rahmendicke.Text));
      With PagePrinter do begin BeginDoc; WriteLines(false); EndDoc; end;
      SetPaperBounds;
    end;
  finally Free; end;
end;

// Button "Drucker einrichten" OnClick
PROCEDURE TExport_PrintForm.Button_DruckerEinrichten_OnClick(Sender: TObject);
begin PrinterSetupDialog.Execute; PagePrinter.RefreshProperties; SetPaperBounds; end;

// Feldbereich OnClick - Bereich, Kommentar, Aktionspath werden gendert
PROCEDURE TExport_PrintForm.GroupBox_Feldbereiche_OnClick(Sender: TObject);
begin DoneEintraegeToPrintLines; end;

// Button "Drucken starten" OnClick
PROCEDURE TExport_PrintForm.Button_Starten_OnClick(Sender: TObject);
var BSOC_Bool1: boolean; BSOC_Int1: integer;
begin
  With PagePrinter do begin
    If not CheckBox_Sortieren.Checked then Collate:=false;
    Copies:=StrToInt(Trim(MaskEdit_AnzahlKopien.Text));
    PrintFromPage:=StrToInt(Trim(MaskEdit_Von.Text));
    PrintToPage:=StrToInt(Trim(MaskEdit_Bis.Text));
  end;
  If CheckBox_InDateiDrucken.Checked then begin
    With TMsg_ExportPrintToFileForm.Create(Self) do try
      If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
      BSOC_Int1:=ShowModal;
      If BSOC_Int1=mrOk then begin
        PagePrinter.PrintToFile:=true;
        PagePrinter.FileName:=Edit_Dateiname.Text;
      end;
    finally Free; end;
  end else begin
    Repeat
      If PagePrinter.Printing then begin
        If MainForm.MsgDlg(50)=mrRetry then BSOC_Bool1:=false else begin BSOC_Int1:=mrCancel; BSOC_Bool1:=true; end
      end else begin BSOC_Int1:=mrOk; BSOC_Bool1:=true; end;
    until BSOC_Bool1;
  end;
  If BSOC_Int1=mrOk then If PagePrinter.Print then ModalResult:=mrOk;
end;

// Button "Hilfe" OnClick
PROCEDURE TExport_PrintForm.Button_Hilfe_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

END.
