{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# EINSTELLUNGEN.PAS - TEinstellungenForm                                                 #
# Einstellungen konfigurieren                                                            #
#########################################################################################}

UNIT Einstellungen;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     StdCtrls, ComCtrls, ExtPage, Mask, Buttons,
     Globals, Main, TreeNT;

Type
  TEinstellungenForm = class(TGradientForm)
    ExtPageControl: TExtPageControl;
    TabSheet_Fenster: TTabSheet;
    TabSheet_Exportieren: TTabSheet;
    Button_Uebernehmen: TBitBtn;
    Button_Abbrechen: TBitBtn;
    Button_Hilfe: TBitBtn;
    TabSheet_Dateien: TTabSheet;
    Label1: TLabel;
    Edit_FTitel: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    MaskEdit_FBreite: TMaskEdit;
    MaskEdit_FHoehe: TMaskEdit;
    UpDown_FBreite: TUpDown;
    UpDown_FHoehe: TUpDown;
    CheckBox_FZentriert: TCheckBox;
    Label4: TLabel;
    ComboBox_FStatus: TComboBox;
    Label5: TLabel;
    MaskEdit_FKommentarHoehe: TMaskEdit;
    UpDown_FKommentarHoehe: TUpDown;
    CheckBox_FUseBreite: TCheckBox;
    CheckBox_FUseHoehe: TCheckBox;
    CheckBox_FUseKommentarHoehe: TCheckBox;
    CheckBox_EBezeichnung: TCheckBox;
    CheckBox_EKommentar: TCheckBox;
    CheckBox_EAktionsstring: TCheckBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Edit_EBezeichnung: TEdit;
    Edit_EKommentar: TEdit;
    Edit_EAktionsstring: TEdit;
    Label9: TLabel;
    Edit_DHlpFile: TEdit;
    GroupBox_DExternApp: TGroupBox;
    Label10: TLabel;
    Label11: TLabel;
    Edit_DExternAppName: TEdit;
    Edit_DExternAppBefehl: TEdit;
    TabSheet_Dateimanager: TTabSheet;
    CheckBox_PUseInfoTips: TCheckBox;
    CheckBox_PUseToolTips: TCheckBox;
    CheckBox_PUseImageIcons: TCheckBox;
    procedure OnCreate(Sender: TObject);
    procedure CheckBox_FUseBreite_OnClick(Sender: TObject);
    procedure CheckBox_FUseHoehe_OnClick(Sender: TObject);
    procedure CheckBox_FUseKommentarHoehe_OnClick(Sender: TObject);
    procedure Button_Hilfe_OnClick(Sender: TObject);
    procedure Button_Uebernehmen_OnClick(Sender: TObject);
  end;

Var EinstellungenForm: TEinstellungenForm;

IMPLEMENTATION

{$R *.DFM}

// Initialisieren - OnCreate - Werte entspr. setzen
PROCEDURE TEinstellungenForm.OnCreate(Sender: TObject);
var OC_Int1: integer; OC_Str1: string;
begin
  // -> Fenster
  Edit_FTitel.Text:=Fenster_Titel; // Fenster-Titel
  If Fenster_Breite>0 then begin  // Fenster-Breite
    MaskEdit_FBreite.Enabled:=true;
    UpDown_FBreite.Enabled:=true;
    CheckBox_FUseBreite.Checked:=true;
    MaskEdit_FBreite.Text:=IntToStr(Fenster_Breite);
  end else MaskEdit_FBreite.Text:=IntToStr(MainForm.Width);
  If Fenster_Hoehe>0 then begin // Fenster-Hhe
    MaskEdit_FHoehe.Enabled:=true;
    UpDown_FHoehe.Enabled:=true;
    CheckBox_FUseHoehe.Checked:=true;
    MaskEdit_FHoehe.Text:=IntToStr(Fenster_Hoehe);
  end else MaskEdit_FHoehe.Text:=IntToStr(MainForm.Height);
  ComboBox_FStatus.ItemIndex:=Fenster_Status; // Fenster-Status;
  CheckBox_FZentriert.Checked:=Fenster_ZentriertPositionieren; // Fenster zentriert positionieren
  If Fenster_KommentarfeldHoehe>0 then begin // Kommentarfeldhhe
    MaskEdit_FKommentarHoehe.Enabled:=true;
    UpDown_FKommentarHoehe.Enabled:=true;
    CheckBox_FUseKommentarHoehe.Checked:=true;
    MaskEdit_FKommentarHoehe.Text:=IntToStr(Fenster_KommentarfeldHoehe);
  end else MaskEdit_FKommentarHoehe.Text:=IntToStr(MainForm.KommentarEdit.Height);
  // -> Exportieren
  CheckBox_EBezeichnung.Checked:=Export_BerCaption; // Feldbereich "Bezeichnung"
  Edit_EBezeichnung.Text:=Export_BerCaption_Trennzeichen; // Trennzeichen "Bezeichnung"
  CheckBox_EKommentar.Checked:=Export_BerKommentar; // Feldbereich "Kommentar"
  Edit_EKommentar.Text:=Export_BerKommentar_Trennzeichen; // Trennzeichen "Kommentar"
  CheckBox_EAktionsstring.Checked:=Export_BerAktion; // Feldbereich "Aktionsstring"
  Edit_EAktionsstring.Text:=Export_BerAktion_Trennzeichen; // Trennzeichen "Aktionsstring"
  // -> Dateien
  OC_Str1:=HlpFileCom; // Hilfedatei
  If Length(OC_Str1)>0 then begin
    If FileExists(ExtractFilePath(ParamStr(0))+ExtractFileName(OC_Str1)) then OC_Str1:=ExtractFileName(OC_Str1)
    else If not ExtractRelativCom(OC_Str1) then OC_Str1:=ExtractFileName(OC_Str1);
  end;
  Edit_DHlpFile.Text:=OC_Str1; Edit_DHlpFile.Modified:=false;
  Edit_DExternAppName.Text:=Extern_ApplicationName; // Name des externen Altionsprogrammes
  Edit_DExternAppBefehl.Text:=Extern_ApplicationCom; // Befehl des externen Aktionsprogrammes
  // -> Projektbaum
  CheckBox_PUseImageIcons.Checked:=MainForm.Tree.Images=MainForm.ImageList; // ImageIcons verwenden
  CheckBox_PUseInfoTips.Checked:=toInfoTip in MainForm.Tree.Options; // InfoTips verwenden
  CheckBox_PUseToolTips.Checked:=toToolTips in MainForm.Tree.Options; // ToolTips verwenden
  ExtPageControl.ActivePage:=TabSheet_Fenster;
  If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
end;

// CheckBox_FUseBreite OnClick - Fensterbreite verwenden
PROCEDURE TEinstellungenForm.CheckBox_FUseBreite_OnClick(Sender: TObject);
begin
  If CheckBox_FUseBreite.Checked then begin MaskEdit_FBreite.Enabled:=true; UpDown_FBreite.Enabled:=true; end
  else begin MaskEdit_FBreite.Enabled:=false; UpDown_FBreite.Enabled:=false; end;
end;

// CheckBox_FUseHoehe OnClick - Fensterhhe verwenden
PROCEDURE TEinstellungenForm.CheckBox_FUseHoehe_OnClick(Sender: TObject);
begin
  If CheckBox_FUseHoehe.Checked then begin MaskEdit_FHoehe.Enabled:=true; UpDown_FHoehe.Enabled:=true; end
  else begin MaskEdit_FHoehe.Enabled:=false; UpDown_FHoehe.Enabled:=false; end;
end;

// CheckBox_FUseKommentarHoehe OnClick - Fenster Kommentarfeldhhe verwenden
PROCEDURE TEinstellungenForm.CheckBox_FUseKommentarHoehe_OnClick(Sender: TObject);
begin
  If CheckBox_FUseKommentarHoehe.Checked then begin MaskEdit_FKommentarHoehe.Enabled:=true; UpDown_FKommentarHoehe.Enabled:=true; end
  else begin MaskEdit_FKommentarHoehe.Enabled:=false; UpDown_FKommentarHoehe.Enabled:=false; end;
end;

// Button "Hilfe" OnClick
PROCEDURE TEinstellungenForm.Button_Hilfe_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

// Button "bernehmen" OnClick
PROCEDURE TEinstellungenForm.Button_Uebernehmen_OnClick(Sender: TObject);
var BUOC_Int1, BUOC_Int2: integer; BUOC_Str1: string;
begin
  // -> Fenster
  If Edit_FTitel.Text<>Fenster_Titel then begin // Fenster-Titel
    Fenster_Titel:=Edit_FTitel.Text;
    MainForm.Caption:='Dipesh-SoftwareManager-32 '+Fenster_Titel;
  end;
  If CheckBox_FUseBreite.Checked then begin // Fenster-Breite
    Val(Trim(MaskEdit_FBreite.Text),BUOC_Int1,BUOC_Int2);
    If BUOC_Int2=0 then Fenster_Breite:=BUOC_Int1;
  end;
  If CheckBox_FUseHoehe.Checked then begin // Fenter-Hhe
    Val(Trim(MaskEdit_FHoehe.Text),BUOC_Int1,BUOC_Int2);
    If BUOC_Int2=0 then Fenster_Hoehe:=BUOC_Int1;
  end;
  Fenster_Status:=ComboBox_FStatus.ItemIndex; // Fenster-Status
  Fenster_ZentriertPositionieren:=CheckBox_FZentriert.Checked; // Fenster zentriert positionieren
  If CheckBox_FUseKommentarHoehe.Checked then begin // Kommentarfeldhhe
    Val(Trim(MaskEdit_FKommentarHoehe.Text),BUOC_Int1,BUOC_Int2);
    If BUOC_Int2=0 then begin
      Fenster_KommentarfeldHoehe:=BUOC_Int1;
      MainForm.KommentarEdit.Height:=BUOC_Int1;
    end;
  end;
  // -> Exportieren
  Export_BerCaption:=CheckBox_EBezeichnung.Checked; // Feldbereich "Bezeichnung" exportieren
  Export_BerCaption_Trennzeichen:=Edit_EBezeichnung.Text; // Trennzeichen "Bezeichnung"
  Export_BerKommentar:=CheckBox_EKommentar.Checked; // Feldbereich "Kommentar" exportieren
  Export_BerKommentar_Trennzeichen:=Edit_EKommentar.Text; // Trennzeichen "Kommentar"
  Export_BerAktion:=CheckBox_EAktionsstring.Checked; // Feldbereich "Aktionsstring" exportieren
  Export_BerAktion_Trennzeichen:=Edit_EAktionsstring.Text; // Trennzeichen "Aktionsstring"
  // -> Dateien
  If Edit_DHlpFile.Modified then begin // Hilfe-Datei
    BUOC_Str1:=Edit_DHlpFile.Text;
    If ExpandFileCom(BUOC_Str1) then begin
      HlpFileCom:=BUOC_Str1; Application.HelpFile:=HlpFileCom; MainForm.SetEnabledDisabledState(0);
    end;
  end;
  Extern_ApplicationName:=Edit_DExternAppName.Text; // Name des externen Altionsprogrammes
  Extern_ApplicationCom:=Edit_DExternAppBefehl.Text; // Befehl des externen Aktionsprogrammes
  // -> Projektbaum
  If CheckBox_PUseImageIcons.Checked then begin // ImageIcons verwenden
    If MainForm.Tree.Images=nil then begin
      If MainForm.ImageList.Count<1 then begin
        With MainForm do begin ImageList.ResourceLoad(rtBitmap,'TREE_DIR1',clTeal);
          ImageList.ResourceLoad(rtBitmap,'TREE_DIR2',clTeal); ImageList.ResourceLoad(rtBitmap,'TREE_ITEM',clTeal);
          For BUOC_Int1:=0 to Tree.Items.Count-1 do begin
            If Tree.Items[BUOC_Int1].GetFirstChild=nil then begin Tree.Items[BUOC_Int1].ImageIndex:=2; Tree.Items[BUOC_Int1].SelectedIndex:=2;
            end else begin Tree.Items[BUOC_Int1].ImageIndex:=0; Tree.Items[BUOC_Int1].SelectedIndex:=1; end;
          end;
        end;
      end;
      MainForm.Tree.Images:=MainForm.ImageList;
    end;
  end else If MainForm.Tree.Images=MainForm.ImageList then MainForm.Tree.Images:=nil;
  If CheckBox_PUseInfoTips.Checked then begin // InfoTips & ToolTips verwenden
    If CheckBox_PUseToolTips.Checked then MainForm.Tree.Options:=[toFullRowSelect,toHotTrack,toInfoTip,toToolTips,toShowButtons,toShowLines,toShowRoot]
    else MainForm.Tree.Options:=[toFullRowSelect,toHotTrack,toInfoTip,toShowButtons,toShowLines,toShowRoot];
  end else begin
    If CheckBox_PUseToolTips.Checked then MainForm.Tree.Options:=[toFullRowSelect,toHotTrack,toToolTips,toShowButtons,toShowLines,toShowRoot]
    else MainForm.Tree.Options:=[toFullRowSelect,toHotTrack,toShowButtons,toShowLines,toShowRoot];
  end;      
end;

END.
