{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# DATEIMANAGER_MKDIR.PAS - TDateimanager_MkDirForm                                       #
# Dateimananger - MkDir (Verzeichnis erstellen)                                          #
#########################################################################################}

UNIT Dateimanager_MkDir;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     ExtCtrls, StdCtrls, Buttons, FileCtrl,
     Globals, Main, Dateimanager;

Type
  TDateimanager_MkDirForm = class(TGradientForm)
    Panel1: TPanel;
    Image1: TImage;
    DirEdit: TEdit;
    Button_Erstellen: TBitBtn;
    Button_Abbrechen: TBitBtn;
    Button_Hilfe: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    procedure Button_Hilfe_OnClick(Sender: TObject);
    procedure DirEdit_OnChange(Sender: TObject);
    procedure Button_Erstellen_OnClick(Sender: TObject);
  end;

Var Dateimanager_MkDirForm: TDateimanager_MkDirForm;

IMPLEMENTATION

{$R *.DFM}

// Button "Hilfe" OnClick
PROCEDURE TDateimanager_MkDirForm.Button_Hilfe_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

// DirEdit OnChange
PROCEDURE TDateimanager_MkDirForm.DirEdit_OnChange(Sender: TObject);
begin
  If DirEdit.Text>'' then begin If not Button_Erstellen.Enabled then Button_Erstellen.Enabled:=true; end
  else begin If Button_Erstellen.Enabled then Button_Erstellen.Enabled:=false; end;
end;

// Button "Erstellen" OnClick
PROCEDURE TDateimanager_MkDirForm.Button_Erstellen_OnClick(Sender: TObject);
var BEOC_Bool1: boolean; BEOC_Str1: string;
begin
  BEOC_Bool1:=false;
  If Pos('\',DirEdit.Text)<>0 then BEOC_Bool1:=true else
  If Pos('/',DirEdit.Text)<>0 then BEOC_Bool1:=true else
  If Pos(':',DirEdit.Text)<>0 then BEOC_Bool1:=true else
  If Pos('*',DirEdit.Text)<>0 then BEOC_Bool1:=true else
  If Pos('?',DirEdit.Text)<>0 then BEOC_Bool1:=true else
  If Pos('"',DirEdit.Text)<>0 then BEOC_Bool1:=true else
  If Pos('<',DirEdit.Text)<>0 then BEOC_Bool1:=true else
  If Pos('>',DirEdit.Text)<>0 then BEOC_Bool1:=true else
  If Pos('|',DirEdit.Text)<>0 then BEOC_Bool1:=true;
  If BEOC_Bool1 then begin
    MainForm.MsgDlg(72); DirEdit.SelectAll; ActiveControl:=DirEdit;
  end else begin
    BEOC_Str1:=DateimanagerForm.FileList.Directory+DirEdit.Text;
    If DirectoryExists(BEOC_Str1) then begin
      MainForm.MsgDlg(70); DirEdit.SelectAll; ActiveControl:=DirEdit;
    end else begin
      If XMkDir(BEOC_Str1) then ModalResult:=mrOk else begin
        MainForm.MsgDlg(71); DirEdit.SelectAll; ActiveControl:=DirEdit;
      end;
    end;
  end;
end;

END.
