{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# DATEIMANAGER_MARKGROUP.PAS - TDateimanager_MarkGroupForm                               #
# Dateimanager - PopupMenu_Markieren "Gruppe markieren"                                  #
#########################################################################################}

UNIT Dateimanager_MarkGroup;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
  StdCtrls, Buttons;

Type
  TDateimanager_MarkGroupForm = class(TGradientForm)
    Label1: TLabel;
    Label2: TLabel;
    MaskEdit: TEdit;
    Button_Uebernehmen: TBitBtn;
    Button_Abbrechen: TBitBtn;
    Button_Hilfe: TBitBtn;
    CheckBox_VerzeichnisseAusschliessen: TCheckBox;
    procedure Button_Hilfe_OnClick(Sender: TObject);
    procedure MaskEdit_OnChange(Sender: TObject);
    procedure Button_Uebernehmen_OnClick(Sender: TObject);
  end;

Var Dateimanager_MarkGroupForm: TDateimanager_MarkGroupForm;

IMPLEMENTATION

{$R *.DFM}

// Button "Hilfe" OnClick
PROCEDURE TDateimanager_MarkGroupForm.Button_Hilfe_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

// MaskEdit OnChange
PROCEDURE TDateimanager_MarkGroupForm.MaskEdit_OnChange(Sender: TObject);
begin
  If MaskEdit.Text>'' then begin
    If not Button_Uebernehmen.Enabled then Button_Uebernehmen.Enabled:=true;
  end else If Button_Uebernehmen.Enabled then Button_Uebernehmen.Enabled:=false;
end;

// Button "bernehmen" OnClick
PROCEDURE TDateimanager_MarkGroupForm.Button_Uebernehmen_OnClick(Sender: TObject);
var BUOC_Bool1: boolean; BUOC_Int1: integer; BUOC_Pchar1: pchar; BUOC_Str1: string;
begin
  // MaskEdit.Text auf gltige Angabe prfen
  BUOC_Bool1:=true; BUOC_Str1:=MaskEdit.Text; BUOC_Str1:=Trim(BUOC_Str1);
  If BUOC_Str1>'' then begin
    BUOC_Int1:=Pos('.',BUOC_Str1);
    If BUOC_Int1=0 then BUOC_Pchar1:='Kein "."-Trennzeichen angegeben.' else begin
      If BUOC_Int1=1 then BUOC_Pchar1:='Kein Dateiname angegeben.' else begin
        If Length(BUOC_Str1)=BUOC_Int1 then BUOC_Pchar1:='Keine Dateierweiterung angegeben.' else begin
          If (Pos('\',BUOC_Str1)<>0)or
             (Pos('/',BUOC_Str1)<>0)or
             (Pos(':',BUOC_Str1)<>0)or
             (Pos('?',BUOC_Str1)<>0)or
             (Pos('"',BUOC_Str1)<>0)or
             (Pos('<',BUOC_Str1)<>0)or
             (Pos('>',BUOC_Str1)<>0)or
             (Pos('|',BUOC_Str1)<>0) then BUOC_Pchar1:='Die Zeichen "/\:?"<>|" drfen nicht verwendet werden.'
          else BUOC_Bool1:=false; // bei gltiger Angabe
        end;
      end;
    end;
  end else BUOC_Pchar1:='Keine Selektionskriterien angegeben.';
  If BUOC_Bool1 then begin // Fehlermessage
    MessageBox(0,BUOC_Pchar1,'Fehler: Ungltige Angabe...',MB_IconStop+MB_Ok+MB_ApplModal+MB_SetForeground);
    Exit;
  end;
  ModalResult:=mrOk; // bei gltiger Angabe
end;

END.
