{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# DATEIMANAGER_EIGENSCHAFTEN.PAS - TDateimanager_EigenschaftenForm                       #
# Dateimanager - Eigenschaften                                                           #
#########################################################################################}

UNIT Dateimanager_Eigenschaften;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     ExtCtrls, StdCtrls, ComCtrls, FileCtrl, Buttons,
     Globals, Dateimanager;

Type
  TDateimanager_EigenschaftenForm = class(TGradientForm)
    Image1: TImage;
    Label_AnzahlMarkierteObjekte: TLabel;
    Label_AnzahlVerzeichnisseDateien: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label_Typ: TLabel;
    Label_Ort: TLabel;
    Label_Groesse: TLabel;
    TPanel1: TPanel;
    Button_Ok: TBitBtn;
    Button_Hilfe: TBitBtn;
    Label_Dosdateiname1: TLabel;
    Label_Erstellt1: TLabel;
    Label_Geaendert1: TLabel;
    Label_Letzter1: TLabel;
    Label_DosDateiname2: TLabel;
    Label_Erstellt2: TLabel;
    Label_Geaendert2: TLabel;
    Label_Letzter2: TLabel;
    Label12: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    CheckBox_DA_ReadOnly: TCheckBox;
    CheckBox_DA_Hidden: TCheckBox;
    CheckBox_DA_Archiv: TCheckBox;
    CheckBox_DA_System: TCheckBox;
    procedure OnActivate(Sender: TObject);
    procedure Button_Ok_OnClick(Sender: TObject);
    procedure Button_Hilfe_OnClick(Sender: TObject);
  end;

Var Attr_ReadOnly, Attr_Hidden, Attr_Archiv, Attr_System: TCheckBoxState;
    Dateimanager_EigenschaftenForm: TDateimanager_EigenschaftenForm;

IMPLEMENTATION

{$R *.DFM}

// Initialisieren - OnActivate
PROCEDURE TDateimanager_EigenschaftenForm.OnActivate(Sender: TObject);
var OA_LongInt1: longint; OA_Int1, OA_Int2: integer; OA_Str1: string;
    OA_TSR: tsearchrec; OA_SysTime: tsystemtime;
  // Liest Gre und Anzahl der markierten Dateien und Verzeichnisse und deren Unterverzeichnisse ein
  procedure ReadSelectedObjectsInfos;
  var GSOI_Int1: integer; GSOI_Str1: string;
    procedure DoneSelObjectInfos(sDir,sName: string; SearchOnlyFiles: boolean);
    var DosError: integer; TSR: tSearchRec;
    begin
      If sDir>'' then If sDir[Length(sDir)]<>'\' then sDir:=sDir+'\';
      // Dateien suchen
      DosError:=FindFirst(sDir+sName,faAnyFile mod faDirectory,TSR);
      While DosError=0 do begin
        If (TSR.Attr and faDirectory)=0 then begin
          inc(OA_Int2); inc(OA_LongInt1,TSR.Size);
          If (TSR.Attr and faReadOnly>0) then begin
            If Attr_ReadOnly=cbUnchecked then Attr_ReadOnly:=cbChecked;
          end else If Attr_ReadOnly=cbChecked then Attr_ReadOnly:=cbGrayed;
          If (TSR.Attr and faHidden>0) then begin
            If Attr_Hidden=cbUnchecked then Attr_Hidden:=cbChecked;
          end else If Attr_Hidden=cbChecked then Attr_Hidden:=cbGrayed;
          If (TSR.Attr and faArchive>0) then begin
            If Attr_Archiv=cbUnchecked then Attr_Archiv:=cbChecked;
          end else If Attr_Archiv=cbChecked then Attr_Archiv:=cbGrayed;
          If (TSR.Attr and faSysFile>0) then begin
            If Attr_System=cbUnchecked then Attr_System:=cbChecked;
          end else If Attr_System=cbChecked then Attr_System:=cbGrayed;
        end;
        DosError:=FindNext(TSR);
      end;
      FindClose(TSR);
      // Unterverzeichnisse suchen
      If not SearchOnlyFiles then begin
        DosError:=FindFirst(sDir+'\*.*',faDirectory,TSR);
        While DosError=0 do begin
          If (TSR.Attr and faDirectory=faDirectory) and (TSR.Name[1]<>'.') then begin
            inc(OA_Int1);
            Label_AnzahlVerzeichnisseDateien.Caption:=IntToStr(OA_Int1)+' Verzeichnis(se), '+IntToStr(OA_Int2)+' Datei(en)';
            Label_Groesse.Caption:=FormatInteger(OA_LongInt1)+' Bytes ('+FormatBytesInteger(OA_LongInt1)+')';
            Update;
            DoneSelObjectInfos(sDir+TSR.Name,sName,false); // rekursiv !
          end;
          DosError:=FindNext(TSR);
        end;
        FindClose(TSR);
      end;
    end;
  begin
    OA_LongInt1:=0; OA_Int1:=0; OA_Int2:=0;
    Attr_ReadOnly:=cbUnchecked; Attr_Hidden:=cbUnchecked; Attr_Archiv:=cbUnchecked; Attr_System:=cbUnchecked;
    For GSOI_Int1:=0 to DateimanagerForm.FileList.Items.Count-1 do begin
      If DateimanagerForm.FileList.Items[GSOI_Int1].Selected then begin
        GSOI_Str1:=DateimanagerForm.FileList.Directory+DateimanagerForm.FileList.Items[GSOI_Int1].Caption;
        If FileExists(GSOI_Str1) then DoneSelObjectInfos(ExtractFilePath(GSOI_Str1),ExtractFileName(GSOI_Str1),true)
        else If DirectoryExists(GSOI_Str1) then begin inc(OA_Int1); DoneSelObjectInfos(GSOI_Str1,'*.*',false); end;
      end;
    end;
    Label_AnzahlVerzeichnisseDateien.Caption:=IntToStr(OA_Int1)+' Verzeichnis(se), '+IntToStr(OA_Int2)+' Datei(en)';
    Label_Groesse.Caption:=FormatInteger(OA_LongInt1)+' Bytes ('+FormatBytesInteger(OA_LongInt1)+')';
    Update;
  end;
begin
  Update;
  Label_AnzahlMarkierteObjekte.Caption:=IntToStr(DateimanagerForm.FileList.SelCount)+' Objekt(e) markiert.';
  Label_Ort.Caption:=LowerCase(DateimanagerForm.FileList.Directory);
  Update;
  ReadSelectedObjectsInfos;
  If DateimanagerForm.FileList.SelCount>1 then begin
    If OA_Int1=0 then Label_Typ.Caption:='Alles Dateien' else
    If OA_Int2=0 then Label_Typ.Caption:='Alles Verzeichnisse' else
    Label_Typ.Caption:='Mehrere Verzeichnisse und Dateien';
  end else begin
    // Dateityp des einen selektierten Objektes ermitteln
    If DateimanagerForm.FileList.SelCount=1 then begin
      OA_Str1:=DateimanagerForm.FileList.Directory+DateimanagerForm.FileList.Selected.Caption;
      Label_Typ.Caption:=DateimanagerForm.FileList.Selected.SubItems[1];
      If FindFirst(OA_Str1,faAnyFile+faDirectory,OA_TSR)=0 then begin
        Label_DosDateiname2.Caption:=UpperCase(OA_TSR.Name);
        FileTimeToSystemTime(OA_TSR.FindData.ftCreationTime,OA_SysTime);
        Label_Erstellt2.Caption:=
          IntToStr(OA_SysTime.wDay)+'.'+IntToStr(OA_SysTime.wMonth)+'.'+IntToStr(OA_SysTime.wYear)+' '+
          IntToStr(OA_SysTime.wHour)+':'+IntToStr(OA_SysTime.wMinute)+':'+IntToStr(OA_SysTime.wSecond);
        FileTimeToSystemTime(OA_TSR.FindData.ftLastWriteTime,OA_SysTime);
        Label_Geaendert2.Caption:=
          IntToStr(OA_SysTime.wDay)+'.'+IntToStr(OA_SysTime.wMonth)+'.'+IntToStr(OA_SysTime.wYear)+' '+
          IntToStr(OA_SysTime.wHour)+':'+IntToStr(OA_SysTime.wMinute)+':'+IntToStr(OA_SysTime.wSecond);
        FileTimeToSystemTime(OA_TSR.FindData.ftLastAccessTime,OA_SysTime);
        Label_Letzter2.Caption:=
          IntToStr(OA_SysTime.wDay)+'.'+IntToStr(OA_SysTime.wMonth)+'.'+IntToStr(OA_SysTime.wYear)+' '+
          IntToStr(OA_SysTime.wHour)+':'+IntToStr(OA_SysTime.wMinute)+':'+IntToStr(OA_SysTime.wSecond);
        Bevel1.Visible:=true;
        Label_DosDateiname1.Visible:=true; Label_DosDateiname2.Visible:=true;
        Label_Erstellt1.Visible:=true; Label_Erstellt2.Visible:=true;
        Label_Geaendert1.Visible:=true; Label_Geaendert2.Visible:=true;
        Label_Letzter1.Visible:=true; Label_Letzter2.Visible:=true;
      end;
    end else Label_Typ.Caption:='Keine Objekte markiert.';
  end;
  CheckBox_DA_ReadOnly.State:=Attr_ReadOnly; CheckBox_DA_Hidden.State:=Attr_Hidden;
  CheckBox_DA_Archiv.State:=Attr_Archiv; CheckBox_DA_System.State:=Attr_System;
  Caption:='Eigenschaften';
  Update;
end;

// Button "OK" OnClick
PROCEDURE TDateimanager_EigenschaftenForm.Button_Ok_OnClick(Sender: TObject);
var EBOC_Bool1: boolean; EBOC_Int1, EBOC_Int2: integer;
  // Setzt die gewhlten Dateiattribute bei allen markierten Objekte und deren Unterdateien
  procedure SetSelectedObjectAttr;
  var SSOA_Int1: integer; SSOA_LongInt: longint; SSOA_Str1: string;
    procedure DoneSetSelObjectAttr(sDir,sName: string; SearchOnlyFiles: boolean);
    var DosError: integer; DSSOA_Str1: string; TSR: tSearchRec;
    begin
      If sDir>'' then If sDir[Length(sDir)]<>'\' then sDir:=sDir+'\';
      // Dateien suchen
      DosError:=FindFirst(sDir+sName,faAnyFile mod faDirectory,TSR);
      While DosError=0 do begin
        If (TSR.Attr and faDirectory)=0 then begin
          // Dateiattribut "Schreibgeschtzt" entspr. setzen
          If CheckBox_DA_ReadOnly.State<>Attr_ReadOnly then begin
            If CheckBox_DA_ReadOnly.State=cbChecked then begin
              If not (TSR.Attr and faReadOnly>0) then EBOC_Bool1:=false else EBOC_Bool1:=true;
              EBOC_Int1:=TSR.Attr+faReadOnly
            end else begin
              If (TSR.Attr and faReadOnly>0) then EBOC_Bool1:=false else EBOC_Bool1:=true;
              EBOC_Int1:=TSR.Attr-faReadOnly;
            end;
            While not EBOC_Bool1 do begin
              If FileSetAttr(sDir+TSR.Name,EBOC_Int1)=0 then EBOC_Bool1:=true else begin
                If (EBOC_Int2<>mrNo)and(EBOC_Int2<>mrYes) then EBOC_Int2:=DateimanagerForm.MsgFileError(1,sDir+TSR.Name);
                Case EBOC_Int2 of mrYes,mrNo: EBOC_Bool1:=true; mrAbort: Exit; end;
              end;
            end;
          end;
          // Dateiattribut "Versteckt" entspr. setzen
          If CheckBox_DA_Hidden.State<>Attr_Hidden then begin
            If CheckBox_DA_Hidden.State=cbChecked then begin
              If not (TSR.Attr and faHidden>0) then EBOC_Bool1:=false else EBOC_Bool1:=true;
              EBOC_Int1:=TSR.Attr+faHidden
            end else begin
              If (TSR.Attr and faHidden>0) then EBOC_Bool1:=false else EBOC_Bool1:=true;
              EBOC_Int1:=TSR.Attr-faHidden
            end;
            While not EBOC_Bool1 do begin
              If FileSetAttr(sDir+TSR.Name,EBOC_Int1)=0 then EBOC_Bool1:=true else begin
                If (EBOC_Int2<>mrNo)and(EBOC_Int2<>mrYes) then EBOC_Int2:=DateimanagerForm.MsgFileError(2,sDir+TSR.Name);
                Case EBOC_Int2 of mrYes,mrNo: EBOC_Bool1:=true; mrAbort: Exit; end;
              end;
            end;
          end;
          // Dateiattribut "Archiv" entspr. setzen
          If CheckBox_DA_Archiv.State<>Attr_Archiv then begin
            If CheckBox_DA_Archiv.State=cbChecked then begin
              If not (TSR.Attr and faArchive>0) then EBOC_Bool1:=false else EBOC_Bool1:=true;
              EBOC_Int1:=TSR.Attr+faArchive;
            end else begin
              If (TSR.Attr and faArchive>0) then EBOC_Bool1:=false else EBOC_Bool1:=true;
              EBOC_Int1:=TSR.Attr-faArchive;
            end;
            While not EBOC_Bool1 do begin
              If FileSetAttr(sDir+TSR.Name,EBOC_Int1)=0 then EBOC_Bool1:=true else begin
                If (EBOC_Int2<>mrNo)and(EBOC_Int2<>mrYes) then EBOC_Int2:=DateimanagerForm.MsgFileError(3,sDir+TSR.Name);
                Case EBOC_Int2 of mrYes,mrNo: EBOC_Bool1:=true; mrAbort: Exit; end;
              end;
            end;
          end;
        end;
        If EBOC_Int2=mrYes then EBOC_Int2:=mrOk;
        DosError:=FindNext(TSR);
      end;
      FindClose(TSR);
      If not SearchOnlyFiles then begin
        // Unterverzeichnisse suchen
        DosError:=FindFirst(sDir+'\*.*',faDirectory,TSR);
        While DosError=0 do begin
          If(TSR.Attr and faDirectory=faDirectory) and (TSR.Name[1]<>'.') then DoneSetSelObjectAttr(sDir+TSR.Name,sName,false); // rekursiv !
          If EBOC_Int2=mrAbort then Exit;
          DosError:=FindNext(TSR);
        end;
        FindClose(TSR);
      end;
    end;
  begin
    For SSOA_Int1:=0 to DateimanagerForm.FileList.Items.Count-1 do begin
      If DateimanagerForm.FileList.Items[SSOA_Int1].Selected then begin
        SSOA_Str1:=DateimanagerForm.FileList.Directory+DateimanagerForm.FileList.Items[SSOA_Int1].Caption;
        If FileExists(SSOA_Str1) then DoneSetSelObjectAttr(ExtractFilePath(SSOA_Str1),ExtractFileName(SSOA_Str1),true)
        else If DirectoryExists(SSOA_Str1) then DoneSetSelObjectAttr(SSOA_Str1,'*.*',false);
      end;
    end;
  end;
begin
  If (CheckBox_DA_ReadOnly.State<>Attr_ReadOnly)or(CheckBox_DA_Hidden.State<>Attr_Hidden)or(CheckBox_DA_Archiv.State<>Attr_Archiv) then begin
    // Bei Modifikation der Dateiattribute, nderungen entsprechend setzen
    Caption:='Setze Dateiattribute. Bitte warten...';
    Update;
    EBOC_Int2:=mrOk;

    {
    nocht BKOC_Int1 entspr. setzen und verabeiten...
    dann eventuell FehlerMsg: Konnte Attribute nicht setzen:
    "wiederholen" "berspringen" "alle iggnorieren" "abbrechen" "hilfe"
    <-> direkt dialog fr eigenschaften, kopieren, verschieben, lschen & entpacken
    }

    SetSelectedObjectAttr;
    If EBOC_Int2=mrAbort then Exit;

  end;
  ModalResult:=mrOk;
end;

// Button "Hilfe" OnClick
PROCEDURE TDateimanager_EigenschaftenForm.Button_Hilfe_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

END.
