{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# DATEIMANAGER_DELETE.PAS - Dateimanager_DeleteForm                                      #
# Dateimanager - markierte Objekte lschen                                               #
#########################################################################################}

UNIT Dateimanager_Delete;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     StdCtrls, ExtCtrls, FileCtrl, Buttons, ShellApi,
     Dateimanager;

Type
  TDateimanager_DeleteForm = class(TGradientForm)
    Button_Starten: TBitBtn;
    Button_Abbrechen: TBitBtn;
    Button_Hilfe: TBitBtn;
    Panel1: TPanel;
    Image_Papierkorb: TImage;
    Label1: TLabel;
    Label2: TLabel;
    procedure OnCreate(Sender: TObject);
    procedure Button_Hilfe_OnClick(Sender: TObject);
    procedure Button_Ja_OnClick(Sender: TObject);
  end;

Var Dateimanager_DeleteForm: TDateimanager_DeleteForm;

IMPLEMENTATION

Uses Msg_DM_FileError;

{$R *.DFM}

// Initialisieren - OnCreate
PROCEDURE TDateimanager_DeleteForm.OnCreate(Sender: TObject);
begin
  Case DateimanagerForm.FileList.SelCount of
    0: begin
         Label1.Caption:='Es wurde keine Objekte markiert, welche gelscht';
         Label2.Caption:='werden knnten.';
         Button_Starten.Enabled:=false;
       end;
    1: begin
         Label1.Caption:='Soll "'+DateimanagerForm.FileList.Selected.Caption+'" wirklich';
         Label2.Caption:='in den Papierkorb verschoben werden ?';
       end;
    else begin
         Label1.Caption:='Sollen diese '+IntToStr(DateimanagerForm.FileList.SelCount)+' markierten Objekte wirklich';
         Label2.Caption:='in den Papierkorb verschoben werden ?';
       end;
  end;
end;

// Button "Hilfe" OnClick
PROCEDURE TDateimanager_DeleteForm.Button_Hilfe_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

// Button "Ja" OnClick
PROCEDURE TDateimanager_DeleteForm.Button_Ja_OnClick(Sender: TObject);
var BSOC_Bool1, BSOC_Bool2: boolean; BSOC_Int1: integer; BSOC_Str1: string;
  // Verschiebt eine oder mehrere Datei in den Papierkorb (mittels Win32-API Aufruf)
  function RecycleFile(FileToRecycle: string): boolean;
  var C1: array[0..255] of char; SHFOS: tshfileopstruct;
  begin
    FillChar(C1,SizeOf(C1),0);
    StrPCopy(C1,FileToRecycle+#0#0);
    With SHFOS do begin
      Wnd:=0;
      wFunc:=FO_DELETE;
      pFrom:=C1;
      pTo:=nil;
      fFlags:=FOF_ALLOWUNDO OR FOF_NOCONFIRMATION OR FOF_SIMPLEPROGRESS;
      fAnyOperationsAborted:=true;
      hNameMappings:=nil;
    end;
    Result:=ShFileOperation(SHFOS)=0;
  end;
begin
  Cursor:=crHourGlass;
  Caption:='Lsche markierte Objekte. Bitte warten...';
  BSOC_Bool2:=true;
  For BSOC_Int1:=0 to DateimanagerForm.FileList.Items.Count-1 do begin
    If DateimanagerForm.FileList.Items[BSOC_Int1].Selected then begin
      BSOC_Str1:=DateimanagerForm.FileList.Directory+DateimanagerForm.FileList.Items[BSOC_Int1].Caption;
      Repeat
        If not RecycleFile(BSOC_Str1) then begin
          If BSOC_Bool2 then begin
            With TMsg_DM_FileErrorForm.Create(Self) do try
              Caption:='Dateifehler: Objekt konnte nicht gelscht werden...';
              If FileExists(BSOC_Str1) then Label1.Caption:='Die folgende Datei konnte nicht gelscht werden.'
              else Label1.Caption:='Das folgende Verzeichnis konnte nicht gelscht werden.';
              Label2.Caption:='Was machen ?'; Label3.Caption:=''; Label4.Caption:=BSOC_Str1;
              HelpContext:=130;
              Case ShowModal of mrRetry: BSOC_Bool1:=false; mrYes: BSOC_Bool1:=true;
                mrNo: BSOC_Bool2:=false; mrAbort: begin Cursor:=crDefault; Exit; end; end;
            finally Free; end;
          end;
        end else BSOC_Bool1:=true;
      until BSOC_Bool1;
    end;
  end;
  ModalResult:=mrOk;
  Cursor:=crDefault;
end;

END.
