{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# DATEIMANAGER_COPYMOVE.PAS - TDateimanager_CopyMoveForm                                 #
# Dateimanager - Markierte Objekte kopieren bzw. verschieben                             #
#########################################################################################}

UNIT Dateimanager_CopyMove;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     StdCtrls, FileCtrl, Buttons, ShellApi,
     Globals, Main, Dateimanager, CopyFile, ExtCtrls, Gauges;

Type
  TDateimanager_CopyMoveForm = class(TGradientForm)
    Button_Starten: TBitBtn;
    Button_Abbrechen: TBitBtn;
    Button_Hilfe: TBitBtn;
    Panel_Step1: TPanel;
    Label_AnzahlObjekte: TLabel;
    Label1: TLabel;
    Label_QuellDir: TLabel;
    GroupBox_ZielDir: TGroupBox;
    Label_ZielLWfrei: TLabel;
    Edit_ZielDir: TEdit;
    DriveComboBox_ZielLW: TDriveComboBox;
    DirectoryListBox_ZielDir: TDirectoryListBox;
    CheckBox_UeberschreibenFragen: TCheckBox;
    Panel_Step2: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Panel_Step3: TPanel;
    Label_KopiereVerschiebe: TLabel;
    Label_Quell: TLabel;
    Label6: TLabel;
    Label_Ziel: TLabel;
    Gauge: TGauge;
    procedure OnShow(Sender: TObject);
    procedure Edit_ZielDir_OnChange(Sender: TObject);
    procedure DriveComboBox_ZielLW_OnChange(Sender: TObject);
    procedure DirectoryListBox_ZielDir_OnChange(Sender: TObject);
    procedure Button_Hilfe_OnClick(Sender: TObject);
    procedure Button_Starten_OnClick(Sender: TObject);
  end;

Var MoveFile: boolean;
    AnzahlAlreadyCopyMoveBytes, AnzahlTotalCopyMoveBytes: integer;
    Dateimanager_CopyMoveForm: TDateimanager_CopyMoveForm;

IMPLEMENTATION

Uses Msg_DM_FileError, Msg_DM_DirError, Msg_CopyMove_OverirdeFile;

{$R *.DFM}

// Initialisieren - OnShow
PROCEDURE TDateimanager_CopyMoveForm.OnShow(Sender: TObject);
begin
  If MoveFile then begin
    // Formular entspr. fr verschieben setzen
    Caption:='Verschieben';
    Hint:='Markierte Objekte verschieben';
    Button_Starten.Hint:='Verschieben der markierten Objekte starten';
    Button_Abbrechen.Hint:='Verschieben abbrechen';
    HelpContext:=206;  
  end else begin
    // Formular entspr. fr kopieren setzen
    Caption:='Kopieren';
    Hint:='Markierte Objekte kopieren';
    Button_Starten.Hint:='Kopieren der markierten Objekte starten';
    Button_Abbrechen.Hint:='Kopieren abbrechen';
    HelpContext:=205;
  end;
  // brige Werte entspr. setzen
  Hint:=Hint;
  If DateimanagerForm.FileList.SelCount>0 then Label_AnzahlObjekte.Caption:=IntToStr(DateimanagerForm.FileList.SelCount)+' Objekt(e) markiert.' else begin
    If MoveFile then Label_AnzahlObjekte.Caption:='Fehler: Keine Objekte markiert die verschoeben werden knnten...'
    else Label_AnzahlObjekte.Caption:='Fehler: Keine Objekte markiert die kopiert werden knnten...';
    Label_AnzahlObjekte.Font.Color:=clRed;
    Button_Starten.Enabled:=false;
  end;
  Label_QuellDir.Caption:=LowerCase(DateimanagerForm.FileList.Directory);
end;

// Edit_ZielDir OnChange
PROCEDURE TDateimanager_CopyMoveForm.Edit_ZielDir_OnChange(Sender: TObject);
var EZDOC_Str1, EZDOC_Str2: string;
begin
  If DirectoryExists(Edit_ZielDir.Text) then begin
    If DateimanagerForm.FileList.SelCount>0 then Button_Starten.Enabled:=true;
    EZDOC_Str1:=LowerCase(Edit_ZielDir.Text);
    If EZDOC_Str1[Length(EZDOC_Str1)]<>'\' then EZDOC_Str1:=EZDOC_Str1+'\';
    EZDOC_Str2:=LowerCase(DirectoryListBox_ZielDir.Directory);
    If EZDOC_Str2[Length(EZDOC_Str2)]<>'\' then EZDOC_Str2:=EZDOC_Str2+'\';
    If EZDOC_Str1<>EZDOC_Str2 then begin
      DirectoryListBox_ZielDir.Directory:=EZDOC_Str1;
      If LowerCase(EZDOC_Str1[1])<>LowerCase(DriveComboBox_ZielLW.Drive) then DriveComboBox_ZielLW.Drive:=EZDOC_Str1[1];
    end;
  end else begin
    If Edit_ZielDir.Text='' then Button_Starten.Enabled:=false else begin
      If DateimanagerForm.FileList.SelCount>0 then Button_Starten.Enabled:=true;
    end;
  end;
end;

// DriveComboBox_ZielLW OnChange
PROCEDURE TDateimanager_CopyMoveForm.DriveComboBox_ZielLW_OnChange(Sender: TObject);
begin
  If Length(Edit_ZielDir.Text)>0 then begin
    If DriveComboBox_ZielLW.Drive<>Edit_ZielDir.Text[1] then Edit_ZielDir.Text:=DriveComboBox_ZielLW.Drive+':\';
  end else Edit_ZielDir.Text:=DriveComboBox_ZielLW.Drive+':\';
  Label_ZielLWfrei.Caption:=IntToStr(DiskFree(0) div 1048576)+' MB frei auf dem Ziellaufwerk.';
end;

// DirectoryListBox_ZielDir OnChange
PROCEDURE TDateimanager_CopyMoveForm.DirectoryListBox_ZielDir_OnChange(Sender: TObject);
var DLBZDOC_Str1, DLBZDOC_Str2: string;
begin
  DLBZDOC_Str1:=LowerCase(Edit_ZielDir.Text);
  If Length(DLBZDOC_Str1)>0 then If DLBZDOC_Str1[Length(DLBZDOC_Str1)]<>'\' then DLBZDOC_Str1:=DLBZDOC_Str1+'\';
  DLBZDOC_Str2:=LowerCase(DirectoryListBox_ZielDir.Directory);
  If DLBZDOC_Str2[Length(DLBZDOC_Str2)]<>'\' then DLBZDOC_Str2:=DLBZDOC_Str2+'\';
  If DLBZDOC_Str1<>DLBZDOC_Str2 then Edit_ZielDir.Text:=DLBZDOC_Str2;
end;

// Button "Hilfe" OnClick
PROCEDURE TDateimanager_CopyMoveForm.Button_Hilfe_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

// Button "Starten" OnClick
PROCEDURE TDateimanager_CopyMoveForm.Button_Starten_OnClick(Sender: TObject);
var BSOC_IgnoreAllCopyMoveErrors: boolean; BSOC_Int1: integer; BSOC_QuellDir, BSOC_QuellSubStr: string;
  // Stellt wieder den ursprnglichen Zustand des Formulares und deren Objekte her
  procedure SetBeginViewStyle;
  begin
    Button_Starten.Show; Button_Abbrechen.Show; Button_Hilfe.Show;
    Panel_Step2.Hide; Panel_Step3.Hide;
    Update;
  end;
  // Liefert die Gre in Bytes der markierten Objekte und deren untergeorneten Objekte zurck
  function GetSelectedObjektsSize: integer;
  var GSOS_Int1: integer; GSOS_Str1: string;
    procedure DoneSelObjectSize(sDir,sName: string; SearchOnlyFiles: boolean);
    var DosError: integer; TSR: tSearchRec;
    begin
      If sDir>'' then If sDir[Length(sDir)]<>'\' then sDir:=sDir+'\';
      // Dateien suchen
      DosError:=FindFirst(sDir+sName,faAnyFile mod faDirectory,TSR);
      While DosError=0 do begin
        If (TSR.Attr and faDirectory)=0 then inc(Result,TSR.Size);
        DosError:=FindNext(TSR);
      end;
      FindClose(TSR);
      // Unterverzeichnisse suchen
      If not SearchOnlyFiles then begin
        DosError:=FindFirst(sDir+'\*.*',faDirectory,TSR);
        While DosError=0 do begin
          If (TSR.Attr and faDirectory=faDirectory) and (TSR.Name[1]<>'.') then
            DoneSelObjectSize(sDir+TSR.Name,sName,false); // rekursiv !
          DosError:=FindNext(TSR);
        end;
        FindClose(TSR);
      end;
    end;
  begin
    Result:=0;
    For GSOS_Int1:=0 to DateimanagerForm.FileList.Items.Count-1 do begin
      If DateimanagerForm.FileList.Items[GSOS_Int1].Selected then begin
        GSOS_Str1:=DateimanagerForm.FileList.Directory+DateimanagerForm.FileList.Items[GSOS_Int1].Caption;
        If FileExists(GSOS_Str1) then DoneSelObjectSize(ExtractFilePath(GSOS_Str1),ExtractFileName(GSOS_Str1),true)
        else If DirectoryExists(GSOS_Str1) then DoneSelObjectSize(GSOS_Str1,'*.*',false);
      end;
    end;
  end;
  // Kopiert/Verschiebt die angegebene Datei SourceFile nach TargetFile
  function DoneCopyMoveFile(SourceFile, TargetFile: string): boolean;
  var DCMF_Bool1: boolean; DCMF_Int1: integer;
    // Kopiert/Verschiebt die Datei mittels des Win32-API's
    function Win32Api_CopyMoveFile(MoveTheFile: boolean): boolean;
    var C1, C2: array[0..255] of char; SHFOS: tshfileopstruct;
    begin
      FillChar(C1,SizeOf(C1),0); StrPCopy(C1,SourceFile+#0#0);
      FillChar(C2,SizeOf(C2),0); StrPCopy(C2,TargetFile+#0#0);
      With SHFOS do begin
        Wnd:=0;
        If MoveTheFile then wFunc:=FO_MOVE else wFunc:=FO_COPY;
        pFrom:=C1;
        pTo:=C2;
        fFlags:=FOF_ALLOWUNDO OR FOF_NOCONFIRMATION OR FOF_SIMPLEPROGRESS;
        fAnyOperationsAborted:=true;
        hNameMappings:=nil;
      end;
      Result:=ShFileOperation(SHFOS)=0;
    end;
  begin
    Label_Quell.Caption:=LowerCase(SourceFile); Label_Quell.Update;
    Label_Ziel.Caption:=LowerCase(TargetFile); Label_Ziel.Update;
    Result:=true;
    If CheckBox_UeberschreibenFragen.Checked then begin
      // berprfen ob Zieldatei eventuell bereits existiert und ggf. nachfragen ob diese berschrieben werden soll
      If FileExists(TargetFile) then begin
        With TMsg_CopyMove_OverrideFileForm.Create(Self) do try
          Label_Dateiname1.Caption:=LowerCase(TargetFile);
          Label_Dateigroesse1.Caption:=FormatInteger(GetFileSizeInByte(TargetFile));
          Label_Dateizeit1.Caption:=DateTimeToStr(FileDateToDateTime(FileAge(TargetFile)));
          Label_Dateiname2.Caption:=LowerCase(SourceFile);
          Label_Dateigroesse2.Caption:=FormatInteger(GetFileSizeInByte(SourceFile));
          Label_Dateizeit2.Caption:=DateTimeToStr(FileDateToDateTime(FileAge(SourceFile)));
          If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
          DCMF_Int1:=ShowModal;
        finally Free; end;
        Case DCMF_Int1 of
          mrYes: CheckBox_UeberschreibenFragen.Checked:=false; // Button "Alle berschreiben"
          mrIgnore: Exit; // Button "berspringen"
          mrCancel: begin Result:=false; Exit; end; // Button "Abbrechen"
        end;
      end;
    end;
    Repeat
      DCMF_Bool1:=true; DCMF_Int1:=mrOk;
      If not Win32Api_CopyMoveFile(MoveFile) then begin
        If not BSOC_IgnoreAllCopyMoveErrors then begin
          With TMsg_DM_FileErrorForm.Create(Self) do try
            If MoveFile then begin
              Caption:='Dateifehler: Konnte Datei nicht verschieben...';
              Label1.Caption:='Die angegebene Datei konnte nicht verschoeben werden.';
            end else begin
              Caption:='Dateifehler: Konnte Datei nicht kopieren...';
              Label1.Caption:='Die angegebene Datei konnte nicht kopiert werden.';
            end;
            Label2.Caption:='Zieldatei: '+LowerCase(TargetFile);
            Label3.Caption:='Was machen ?';
            Label4.Caption:=LowerCase(SourceFile);
            HelpContext:=133;
            DCMF_Int1:=ShowModal;
          finally Free; end;
          Case DCMF_Int1 of
            mrRetry: DCMF_Bool1:=false;
            mrNo: begin BSOC_IgnoreAllCopyMoveErrors:=true; DCMF_Int1:=mrYes; end;
            mrCancel: begin Result:=false; Exit; end;
          end;
        end else DCMF_Int1:=mrYes;
      end;
    until DCMF_Bool1;
    If DCMF_Int1<>mrYes then begin
      inc(AnzahlAlreadyCopyMoveBytes,GetFileSizeInByte(TargetFile));
      Gauge.Progress:=GetProcent(AnzahlTotalCopyMoveBytes,AnzahlAlreadyCopyMoveBytes);
      Gauge.Update;
    end;
  end;
  // Kopiert/Verschiebt das angegebene Verzeichnis und alle seine untergeordneten Objekte
  function DoneCopyMoveDir(SubDir: string): boolean;
  var DosError: integer; TSR: Tsearchrec;
  begin
    Result:=true;
    If SubDir[1]='\' then Delete(SubDir,1,1);
    If SubDir[Length(SubDir)]<>'\' then SubDir:=SubDir+'\';
    // Ggf. aktuelles Zielverzeichnis erstellen
    If not DirectoryExists(Edit_ZielDir.Text+SubDir) then begin
      If not XMkDir(Edit_ZielDir.Text+SubDir) then begin
        With TMsg_DirErrorForm.Create(Self) do try
          If MoveFile then Label4.Caption:='nicht verschoben werden.' else Label4.Caption:='nicht kopiert werden.';
          DirLabel.Caption:=LowerCase(Edit_ZielDir.Text+SubDir);
          If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
          DosError:=ShowModal;
        finally Free; end;
        If DosError=mrOk then Exit else begin Result:=false; Exit; end;
      end;
    end;
    // Dateien innerhalb des aktuellen Verzeichnisses kopieren/verschieben
    DosError:=FindFirst(BSOC_QuellDir+SubDir+'*.*',faAnyFile mod faDirectory,TSR);
    While DosError=0 do begin
      If (TSR.Attr and faDirectory)=0 then begin
        If not DoneCopyMoveFile(BSOC_QuellDir+SubDir+TSR.Name,Edit_ZielDir.Text+SubDir+TSR.Name) then begin Result:=false; Exit; end;
      end;
      DosError:=FindNext(TSR);
    end;
    FindClose(TSR);
    // Verzeichnisse abklappern
    DosError:=FindFirst(BSOC_QuellDir+SubDir+'*.*',faDirectory,TSR);
    While DosError=0 do begin
      If ((TSR.Attr and faDirectory)=faDirectory) and (TSR.Name[1]<>'.') then begin
        If not DoneCopyMoveDir(SubDir+TSR.Name) then begin Result:=false; Exit; end; // Rekursiv !
        If MoveFile then begin {$I-} RmDir(BSOC_QuellDir+SubDir+TSR.Name); {$I+} end;
      end;
      DosError:=FindNext(TSR);
    end;
    FindClose(TSR);
  end;
begin
  If Edit_ZielDir.Text[Length(Edit_ZielDir.Text)]<>'\' then Edit_ZielDir.Text:=Edit_ZielDir.Text+'\';
  // Ggf. Zielverzeichnis erstellen
  If not DirectoryExists(Edit_ZielDir.Text) then begin
    If not XMkDir(Edit_ZielDir.Text) then begin
      If MoveFile then MainForm.MsgDlg(77) else MainForm.MsgDlg(76);
      Exit;
    end;
  end;
  // Vorbereitungen zum berechnen des Platzbedarfes
  Button_Starten.Hide; Button_Abbrechen.Hide; Button_Hilfe.Hide;
  Panel_Step2.Show;
  Update;
  // Platzbedarf berechnen und auswerten
  AnzahlTotalCopyMoveBytes:=GetSelectedObjektsSize;
  If AnzahlTotalCopyMoveBytes>=DiskFree(Ord(UpCase(Edit_ZielDir.Text[1]))-64) then begin
    If MainForm.MsgDlg(75)<>mrYes then begin SetBeginViewStyle; Exit; end;
  end;
  // Vorbereitungen zum kopieren/verschieben
  If MoveFile then Label_KopiereVerschiebe.Caption:='Verschiebe Datei'
  else Label_KopiereVerschiebe.Caption:='Kopiere Datei';
  AnzahlAlreadyCopyMoveBytes:=0;
  Button_Abbrechen.Show;
  Panel_Step3.Show;
  Update;
  BSOC_IgnoreAllCopyMoveErrors:=false;
  // Markierte Objekte kopieren/verschieben
  BSOC_QuellDir:=DateimanagerForm.FileList.Directory;
  If BSOC_QuellDir[Length(BSOC_QuellDir)]<>'\' then BSOC_QuellDir:=BSOC_QuellDir+'\';
  For BSOC_Int1:=0 to DateimanagerForm.FileList.Items.Count-1 do begin
    If DateimanagerForm.FileList.Items[BSOC_Int1].Selected then begin
      BSOC_QuellSubStr:=DateimanagerForm.FileList.Items[BSOC_Int1].Caption;
      If Length(BSOC_QuellSubStr)>0 then begin
        If FileExists(BSOC_QuellDir+BSOC_QuellSubStr) then begin
          If not DoneCopyMoveFile(BSOC_QuellDir+BSOC_QuellSubStr,Edit_ZielDir.Text+BSOC_QuellSubStr) then begin
            SetBeginViewStyle; If MoveFile then MainForm.MsgDlg(81) else MainForm.MsgDlg(80); Exit;
          end;
        end else
        If DirectoryExists(BSOC_QuellDir+BSOC_QuellSubStr) then begin
          If not DoneCopyMoveDir(BSOC_QuellSubStr) then begin
            SetBeginViewStyle; If MoveFile then MainForm.MsgDlg(81) else MainForm.MsgDlg(80); Exit;
          end else If MoveFile then begin {$I-} RmDir(BSOC_QuellDir+BSOC_QuellSubStr); {$I+} end;
        end;
      end;
    end;
  end;
  // Auswertung
  If AnzahlAlreadyCopyMoveBytes=AnzahlTotalCopyMoveBytes then begin
    If MoveFile then MainForm.MsgDlg(83) else MainForm.MsgDlg(82);
  end else begin
    If MoveFile then MainForm.MsgDlg(85) else MainForm.MsgDlg(84);
  end;
  ModalResult:=mrOk;
end;

END.
