{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# DATEIMANAGER.PAS - TDateiManagerForm                                                   #
# Aktion - Interner Dateimanager                                                         #
#########################################################################################}

UNIT Dateimanager;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     StdCtrls, ExtCtrls, ComCtrls, FileCtrl, Buttons, Menus, FileList, ShellAPI,
     Splash, Globals, Main;

Type
  TDateimanagerForm = class(TGradientForm)
    StatusBar: TStatusBar;
    ButtonPanel: TPanel;
    Button_Kopieren: TBitBtn;
    Button_Verschieben: TBitBtn;
    Button_Loeschen: TBitBtn;
    Button_MkDir: TBitBtn;
    Button_Entpacken: TBitBtn;
    Button_Eigenschaften: TBitBtn;
    FileList: TFileList;
    FilterComboBox: TFilterComboBox;
    Button_IconSmall: TSpeedButton;
    Button_IconList: TSpeedButton;
    Button_IconReport: TSpeedButton;
    Button_IconBig: TSpeedButton;
    Button_Select: TSpeedButton;
    Button_Refresh: TSpeedButton;
    Button_Sortieren: TSpeedButton;
    Button_UpperDir: TSpeedButton;
    DriveComboBox: TDriveComboBox;
    Button_Back: TSpeedButton;
    PopupMenu_Sortieren: TPopupMenu;
    PopupMenu_Markieren: TPopupMenu;
    PopupMenu_Sortieren_Name: TMenuItem;
    PopupMenu_Sortieren_Erweiterung: TMenuItem;
    PopupMenu_Sortieren_Typ: TMenuItem;
    PopupMenu_Sortieren_Groesse: TMenuItem;
    PopupMenu_Sortieren_DatumUhrzeit: TMenuItem;
    PopupMenu_Markieren_GruppeMarkieren: TMenuItem;
    PopupMenu_Markieren_MarkierungUmkehren: TMenuItem;
    PopupMenu_Markieren_KeineObjekteMarkieren: TMenuItem;
    PopupMenu_Markieren_AlleObjekteMarkieren: TMenuItem;
    Edit_Directory: TEdit;
    PopupMenu_FileList: TPopupMenu;
    PopupMenu_FileList_Oeffnen: TMenuItem;
    PopupMenu_FileList_N1: TMenuItem;
    PopupMenu_FileList_Kopieren: TMenuItem;
    PopupMenu_FileList_Verschieben: TMenuItem;
    PopupMenu_FileList_Loeschen: TMenuItem;
    PopupMenu_FileList_RarEntpacken: TMenuItem;
    PopupMenu_FileList_N2: TMenuItem;
    PopupMenu_FileList_VerzeichnisErstellen: TMenuItem;
    PopupMenu_FileList_N3: TMenuItem;
    PopupMenu_FileList_Eigenschaften: TMenuItem;
    PopupMenu_Entpacken: TPopupMenu;
    PopupMenu_Entpacken_ZipArchiv: TMenuItem;
    PopupMenu_Entpacken_RarArchiv: TMenuItem;
    PopupMenu_FileList_ZipEntpacken: TMenuItem;
    procedure OnCreate(Sender: TObject);
    procedure OnShow(Sender: TObject);
    procedure OnActivate(Sender: TObject);
    procedure OnClose(Sender: TObject; var Action: TCloseAction);
    procedure OnResize(Sender: TObject);
    procedure ButtonPanel_OnResize(Sender: TObject);
    procedure StatusBar_OnResize(Sender: TObject);
    procedure FileList_OnMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure Edit_Directory_OnMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    // OnChange
    procedure DriveComboBox_OnChange(Sender: TObject);
    procedure FilterComboBox_OnChange(Sender: TObject);
    procedure FileList_OnChanging(Sender: TObject; Item: TListItem; Change: TItemChange; var AllowChange: Boolean);
    procedure FileList_OnChange(Sender: TObject; Item: TListItem; Change: TItemChange);
    // OnClick
    procedure Button_Back_OnClick(Sender: TObject);
    procedure Button_UpperDir_OnClick(Sender: TObject);
    procedure Button_Refresh_OnClick(Sender: TObject);
    procedure Button_Sortieren_OnClick(Sender: TObject);
    procedure Button_Select_OnClick(Sender: TObject);
    procedure Button_IconBig_OnClick(Sender: TObject);
    procedure Button_IconSmall_OnClick(Sender: TObject);
    procedure Button_IconList_OnClick(Sender: TObject);
    procedure Button_IconReport_OnClick(Sender: TObject);
    procedure PopupMenu_Sortieren_OnClick(Sender: TObject);
    procedure PopupMenu_Markieren_GruppeMarkieren_OnClick(Sender: TObject);
    procedure PopupMenu_Markieren_MarkierungUmkehren_OnClick(Sender: TObject);
    procedure PopupMenu_Markieren_KeineObjekteMarkieren_OnClick(Sender: TObject);
    procedure PopupMenu_Markieren_AlleObjekteMarkieren_OnClick(Sender: TObject);
    procedure Edit_Directory_OnKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    // FileList
    procedure FileList_OnMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FileList_OnDblClick(Sender: TObject);
    procedure FileList_OnKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FileList_OnEdited(Sender: TObject; Item: TListItem; var S: string);
    // Aktionen
    procedure Button_Kopieren_OnClick(Sender: TObject);
    procedure Button_Verschieben_OnClick(Sender: TObject);
    procedure Button_Loeschen_OnClick(Sender: TObject);
    procedure Button_Entpacken_OnClick(Sender: TObject);
    procedure PopupMenu_Entpacken_ZipArchiv_OnClick(Sender: TObject);
    procedure PopupMenu_Entpacken_RarArchiv_OnClick(Sender: TObject);
    procedure Button_MkDir_OnClick(Sender: TObject);
    procedure Button_Eigenschaften_OnClick(Sender: TObject);
  private
    procedure SetDirectoryEdit;
    procedure SetBackState;
  public
    function MsgFileError(MsgNr: byte; MsgFileStr: string): integer;
    procedure ExecuteFileCom(ComToExecute,Parameter: string);
  end;

Var Dateimanager_SelBool: boolean;
    Dateimanager_SelBytes: longint;
    Dateimanager_Str1: string;
    Dateimanager_BackList: Tstringlist;
    DateimanagerForm: TDateimanagerForm;

IMPLEMENTATION

Uses Msg_DM_FileError, Dateimanager_MarkGroup, Dateimanager_CopyMove, Dateimanager_Delete,
     Dateimanager_MkDir, Dateimanager_Eigenschaften, Unrar, Unzip;

{$R *.DFM}

// Initialisieren- OnCreate
PROCEDURE TDateimanagerForm.OnCreate(Sender: TObject);
begin
  SplashForm.ProgressBar.Position:=50; SplashForm.Update;
  Case Dateimanager_ShowIcon of
    vsIcon: begin Button_IconBig.Down:=true; FileList.ViewStyle:=vsIcon; end;
    vsSmallIcon: begin Button_IconSmall.Down:=true; FileList.ViewStyle:=vsSmallIcon; end;
    vsList: begin Button_IconList.Down:=true; FileList.ViewStyle:=vsList; end;
    vsReport: begin Button_IconReport.Down:=true; FileList.ViewStyle:=vsReport; end;
  end;
  SplashForm.ProgressBar.Position:=53; SplashForm.Update;
end;

// Initialisieren - OnShow
PROCEDURE TDateimanagerForm.OnShow(Sender: TObject);
begin
  Dateimanager_SelBytes:=0;
  Button_Back.Enabled:=false;
  Button_Back.Hint:='Zurck';
  Dateimanager_BackList:=Tstringlist.Create;
  FileList.Hint:='';
  Edit_Directory.Hint:='';
end;

// Initialisieren - OnActivate
PROCEDURE TDateimanagerForm.OnActivate(Sender: TObject);
var OA_Int1: integer; OA_Str1: string;
begin
  FileList.Directory:=ExtractFilePath(Dateimanager_Str1);
  If FileExists(Dateimanager_Str1) then begin
    OA_Str1:=LowerCase(ExtractFileName(Dateimanager_Str1));
    For OA_Int1:=0 to FileList.Items.Count-1 do
      If LowerCase(FileList.Items[OA_Int1].Caption)=OA_Str1 then FileList.Selected:=FileList.Items[OA_Int1];
    If FileList.Selected<>nil then FileList.Selected.MakeVisible(false);
  end;
  DriveComboBox.Drive:=FileList.Directory[1];
  SetDirectoryEdit;
end;

// OnClose des Formulares
PROCEDURE TDateimanagerForm.OnClose(Sender: TObject; var Action: TCloseAction);
begin
  FileList.Directory:='';
  Edit_Directory.Text:='';
  If Button_Back.Enabled then Button_Back.Enabled:=false;
  If Button_UpperDir.Enabled then Button_UpperDir.Enabled:=false;
  Dateimanager_BackList.Free;
end;

// OnResize des Formulares
PROCEDURE TDateimanagerForm.OnResize(Sender: TObject);
begin  
  FileList.SetBounds(0,28,Width-8,Height-124);
  Edit_Directory.SetBounds(1,Height-96,Width-10,20);
end;

// OnResize des ButtonPanel
PROCEDURE TDateimanagerForm.ButtonPanel_OnResize(Sender: TObject);
var BOPR_Int1, BOPR_Int2: integer;
begin
  BOPR_Int1:=(ButtonPanel.Width-10) div 6;
  BOPR_Int2:=ButtonPanel.Width-(BOPR_Int1 * 6)-10;
  Button_Kopieren.Width:=BOPR_Int1;
  Button_Verschieben.SetBounds(Button_Kopieren.Left+BOPR_Int1,5,BOPR_Int1,19);
  Button_Loeschen.SetBounds(Button_Verschieben.Left+BOPR_Int1,5,BOPR_Int1,19);
  Button_Entpacken.SetBounds(Button_Loeschen.Left+BOPR_Int1,5,BOPR_Int1,19);
  Button_MkDir.SetBounds(Button_Entpacken.Left+BOPR_Int1,5,BOPR_Int1,19);
  Button_Eigenschaften.SetBounds(Button_MkDir.Left+BOPR_Int1,5,BOPR_Int1+BOPR_Int2,19);
end;

// OnResize der StatusBar
PROCEDURE TDateimanagerForm.StatusBar_OnResize(Sender: TObject);
begin
  If Width>=500 then begin
    DriveComboBox.Width:=(Width-270) div 2;
    Button_Refresh.Left:=DriveComboBox.Width+57;
    Button_Sortieren.Left:=Button_Refresh.Left+25;
    Button_Select.Left:=Button_Sortieren.Left+25;
    Button_IconBig.Left:=Button_Select.Left+29;
    Button_IconSmall.Left:=Button_IconBig.Left+25;
    Button_IconList.Left:=Button_IconSmall.Left+25;
    Button_IconReport.Left:=Button_IconList.Left+25;
    FilterComboBox.SetBounds(Button_IconReport.Left+28,4,Width-Button_IconReport.Left-37,21);
  end;
end;

// FileList OnMouseMove
PROCEDURE TDateimanagerForm.FileList_OnMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin FileList.Hint:=IntToStr(FileList.Items.Count)+' Objekte'; end;

// Edit_Directory OnMouseMove
PROCEDURE TDateimanagerForm.Edit_Directory_OnMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin Edit_Directory.Hint:=IntToStr(Length(Edit_Directory.Text))+' Zeichen'; end;

{------------------------------------------------------------------------------------------
OnChange
------------------------------------------------------------------------------------------}

// DriveComboBox OnChange
PROCEDURE TDateimanagerForm.DriveComboBox_OnChange(Sender: TObject);
begin
  If FileList.Directory>'' then If DriveComboBox.Drive<>FileList.Directory[1] then begin
    SetBackState;
    FileList.Directory:=DriveComboBox.Drive+':\';
    SetDirectoryEdit;
  end;
end;

// FilterComboBox OnChange
PROCEDURE TDateimanagerForm.FilterComboBox_OnChange(Sender: TObject);
begin FileList.Mask:=FilterComboBox.Mask; end;

// FileList OnChanging - Vor der Item-nderung
PROCEDURE TDateimanagerForm.FileList_OnChanging(Sender: TObject; Item: TListItem; Change: TItemChange; var AllowChange: Boolean);
begin Dateimanager_SelBool:=Item.Selected; end;

// FileList OnChange - Nach der Item-nderung
PROCEDURE TDateimanagerForm.FileList_OnChange(Sender: TObject; Item: TListItem; Change: TItemChange);
var FLOC_Int1, FLOC_Int2: integer;
begin
  StatusBar.Panels[0].Text:=IntToStr(FileList.SelCount)+' Objekt(e) markiert.';
  Case FileList.SelCount of
    0: begin StatusBar.Panels[1].Text:=''; Dateimanager_SelBytes:=0; end;
    1: begin
         Val(FileList.Selected.SubItems[0],FLOC_Int1,FLOC_Int2);
         If FLOC_Int2=0 then begin
           Dateimanager_SelBytes:=FLOC_Int1;
           StatusBar.Panels[1].Text:=FormatInteger(Dateimanager_SelBytes)+' Bytes';
         end else begin StatusBar.Panels[1].Text:=''; Dateimanager_SelBytes:=0; end;
       end;
    else begin
      Val(Item.SubItems[0],FLOC_Int1,FLOC_Int2);
      If FLOC_Int2=0 then begin
        If Item.Selected then begin
          If not Dateimanager_SelBool then inc(Dateimanager_SelBytes,FLOC_Int1)
        end else If Dateimanager_SelBool then dec(Dateimanager_SelBytes,FLOC_Int1);
        StatusBar.Panels[1].Text:=FormatInteger(Dateimanager_SelBytes)+' Bytes';
      end;
    end;
  end;
end;

{------------------------------------------------------------------------------------------
OnClick
------------------------------------------------------------------------------------------}

// Button "Zurck" OnClick
PROCEDURE TDateimanagerForm.Button_Back_OnClick(Sender: TObject);
begin
  FileList.Directory:=Dateimanager_BackList[Dateimanager_BackList.Count-1];
  If DriveComboBox.Drive<>FileList.Directory[1] then DriveComboBox.Drive:=FileList.Directory[1];
  Dateimanager_BackList.Delete(Dateimanager_BackList.Count-1);
  If Dateimanager_BackList.Count=0 then begin Button_Back.Enabled:=false; Button_Back.Hint:='Zurck'; end;
  SetDirectoryEdit;
end;

// Button "bergeordnetes Verzeichnis" OnClick
PROCEDURE TDateimanagerForm.Button_UpperDir_OnClick(Sender: TObject);
var BUPOC_Str1: string;
begin
  BUPOC_Str1:=FileList.Directory;
  Repeat Delete(BUPOC_Str1,Length(BUPOC_Str1),1); If Length(BUPOC_Str1)=0 then Exit; until BUPOC_Str1[Length(BUPOC_Str1)]='\';
  If BUPOC_Str1>'' then begin
    SetBackState;
    FileList.Directory:=BUPOC_Str1;
  end;
  SetDirectoryEdit;
end;

// Button "Ansicht aktualisieren" OnClick
PROCEDURE TDateimanagerForm.Button_Refresh_OnClick(Sender: TObject);
begin FileList.Directory:=FileList.Directory; end;

// Button "Sortieren" OnClick
PROCEDURE TDateimanagerForm.Button_Sortieren_OnClick(Sender: TObject);
begin PopupMenu_Sortieren.Popup(Left+Button_Sortieren.Left+3,Top+49); end;

// Button "Markieren" OnClick
PROCEDURE TDateimanagerForm.Button_Select_OnClick(Sender: TObject);
begin PopupMenu_Markieren.Popup(Left+Button_Select.Left+3,Top+49); end;

// Button "Groe Symbole" OnClick
PROCEDURE TDateimanagerForm.Button_IconBig_OnClick(Sender: TObject);
begin FileList.ViewStyle:=vsIcon; end;

// Button "Kleine Symbole" OnClick
PROCEDURE TDateimanagerForm.Button_IconSmall_OnClick(Sender: TObject);
begin FileList.ViewStyle:=vsSmallIcon; end;

// Button "Liste" OnClick
PROCEDURE TDateimanagerForm.Button_IconList_OnClick(Sender: TObject);
begin FileList.ViewStyle:=vsList; end;

// Button "Details" OnClick
PROCEDURE TDateimanagerForm.Button_IconReport_OnClick(Sender: TObject);
begin FileList.ViewStyle:=vsReport; end;

// Edit_Directory OnKeyDown
PROCEDURE TDateimanagerForm.Edit_Directory_OnKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
var EDOKD_Str1: string;
begin
  If Key=13 then begin
    EDOKD_Str1:=Edit_Directory.Text;
    If DirectoryExists(EDOKD_Str1) then begin
      If EDOKD_Str1[Length(EDOKD_Str1)]<>'\' then EDOKD_Str1:=EDOKD_Str1+'\';
      SetBackState;
      FileList.Directory:=EDOKD_Str1;
      If DriveComboBox.Drive<>FileList.Directory[1] then DriveComboBox.Drive:=FileList.Directory[1];
      SetDirectoryEdit;
    end;
  end;
end;

// PopupMenu_Sortieren OnClick
PROCEDURE TDateimanagerForm.PopupMenu_Sortieren_OnClick(Sender: TObject);
begin
  If PopupMenu_Sortieren_Name.Checked then PopupMenu_Sortieren_Name.Checked:=false;
  If PopupMenu_Sortieren_Erweiterung.Checked then PopupMenu_Sortieren_Erweiterung.Checked:=false;
  If PopupMenu_Sortieren_Typ.Checked then PopupMenu_Sortieren_Typ.Checked:=false;
  If PopupMenu_Sortieren_Groesse.Checked then PopupMenu_Sortieren_Groesse.Checked:=false;
  If PopupMenu_Sortieren_DatumUhrzeit.Checked then PopupMenu_Sortieren_DatumUhrzeit.Checked:=false;
  If Sender=PopupMenu_Sortieren_Name then begin FileList.SortColumn:=fiName; PopupMenu_Sortieren_Name.Checked:=true; end else
  If Sender=PopupMenu_Sortieren_Erweiterung then begin FileList.SortColumn:=fiDosExt; PopupMenu_Sortieren_Erweiterung.Checked:=true; end else
  If Sender=PopupMenu_Sortieren_Typ then begin FileList.SortColumn:=fiType; PopupMenu_Sortieren_Typ.Checked:=true; end else
  If Sender=PopupMenu_Sortieren_Groesse then begin FileList.SortColumn:=fiSize; PopupMenu_Sortieren_Groesse.Checked:=true; end else
  If Sender=PopupMenu_Sortieren_DatumUhrzeit then begin FileList.SortColumn:=fiCreated; PopupMenu_Sortieren_DatumUhrzeit.Checked:=true; end;
  Button_Refresh_OnClick(Sender);
end;

// PopupMenu_Markieren "Gruppe markieren" OnClick
PROCEDURE TDateimanagerForm.PopupMenu_Markieren_GruppeMarkieren_OnClick(Sender: TObject);
var PMMGMOC_Int1: integer; TSR: Tsearchrec;
begin
  With TDateimanager_MarkGroupForm.Create(Self) do try
    If mainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
    If ShowModal=mrOk then begin
      If CheckBox_VerzeichnisseAusschliessen.Checked then PMMGMOC_Int1:=faAnyFile else PMMGMOC_Int1:=faDirectory+faAnyFile;
      If FindFirst(FileList.Directory+MaskEdit.Text,PMMGMOC_Int1,TSR)=0 then begin
        Repeat
          For PMMGMOC_Int1:=0 to FileList.Items.Count-1 do begin
            If FileList.Items[PMMGMOC_Int1].Caption=TSR.Name then
              If not FileList.Items[PMMGMOC_Int1].Selected then FileList.Items[PMMGMOC_Int1].Selected:=true;
          end;
        until FindNext(TSR)<>0;
      end;
      FindClose(TSR);
    end;
  finally Free; end;
end;

// PopupMenu_Markieren "Markierung umkehren" OnClick
PROCEDURE TDateimanagerForm.PopupMenu_Markieren_MarkierungUmkehren_OnClick(Sender: TObject);
var PMMMUOC_Int1: integer;
begin
  For PMMMUOC_Int1:=0 to FileList.Items.Count-1 do begin
    If FileList.Items[PMMMUOC_Int1].Selected then FileList.Items[PMMMUOC_Int1].Selected:=false
    else FileList.Items[PMMMUOC_Int1].Selected:=true;
  end;
end;

// PopupMenu_Markieren "Keine Objekte markieren" OnClick
PROCEDURE TDateimanagerForm.PopupMenu_Markieren_KeineObjekteMarkieren_OnClick(Sender: TObject);
var PMMKOMOC_Int1: integer;
begin
  For PMMKOMOC_Int1:=0 to FileList.Items.Count-1 do
    If FileList.Items[PMMKOMOC_Int1].Selected then FileList.Items[PMMKOMOC_Int1].Selected:=false;
end;

// PopupMenu_Markieren "Alle Objekte markieren" OnClick
PROCEDURE TDateimanagerForm.PopupMenu_Markieren_AlleObjekteMarkieren_OnClick(Sender: TObject);
var PMMAOMOC_Int1: integer;
begin
  For PMMAOMOC_Int1:=0 to FileList.Items.Count-1 do
    If not FileList.Items[PMMAOMOC_Int1].Selected then FileList.Items[PMMAOMOC_Int1].Selected:=true;
end;

{------------------------------------------------------------------------------------------
FileList
------------------------------------------------------------------------------------------}

// FileList OnMouseDown
PROCEDURE TDateimanagerForm.FileList_OnMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  If Button=mbRight then begin
    If FileList.SelCount=0 then FileList.Selected:=FileList.GetItemAt(X,Y);
    WIth Popupmenu_FileList do begin
      Case FileList.SelCount of
        0: begin
             Items[0].Enabled:=false; Items[2].Enabled:=false; Items[3].Enabled:=false;
             Items[4].Enabled:=false; Items[5].Enabled:=false; Items[6].Enabled:=false;
             Items[10].Enabled:=false;
           end;
        1: begin
             Items[0].Enabled:=true; Items[2].Enabled:=true; Items[3].Enabled:=true;
             Items[4].Enabled:=true; Items[5].Enabled:=true; Items[6].Enabled:=true;
             Items[10].Enabled:=true;
           end;
        else begin
          Items[0].Enabled:=false; Items[2].Enabled:=true; Items[3].Enabled:=true;
          Items[4].Enabled:=true; Items[5].Enabled:=false; Items[6].Enabled:=false;
          Items[10].Enabled:=true;
        end;
      end;
    end;
    PopupMenu_FileList.Popup(Left+X+6,Top+Y+54);
  end;
end;

// FileList OnDblClick
PROCEDURE TDateimanagerForm.FileList_OnDblClick(Sender: TObject);
var FLODC_Int1: integer; FLODC_Str1: string;
begin
  If FileList.SelCount<>1 then begin
    For FLODC_Int1:=0 to FileList.Items.Count-1 do begin
      If FileList.Items[FLODC_Int1].Focused then begin
        FileList.Selected:=FileList.Items[FLODC_Int1];
        Exit;
      end;
    end;
    If FileList.Items.Count>0 then FileList.Selected:=FileList.Items[0];
    Exit;
  end;
  FLODC_Str1:=FileList.Directory+FileList.Selected.Caption;
  If FileExists(FLODC_Str1) then ExecuteFileCom(FLODC_Str1,'') else
  If DirectoryExists(FLODC_Str1) then begin
    If FLODC_Str1[Length(FLODC_Str1)]<>'\' then FLODC_Str1:=FLODC_Str1+'\';
    SetBackState;
    FileList.Directory:=FLODC_Str1;
    SetDirectoryEdit;
  end;
end;

// FileList OnKeyDown
PROCEDURE TDateimanagerForm.FileList_OnKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin If Key=13 then FileList_OnDblClick(Sender); end;

// FileList OnEditied - Nach dem editieren eines Eintrages
PROCEDURE TDateimanagerForm.FileList_OnEdited(Sender: TObject; Item: TListItem; var S: string);
var FLOE_Bool1: boolean; FLOE_File: file;
begin
  FLOE_Bool1:=false;
  If Pos('\',S)=0 then If Pos('/',S)=0 then If Pos(':',S)=0 then If Pos('*',S)=0 then If Pos('?',S)=0 then
  If Pos('"',S)=0 then If Pos('<',S)=0 then If Pos('>',S)=0 then If Pos('|',S)=0 then FLOE_Bool1:=true;
  If FLOE_Bool1 then begin
    // Datei oder Verzeichnis umbenennen
    AssignFile(FLOE_File,FileList.Directory+Item.Caption);
    {$I-} Rename(FLOE_File,FileList.Directory+S); {$I+}
    If IoResult<>0 then begin MainForm.MsgDlg(116); S:=Item.Caption; FileList.Update; end;
  end else begin MainForm.MsgDlg(115); S:=Item.Caption; FileList.Update; end;
end;

{------------------------------------------------------------------------------------------
Aktionen
------------------------------------------------------------------------------------------}

// Button "Kopieren" OnClick - markierte Objekte kopieren
PROCEDURE TDateimanagerForm.Button_Kopieren_OnClick(Sender: TObject);
begin
  With TDateimanager_CopyMoveForm.Create(Self) do try
    MoveFile:=false;
    Edit_ZielDir.Text:=StartDir;
    If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
    ShowModal;
  finally Free; end;
end;

// Button "Verschieben" OnClick - markierte Objekte verschieben
PROCEDURE TDateimanagerForm.Button_Verschieben_OnClick(Sender: TObject);
begin
  With TDateimanager_CopyMoveForm.Create(Self) do try
    MoveFile:=true;
    Edit_ZielDir.Text:=StartDir;
    If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
    ShowModal;
  finally Free; end;
end;

// Button "Lschen" OnClick - markierte Objekte in den Papierkorb verschieben
PROCEDURE TDateimanagerForm.Button_Loeschen_OnClick(Sender: TObject);
var BLOC_Int1: integer;
begin
  With TDateimanager_DeleteForm.Create(Self) do try
    If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
    If ShowModal=mrOk then Button_Refresh_OnClick(Sender);
  finally Free; end;
end;

// Button "Entpacken" OnClick - markierte Archiv-Datei entpacken
PROCEDURE TDateimanagerForm.Button_Entpacken_OnClick(Sender: TObject);
begin
  If FileList.SelCount>0 then
    PopupMenu_Entpacken.Popup(Left+Button_Entpacken.Left+4,Top+ButtonPanel.Top-12)
  else MainForm.MsgDlg(103);
end;

// PopupMenu_Entpacken "Zip-Archiv entpacken" OnClick
PROCEDURE TDateimanagerForm.PopupMenu_Entpacken_ZipArchiv_OnClick(Sender: TObject);
begin
  Screen.Cursor:=crHourGlass; ZipArchiveCom:=FileList.Directory+FileList.Selected.Caption;
  With TUnzipForm.Create(Self) do try ShowModal; finally Free; Screen.Cursor:=crDefault; end;
end;

// PopupMenu_Entpacken "Rar-Archiv entpacken" OnClick
PROCEDURE TDateimanagerForm.PopupMenu_Entpacken_RarArchiv_OnClick(Sender: TObject);
begin
  With TUnrarForm.Create(Self) do try
    RarArchiveFileCom:=StartDir[1]+':'+PrjRec.AktionStr;
    ShowModal;
  finally Free; end;
end;

// Button "MkDir" OnClick - Verzeichnis erstellen
PROCEDURE TDateimanagerForm.Button_MkDir_OnClick(Sender: TObject);
var BMDOC_Int1: integer; BMDOC_Str1: string;
begin
  With TDateimanager_MkDirForm.Create(Self) do try
    If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
    BMDOC_Int1:=ShowModal;
    If BMDOC_Int1=mrOk then BMDOC_Str1:=DirEdit.Text;
  finally Free; end;
  If BMDOC_Int1=mrOk then begin
    Button_Refresh_OnClick(Sender);
    BMDOC_Int1:=0;
    Repeat
      If FileList.Items[BMDOC_Int1].Caption=BMDOC_Str1 then begin
        FileList.Selected:=FileList.Items[BMDOC_Int1]; Exit;
      end else begin If BMDOC_Int1=FileList.Items.Count-1 then Exit else inc(BMDOC_Int1); end;
    until false;
  end;
end;

// Button "Eigenschaften" OnClick - Eigenschaften der markierten Objekte
PROCEDURE TDateimanagerForm.Button_Eigenschaften_OnClick(Sender: TObject);
begin
  With TDateimanager_EigenschaftenForm.Create(Self) do try
    If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
    ShowModal;
  finally Free; end;
end;

{------------------------------------------------------------------------------------------
Private-Deklarationen
------------------------------------------------------------------------------------------}

// Setzt gem. dem FileList.Directory Enabled/Disabeld-Status des Buttons "bergeordnetes Verzeichnis"
PROCEDURE TDateimanagerForm.SetDirectoryEdit;
begin
  If Length(FileList.Directory)>3 then begin
    If not Button_UpperDir.Enabled then Button_UpperDir.Enabled:=true;
  end else If Button_UpperDir.Enabled then Button_UpperDir.Enabled:=false;
  Edit_Directory.Text:=FileList.Directory;
end;

// Setzt die Zurck-Aktionen (Back-StringList & Back-Button)
PROCEDURE TDateimanagerForm.SetBackState;
begin
  Dateimanager_BackList.Add(FileList.Directory);
  Button_Back.Hint:=LowerCase(FileList.Directory);
  If not Button_Back.Enabled then Button_Back.Enabled:=true;
end;

{------------------------------------------------------------------------------------------
Public-Deklarationen
------------------------------------------------------------------------------------------}

// MessageBox "TMsg_DM_FileErrorForm": Dateifehler...
FUNCTION TDateimanagerForm.MsgFileError(MsgNr: byte; MsgFileStr: string): integer;
begin
  With TMsg_DM_FileErrorForm.Create(Self) do try
    Case MsgNr of
      1..3: begin // Eigenschaften - Dateiattribute konnten nicht gesetzt werden
              Caption:='Dateifehler: Dateizugriff fehlgeschlagen...';
              Case MsgNr of
                1: Label1.Caption:='Das Dateiattribut "Schreibgeschtzt" konnte bei der folgenden Datei nicht gesetzt';
                2: Label1.Caption:='Das Dateiattribut "Versteckt" konnte bei der folgenden Datei nicht gesetzt';
                3: Label1.Caption:='Das Dateiattribut "Archivdatei" konnte bei der folgenden Datei nicht gesetzt';
              end;
              Label2.Caption:='werden.'; Label3.Caption:='Wie weiterverfahren ?';
              Image_MkDir.Visible:=true;
              HelpContext:=128;
            end;
    end;
    Label4.Caption:=LowerCase(MsgFileStr);
    If MainForm.Mainmenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
    MessageBeep(MB_ICONQUESTION);
    Result:=ShowModal;
  finally Free; end;
end;

// Datei ausfhren
PROCEDURE TDateimanagerForm.ExecuteFileCom(ComToExecute,Parameter: string);
var Open_Result: integer; zFileName, zParams, zDir: array[0..150] of Char;
begin
  StrPCopy(zFileName,ExtractFileName(ComToExecute)); StrPCopy(zParams,Parameter); StrPCopy(zDir,ExtractFilePath(ComToExecute));
  Try Open_Result:=ShellExecute(Application.MainForm.Handle,nil,zFileName,zParams,zDir,SW_SHOWNORMAL);
  Finally Case Open_Result of
    0: zFileName:='Nicht gengend freier Speicher bzw. freie Resourcen.';
    ERROR_FILE_NOT_FOUND: zFileName:='Datei konnte nicht gefunden werden.';
    ERROR_PATH_NOT_FOUND: zFileName:='Verzeichnis konnte nicht gefunden werden.';
    ERROR_BAD_FORMAT: zFileName:='Die EXE-Datei ist fehlerhaft oder ungltig.';
    SE_ERR_ACCESSDENIED: zFileName:='Das Betriebssystem hat keinen Zugriff auf die spezifizierte Datei.';
    SE_ERR_ASSOCINCOMPLETE: zFileName:='Der angegebene Dateiname ist ungltig oder unkomplet.';
    SE_ERR_DDEBUSY: zFileName:='DDE-Konversation schlug fehl, da z.Z. eine andere DDE-Transaktion aktiv ist.';
    SE_ERR_DDEFAIL: zFileName:='DDE-Konversation schlug fehl.';
    SE_ERR_DDETIMEOUT: zFileName:='DDE-Konversation schlug fehl, da zugestandene Zeit berschritten wurde.';
    SE_ERR_DLLNOTFOUND: zFileName:='Die spezifizierte Dynamik-Link-Library konnte nicht gefunden werden.';
    SE_ERR_NOASSOC: zFileName:='Dieser Dateierweiterung ist kein Programm zugeordnet.';
    SE_ERR_OOM: zFileName:='Nicht gengend freier Speicher um die Operation durchzufhren.';
    SE_ERR_SHARE: zFileName:='Unbekannter Fehler. Aktion konnte nicht Durchgefhrt werden.';
    else begin zFileName:=''; end;
  end; end;
  If zFileName>'' then MessageBox(0,zFileName,'Fehler:',MB_Ok+MB_IconStop+MB_ApplModal+MB_SetForeground);
end;

END.
