{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# AKTIONEDIT.PAS - TAktionEditForm                                                       #
# Aktion innerhalb der MainForm bearbeiten                                               #
#########################################################################################}

UNIT AktionEdit;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     StdCtrls, Buttons, FileCtrl, Globals, Main;

Type
  TAktionEditForm = class(TGradientForm)
    GroupBox_Com: TGroupBox;
    ListBox: TListBox;
    EditCom: TEdit;
    Button_Uebernehmen: TBitBtn;
    Button_Abbrechen: TBitBtn;
    Button_Hilfe: TBitBtn;
    ButtonCom: TSpeedButton;
    InfoLabel: TLabel;
    procedure OnShow(Sender: TObject);
    procedure ListBox_OnKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure ListBox_OnMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure EditCom_OnChange(Sender: TObject);
    procedure Button_Uebernehmen_OnClick(Sender: TObject);
    procedure Button_Hilfe_OnClick(Sender: TObject);
    procedure ButtonCom_OnClick(Sender: TObject);
  end;

Var AktionEditForm: TAktionEditForm;

IMPLEMENTATION

Uses AktionChangeCom;

{$R *.DFM}

// Initialisieren
PROCEDURE TAktionEditForm.OnShow(Sender: TObject);
begin
  PrjRec:=MainForm.Tree.Selected.Data;
  ListBox.ItemIndex:=PrjRec.AktionNr;
  EditCom.Text:=PrjRec.AktionStr;
  If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
end;

// ListBox OnKeyUp
PROCEDURE TAktionEditForm.ListBox_OnKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin EditCom_OnChange(Sender); end;

// ListBox OnMouseUp
PROCEDURE TAktionEditForm.ListBox_OnMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin EditCom_OnChange(Sender); end;

// EditCom OnChange
PROCEDURE TAktionEditForm.EditCom_OnChange(Sender: TObject);
var ECOC_Str1: string;
begin 
  If Length(EditCom.Text)>0 then begin
    ECOC_Str1:=EditCom.Text;
    If ECOC_Str1[1]<>'\' then ECOC_Str1:='\'+ECOC_Str1;
    ECOC_Str1:=StartDir[1]+':'+ECOC_Str1;
    If (not FileExists(ECOC_Str1))and(not DirectoryExists(ECOC_Str1)) then begin
      InfoLabel.Caption:='Fehler: Das angegebene relative Verzeichnis bzw. Datei konnte nicht gefunden werden.'; InfoLabel.Font.Color:=clRed;
    end else
    If (not FileExists(ECOC_Str1))and((ListBox.ItemIndex=2)or(ListBox.ItemIndex=3)or(ListBox.ItemIndex=4)) then begin
      InfoLabel.Caption:='Fehler: Es wurde eine Dateiaktion gewhlt, jedoch keine entsprechende Datei definiert.'; InfoLabel.Font.Color:=clRed;
    end else begin InfoLabel.Caption:='"'+LowerCase(ECOC_Str1)+'"'; InfoLabel.Font.Color:=clBlue; end;
  end else begin
    If ListBox.ItemIndex=0 then begin InfoLabel.Caption:='Datei oder Verzeichnis whlen...'; InfoLabel.Font.Color:=clBlue; end
    else begin InfoLabel.Caption:='Fehler: Keine Datei bzw. kein Verzeichnis gewhlt.'; InfoLabel.Font.Color:=clRed; end;
  end;
  If ((PrjRec.AktionNr=ListBox.ItemIndex)and(LowerCase(PrjRec.AktionStr)=LowerCase(EditCom.Text)))or(EditCom.Text='') then
    Button_Uebernehmen.Enabled:=false else Button_Uebernehmen.Enabled:=true;
end;

// Button "Verzeichnis/Datei whlen" OnClick
PROCEDURE TAktionEditForm.ButtonCom_OnClick(Sender: TObject);
var BCOC_Str1: string;
begin
  With TAktionChangeComForm.Create(Self) do try
    BCOC_Str1:=EditCom.Text;
    If Length(BCOC_Str1)>0 then begin
      If BCOC_Str1[1]<>'\' then BCOC_Str1:='\'+BCOC_Str1;
      BCOC_Str1:=StartDir[1]+':'+BCOC_Str1;
      If not FileExists(BCOC_Str1) then If not DirectoryExists(BCOC_Str1) then BCOC_Str1:=StartDir;
    end else BCOC_Str1:=StartDir;
    AktionChangeCom_ComStr:=BCOC_Str1; // AktionChangeCom_ComStr erwartet vollen/realen Verzeichnis-/Dateistring
    If ShowModal=mrOk then begin
      BCOC_Str1:=AktionChangeCom_ComStr; // AktionChangeCom_ComStr liefert vollen/realen Verzeichnis-/Dateistring zurck
      If Length(BCOC_Str1)>2 then begin
        Delete(BCOC_Str1,1,2);
        If BCOC_Str1[1]<>'\' then BCOC_Str1:='\'+BCOC_Str1;
        EditCom.Text:=BCOC_Str1
      end else If MainForm.MsgDlg(30)=idYes then EditCom.Text:=BCOC_Str1;
    end;
  finally Free; end;
end;

// Button "bernehmen" OnClick
PROCEDURE TAktionEditForm.Button_Uebernehmen_OnClick(Sender: TObject);
begin
  PrjRec.AktionNr:=ListBox.ItemIndex;
  PrjRec.AktionStr:=EditCom.Text;
  MainForm.Tree.Selected.Data:=PrjRec;
  New(PrjRec); PrjRec.Kommentar:=Tstringlist.Create;
  MainForm.Tree.OnChange(Sender,MainForm.Tree.Selected);
end;

// Button "Hilfe" OnClick
PROCEDURE TAktionEditForm.Button_Hilfe_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

END.
