{#########################################################################################
# DSM32 - Dipesh-SoftwareManager-32 Version 3.xx                       fr Win32-Windows #
# Programmiert und Entwickelt von Sebastian Sauer (Dipesh)                      (C) 1998 #
##########################################################################################
# AKTIONCHANGECOM.PAS - TAktionChangeComForm                                             #
# Verzeichnis/Datei des wechseln, ButtonCom-OnClick innerhalb der AktionEditForm         #
#########################################################################################}

UNIT AktionChangeCom;

INTERFACE

Uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GradForm,
     FileCtrl, StdCtrls, Buttons, Main;

Type
  TAktionChangeComForm = class(TGradientForm)
    DirectoryListBox: TDirectoryListBox;
    FileListBox: TFileListBox;
    DriveComboBox: TDriveComboBox;
    FilterComboBox: TFilterComboBox;
    LabelCom: TLabel;
    Button_Uebernehmen: TBitBtn;
    Button_Abbrechen: TBitBtn;
    Button_Hilfe: TBitBtn;
    procedure OnClose(Sender: TObject; var Action: TCloseAction);
    procedure OnCreate(Sender: TObject);
    procedure OnActivate(Sender: TObject);
    procedure DirectoryListBox_OnChange(Sender: TObject);
    procedure FileListBox_OnChange(Sender: TObject);
    procedure Button_Hilfe_OnClick(Sender: TObject);
    procedure Button_Uebernehmen_OnClick(Sender: TObject);
  end;

Var AktionChangeCom_ComStr: string;
    AktionChangeComForm: TAktionChangeComForm;

IMPLEMENTATION

{$R *.DFM}

// OnClose
PROCEDURE TAktionChangeComForm.OnClose(Sender: TObject; var Action: TCloseAction);
begin
  DirectoryListBox.Directory:='';
  FileListBox.Filename:='';
end;

// Initialiseren - OnCreate
PROCEDURE TAktionChangeComForm.OnCreate(Sender: TObject);
begin
  DirectoryListBox.Directory:='';
  FileListBox.Filename:='';
  If MainForm.MainMenu.Items[5].Items[0].Enabled then Button_Hilfe.Enabled:=true;
end;

// Initialisieren - OnActivate
PROCEDURE TAktionChangeComForm.OnActivate(Sender: TObject);
begin
  If DirectoryListBox.Directory<>ExtractFilePath(AktionChangeCom_ComStr) then DirectoryListBox.Directory:=ExtractFilePath(AktionChangeCom_ComStr);
  FileListBox.Filename:=ExtractFileName(AktionChangeCom_ComStr);
end;

// DirectoryListBox OnChange
PROCEDURE TAktionChangeComForm.DirectoryListBox_OnChange(Sender: TObject);
var DLBOC_Str1: string;
begin
  DLBOC_Str1:=DirectoryListBox.Directory;
  If DLBOC_Str1[Length(DLBOC_Str1)]<>'\' then DLBOC_Str1:=DLBOC_Str1+'\';
  LabelCom.Caption:=LowerCase(DLBOC_Str1);
  FileListBox.ItemIndex:=-1;
end;

// FileListBox OnChange
PROCEDURE TAktionChangeComForm.FileListBox_OnChange(Sender: TObject);
begin
  If FileListBox.ItemIndex<>-1 then LabelCom.Caption:=LowerCase(FileListBox.Filename);
end;

// Button "bernehmen" OnClick
PROCEDURE TAktionChangeComForm.Button_Uebernehmen_OnClick(Sender: TObject);
begin AktionChangeCom_ComStr:=LabelCom.Caption; end;

// Button "Hilfe" OnClick
PROCEDURE TAktionChangeComForm.Button_Hilfe_OnClick(Sender: TObject);
begin Application.HelpContext(HelpContext); end;

END.
