unit MainForm;

{
1997 Apr 02  V1.0.2  Testbed for DiskList component
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, DiskList, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Button1: TButton;
    DiskListView1: TDiskListView;
    procedure DiskListView1Change(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  Timer1.Enabled := True;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  Timer1.Enabled := False;
  DiskListView1.ScanDrives;
end;

procedure TForm1.DiskListView1Change(Sender: TObject; Item: TListItem;
  Change: TItemChange);
var
  s: string;
  i: integer;
begin
  s := DiskListView1.SelectedDrives;
  if length (s) = 1
    then Caption := 'Selected drive '
    else Caption := 'Selected drives ';
  for i := 1 to Length (s) do
    Caption := Caption + s [i] + ': ';
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Close;
end;

end.

