unit DragSelect;
{

UNIT
  DragSelect

CLASSES
  TDragSelect

DESCRIPTION
  Defines the TDragSelect TSelectEvent types. TDragSelect subclasses a TWinControl
  (specified by the TARGETCONTROL property) and



}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TSelectEvent = procedure(Sender : TObject; SelRect : TRect) of object;

  TDragSelect = class(TComponent)
  private
    { Private declarations }
    FOnSelect   : TSelectEvent;
    FTarget     : TWinControl;
    FOldWndProc : TWndMethod;
    FSelRect    : TRect;
    FMoveRef    : TPoint;
    FLineWidth  : integer;

    FSelecting  : boolean;

    function NormalizeRect(R : TRect) : TRect;

    procedure DrawRect(R : TRect);
    procedure SetTarget(Value : TWinControl);

  protected
    { Protected declarations }
  public
    { Public declarations }
    procedure   Loaded; override;
    constructor Create(AOwner : TCOmponent); override;
    destructor  Destroy; override;

    procedure WndProc(var Message : TMessage);

    procedure MouseDown(Message : TWMLButtonDown);
    procedure MouseMove(Message : TWMMouseMove);
    procedure MouseUp(Message : TWMLButtonUp);
  published
    { Published declarations }
    property LineWidth : integer read FLineWidth write FLineWidth;

    property TargetControl : TWinControl  read FTarget write SetTarget;
    property OnSelect      : TSelectEvent read FOnSelect write FOnSelect;
  end;

procedure Register;

implementation

{$R DRAGSELECT.DCR}
procedure TDragSelect.SetTarget(Value : TWinControl);
begin
  if csDesigning in ComponentState then begin
    FTarget := Value;
    exit;
  end; // if Design mode..

  if assigned(FOldWndProc) then
    FTarget.WindowProc := FOldWndProc;

  FTarget := Value;
  FOldWndProc := FTarget.WindowProc;
  FTarget.WindowProc := WndProc;

end; // SetTarget


procedure TDragSelect.DrawRect(R : TRect);
var
  FCanvas : TCanvas;
  DC      : hDC;
  iCount  : integer;

  procedure ZoomRect(var R : TRect; Amount : integer);
  begin
    with R do begin
      Dec(Left,Amount);
      Dec(Top,Amount);
      Inc(Right,Amount);
      Inc(Bottom,Amount);
    end; // with R
  end; // ZoomRect


begin
  FCanvas := TCanvas.Create;
  DC := GetDC(FTarget.Handle);
  FCanvas.Handle := DC;
  try
    for iCount := 0 to LineWidth-1 do begin
      FCanvas.DrawFocusRect(R);
      ZoomRect(R,1);
    end; // for iCount

  finally
    FCanvas.Free;
    ReleaseDC(FTarget.Handle, DC);
  end; // try..finally
end; // DrawRect()

procedure TDragSelect.MouseDown(Message : TWMLButtonDown);
begin
  FSelecting := TRUE;
  FSelRect.TopLeft := Point(MEssage.XPos,Message.YPos);
  FSelRect.BottomRight := FSelRect.TopLeft;

  FMoveRef := Point(Message.XPos, Message.YPos);


  FSelRect := NormalizeRect(FSelRect);

  DrawRect(FSelRect);

end; // MouseDown


procedure TDragSelect.MouseMove(Message : TWMMouseMove);
begin
  if not FSelecting then
    exit;

  DrawRect(FSelRect);

  FSelRect := NormalizeRect(Rect(FMoveRef.X, FMoveRef.Y, Message.XPos, MEssage.YPos));

  DrawRect(FSelRect);
end; // MouseMove


procedure TDragSelect.MouseUp(Message : TWMLButtonUp);
begin
  DrawRect(FSelRect);

  if assigned(FOnSelect) then
    FOnSelect(Self,FSelRect);

  FSelecting := FALSE;
end; // MouseUp

procedure TDragSelect.Loaded;
begin
  inherited Loaded;
end;

constructor TDragSelect.Create(AOwner : TCOmponent);
begin
  inherited Create(AOwner);
  FOldWndProc := nil;
  FSelecting := FALSE;
  FLineWidth := 2;
end;

destructor  TDragSelect.Destroy;
begin
  if not (csDesigning in ComponentState) then
    FTarget.WindowProc := FOldWndProc;
  inherited Destroy;
end;

procedure TDragSelect.WndProc(var Message : TMessage);
{
  Override message handler for the target control.
}
begin
  case Message.Msg of
    WM_LBUTTONDOWN : MouseDown(TWMMouse(Message));
    WM_LBUTTONUP   : MouseUp(TWMMouse(Message));
    WM_MOUSEMOVE   : MouseMove(TWMMouse(Message));
  end; { case Message.Msg of }
  if assigned(FOldWndProc) then
    FOldWndProc(Message);
end;



function TDragSelect.NormalizeRect(R : TRect) : TRect;

  procedure SwapInt(var A,B : integer);
  var
    T : integer;
  begin { SwapInt }
    T := A;
    A := B;
    B := T;
  end; { SwapInt }



begin { TfrmDiagram.NormalizeRect }
  if R.Left > R.Right then SwapInt(R.Left,R.Right);
  if R.Top > R.Bottom then SwapInt(R.Top,R.Bottom);


  Result := R;
end;  { TfrmDiagram.NormalizeRect }


procedure Register;
begin
  RegisterComponents('IC', [TDragSelect]);
end;

end.
 