{*************************************************************}
{            DotFrame Component for Delphi 32                 }
{ Version:   0.99 beta                                        }
{ E-Mail:    info@utilmind.com                                }
{ Home Page: http://www.utilmind.com                          }
{ Created:   September 17, 1999                               }
{ Modified:  September 28, 1999                               }
{ Legal:     Copyright (c) 1999, UtilMind Solutions           }
{-------------------------------------------------------------}
{ This component is FREEWARE. Enjoy with it but please don't  }
{ ask us about support. However, if you have found a way how  }
{ to improve the TDotFrame - we shall be grateful for sent    }
{ examples.                                                   }
{*************************************************************}
{      DESCRIPTION:                                           }
{ Component draws the dotted frame. On appearance is similar  }
{ to standard Windows frame, intended for selecting of the    }
{ objects. The similar frame is used in Windows 95 and lower  }
{ for dragging of the windows.                                }
{ Very easily adapts to any program in which it is necessary  }
{ to select a part of a picture or form.                      }
{*************************************************************}
{      PROPERTIES:                                            }
{ 1. FrameRect - persitent object which contains the frame    }
{    coordinates:                                             }
{    Left, Right, Top and Bottom.                             }
{ 2. Width - width of the dotted frame                        }
{ 3. Visible - as usual :)                                    }
{      METHODS:                                               }
{ BeginSelect, ProcessSelect and EndSelect                    }
{  PLEASE SEE THE DEMO PROJECT FOR MORE INFO                  }
{*************************************************************}

unit DotFrame;

interface

uses
  Windows, Classes, Controls;

type
  TDotFrame = class;

{ The dotted rectangle }  
  TDotRectangle = class(TPersistent)
  private
    Parent: TDotFrame;
    FLeft, FTop, FRight, FBottom: Integer;

    procedure SetLeft(Value: Integer);
    procedure SetTop(Value: Integer);
    procedure SetRight(Value: Integer);
    procedure SetBottom(Value: Integer);
  public
    constructor Create(aParent: TDotFrame);
  published
    property Left: Integer read FLeft write SetLeft;
    property Top: Integer read FTop write SetTop;
    property Right: Integer read FRight write SetRight;
    property Bottom: Integer read FBottom write SetBottom;
  end;

{ ------ TDotFrame -----}  
  TDotFrame = class(TComponent)
  private
    BeginPoint, EndPoint: TPoint;
    Select: Boolean;

    FFrameRect: TDotRectangle;
    FWidth: Integer;
    FVisible: Boolean;

    procedure SetVisible(Value: Boolean);
    procedure SetWidth(Value: Integer);
  protected
  public
    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;

    procedure BeginSelect;
    procedure ProcessSelect;
    procedure EndSelect;

    procedure DrawDotFrame(DC: hDC; Rect: TRect);
  published
    property FrameRect: TDotRectangle read FFrameRect write FFrameRect;
    property Visible: Boolean read FVisible write SetVisible;
    property Width: Integer read FWidth write SetWidth;
  end;

procedure Register;

implementation

{ The dotted rectangle }
constructor TDotRectangle.Create;
begin
  inherited Create;
  FLeft := 0;
  FTop := 0;
  FRight := 150;
  FBottom := 100;
  Parent := aParent;
end;

procedure TDotRectangle.SetLeft(Value: Integer);
var
  Vis: Boolean;
begin
  if FLeft <> Value then
   begin
    Vis := Parent.FVisible;
    if Vis then Parent.Visible := False;
    FLeft := Value;
    if Vis then Parent.Visible := True;    
   end;
end;

procedure TDotRectangle.SetTop(Value: Integer);
var
  Vis: Boolean;
begin
  if FTop <> Value then
   begin
    Vis := Parent.FVisible;
    if Vis then Parent.Visible := False;
    FTop := Value;
    if Vis then Parent.Visible := True;
   end;
end;

procedure TDotRectangle.SetRight(Value: Integer);
var
  Vis: Boolean;
begin
  if FRight <> Value then
   begin
    Vis := Parent.FVisible;
    if Vis then Parent.Visible := False;
    FRight := Value;
    if Vis then Parent.Visible := True;
   end;
end;

procedure TDotRectangle.SetBottom(Value: Integer);
var
  Vis: Boolean;
begin
  if FBottom <> Value then
   begin
    Vis := Parent.FVisible;
    if Vis then Parent.Visible := False;
    FBottom := Value;
    if Vis then Parent.Visible := True;
   end;
end;

{ ------ TDotFrame -----}
constructor TDotFrame.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  FFrameRect := TDotRectangle.Create(Self);
  FWidth := 3;
end;

destructor TDotFrame.Destroy;
begin
  Visible := False;
  FFrameRect.Free;
  inherited Destroy;
end;

procedure TDotFrame.SetWidth(Value: Integer);
var
  Vis: Boolean;
begin
  if FWidth <> Value then
   begin
    Vis := FVisible;
    if Vis then Visible := False;
    FWidth := Value;
    if Vis then Visible := True;    
   end;
end;

procedure TDotFrame.SetVisible(Value: Boolean);
var
  DC: hDC;
begin
  if FVisible <> Value then
   begin
    FVisible := Value;

    DC := GetDC(0);
    DrawDotFrame(DC, Rect(FFrameRect.Left, FFrameRect.Top,
                      FFrameRect.Right, FFrameRect.Bottom));
    ReleaseDC(0, DC);
   end;
end;

procedure TDotFrame.BeginSelect;
begin
  Select := True;
  GetCursorPos(BeginPoint);
  FFrameRect.Left := BeginPoint.X;
  FFrameRect.Top := BeginPoint.Y;
  FFrameRect.Right := BeginPoint.X;
  FFrameRect.Bottom := BeginPoint.Y;
  Visible := True;
end;

procedure TDotFrame.ProcessSelect;
begin
  if Select then
   begin
    GetCursorPos(EndPoint);

    Visible := False;
    FFrameRect.Right := EndPoint.X;
    FFrameRect.Bottom := EndPoint.Y;
    Visible := True;
   end;  
end;

procedure TDotFrame.EndSelect;
begin
  Select := False;
  Visible := False;
end;

{ Draw the dotted frame }
procedure TDotFrame.DrawDotFrame(DC: hDC; Rect: TRect);
var
  Region, RegionOut, RegionIn: hRgn;
  OldBrush, Brush: hBrush;
  SaveIndex: Integer;
  R: TRect;
  Swap: Integer;

  function CreatePattern: hBrush;
  const
    Patterns: Array[Boolean] of Word = ($5555, $AAAA);
  var
    i: Integer;
    GrayPattern: Array[0..7] of Word;
    GrayBitmap: hBitmap;
  begin
    for i := 0 to 7 do
      GrayPattern[i] := Patterns[Odd(i)];
    GrayBitmap := CreateBitmap(8, 8, 1, 1, @GrayPattern);

    Result := CreatePatternBrush(GrayBitmap);
    DeleteObject(GrayBitmap);
  end;

  function CreateNullRegion: hRgn;
  var
    R: TRect;
  begin
    SetRectEmpty(R);
    Result := CreateRectRgnIndirect(R);
  end;

begin
  if (Rect.Left = Rect.Right) and (Rect.Top = Rect.Bottom) then Exit;

  if Rect.Left > Rect.Right then
   begin
    Swap := Rect.Left;
    Rect.Left := Rect.Right;
    Rect.Right := Swap;
   end;
  if Rect.Top > Rect.Bottom then
   begin
    Swap := Rect.Top;
    Rect.Top := Rect.Bottom;
    Rect.Bottom := Swap;
   end;

  RegionOut := CreateRectRgnIndirect(Rect);

  R.Left := Rect.Left + FWidth;
  R.Top := Rect.Top + FWidth;
  R.Right := Rect.Right - FWidth;
  R.Bottom := Rect.Bottom - FWidth;

  RegionIn := CreateRectRgnIndirect(R);

  Region := CreateNullRegion;

  CombineRgn(Region, RegionOut, RegionIn, RGN_XOR);

  Brush := CreatePattern;
  OldBrush := SelectObject(DC, Brush);

  SaveIndex := SaveDC(DC);

  SelectClipRgn(DC, Region);

  PatBlt(DC, Rect.Left, Rect.Top, Rect.Right, Rect.Bottom, PatInvert);

  RestoreDC(DC, SaveIndex);

  SelectObject(DC, OldBrush);
  DeleteObject(Brush);
  DeleteObject(Region);
  DeleteObject(RegionIn);
  DeleteObject(RegionOut);
end;

procedure Register;
begin
  RegisterComponents('UtilMind', [TDotFrame]);
end;

end.
