{****************************************************************************}
{ Unit:    AboutDialog                                                       }
{ Class:   TAboutDialog                                                      }
{ Version: 1.0                                                               }
{ Purpose: Borland-Style about dialog box with additional features           }
{ Authpr:  Ian Huang                                                         }
{ E-Mail:  ian@jigsaw.com.au                                                }
{ Date:    11/01/1997                                                        }
{****************************************************************************}
{$D-,L-} {Remove if you wish to debug this code}
unit AboutDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, StdCtrls,
  Dialogs, About;

type
  TAboutDialog = class(TComponent)
  private
    FCompany, FProductName, FVersion, FCopyright, FURL, FEMAIL: string;
  protected
  public
    function Execute: Boolean;
    constructor Create(AOwner: TComponent); override;
  published
    property Company: string read FCompany write FCompany;
    property ProductName: string read FProductName write FProductName;
    property Version: string read FVersion write FVersion;
    property Copyright: string read FCopyright write FCopyright;
    property URL: string read FURL write FURL;
    property EMail: string read FEMail write FEMail;
  end;

var
  AboutBox: TAboutBox;

procedure register;

implementation

procedure register;
begin
  RegisterComponents('Samples',[TAboutDialog]);
end;

constructor TAboutDialog.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Company := 'Your Company Name';
  ProductName := '';
  VERSION := 'Version';
  Copyright := 'Copyright Info';
  URL := 'Youe Web Site';
  EMail := 'Your E-Mail Address Here';
end;

function TAboutDialog.Execute: Boolean;
begin
  AboutBox := TAboutBox.Create(Application);
  if ProductName = '' then ProductName := Application.Title;
  try
    // Set dialog strings
    AboutBox.Company.Caption := Company;
    AboutBox.ProductName1.Caption := ProductName;
    AboutBox.ProductName2.Caption := ProductName;
    AboutBox.ProductName3.Caption := ProductName;
    AboutBox.VERSION.Caption := VERSION;
    AboutBox.Copyright.Caption := Copyright;
    AboutBox.URL.Caption := URL;
    AboutBox.EMail.Caption := EMail;
    AboutBox.Caption := 'About ' + ProductName;
    with AboutBox do
    begin
      ProgramIcon.Picture.Graphic := Application.ICON;
      Result := (ShowModal = IDOK);
    end;
  finally
    AboutBox.Free;
  end;
end;


end.

