// The Digital Keys Library  Copyright (C) 2000 RITLABS S.R.L.
// DKlibAPI  Copyright (C) 2000 RITLABS S.R.L.
// Interface module

unit dklibapi;

interface uses Windows;

type
  TLoadKeyringsCallback = procedure(What: Integer; ParamA, ParamB, AppData: Pointer); stdcall;
  TEncodeCallback = procedure(What: Integer; ParamA, ParamB, AppData: Pointer); stdcall;
  TDecodeCallback = procedure(What: Integer; ParamA, ParamB, AppData: Pointer); stdcall;
  TTestKeyringsCallback = procedure(What: Integer; ParamA, ParamB, AppData: Pointer); stdcall;

  TdkTestKeyringParam = packed record
    cbSize: UINT;
    lpszKeyring: LPSTR;
    lpfnTestKeyringCallback: TTestKeyringsCallback;
    lpAppData: Pointer;
  end;

  TdkLoadKeyringsParam = packed record
    cbSize: UINT;
    lpszPubring: LPSTR;
    lpszSecring: LPSTR;
    lpszRandseed: LPSTR;
    bUseSmartCard: BOOL;
    bUseKeyboard: BOOL;
    dwReaderComIndex: DWORD;
    dwDefaultKeyIdA: DWORD;
    dwDefaultKeyIdB: DWORD;
    lpfnLoadKeyringsCallback: TLoadKeyringsCallback;
    lpAppData: Pointer;
  end;

  TdkEncodeParam = packed record
    cbSize: UINT;
    lpRcpts: PChar;
    nRcpts: Integer;
    bEncrypt: BOOL;
    bSign: BOOL;
    bCompress: BOOL;
    bEncryptDefKey: BOOL;
    lpSource: PChar;
    dwSrcSize: DWORD;
    lpfnEncodeCallback: TEncodeCallback;
    lpAppData: Pointer;
    Reserved: Pointer;
    lpRcpIds: Pointer;
    bBinary: Boolean;
  end;


  TdkDecodeParam = packed record
    cbSize: UINT;
    lpSource: PChar;
    dwSrcSize: DWORD;
    bReqSig: BOOL;
    lpfnDecodeCallback: TDecodeCallback;
    lpAppData: Pointer;
    Reserved: Pointer;
    bBinary: BOOL;
  end;

  PdkSignatureReport = ^TdkSignatureReport;
  TdkSignatureReport = packed record
    cbSize: UINT;
    bPassed: BOOL;
    bError: BOOL;
    bRevoked: BOOL;
    bDisabled: BOOL;
    bExpired: BOOL;
    bInvalid: BOOL;
    bValid: BOOL;
    Time: TFILETIME;
    lpszSigner: PChar;
    Reserved: Pointer;
    lpKeyIdA: Pointer;
    lpKeyIdB: Pointer;
  end;

const
  dkMaxPassphraseLength = 250;

type
  PdkInputPassphrase = ^TdkInputPassphrase;
  TdkInputPassphrase = packed record
    cbSize: UINT;
    PassphraseBuf: array[0..dkMaxPassphraseLength-1] of Char;
    lpszKeyName: PChar;
    lpDecryptorNames: PChar;
    dwNumDecryptors: UINT;
    bOK: BOOL;
  end;

const
  dkMaxPincodeLength = 8;

type
  PdkInputPINCode = ^TdkInputPINCode;
  TdkInputPINCode = packed record
    cbSize: UINT;
    PincodeBuf: array[0..dkMaxPincodeLength-1] of Char;
    bOK: BOOL;
  end;


const
  dkScSInitReaderBefore = 0;
  dkScSInitCardBefore   = 1;
  dkScSVerifyPINBefore  = 2;
  dkScSReadKeyBefore    = 3;

  dkScSInitReaderAfter  = 4;
  dkScSInitCardAfter    = 5;
  dkScSVerifyPINAfter   = 6;
  dkScSReadKeyAfter     = 7;

  dkScEKeyUnkOwner      = 8;
  dkScEKeyDiffOwner     = 9;

  dkInputPinCode        = 10;
  dkTotalKeys           = 11;

  dkEcEPubKeysNotFound  = 20;
  dkEcOutBuf            = 21;

  dkDcSigReport         = 30;
  dkDcEUnkSigner        = 31;
  dkDcSeckeyNotFound    = 32;
  dkDcOutBuf            = 33;

  dkInputPassphrase     = 100;

  ERROR_DK_NO_ERROR             = 0;
  ERROR_DK_ACCESS_SMARTCARD     = 1;
  ERROR_DK_INVALID_PARAMETER    = 2;
  ERROR_DK_ALREADY_INITIALIZED  = 3;
  ERROR_DK_DLL_NOT_FOUND        = 4;
  ERROR_DK_LOAD_PUBRING         = 5;
  ERROR_DK_LOAD_SECRING         = 6;
  ERROR_DK_NO_DEFAULT_KEY       = 7;
  ERROR_DK_SC_UNKNOWN_OWNER     = 8;
  ERROR_DK_SC_DIFF_OWNER        = 9;
  ERROR_DK_NOT_INITIALIZED      = 10;
  ERROR_DK_SIGNATURE_FORMAT     = 11;
  ERROR_DK_UNKNOWN_SIGNER       = 12;
  ERROR_DK_SECKEY_NOT_FOUND     = 13;
  ERROR_DK_OPEN_SECKEY          = 14;
  ERROR_DK_RECURSION            = 15;
  ERROR_DK_INVALID_ACCESS       = 16;
  ERROR_DK_SC_DRIVER_FAILURE    = 17;
  ERROR_DK_SIG_REQUIRED         = 18;
  ERROR_DK_BAD_DATA_FORMAT      = 19;
  ERROR_DK_BAD_ARMOR            = 20;
  ERROR_DK_CANT_DECRYPT         = 21;
  ERROR_DK_CANT_SIGN            = 22;
  ERROR_DK_CANT_ENCRYPT         = 23;
  ERROR_DK_PUBKEY_NOT_FOUND     = 24;
  ERROR_DK_INPUT_CANCELLED      = 25;
  ERROR_DK_LOAD_KEYRING         = 26;

implementation

end.
