unit DiskDlg;
//==========================================================================
// Copyright  1999 by Dani Seelhofer
// for Goldfish Software GmbH, Switzerland
//--------------------------------------------------------------------------
// Vers.  Date      Remarks
// 1.0.0  05.27.99  Initial release
//==========================================================================
interface

uses
    Windows,Classes,ShellApi;

type
    TCopyDiskDlg = class(TComponent)
    Private
        { Private-Deklarationen }
    Protected
        { Protected-Deklarationen }
    Public
        constructor Create(aOwner: TComponent);override;
        function Execute: Boolean;
        { Public-Deklarationen }
    Published
        { Published-Deklarationen }
    end;

    TFormatDiskDlg = class(TComponent)
    Private
        { Private-Deklarationen }
    Protected
        { Protected-Deklarationen }
    Public
        constructor Create(aOwner: TComponent);override;
        function Execute: Boolean;
        { Public-Deklarationen }
    Published
        { Published-Deklarationen }
    end;

procedure Register;

implementation

procedure Register;
begin
    RegisterComponents('Dan' + #39 + 's Components', [TCopyDiskDlg]);
    RegisterComponents('Dan' + #39 + 's Components', [TFormatDiskDlg]);
end;

//==========================================================================

constructor TCopyDiskDlg.Create(aOwner: TComponent);
//==========================================================================
begin
    inherited Create(aOwner);
end;

//==========================================================================

constructor TFormatDiskDlg.Create(aOwner: TComponent);
//==========================================================================
begin
    inherited Create(aOwner);
end;


//==========================================================================

function TCopyDiskDlg.Execute: Boolean;
//==========================================================================
const
    SHOW_DLG_STR                                  = 'rundll32.exe Diskcopy.dll,DiskCopyRunDll';
begin
    Result := True;
    //ShellExecute returns a value below 32 if the function fails...
     if WinExec(PChar(SHOW_DLG_STR), SW_SHOWDEFAULT) <= 31 then
        Result := False;
end;

//==========================================================================

function TFormatDiskDlg.Execute: Boolean;
//==========================================================================
const
    SHOW_DLG_STR                                  = 'rundll32.exe Shell32.dll, SHFormatDrive';
begin
    Result := True;
    //ShellExecute returns a value below 32 if the function fails...
     if WinExec(PChar(SHOW_DLG_STR), SW_SHOWDEFAULT) <= 31 then
        Result := False;
end;

end.

