{*******************************************************************************
*  TDirLabel version 0.1                                                       *
********************************************************************************
* Author: Raoul Snyman                                                         *
* ---------------------------------------------------------------------------- *
* E-Mail: components@saturnlaboratories.gq.nu                                  *
* ---------------------------------------------------------------------------- *
* Copyright: 2002 Saturn Laboratories, All rights reserved.                   *
* ---------------------------------------------------------------------------- *
* Description: TDirLabel is a label which will automatically cut a directory   *
*              down to "...\" when the whole directory gets too long for the   *
*              label. It will do this continuously until the modified folder   *
*              fits in the whole label. So if you have something like this:    *
*              "C:\Program Files\Borland\Delphi 3\Bin" and the folder needs to *
*              de shortened, it will become "C:\...\Borland\Delphi 3\Bin" and  *
*              if it's still too long, it'll become "C:\...\...\Delphi 3\Bin"  *
********************************************************************************
* This component is FREEWARE.                                                  *
* ---------------------------------------------------------------------------- *
* Please let me know if you find it useful!!                                   *
* ---------------------------------------------------------------------------- *
* It may be used for commercial purposes on the condition that you give me     *
* credit (i.e. place it in your credits list).                                 *
* ---------------------------------------------------------------------------- *
* If used in freeware, it's not necessary to give me credit, although it would *
* be appreciated.                                                              *
* ---------------------------------------------------------------------------- *
* If you modify this code, please send me an e-mail with a copy of the code    *
* attached, letting me know what it was that you modified/added.               *
* Please use the structure below to specify what you modified. Add the ref-    *
* erence to the end of the line you inserted/modified. Thanks.                 *
********************************************************************************
* Modified: (first name) (last name)     Reference: // (initials)              *
*           (version), (date)                                                  *
*           (description of modification)                                      *
*******************************************************************************}

unit DirLabel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TDirLabel = class(TCustomLabel)
  private
    { Private declarations }
    FDirectory: String;
    procedure SetDirectory(Value: String);
    function ShortenString(S: String): String;
  protected
    { Protected declarations }
  public
    { Public declarations }
  published
    { Published declarations }
    property Directory: String read FDirectory write SetDirectory;
    property Align;
    property Alignment;
    property AutoSize;
    property Color;
    property Cursor;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property Height;
    property Hint;
    property Layout;
    property Left;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowAccelChar;
    property ShowHint;
    property Tag;
    property Top;
    property Transparent;
    property Visible;
    property Width;
  end;

procedure Register;

implementation

{$R DirLabel.dcr}

function TDirLabel.ShortenString(S: String): String;
var I: Integer;
    Drive, Folder: String;
begin
 if Canvas.TextWidth(S) > Width
  then
   begin
    I := 4;
    Drive := Copy(S, 1, 3);
    Folder := Copy(S, 4, Length(S)-4);
    while Canvas.TextWidth(Folder+Drive) > Width do
     begin
      repeat
       Inc(I);
      until (I = Length(S)) or (S[I-1] = '\');
      Drive := Drive + '...\';
      Folder := Copy(S, I, (Length(S)-I)+1);
     end;
    ShortenString := Drive + Folder;
   end
  else
   ShortenString := S;
end;

procedure TDirLabel.SetDirectory(Value: String);
begin
 FDirectory := Value;
 Caption := ShortenString(Value);
 Invalidate;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TDirLabel]);
end;

end.
