unit ThDirCh;

interface

uses
  Classes,Windows;

type

  TThDirChange = class(TThread)
  private
    procedure DoOnChange;
  protected
    procedure Execute; override;
  public
        Directory:string;
        OnChange:TNotifyEvent;
  end;

implementation

procedure TThDirChange.Execute;
var
   fr:TWOHandleArray;
   i:integer;
begin
     if Copy(Directory,Length(Directory),1)<>'\' then Directory:=Directory+'\';
     fr[0]:=FindFirstChangeNotification(Pchar(Directory),false,FILE_NOTIFY_CHANGE_FILE_NAME);
     fr[1]:=FindFirstChangeNotification(Pchar(Directory),false,FILE_NOTIFY_CHANGE_LAST_WRITE);
     fr[2]:=FindFirstChangeNotification(Pchar(Directory),false,FILE_NOTIFY_CHANGE_DIR_NAME);
     fr[3]:=FindFirstChangeNotification(Pchar(Directory),false,FILE_NOTIFY_CHANGE_ATTRIBUTES);
     fr[4]:=FindFirstChangeNotification(Pchar(Directory),false,FILE_NOTIFY_CHANGE_SIZE);
     while not Terminated do begin
           if (((FindNextChangeNotification(fr[0])) and (FindNextChangeNotification(fr[1])))
              and
              (FindNextChangeNotification(fr[2])))
              and
              (FindNextChangeNotification(fr[3]))
              and
              (FindNextChangeNotification(fr[4]))
              then begin
                   i:=WAIT_TIMEOUT;
                   while (i=WAIT_TIMEOUT) and (not Terminated) do
                         i:=WaitForMultipleObjects(5,@fr,false,10);
                   if Not Terminated then Synchronize(DoOnChange);
                   end;
           end;
     FindCloseChangeNotification(fr[0]);
     FindCloseChangeNotification(fr[1]);
     FindCloseChangeNotification(fr[2]);
     FindCloseChangeNotification(fr[3]);
     FindCloseChangeNotification(fr[4]);
     FindCloseChangeNotification(fr[5]);
end;

procedure TThDirChange.DoOnChange;
begin
     if Assigned(OnChange) then OnChange(self);
end;

end.
