unit DirChange;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ThDirCh,FileCtrl;

type
    TDirCh=procedure(Sender:TObject;Item1,Item2:TWIN32FindData) of object;
    TDirCh1=procedure(Sender:TObject;Item:TWIN32FindData) of object;

  TDirChange = class(TComponent)
  private
    { Private declarations }

    fOnChangeAtr,fOnChangeCreationTime,
    fOnChangeAccessTime,fOnChangeWriteTime,
    fOnChangeSize,fOnAnyChange:TDirCh;

    fOnChangeNew,fOnChangeDeleted,fOnChangeRenamed:TDirCh1;

    fActive:Boolean;
    fDirectory:string;
    fThread:TThDirChange;
    fOldFiles:TList;
    procedure SetActive(Value:Boolean);
    procedure SetDirectory(Value:string);
    procedure OnTerminate(Sender:TObject);
    procedure GetDirFiles(List:TList);
    procedure ClearList(List:TList);
    procedure TestLists(List:TList);

    procedure OnChange(Sender:TObject);

  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;

  published
    { Published declarations }
    property Active:Boolean read fActive write SetActive;
    property Directory:string read fDirectory write SetDirectory;
    property OnChangeAttributes:TDirCh read fOnChangeAtr write fOnChangeAtr;
    property OnChangeCreationTime:TDirCh read fOnChangeCreationTime write fOnChangeCreationTime;
    property OnChangeAccessTime:TDirCh read fOnChangeAccessTime write fOnChangeAccessTime;
    property OnChangeWriteTime:TDirCh read fOnChangeWriteTime write fOnChangeWriteTime;
    property OnChangeSize:TDirCh read fOnChangeSize write fOnChangeSize;
    property OnAnyChange:TDirCh read fOnAnyChange write fOnAnyChange;
    property OnChangeDeleted:TDirCh1 read fOnChangeDeleted write fOnChangeDeleted;
    property OnChangeNew:TDirCh1 read fOnChangeNew write fOnChangeNew;
    property OnChangeRenamed:TDirCh1 read fOnChangeRenamed write fOnChangeRenamed;

  end;

procedure Register;

implementation

constructor TDirChange.Create(AOwner:TComponent);
begin
     Inherited Create(AOwner);
     fActive:=False;
     fOldFiles:=TList.Create;
end;

destructor TDirChange.Destroy;
begin
     Active:=False;
     ClearList(fOldFiles);
     fOldFiles.Free;
     inherited Destroy;
end;

procedure TDirChange.SetActive(Value:Boolean);
begin
     if Value=fActive then exit;
     if Value then begin
        if Copy(fDirectory,Length(fDirectory),1)<>'\' then fDirectory:=fDirectory+'\';
        if DirectoryExists(fDirectory) then begin
           ClearList(fOldFiles);
           GetDirFiles(fOldFiles);
           fThread:=TThDirChange.Create(True);
           fThread.Directory:=fDirectory;
           fThread.FreeOnTerminate:=True;
           fThread.OnTerminate:=OnTerminate;
           fThread.OnChange:=OnChange;
           fThread.Resume;
           fActive:=True;
           end;
        end
     else fThread.Terminate;
end;

procedure TDirChange.OnTerminate(Sender:TObject);
begin
     fActive:=False;
end;

procedure TDirChange.SetDirectory(Value:string);
var
   x:Boolean;
begin
     x:=fActive;
     Active:=False;
     fDirectory:=Value;
     Active:=x;
end;

procedure TDirChange.OnChange(Sender:TObject);
begin
    TestLists(fOldFiles);
end;

procedure TDirChange.ClearList(List:TList);
begin
     while List.Count>0 do begin
           FreeMem(List.Items[0],SizeOf(TWIN32FindData));
           List.Delete(0);
           end;
end;

procedure TDirChange.GetDirFiles(List:TList);
var
   fn:THandle;
   fr:TWIN32FindData;
   pfr:PWIN32FindData;
begin
     ClearList(List);
     fn:=FindFirstFile(Pchar(fDirectory+'*.*'),fr);
     if fn<>INVALID_HANDLE_VALUE then begin
        while FindNextFile(fn,fr) do
              if fr.cFileName[0]<>'.' then begin
                 New(pfr);
                 pfr^:=fr;
                 List.Add(pfr);
                 end;
        Windows.FindClose(fn);
        end;
end;

procedure TDirChange.TestLists(List:TList);
var
   i,j:integer;
   f1,f2:PWIN32FindData;
   ff:TWIN32FindData;
   s1,s2:string;
   List1:TList;
   Ch,Del:Boolean;
begin
     List1:=TList.Create;
     GetDirFiles(List1);
     for i:=0 to List.Count-1 do begin
         f1:=List.Items[i];
         Ch:=False;
         s1:=f1^.cFileName;
         Del:=True;
         for j:=0 to List1.Count-1 do begin
             f2:=List1.Items[j];
             s2:=f2^.cFileName;
             if s1=s2 then begin
                Del:=False;
                if f1^.dwFileAttributes<>f2^.dwFileAttributes then begin
                   ch:=True;
                   if Assigned(fOnChangeAtr) then fOnChangeAtr(self,f1^,f2^);
                   end;
                if ((f1^.ftCreationTime.dwLowDateTime<>f2.ftCreationTime.dwLowDateTime)
                   or (f1^.ftCreationTime.dwHighDateTime<>f2.ftCreationTime.dwHighDateTime))
                   then begin
                   ch:=true;
                   if Assigned(fOnChangeCreationTime) then fOnChangeCreationTime(self,f1^,f2^);
                   end;
                if ((f1^.ftLastAccessTime.dwLowDateTime<>f2.ftLastAccessTime.dwLowDateTime)
                   or (f1^.ftLastAccessTime.dwHighDateTime<>f2.ftLastAccessTime.dwHighDateTime))
                   then begin
                   ch:=true;
                   if Assigned(fOnChangeAccessTime) then fOnChangeAccessTime(self,f1^,f2^);
                   end;
                if ((f1^.ftLastWriteTime.dwLowDateTime<>f2.ftLastWriteTime.dwLowDateTime)
                   or (f1^.ftLastWriteTime.dwHighDateTime<>f2.ftLastWriteTime.dwHighDateTime))
                   then begin
                   ch:=true;
                   if Assigned(fOnChangeWriteTime) then fOnChangeWriteTime(self,f1^,f2^);
                   end;
                if (f1^.nFileSizeHigh<>f2^.nFileSizeHigh) or (f1^.nFileSizeLow<>f2^.nFileSizeLow) then begin
                   ch:=True;
                   if Assigned(fOnChangeSize) then fOnChangeSize(self,f1^,f2^);
                   end;
                if ch then
                   if Assigned(fOnAnyChange) then fOnAnyChange(self,f1^,f2^);
                end;
             end;
         if Del then Begin
            if Assigned(fOnChangeDeleted) and (List.Count>List1.Count) then fOnChangeDeleted(self,f1^);
            if Assigned(fOnAnyChange) then fOnAnyChange(self,f1^,ff);
            end;
         end;
     for i:=0 to List1.Count-1 do begin
         f2:=List1.Items[i];
         s2:=f2^.cFileName;
         Del:=True;
         for j:=0 to List.Count-1 do begin
             f1:=List.Items[j];
             s1:=f1^.cFileName;
             if s1=s2 then Del:=False;
             end;
         if Del then begin
            if Assigned(fOnChangeRenamed) and (List.Count=List1.Count) then fOnChangeRenamed(self,f2^);
            if Assigned(fOnChangeNew) and (List.Count<List1.Count) then fOnChangeNew(self,f2^);
            if Assigned(fOnAnyChange) then fOnAnyChange(self,f2^,ff);
            end;
         end;
     ClearList(List);
     for j:=0 to List1.Count-1 do begin
         List.Add(List1.Items[0]);
         List1.Delete(0);
         end;
     List1.Free;
end;


procedure Register;
begin
  RegisterComponents('Standard', [TDirChange]);
end;

end.
