program diff;

uses
  classes,
  sysutils,
  aDiff in 'aDiff.pas';

procedure NotifyMe;
begin
  Write('.');
end;

var
  maxlev:integer;
  InStream,OutStream,UseStream:TFileStream;

begin
  Writeln('Difference Maker  Version 1.33');
  Writeln('Copyright (c) 1997 S.Kurinny & S.Kostinsky');
  If (ParamCount<4) or (not (paramstr(1)[1] in ['a','A','e','E','X','x'])) then
  begin
    Writeln;
    Writeln('Use: Diff <a|e> <In_file> <out_file> <use_file> [comp_level]');
    Writeln;
    Writeln('Comp_level - 10..1000  (25 by default)');
    Writeln('            (10   - max. speed, min. comp. ratio)');
    Writeln('            (1000 - min. speed, max. comp. ratio)');
    Writeln;
    Writeln('Use_file   - old file name');
    Writeln('In_file    - input file name');
    Writeln('Out_file   - output file name');
    Writeln;
    Writeln('a - compress  e - extract');

    Writeln;
    Writeln('Press ENTER');
    Readln;
    exit;
  end;
  InStream:=TFileStream.Create(Paramstr(2),fmopenread+fmShareDenyNone);
  OutStream:=TFileStream.Create(Paramstr(3),fmcreate);
  UseStream:=TFileStream.Create(Paramstr(4),fmopenread+fmShareDenyNone);
  try
    Case paramstr(1)[1] of
    'a','A':
      begin
      Writeln('Compressing...');
      if paramcount>4 then maxlev:=strtoint(paramstr(5)) else maxlev:=25;
      DiffStreamCompress(InStream,UseStream,OutStream,NotifyMe,MaxLev);
      end;
    'e','E','x','X':
      begin
      Writeln('Extracting...');
      DiffStreamExtract(InStream,UseStream,OutStream,NotifyMe);
      end;
    end;
  finally
    InStream.Free;
    OutStream.Free;
    UseStream.Free;
  end;
  Writeln;Writeln('Ok');
end.
