unit DICOM;
// Limitations
//- only reads data with 8/16 bit data_alloc
//- compiling for Pascal other than Delphi 2.0+: gDynStr gets VERY big
//- does not extract encapsulated/compressed images
//- write_dicom: currently only writes little endian, data should be little_endian
//- chris.rorden@mrc-cbu.cam.ac.uk
interface
uses
  SysUtils,Dialogs,Controls;
{$H+} //use long, dynamic strings

type
ByteRA = array [1..1] of byte;
Bytep = ^ByteRA;
WordRA = array [1..1] of Word;
Wordp = ^WordRA;

  DICOMdata = record
   XYZdim: array [1..3] of integer;
   XYZori: array [1..3] of integer;
   XYZmm: array [1..3] of double;
   GenesisCpt,GenesisPacked: boolean;
   IntenScale: double;
   Monochrome,SamplesPerPixel,PlanarConfig,ImageStart,little_endian,
   Allocbits_per_pixel,Storedbits_per_pixel,ImageSz,
   WindowWidth,WindowCenter: integer;

  end;
//type
	int32  = LongInt;
	uint32 = Cardinal;
	int16  = SmallInt;
	uint16 = Word;
	int8   = ShortInt;
	uint8  = Byte;
const
     kCR = chr (13);
kA = ord('A');
kB = ord('B');
kC = ord('C');
kD = ord('D');
kE = ord('E');
kF = ord('F');
kG = ord('G');
kH = ord('H');
kI = ord('I');
kJ = ord('J');
kK = ord('K');
kL = ord('L');
kM = ord('M');
kN = ord('N');
kO = ord('O');
kP = ord('P');
kQ = ord('Q');
kR = ord('R');
kS = ord('S');
kT = ord('T');
kU = ord('U');
kV = ord('V');
kW = ord('W');
kX = ord('X');
kY= ord('Y');
kZ= ord('Z');
procedure write_slc (lFileName: string; var pDICOMdata: DICOMdata;var lSz: integer; lDICOM3: boolean);
procedure read_ge_data(var lDICOMdata: DICOMdata; var lHdrOK, lImageFormatOK: boolean; var lDynStr: string;lFileName: string);
procedure read_dicom_data(lAutoDetectGenesis,lReadColorTables: boolean; var lDICOMdata: DICOMdata; var lHdrOK, lImageFormatOK: boolean; var lDynStr: string;lFileName: string);
procedure write_dicom (lFileName: string; var pDICOMdata: DICOMdata;var lSz: integer; lDICOM3: boolean);
var
  red_table_size : Integer = 0;
  green_table_size : Integer = 0;
  blue_table_size : Integer = 0;

  red_table   : ByteP;
  green_table : ByteP;
  blue_table  : ByteP;

implementation
procedure write_slc (lFileName: string; var pDICOMdata: DICOMdata;var lSz: integer; lDICOM3: boolean);
const kMaxRA = 41;
     lXra: array [1..kMaxRA] of byte = (7,8,9,21,22,26,27,
     35,36,44,45,
     50,62,66,78,
     81,95,
     97,103,104,105,106,111,
     113,123,127,
     129,139,142,
     146,147,148,149,155,156,157,
     166,167,168,169,170);
var
   fp: file;
   lX,lClr,lInc,lPos,lRApos: integer;
   lP: bytep;
//     WriteGroupElement(lDICOM3,-1,lPos,$0002,$0010,'U','I','1.2.840.10008.1.2')//implicit xfer syntax
procedure WriteString(lStr: string; lCR: boolean);
var
     n,lStrLen      : Integer;
begin
     lStrLen := length(lStr);
     for n := 1 to lstrlen do begin
            lPos := lPos + 1;
            lP[lPos] := ord(lStr[n]);
     end;
     if lCR then begin
        lPos := lPos + 1;
        lP[lPos] := ord(kCR);
     end;
end;

begin
  lSz := 0;
  getmem(lP,2048);
  lPos := 0;
  WriteString('11111',true);
  WriteString(inttostr(pDicomData.XYZdim[1])+' '+inttostr(pDicomData.XYZdim[2])+' '+inttostr(pDicomData.XYZdim[3])+' 8',true);
  WriteString(floattostrf(pDicomData.XYZmm[1],ffFixed,7,7)+' '+floattostrf(pDicomData.XYZmm[2],ffFixed,7,7)+' '+floattostrf(pDicomData.XYZmm[3],ffFixed,7,7),true);
  WriteString('1 1 0 0',true); //mmunits,MR,original,nocompress
  WriteString('16 12 X',false); //icon is 8x8 grid, so 64 bytes for red,green blue
  for lClr := 1 to 3 do begin
    lRApos := 1;
    for lX := 1 to 192 do begin
      inc(lPos);
      if (lRApos <= kMaxRA) and (lX = lXra[lRApos]) then begin
         inc(lRApos);
         lP[lPos] := 200;
      end else
          lP[lPos] := 0;
    end; {icongrid 1..192}
  end; {RGB}
(*  for lClr := 1 to 3 do begin
      for lX := 1 to 192 do begin
          inc(lPos);
          lP[lPos] := 0;//lX;
      end;  {icon grid 1..64}
  end; {RGB}
  *)
  lX := 2;
  lClr := 3;
  if lFileName <> '' then begin
     //showmessage(chr(lP[1])+chr(lP[lX])+chr(lP[lClr])+': '+inttostr(lPos));
     AssignFile(fp, lFileName);
     Rewrite(fp, 1);
     blockwrite(fp,lP^,lPos);
     close(fp);
  end;
  freemem(lP);
  lSz := lPos;
end;

procedure read_ge_data(var lDICOMdata: DICOMdata; var lHdrOK, lImageFormatOK: boolean; var lDynStr: string;lFileName: string);
label
  539;
var
  lI,W1,W2: word;
  lDATFormatOffset,lExamHeaderLen,lExamHeaderOffset,lHdrOffset,lCompress,linitialoffset,n, i,j,value, Width, max16,min16,slicesz,filesz,where,lStart,lEnd : LongInt;
  tx     : array [0..26] of Char;
  FP: file;
  lMR: boolean;
function swap32i(lPos: longint): Longint;
type
  swaptype = packed record
    case byte of
      0:(Word1,Word2 : word); //word is 16 bit
      1:(Long:LongInt);
  end;
  swaptypep = ^swaptype;
var
   s : LongInt;
  inguy:swaptypep;
  outguy:swaptype;
begin
     seek(fp,lPos);
  BlockRead(fp, s, 4, n);
  inguy := @s; //assign address of s to inguy
  outguy.Word1 := swap(inguy^.Word2);
  outguy.Word2 := swap(inguy^.Word1);
  swap32i:=outguy.Long;
end;
function fswap4r (lPos: longint): single;
type
  swaptype = packed record
    case byte of
      0:(Word1,Word2 : word); //word is 16 bit
      1:(float:single);
  end;
  swaptypep = ^swaptype;
var
   s:single;
  inguy:swaptypep;
  outguy:swaptype;
begin
     seek(fp,lPos);
  BlockRead(fp, s, 4, n);
  inguy := @s; //assign address of s to inguy
  outguy.Word1 := swap(inguy^.Word2);
  outguy.Word2 := swap(inguy^.Word1);
  fswap4r:=outguy.float;
end;
begin
	red_table_size   := 0;
	green_table_size := 0;
	blue_table_size  := 0;
	red_table        := nil;
	green_table      := nil;
	blue_table       := nil;
  lImageFormatOK := true;
  lHdrOK := false;
  if not fileexists(lFileName) then begin
     lImageFormatOK := false;
     exit;
  end;
  FileMode := 0; //set to readonly
  AssignFile(fp, lFileName);
  Reset(fp, 1);
  FIleSz := FileSize(fp);
  lDATFormatOffset := 0;
  lDICOMdata.PlanarConfig:= 1; //only used in RGB values
  lDICOMdata.SamplesPerPixel := 1;
  lDICOMdata.WindowCenter := 0;
  lDICOMdata.WindowWidth := 0;
  lDICOMdata.monochrome := 2; {most common}
     lDICOMdata.XYZmm[1] := 1;
     lDICOMdata.XYZmm[2] := 1;
     lDICOMdata.XYZmm[3] := 1;
     lDICOMdata.XYZdim[1] := 1;
     lDICOMdata.XYZdim[2] := 1;
     lDICOMdata.XYZdim[3] := 1;
     lDICOMdata.ImageStart := 0;
     lDICOMdata.Little_Endian := 0;
     if filesz < (3079+5208) then begin
        showmessage('This file is to small to be a Genesis DAT format image.');
        goto 539;
     end;
     lDynStr:= '';
     lInitialOffset := 0;
     seek(fp, lInitialOffset);
     BlockRead(fp, tx, 4*SizeOf(Char), n);
  if (tx[0] <> 'I') OR (tx[1] <> 'M') OR (tx[2] <> 'G') OR (tx[3] <> 'F') then begin {DAT format}
        lDynStr := lDynStr+'GE Genesis Signa DAT tape format'+kCR;
        seek(fp,114+97);
        BlockRead(fp, tx, 25*SizeOf(Char), n);
        lDynStr := lDynStr + 'Patient Name: ';
        for lI := 0 to 24 do
            lDynStr := lDynStr + tx[lI];
        lDynStr := lDynStr + kCR;
        seek(fp,114+84);
        BlockRead(fp, tx, 13*SizeOf(Char), n);
        lDynStr := lDynStr + 'Patient ID: ';
        for lI := 0 to 12 do
            lDynStr := lDynStr + tx[lI];
        lDynStr := lDynStr + kCR;
     seek(fp, 114+305);
     BlockRead(fp, tx, 3*SizeOf(Char), n);
     if (tx[0]='M') and (tx[1] = 'R') then
        lMR := true
     else if (tx[0] = 'C') and(tx[1] = 'T') then
          lMR := false
     else begin
          Showmessage('Is this a Genesis DAT image? The modality is '+tx[0]+tx[1]+tx[3]
          +'. Expected ''MR'' or ''CT''.');
         exit;
     end;
     if lMR then
        lInitialOffset := 3180
     else
         lInitialOffset := 3178;
     seek(fp, lInitialOffset);
     BlockRead(fp, tx, 4*SizeOf(Char), n);
     if (tx[0] <> 'I') OR (tx[1] <> 'M') OR (tx[2] <> 'G') OR (tx[3] <> 'F') then begin
        showmessage('This image does not have the required label ''IMGF''. This is not a Genesis DAT image.');
        goto 539;
     end;
     lDicomData.XYZmm[3] := fswap4r ({}2158{linitialoffset+lHdrOffset}+26);// slice thickness mm
     lDicomData.XYZmm[1] := fswap4r ({}2158{linitialoffset+lHdrOffset}+50);// pixel size- X
     lDicomData.XYZmm[2] := fswap4r ({}2158{linitialoffset+lHdrOffset}+54);//pixel size - Y
     lDATFormatOffset := 4;
end; {DAT format}
     if lDATFormatOffset = 0 then begin
        lDynStr := lDynStr+'GE Genesis Signa format'+kCR;
        lHdrOffset := swap32i(linitialoffset+132);//x132- int ptr to exam heade
        seek(fp,lHdrOffset+97);
        BlockRead(fp, tx, 25*SizeOf(Char), n);
        lDynStr := lDynStr + 'Patient Name: ';
        for lI := 0 to 24 do
            lDynStr := lDynStr + tx[lI];
        lDynStr := lDynStr + kCR;
        seek(fp,lHdrOffset+84);
        BlockRead(fp, tx, 13*SizeOf(Char), n);
        lDynStr := lDynStr + 'Patient ID: ';
        for lI := 0 to 12 do
            lDynStr := lDynStr + tx[lI];
        lDynStr := lDynStr + kCR;
        lHdrOffset := swap32i(linitialoffset+148);//x148- int ptr to image heade
        lDicomData.XYZmm[3] := fswap4r ({}lHdrOffset{linitialoffset+lHdrOffset}+26);// slice thickness mm
        lDicomData.XYZmm[1] := fswap4r ({}lHdrOffset{linitialoffset+lHdrOffset}+50);// pixel size- X
        lDicomData.XYZmm[2] := fswap4r ({}lHdrOffset{linitialoffset+lHdrOffset}+54);//pixel size - Y
     end;

     lDicomData.ImageStart := lDATFormatOffset+linitialoffset + swap32i(linitialoffset+4);//byte displacement to image data
     lDicomData.XYZdim[1] := swap32i(linitialoffset+8); //width
     lDicomData.XYZdim[2] := swap32i(linitialoffset+12);//height
     lDicomData.Allocbits_per_pixel := swap32i(linitialoffset+16);//bits
     lDicomData.Storedbits_per_pixel:= lDicomData.Allocbits_per_pixel;
     lCompress := swap32i(linitialoffset+20); //compression
     //showmessage(inttostr(lCompress));
     if (lCompress = 3) or (lCompress = 4) then
        lDicomData.GenesisCpt := true
     else
         lDicomData.GenesisCpt := false;
     if (lCompress = 2) or (lCompress = 4) then
        lDicomData.GenesisPacked := true
     else
         lDicomData.GenesisPacked := false;
     lDynStr := lDynStr+'XYZ dim:' +inttostr(lDicomData.XYZdim[1])+'/'
     +inttostr(lDicomData.XYZdim[2])+'/'+inttostr(lDicomData.XYZdim[3])
     +kCR+'XYZ mm:'+floattostrf(lDicomData.XYZmm[1],ffFixed,8,2)+'/'
     +floattostrf(lDicomData.XYZmm[2],ffFixed,8,2)+'/'+floattostrf(lDicomData.XYZmm[3],ffFixed,8,2);
  lHdrOK := true;
539:
       CloseFile(fp);
  FileMode := 2; //set to read/write
end;

procedure write_dicom (lFileName: string; var pDICOMdata: DICOMdata;var lSz: integer; lDICOM3: boolean);
var
   fp: file;
   lHiBit,lGrpError,lStart,lEnd,lInc,lPos: integer;
   lP: bytep;
//     WriteGroupElement(lDICOM3,-1,lPos,$0002,$0010,'U','I','1.2.840.10008.1.2')//implicit xfer syntax
procedure WriteGroupElement(lExplicit: boolean; lInt2,lInt4: integer; var lPos: integer;lGrp,lEle: integer;lChar1,lChar2: char;lInStr: string);
var
     lStr: string;
//	t1, t2 : uint8;
     lPad: boolean;
  n,lStrLen      : Integer;
     lT0,lT1: byte;
begin
     lStr := lInStr;
     lPad := false;
     lT0 := ord(lChar1);
     lT1 := ord(lChar2);
     if (lInt2 >= 0) then
        lStrLen := 2
     else if (lInt4 >= 0) then
        lStrLen := 4
     else begin
          lStrLen := length(lStr);
          if odd(lStrLen) then begin
             inc(lStrLen);
             lPad := true;
             //lStr := lStr + ' ';
          end;
     end;
     lP[lPos+1] := lGrp and $00FF;
     lP[lPos+2] := (lGrp and $FF00) shr 8;
     lP[lPos+3] := lEle and $00FF;
     lP[lPos+4] := (lEle and $FF00) shr 8;
     lInc := 4; //how many bytes have we added;

     if (lExplicit) and ( ((lT0=kO) and (lT1=kB)) or ((lT0=kO) and (lT1=kW))
      or ((lT0=kS) and (lT1=kQ)) )
      then begin

           lP[lPos+5] := lT0;
           lP[lPos+6] := lT1;
           lP[lPos+7] := 0;
           lP[lPos+8] := 0;
           lInc := lInc + 4;
           if lgrp <> $7FE0 then begin
              lP[lPos+9] := lStrLen and $000000FF;
              lP[lPos+10] := lStrLen and $0000FF00;
              lP[lPos+11] := lStrLen and $00FF0000;
              lP[lPos+12] := lStrLen and $FF000000;
              lInc := lInc + 4;
           end;
   end else
   if (lExplicit) and ( ((lT0=kA) and (lT1=kE)) or ((lT0=kA) and (lT1=kS))
      or ((lT0=kA) and (lT1=kT)) or ((lT0=kC) and (lT1=kS)) or ((lT0=kD) and (lT1=kA))
      or ((lT0=kD) and (lT1=kS))
      or ((lT0=kD) and (lT1=kT)) or ((lT0=kF) and (lT1=kL)) or ((lT0=kF) and (lT1=kD))
      or ((lT0=kI) and (lT1=kS)) or ((lT0=kL) and (lT1=kO))or ((lT0=kL) and (lT1=kT))
      or ((lT0=kP) and (lT1=kN)) or ((lT0=kS) and (lT1=kH)) or ((lT0=kS) and (lT1=kL))
      or ((lT0=kS) and (lT1=kS)) or ((lT0=kS) and (lT1=kT)) or ((lT0=kT) and (lT1=kM))
      or ((lT0=kU) and (lT1=kI)) or ((lT0=kU) and (lT1=kL)) or ((lT0=kU) and (lT1=kS))
      or ((lT0=kA) and (lT1=kE)) or ((lT0=kA) and (lT1=kS)) )
      then begin
           lP[lPos+5] := lT0;
           lP[lPos+6] := lT1;
           lP[lPos+7] := lStrLen and $000000FF;
           lP[lPos+8] := lStrLen and $00000FF00;
           lInc := lInc + 4;
   end else if (not ( ((lT0=kO) and (lT1=kB)) or ((lT0=kO) and (lT1=kW))
      or ((lT0=kS) and (lT1=kQ)) )) then begin {Not explicit}
           lP[lPos+5] := lStrLen and $000000FF;
           lP[lPos+6] := lStrLen and $0000FF00;
           lP[lPos+7] := lStrLen and $00FF0000;
           lP[lPos+8] := lStrLen and $FF000000;
           lInc := lInc + 4;
   end;
   if lstrlen = 0 then exit;
   lPos := lPos + lInc;
   if lInt2 >= 0 then begin
       inc(lPos);
       lP[lPos] := lInt2 and $00FF;
       inc(lPos);
       lP[lPos] := (lInt2 and $FF00) shr 8;
//       showmessage(inttostr(lInt2));
       exit;
   end;
   if lInt4 >= 0 then begin
       inc(lPos);
       lP[lPos] := lInt4 and $000000FF;
       inc(lPos);
       lP[lPos] := (lInt4 and $0000FF00) shr 8;
       inc(lPos);
       lP[lPos] := (lInt4 and $00FF0000) shr 16;
       inc(lPos);
       lP[lPos] := (lInt4 and $FF000000) shr 24;
       exit;
   end;
   if lPad then begin
       for n := 1 to (lstrlen-1) do begin
            lPos := lPos + 1;
            lP[lPos] := ord(lStr[n]);
       end;
       lPos := lPos + 1;
       lP[lPos] := 0;
   end else begin
       for n := 1 to lstrlen do begin
            lPos := lPos + 1;
            lP[lPos] := ord(lStr[n]);
       end;
   end;
//   lInc := lInc + lStrLen;

end;

begin
     lSz := 0;
  getmem(lP,1024);
  if lDiCOM3 then begin
     for lInc := 1 to 127 do
      lP[lInc] := 0;
     lP[lInc+1] := ord('D');
     lP[lInc+2] := ord('I');
     lP[lInc+3] := ord('C');
     lP[lInc+4] := ord('M');
     lPos := 128 + 4;
     lGrpError := 12;
  end else begin
      lPos := 0;
      lGrpError := 12;
  end;
if lDICOM3 then begin
  lStart := lPos;
  WriteGroupElement(lDICOM3,-1,2,lPos,$0002,$0000,'U','L','');//length
 //xx  WriteGroupElement(lDICOM3,256,-1,lPos,$0002,$0001,'O','B','');//meta info
  WriteGroupElement(lDICOM3,256,-1,lPos,$0002,$0001,'O','B',' ');//256
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0002,$0002,'U','I','1.2.840.10008.5.1.4.1.1.4');//implicit xfer syntax
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0002,$0003,'U','I','999.999.2.19960619.163000.1.103');//implicit xfer syntax
  if not lDICOM3 then
     WriteGroupElement(lDICOM3,-1,-1,lPos,$0002,$0010,'U','I','1.2.840.10008.1.2')//implicit xfer syntax
  else if pDicomData.little_endian = 1 then
     WriteGroupElement(lDICOM3,-1,-1,lPos,$0002,$0010,'U','I','1.2.840.10008.1.2.1')//little xfer syntax
  else
     WriteGroupElement(lDICOM3,-1,-1,lPos,$0002,$0010,'U','I','1.2.840.10008.1.2.2');//furezx should be 2//big xfer syntax
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0002,$0012,'U','I','999.999');//implicit xfer syntax
  lEnd := lPos;
  lPos := lStart;
  WriteGroupElement(lDICOM3,-1,lEnd-lStart-lGrpError,lPos,$0002,$0000,'U','L','');//length
  lPos := lEnd;
end;
  lStart := lPos;
  WriteGroupElement(lDICOM3,-1,18,lPos,$0008,$0000,'U','L','');//length
//DICOM part 3: 0008,0008 required for MR
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0008,$0008,'C','S','ORIGINAL\PRIMARY');//
 if not lDICOM3 then
     WriteGroupElement(lDICOM3,-1,2,lPos,$0008,$0010,'L','O','ACR-NEMA 2.0');//length
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0008,$0016,'U','I','1.2.840.10008.5.1.4.1.1.4');//
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0008,$0018,'U','I','999.999.2.19960619.163000.1.103');
//a  WriteGroupElement(lDICOM3,-1,-1,lPos,$0008,$0020,'D','A','1995.06.26');//implicit xfer syntax
//a  WriteGroupElement(lDICOM3,-1,-1,lPos,$0008,$0023,'D','A','1995.06.26');//implicit xfer syntax
//a  WriteGroupElement(lDICOM3,-1,-1,lPos,$0008,$0030,'T','M','11:20:00');//implicit xfer syntax
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0008,$0060,'C','S','OT');//modality
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0008,$0070,'L','O','MRIcro');//modality
//a  WriteGroupElement(lDICOM3,-1,-1,lPos,$0008,$0080,'L','O','Community Hospital');//modality
//a  WriteGroupElement(lDICOM3,-1,-1,lPos,$0008,$0081,'S','T','Anytown');//modality
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0008,$0090,'P','N','Anonymized');//name
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0008,$1030,'L','O','MRI');//modality
  lEnd := lPos;
  lPos := lStart;
  WriteGroupElement(lDICOM3,-1,lEnd-lStart-lGrpError,lPos,$0008,$0000,'U','L','');//length
  lPos := lEnd;

  lStart := lPos;
  WriteGroupElement(lDICOM3,-1,18,lPos,$0010,$0000,'U','L','');//length
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0010,$0010,'P','N','Anonymized');//name
  lEnd := lPos;
  lPos := lStart;
  WriteGroupElement(lDICOM3,-1,lEnd-lStart-lGrpError,lPos,$0010,$0000,'U','L','');//length
  lPos := lEnd;

  lStart := lPos;
  WriteGroupElement(lDICOM3,-1,18,lPos,$0018,$0000,'U','L','');//length
//z DICOM part 3: 0018,0020 required for MR
//z DICOM part 3: 0018,0021 required for MR
//z DICOM part 3: 0018,0022 required for MR
//z DICOM part 3: 0018,0023 required for MR

  WriteGroupElement(lDICOM3,-1,-1,lPos,$0018,$0050,'D','S',floattostrf(pDicomData.XYZmm[3],ffFixed,8,2));//slice thickness
//z DICOM part 3: 0018,0080 required for MR
//z  WriteGroupElement(lDICOM3,-1,-1,lPos,$0018,$0080,'D','S',floattostrf(1333.33,ffFixed,8,2));//
//z DICOM part 3: 0018,0081 required for MR
//z  WriteGroupElement(lDICOM3,-1,-1,lPos,$0018,$0081,'D','S',floattostrf(11.98,ffFixed,8,2));//
//z DICOM part 3: 0018,0091 required for MR
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0018,$1020,'L','O',inttostr(pDicomData.XYZori[1])+'\'+inttostr(pDicomData.XYZori[2])+'\'+inttostr(pDicomData.XYZori[3]));//software version
//a  WriteGroupElement(lDICOM3,-1,-1,lPos,$0018,$1149,'I','S','350');//Study UID

//b 0018,1314 found in demo MRs:
//a  WriteGroupElement(lDICOM3,-1,-1,lPos,$0018,$1314,'D','S','50');//
  lEnd := lPos;
  lPos := lStart;
  WriteGroupElement(lDICOM3,-1,lEnd-lStart-lGrpError,lPos,$0018,$0000,'U','L','');//length
  lPos := lEnd;


  lStart := lPos;
  WriteGroupElement(lDICOM3,-1,18,lPos,$0020,$0000,'U','L','');//length
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0020,$000D,'U','I','999.999.2.19960619.163000');//Study UID
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0020,$000E,'U','I','999.999.2.19960619.163000.1');//Study UID
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0020,$0011,'I','S','1');//Study UID
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0020,$0013,'I','S','103');//Study UID
//  WriteGroupElement(lDICOM3,-1,-1,lPos,$0020,$1041,'D','S',floattostrf(1-pDicomData.XYZdim[3],ffFixed,8,2));//$1041: info := 'Slice Location';
  lEnd := lPos;
  lPos := lStart;
  WriteGroupElement(lDICOM3,-1,lEnd-lStart-lGrpError,lPos,$0020,$0000,'U','L','');//length
  lPos := lEnd;

  lStart := lPos;
  WriteGroupElement(lDICOM3,-1,28,lPos,$0028,$0000,'U','L','');//length
  //0028,0002: set value to 1 [plane]: greyscale, required by DICOM part 3 for MR
  WriteGroupElement(lDICOM3,1,-1,lPos,$0028,$0002,'U','S','');
  //MONOCHROME1: low values = white, MONOCHROME2: low values = dark, 0028,0004 required for MR
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0028,$0004,'C','S','MONOCHROME2');
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0028,$0008,'I','S',inttostr(pDicomData.XYZdim[3]));//num frames
  //Part 3 of DICOM standard: 0028,0009 is REQUIRED for Multiframe images: 1063/18 for time, 1065/18 for time vector and 13/20 for image number [space]
  WriteGroupElement(lDICOM3,-1,($0013 shl 16)+($20 ),lPos,$0028,$0009,'A','T','');//frame ptr
  WriteGroupElement(lDICOM3,pDicomData.XYZdim[2],-1,lPos,$0028,$0010,'U','S',' ');//inttostr(lDicomData.XYZdim[2]));//row
  WriteGroupElement(lDICOM3,pDicomData.XYZdim[1],-1,lPos,$0028,$0011,'U','S',' ');//inttostr(lDicomData.XYZdim[1]));//col
  //0030 order: row spacing[y], column spacing[x]: see DICOM part 3
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0028,$0030,'D','S',floattostrf(pDicomData.XYZmm[2],ffFixed,8,2)+'\'+floattostrf(pDicomData.XYZmm[1],ffFixed,8,2));//pixel spacing
//DICOM part 3: 0028,0100 required for MR
  WriteGroupElement(lDICOM3,pDicomData.Allocbits_per_pixel,-1,lPos,$0028,$0100,'U','S',' ');//inttostr(lDicomData.Allocbits_per_pixel));//bitds alloc
  WriteGroupElement(lDICOM3,pDicomData.Storedbits_per_pixel,-1,lPos,$0028,$0101,'U','S',' ');//inttostr(lDicomData.Storedbits_per_pixel));//bits stored
  if pDicomData.little_endian <> 1 then
     lHiBit := 0
  else
      lHiBit := pDicomData.Storedbits_per_pixel -1;
  WriteGroupElement(lDICOM3,lHiBit,-1,lPos,$0028,$0102,'U','S',' ');//inttostr(lDicomData.Storedbits_per_pixel -1));//high bit
  WriteGroupElement(lDICOM3,0,-1,lPos,$0028,$0103,'U','S',' ');//pixel representation//inttostr(lDicomData.Storedbits_per_pixel -1));//high bit
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0028,$1052,'D','S',floattostrf(0,ffFixed,8,2));//rescale intercept
  WriteGroupElement(lDICOM3,-1,-1,lPos,$0028,$1053,'D','S',floattostrf(pDicomData.IntenScale,ffGeneral,7,2));//slice thickness

  lEnd := lPos;
  lPos := lStart;
  WriteGroupElement(lDICOM3,-1,lEnd-lStart-lGrpError,lPos,$0028,$0000,'U','L','');//length
  lPos := lEnd;

  WriteGroupElement(lDICOM3,-1,pDicomData.ImageSz+12,lPos,($7FE0),$0000,'U','L','');//data size
  WriteGroupElement(lDICOM3,-1,pDicomData.ImageSz,lPos,($7FE0),$0010,'O','B','');//data size
  if lFileName <> '' then begin
     AssignFile(fp, lFileName);
     Rewrite(fp, 1);
     blockwrite(fp,lP^,lPos);
     close(fp);
  end;
  freemem(lP);
  lSz := lPos;
end;

procedure read_dicom_data(lAutoDetectGenesis,lReadColorTables: boolean; var lDICOMdata: DICOMdata; var lHdrOK, lImageFormatOK: boolean; var lDynStr: string;lFileName: string);
label 666,777;
type
  dicom_types = (unknown, i8, i16, i32, ui8, ui16, ui32, _string );
var
 lWordRA: Wordp;
   FP: file;
   lT0,lT1,lT2,lT3:byte;
   lGenesis,lFirstPass,lrOK,lBig,lBigSet,lGrp,explicitVR,first_one    : Boolean;
  time_to_quit : Boolean;
  group, element, dummy, e_len, remaining, tmp : uint32;
  lgrpstr,tmpstr,lStr,info   : string;
  t      : dicom_types;
  lfloat1,lfloat2: double;
  n, i,j,value, Width, max16,min16,slicesz,filesz,where,lStart,lEnd : LongInt;
  tx     : array [0..3] of Char;
  buff: pCHar;
  lColorRA: bytep;
(*procedure QStr(lS: String);
var lO: string;
lL,lI: integer;
begin
     lL := length(lS);
     if lL < 1 then begin
        showmessage('Empty string');
        exit;
     end;
     lO := '';
     for lI := 1 to lL do begin
         if lS[lI] in ['.','+','-','/','\', '0'..'9','a'..'z','A'..'Z'] then
            lO := lO + lS[lI]
         else
             lO := lO + 'x';
     end;
     showmessage(lO);
end;(**)

procedure readfloats (var fp: file; remaining: integer; var lOutStr: string; var lf1, lf2: double; var lReadOK: boolean);
var  lDigit : boolean;
   li,lLen,n: integer;
    lfStr: string;
begin
    lf1 := 1;
    lf2 := 2;
if (FilePos(fp) > (filesz-remaining)) or (remaining < 1) then begin
   lOutStr := '';
   lReadOK := false;
   exit;
end else
    lReadOK := true;
    lOutStr := '';
    GetMem( buff, e_len);
    BlockRead(fp, buff^, e_len, n);
    for li := 0 to e_len-1 do
        if Char(buff[li]) in ['/','\','e','E','+','-','.','0'..'9']
           then lOutStr := lOutStr +(Char(buff[li]))
        else lOutStr := lOutStr + ' ';
    FreeMem( buff);
    lfStr := '';
    lLen := length(lOutStr);
    li := 1;
    lDigit := false;
    repeat
      if (lOutStr[li] in ['+','-','e','E','.','0'..'9']) then
         lfStr := lfStr + lOutStr[li];
      if lOutStr[li] in ['0'..'9'] then lDigit := true;
      inc(li);
    until (li > lLen) or (lDigit);
    if not lDigit then exit;
    if li <= li then begin
       repeat
             if not (lOutStr[li] in ['+','-','e','E','.','0'..'9']) then lDigit := false
             else begin
                  if lOutStr[li] = 'E' then lfStr := lfStr+'e'
                  else
                      lfStr := lfStr + lOutStr[li];
             end;
             inc(li);
       until (li > lLen) or (not lDigit);
    end;
    //QStr(lfStr);
    try
       lf1 := strtofloat(lfStr);
    except
          on EConvertError do begin
             showmessage('Unable to convert the string '+lfStr+' to a real number');
             lf1 := 1;
             exit;
          end;
    end; {except}
    lfStr := '';
    if li > llen then exit;
    repeat
             if (lOutStr[li] in ['+','E','e','.','-','0'..'9']) then begin
                  if lOutStr[li] = 'E' then lfStr := lfStr+'e'
                  else
                      lfStr := lfStr + lOutStr[li];
             end;
             if (lOutStr[li] in ['0'..'9']) then lDigit := true;
             inc(li);
    until (li > lLen);
    if not lDigit then exit;
    //QStr(lfStr);
    try
       lf2 := strtofloat(lfStr);
    except
          on EConvertError do begin
             showmessage('Unable to convert the string '+lfStr+' to a real number');
             exit;
          end;
    end;

end;
function read16( var fp : File; var lReadOK: boolean ): uint16;
var
	t1, t2 : uint8;
  n      : Integer;
begin
if FilePos(fp) > (filesz-2) then begin
   read16 := 0;
   lReadOK := false;
   exit;
end else
    lReadOK := true;
	BlockRead(fp, t1, SizeOf(uint8), n);
	BlockRead(fp, t2, SizeOf(uint8), n);
  if lDICOMdata.little_endian <> 0
  	then Result := (t1 + t2*256) AND $FFFF
  	else Result := (t1*256 + t2) AND $FFFF;
end;

function  ReadStr(var fp: file; remaining: integer; var lReadOK: boolean) : string;
var lInc, lN,Val,n: integer;
	t1, t2 : uint8;
     lStr : String;
begin
if FilePos(fp) > (filesz-remaining) then begin
   lReadOK := false;
   exit;
end else
    lReadOK := true;
    Result := '';
    lN := remaining div 2;
    if lN < 1 then exit;
    lStr := '';
    for lInc := 1 to lN do begin
	BlockRead(fp, t1, SizeOf(uint8), n);
	BlockRead(fp, t2, SizeOf(uint8), n);
     if lDICOMdata.little_endian <> 0 then
        Val := (t1 + t2*256) AND $FFFF
     else
         Val := (t1*256 + t2) AND $FFFF;
     if lInc < lN then lStr := lStr + inttostr(Val)+ ', '
     else lStr := lStr + inttostr(Val);
    end;
    Result := lStr;
    if odd(remaining) then BlockRead(fp, t1, SizeOf(uint8), n);
end;
function  ReadStrHex(var fp: file; remaining: integer; var lReadOK: boolean) : string;
var lInc, lN,Val,n: integer;
	t1, t2 : uint8;
     lStr : String;
begin
if FilePos(fp) > (filesz-remaining) then begin
   lReadOK := false;
   exit;
end else
    lReadOK := true;
    Result := '';
    lN := remaining div 2;
    if lN < 1 then exit;
    lStr := '';
    for lInc := 1 to lN do begin
	BlockRead(fp, t1, SizeOf(uint8), n);
	BlockRead(fp, t2, SizeOf(uint8), n);
     if lDICOMdata.little_endian <> 0 then
        Val := (t1 + t2*256) AND $FFFF
     else
         Val := (t1*256 + t2) AND $FFFF;
     if lInc < lN then lStr := lStr + 'x'+inttohex(Val,4)+ ', '
     else lStr := lStr + 'x'+inttohex(Val,4);
//     if Inc > 1 then  lStr := lStr + ', ';
    end;
    Result := lStr;
    if odd(remaining) then BlockRead(fp, t1, SizeOf(uint8), n);
end;

function read32 ( var fp : File; var lReadOK: boolean ): uint32;
var
	t1, t2, t3, t4 : byte;
  n : Integer;
begin
if FilePos(fp) > (filesz-4) then begin
   Read32 := 0;
   lReadOK := false;
   exit;
end else
    lReadOK := true;
	BlockRead(fp, t1, SizeOf(uint8), n);
	BlockRead(fp, t2, SizeOf(uint8), n);
	BlockRead(fp, t3, SizeOf(uint8), n);
	BlockRead(fp, t4, SizeOf(uint8), n);
  if lDICOMdata.little_endian <> 0
  	then Result := (t1 + t2*256 + t3*256*256 + t4*256*256*256) AND $FFFFFFFF
    else Result := (t1*256*256*256 + t2*256*256 + t3*256 + t4) AND $FFFFFFFF;
end;

begin
	red_table_size   := 0;
	green_table_size := 0;
	blue_table_size  := 0;
	red_table        := nil;
	green_table      := nil;
	blue_table       := nil;
  lImageFormatOK := true;
  lHdrOK := false;
  if not fileexists(lFileName) then begin
     lImageFormatOK := false;
     exit;
  end;
  FileMode := 0; //set to readonly
  AssignFile(fp, lFileName);
  Reset(fp, 1);
  lDICOMdata.PlanarConfig:= 1; //only used in RGB values
  lDICOMdata.GenesisCpt := false;
  lDICOMdata.GenesisPacked := false;
  lDICOMdata.SamplesPerPixel := 1;
  lDICOMdata.WindowCenter := 0;
  lDICOMdata.WindowWidth := 0;
  lDICOMdata.monochrome := 2; {most common}
     lDICOMdata.XYZmm[1] := 1;
     lDICOMdata.XYZmm[2] := 1;
     lDICOMdata.XYZmm[3] := 1;
     lDICOMdata.XYZdim[1] := 1;
     lDICOMdata.XYZdim[2] := 1;
     lDICOMdata.XYZdim[3] := 1;
     lDICOMdata.ImageStart := 0;
     lDICOMdata.Little_Endian := 1;
  lDynStr:= '';
  first_one    := true;
  info := '';
  lGrp:= false;
  lBigSet := false;
  FIleSz := FileSize(fp);
  if (lAutoDetectGenesis) and (FileSz > (114+35+4)) then begin
     seek(fp, 0);
     BlockRead(fp, tx, 4*SizeOf(Char), n);
     lGenesis := false;
     if (tx[0] <> 'I') OR (tx[1] <> 'M') OR (tx[2] <> 'G') OR (tx[3] <> 'F') then begin {DAT format}
        seek(fp, 114+305);
        BlockRead(fp, tx, 3*SizeOf(Char), n);
        if ((tx[0]='M') and (tx[1] = 'R')) or ((tx[0] = 'C') and(tx[1] = 'T')) then
           lGenesis := true;
     end else
         lGenesis := true;
     if lGenesis then begin
        CloseFile(fp);
        FileMode := 2; //set to read/write
        read_ge_data(lDICOMdata, lHdrOK, lImageFormatOK,lDynStr,lFileName);
        exit;
     end;
  end; //AutodetectGenesis
		// try DICOM part 10 i.e. a 128 byte file preamble followed by "DICM"
  if filesz <= 8 then goto 666;
  seek(fp, 0);
  //where := FilePos(fp);
  BlockRead(fp, tx, 4*SizeOf(Char), n);
  if (tx[0] <> 'D') OR (tx[1] <> 'I') OR (tx[2] <> 'C') OR (tx[3] <> 'M') then begin
     if filesz > 132 then begin
        seek(fp, 128); //skip the preamble - next 4 bytes should be 'DICM'
  	   //where := FilePos(fp);
        BlockRead(fp, tx, 4*SizeOf(Char), n);
     end;
     if (tx[0] <> 'D') OR (tx[1] <> 'I') OR (tx[2] <> 'C') OR (tx[3] <> 'M') then begin
        seek(fp, 0);
        group   := read16(fp,lrOK);
        if not lrOK then goto 666;
        if NOT (group in [$0000, $0002, $0004, $0008]) then begin
           goto 666;
        end;
        seek(fp, 0);
     end; //else showmessage('DICM at 128');
  end; //else showmessage('DICM at 0');;
		// Read DICOM Tags
	time_to_quit := FALSE;
     explicitVR := false;
    tmpstr := '';
    lBig := false;
      tmp := 0;
    while NOT time_to_quit do begin
  t := unknown;
  	where     := FilePos(fp);
     lFirstPass := true;
777:
   	group     := read16(fp,lrOK);
     if not lrOK then goto 666;

     if (lFirstPass) and (group = 2048) then begin
         if lDicomData.little_endian = 1 then lDicomData.Little_endian := 0
         else lDicomData.little_endian := 1;
         seek(fp,where);
         lFirstPass := false;
         goto 777;
     end;
     element   := read16(fp,lrOK);
     if not lrOK then goto 666;
     e_len:= read32(fp,lrOK);
     if not lrOK then goto 666;
lGrpStr := '';
    lt0 := e_len and 255;
    lt1 := (e_len shr 8) and 255;
    lt2 := (e_len shr 16) and 255;
    lt3 := (e_len shr 24) and 255;
 if explicitVR or first_one then begin
   if  ((lT0=kO) and (lT1=kB)) or ((lT0=kO) and (lT1=kW)) or ((lT0=kS) and (lT1=kQ)) then begin
       lGrpStr := chr(lT0)+chr(lT1);
           e_len:= read32(fp,lrOK);
           if not lrOK then goto 666;
           if first_one then explicitVR := true;
   end else if ((lT3=kO) and (lT2=kB)) or ((lT3=kO) and (lT2=kW)) or ((lT3=kS) and (lT2=kQ)) then begin
           e_len:= read32(fp,lrOK);
           if not lrOK then goto 666;
           if first_one then explicitVR := true;
   end else
   if  ( ((lT0=kA) and (lT1=kE)) or ((lT0=kA) and (lT1=kS))
      or ((lT0=kA) and (lT1=kT)) or ((lT0=kC) and (lT1=kS)) or ((lT0=kD) and (lT1=kA))
      or ((lT0=kD) and (lT1=kS))
      or ((lT0=kD) and (lT1=kT)) or ((lT0=kF) and (lT1=kL)) or ((lT0=kF) and (lT1=kD))
      or ((lT0=kI) and (lT1=kS)) or ((lT0=kL) and (lT1=kO))or ((lT0=kL) and (lT1=kT))
      or ((lT0=kP) and (lT1=kN)) or ((lT0=kS) and (lT1=kH)) or ((lT0=kS) and (lT1=kL))
      or ((lT0=kS) and (lT1=kS)) or ((lT0=kS) and (lT1=kT)) or ((lT0=kT) and (lT1=kM))
      or ((lT0=kU) and (lT1=kI)) or ((lT0=kU) and (lT1=kL)) or ((lT0=kU) and (lT1=kS))
      or ((lT0=kA) and (lT1=kE)) or ((lT0=kA) and (lT1=kS)) )
      then begin
           lGrpStr := chr(lT0) + chr(lT1);
           if lDicomData.little_endian = 1 then
              e_len := (e_len and $ffff0000) shr 16
           else
              e_len := swap((e_len and $ffff0000) shr 16);
           if first_one then begin
              explicitVR := true;
           end;
   end else if (
           ((lT3=kA) and (lT2=kT)) or ((lT3=kC) and (lT2=kS)) or ((lT3=kD) and (lT2=kA))
           or ((lT3=kD) and (lT2=kS))
      or ((lT3=kD) and (lT2=kT)) or ((lT3=kF) and (lT2=kL)) or ((lT3=kF) and (lT2=kD))
      or ((lT3=kI) and (lT2=kS)) or ((lT3=kL) and (lT2=kO))or ((lT3=kL) and (lT2=kT))
      or ((lT3=kP) and (lT2=kN)) or ((lT3=kS) and (lT2=kH)) or ((lT3=kS) and (lT2=kL))
      or ((lT3=kS) and (lT2=kS)) or ((lT3=kS) and (lT2=kT)) or ((lT3=kT) and (lT2=kM))
      or ((lT3=kU) and (lT2=kI)) or ((lT3=kU) and (lT2=kL)) or ((lT3=kU) and (lT2=kS)))
      then begin
           if lDicomData.little_endian = 1 then
              e_len := (256 * lT0) + lT1
           else
              e_len := (lT0) + (256*lT1);
           if first_one then begin
              explicitVR := true;
           end;
   end;
end; //not first_one or explicit
   if (first_one) and (lDicomdata.little_endian =0) and (e_len = $04000000) then begin
      ShowMessage('Switching to little endian');
      lDicomData.little_endian := 1;
      seek(fp, where);
      first_one := false;
      goto 777;
   end else if (first_one) and (lDicomData.little_endian =1) and (e_len = $04000000) then begin
       ShowMessage('Switching to little endian');
       lDicomData.little_endian := 0;
       seek(fp, where);
       first_one := false;
       goto 777;
   end;
   first_one    := false;
    remaining := e_len;
    info := 'UNKNOWN';
    case group of
    	$0002 :
      	case element of
        	$00 :  info := 'File Meta Elements Group Len';
          $01 :  info := 'File Meta Info Version';
          $02 :  info := 'Media Storage SOP Class UID';
          $03 :  info := 'Media Storage SOP Inst UID';
          $10 :  begin
              info := 'Transfer Syntax UID';
              TmpStr := '';
              if FilePos(fp) > (filesz-e_len) then goto 666;
              GetMem( buff, e_len);
              BlockRead(fp, buff^, e_len, n);
              for i := 0 to e_len-1 do
                   	if Char(buff[i]) in ['+','-',' ', '0'..'9','a'..'z','A'..'Z']
                     	then TmpStr := TmpStr +(Char(buff[i]))
                      else TmpStr := TmpStr +('.');
              FreeMem( buff);
              lStr := '';
              if length(TmpStr) >= 19 then begin
                  if TmpStr[19] = '1' then begin
                     lBigSet:= true;
                     lBig := false;
                  end else if TmpStr[19] = '2' then begin
                     lBigSet:= true;
                     lBig := true;
                  end else if TmpStr[19] = '4' then begin
                      ShowMessage('Unable to extract JPEG: '+TmpStr[17]);
                      lImageFormatOK := false;
                  end else if TmpStr[19] = '5' then begin
                      ShowMessage('Unable to extract lossless run length encoding: '+TmpStr[17]);
                      lImageFormatOK := false;
                  end else begin
                      ShowMessage('Unable to extract unknown data type: '+TmpStr[17]);
                      lImageFormatOK := false;
                  end;
              end; {length}
                  remaining := 0;
                  e_len := 0; {use tempstr}
              end;
          $12 :  begin
              info := 'Implementation Class UID';
              end;
          $13 :
              info := 'Implementation Version Name';
          $16 :  info := 'Source App Entity Title';
          $100:  info := 'Private Info Creator UID';
          $102:  info := 'Private Info';
				end;
      $0008 :
        case element of
          $00 :  begin
              info := 'Identifying Group Length';
          end;
          $01 :  info := 'Length to End';
          $05 :  info := 'Specific Character Set';
          $08 :  begin
              info := 'Image Type';
              t := _string;
              end;
          $10 :  info := 'Recognition Code';
          $12 :  info := 'Instance Creation Date';
          $13 :  info := 'Instance Creation Time';
          $14 :  info := 'Instance Creator UID';
          $16 :  info := 'SOP Class UID';
          $18 :  info := 'SOP Instance UID';
          $20 :  info := 'Study Date';
          $21 :  info := 'Series Date';
          $22 :  info := 'Acquisition Date';
          $23 :  info := 'Image Date';
          $30 :  info := 'Study Time';
          $31 :  info := 'Series Time';
          $32 :  info := 'Acquisition Time';
          $33 :  info := 'Image Time';
          $40 :  info := 'Data Set Type';
          $41 :  info := 'Data Set Subtype';
          $50 :  info := 'Accession Number';
          $60 :  begin info := 'Modality';  t := _string; end;
          $64 :  begin info := 'Conversion Type';  t := _string; end;
          $70 :  info := 'Manufacturer';
          $80 :  info := 'Institution Name';
          $81 :  info := 'City Name';
          $90 :  info := 'Referring Physician''s Name';
          $1010: info := 'Station Name';
          $1030: begin info := 'Study Description'; t := _string; end;
          $103e: info := 'Series Description';
          $1040: info := 'Institutional Dept. Name';
          $1050: info := 'Performing Physician''s Name';
          $1060: info := 'Name Phys(s) Read Study';
          $1070: begin info := 'Operator''s Name';  t := _string; end;
          $1080: info := 'Admitting Diagnosis Description';
          $1090: begin info := 'Manufacturer''s Model Name';t := _string; end;
          $1140: info := 'Referenced Image Sequence';
          $2120: info := 'Stage Name';
          $2122: begin info := 'Stage Number';t := _string; end;
          $2124: begin info := 'Number of Stages';t := _string; end;
          $2128: begin info := 'View Number';t := _string; end;
          $212A: begin info := 'Number of Views in stage';t := _string; end;
          $2204: info := 'Transducer Orientation';


        end;
    	$0010 :
        case element of
        	$00 :  info := 'Patient Group Length';
          $10 :  begin info := 'Patient''s Name'; t := _string; end;
          $20 :  info := 'Patient ID';
          $30 :  info := 'Patient Date of Birth';
          $40 :  begin info := 'Patient Sex';  t := _string; end;
          $1005: info := 'Patient''s Birth Name';
          $1010: info := 'Patient Age';
          $1030: info := 'Patient Weight';
          $21b0: info := 'Additional Patient History';
				end;
			$0018 :
        case element of
             $00 :  info := 'Acquisition Group Length';
          $10 :  begin info := 'Contrast/Bolus Agent'; t := _string; end;
          $15: info := 'Body Part Examined';
          $20 :  begin info := 'Scanning Sequence';t := _string; end;
          $21 :  begin info := 'Sequence Variant';t := _string; end;
          $22 :  info := 'Scan Options';
          $23 :  begin info := 'MR Acquisition Type'; t := _string; end;
          $24 :  info := 'Sequence Name';
          $25 :  begin info := 'Angio Flag';t := _string; end;
          $30 :  info := 'Radionuclide';
          $50 :  begin info := 'Slice Thickness';
             readfloats (fp, remaining, TmpStr, lfloat1, lfloat2, lROK);
              if not lrOK then goto 666;
e_len := 0;      remaining := 0;
             lDICOMdata.XYZmm[3] := lfloat1;
          end;
          $60: info := 'KVP';
          $70: begin t := _string; info := 'Counts Accumulated'; end;
          $71: begin t := _string; info := 'Acquisition Condition'; end;
          $80 :  info := 'Repetition Time';
          $81 :  info := 'Echo Time';
          $82 :  begin t := _string; info := 'Inversion Time'; end;
          $83 :  begin t := _string; info := 'Number of Averages'; end;
          $84 :  info := 'Imaging Frequency';
          $85 :  begin info := 'Imaged Nucleus';  t := _string; end;
          $86 :  begin info := 'Echo Number';t := _string; end;
          $87 :  info := 'Magnetic Field Strength';
          $88 :  info := 'Spacing Between Slices';
          $89 : begin
              t := _string;
              info := 'Number of Phase Encoding Steps';
              end;
          $90 :  info := 'Data collection diameter';
          $91 :  begin info := 'Echo Train Length';t := _string; end;
          $93: info := 'Percent Sampling';
          $94: info := 'Percent Phase Field View';
          $95 :  info := 'Pixel Bandwidth';
          $1000: begin t := _string; info := 'Device Serial Number'; end;
          $1020: begin info := 'Software Version';t := _string; end;
          $1030: info := 'Protocol Name';
          $1040: info := 'Contrast/Bolus Route';
          $1050 :  begin
              t := _string; info := 'Spatial Resolution'; end;
          $1062: info := 'Nominal Interval';
          $1063: info := 'Frame Time';
          $1081: info := 'Low R-R Value';
          $1082: info := 'High R-R Value';
          $1083: info := 'Intervals Acquired';
          $1084: info := 'Intervals Rejected';
          $1088: begin info := 'Heart Rate'; t := _string; end;
          $1090: begin info :=  'Cardiac Number of Images'; t := _string; end;
          $1094: begin info :=  'Trigger Window';t := _string; end;
          $1100: info := 'Reconstruction Diameter';
          $1110: info := 'Distance Source to Detector';
          $1111: info := 'Distance Source to Patient';
          $1120: info := 'Gantry/Detector Tilt';
          $1130: info := 'Table Height';
          $1140: info := 'Rotation Direction';
          $1149: begin
              t := _string; info := 'Field of View Dimension[s]'; end;
          $1150: info := 'Exposure Time';
          $1151: info := 'X-ray Tube Current';
          $1152 :  info := 'Exposure';
          $1155: info := 'Radiation Setting';
          $1160: info := 'Filter Type';
          $1170 :  info := 'Generator Power';
          $1190 :  info := 'Focal Spot[s]';
          $1200 :  info := 'Date of Last Calibration';
          $1201 :  info := 'Time of Last Calibration';
          $1210: info := 'Convolution Kernel';
          $1250: begin t := _string; info := 'Receiving Coil'; end;
          $1251: begin t := _string; info := 'Transmitting Coil'; end;
          $1260 :  begin
              t := _string; info := 'Plate Type'; end;
          $1261 :  begin
              t := _string; info := 'Phosphor Type';  end;
          $1310: begin info := 'Acquisition Matrix'; TmpStr := ReadStr(fp, remaining,lrOK);
                     if not lrOK then goto 666;
e_len := 0; remaining := 0; end;
          $1312: begin
              t := _string; info := 'Phase Encoding Direction'; end;
          $1314: begin
              t := _string; info := 'Flip Angle'; end;
          $1315: begin
              t := _string;info := 'Variable Flip Angle Flag'; end;
          $1316: begin
              t := _string;info := 'SAR'; end;
          $1400: info := 'Aquisition Device Processing Description';
          $1401: begin info := 'Aquisition Device Processing Code';t := _string; end;
          $1402: info := 'Cassette Orientation';
          $1403: info := 'Cassette Size';
          $1500: info := 'Positioner Motion';
          $1510: info := 'Positioner Primary Angle';
          $1511: info := 'Positioner Secondary Angle';
          $5020: info := 'Processing Function';
          $5100: begin
              t := _string; info := 'Patient Position';  end;
          $5101: begin info := 'View Position';t := _string; end;
          $6000: begin info := 'Sensitivity'; t := _string; end;
				end;
			$0020 :
        case element of
					$00 :  info := 'Relationship Group Length';
          $0d :  info := 'Study Instance UID';
          $0e :  info := 'Series Instance UID';
          $10 :  info := 'Study ID';
          $11 :  begin info := 'Series Number';       t := _string; end;
          $12 :  begin info := 'Acquisition Number';  t := _string; end;
          $13 :  begin info := 'Image Number';        t := _string; end;
          $20 :  begin info := 'Patient Orientation'; t := _string; end;
          $30 :  info := 'Image Position';
          $32 :  info := 'Image Position Patient';
          $35 :  info := 'Image Orientation';
          $37 :  info := 'Image Orientation (Patient)';
          $50 :  info := 'Location';
          $52 :  info := 'Frame of Reference UID';
          $91 :  info := 'Echo Train Length';
          $70 :  info := 'Image Geometry Type';
          $60 :  info := 'Laterality';
          $1001: info := 'Acquisitions in Series';
          $1002: info := 'Images in Acquisition';
          $1020: info := 'Reference';
          $1040: begin info :=  'Position Reference';  t := _string; end;
          $1041: info := 'Slice Location';
          $3401: info := 'Modifying Device ID';
          $3402: info := 'Modified Image ID';
          $3403: info := 'Modified Image Date';
          $3404: info := 'Modifying Device Mfg.';
          $3405: info := 'Modified Image Time';
          $3406: info := 'Modified Image Desc.';
          $4000: info := 'Image Comments';
          $5000: info := 'Original Image ID';
          $5002: info := 'Original Image... Nomenclature';
				end;
			$0028 :
        case element of
        	$00 :  info := 'Image Presentation Group Length';
          $02 :  begin
              info := 'Samples Per Pixel';
          				tmp := read16(fp,lrOK);
                                        if not lrOK then goto 666;
          				lDicomData.SamplesPerPixel :=tmp;
                  remaining := 0;
              end;

          $04 :  begin
              info := 'Photometric Interpretation';{help}
              TmpStr := '';
              if FilePos(fp) > (filesz-e_len) then goto 666;
              GetMem( buff, e_len);
              BlockRead(fp, buff^, e_len, n);
              for i := 0 to e_len-1 do
                   	if Char(buff[i]) in [{'+','-',' ', }'0'..'9','a'..'z','A'..'Z']
                     	then TmpStr := TmpStr +(Char(buff[i]));
              FreeMem( buff);
              if TmpStr = 'MONOCHROME1' then lDicomdata.monochrome := 1
              else if TmpStr = 'MONOCHRMOE2' then lDicomdata.monochrome := 2
              else lDICOMdata.monochrome := 3;
                  remaining := 0;
                  e_len := 0; {use tempstr}

          end;
          $05 :  info := 'Image Dimensions (ret)';
          $06 : begin
              info := 'Planar Configuration';
                        				tmp := read16(fp,lrOK);
                                        if not lrOK then goto 666;
          				lDicomData.PlanarConfig :=tmp;
                  remaining := 0;
              end;

          $08 :  begin
              t := _string;
              lStr := '';
              if FilePos(fp) > (filesz-e_len) then goto 666;
              GetMem( buff, e_len);
              BlockRead(fp, buff^, e_len, n);
              for i := 0 to e_len-1 do
                   	if Char(buff[i]) in ['+','-','0'..'9']
                     	then lStr := lStr +(Char(buff[i]));
              FreeMem( buff);
              lDicomData.XYZdim[3] := strtoint(lStr);
          				tmp := lDicomData.XYZdim[3];
                  remaining := 0;
                  if lDicomData.XYZdim[3] < 1 then lDicomData.XYZdim[3] := 1;
               info := 'Number of Frames';
                 end;
          $09: begin info := 'Frame Increment Pointer'; TmpStr := ReadStrHex(fp, remaining,lrOK);           if not lrOK then goto 666;
 e_len := 0; remaining := 0; end;
          $10 :  begin info := 'Rows';
          				lDicomData.XYZdim[2] := read16(fp,lrOK);
                                        if not lrOK then goto 666;
          				tmp := lDicomData.XYZdim[2];
                  remaining := 0;
                 end;
          $11 :  begin info := 'Columns';
          				lDicomData.XYZdim[1] := read16(fp,lrOK);
                             if not lrOK then goto 666;
          				tmp := lDicomData.XYZdim[1];
                  remaining := 0;
                 end;
          $30 :  begin info := 'Pixel Spacing';
          readfloats (fp, remaining, TmpStr, lfloat1, lfloat2, lROK);
          if not lrOK then goto 666;
          //row spacing [y], then column spacing [x]: see part 3 of DICOM
          e_len := 0;      remaining := 0;
             lDICOMdata.XYZmm[2] := lfloat1;
             lDICOMdata.XYZmm[1] := lfloat2;
          end;
          $31: info := 'Zoom Factor';
          $32: info := 'Zoom Center';
          $34: begin info :='Pixel Aspect Ratio';t := _string; end;
          $40: info := 'Image Format [ret]';
          $50 :  info := 'Manipulated Image [ret]';
          $51: info := 'Corrected Image';
          $60: begin info := 'Compression Code [ret]';t := _string; end;
          $0100: begin info := 'Bits Allocated';
                 tmp := read16(fp,lrOK);
                            if not lrOK then goto 666;
                  if tmp = 8 then lDicomData.Allocbits_per_pixel := 8
                  else if tmp = 12 then lDicomData.Allocbits_per_pixel := 12
                  else if tmp = 16 then lDicomData.Allocbits_per_pixel := 16
                  else begin
                    if lImageFormatOK then
                       Showmessage('This software can only read 8, 12 and 16 bit DICOM files. This file allocates '+inttostr(tmp)+' bits per voxel.');
                      lImageFormatOK := false;
                  end;
                  remaining := 0;
                 end;
        	$0101: begin info := 'Bits Stored';
          				tmp := read16(fp,lrOK);
                             if not lrOK then goto 666;

                  if tmp <= 8 then lDicomData.Storedbits_per_pixel := 8
                  else if tmp <= 16 then lDicomData.Storedbits_per_pixel := 16
                  else begin
                    if lImageFormatOK then
                       Showmessage('This software can only read 8, 12 and 16 bit DICOM files. This file stores '+inttostr(tmp)+' bits per voxel.');
                    lDicomData.Storedbits_per_pixel := tmp;
                      lImageFormatOK := false;
                  end;
                  remaining := 0;
          			 end;
          $0102: begin info := 'High Bit';
          				tmp := read16(fp,lrOK);
                                        if not lrOK then
                                           goto 666;

                                 (*
                                 could be 11 for 12 bit cr images so just
                                 skip checking it
                                 assert(tmp == 7 || tmp == 15);
                                 *)
                  remaining := 0;
                 end;
          $0103: info := 'Pixel Representation';
          $0104: info := 'Smallest Valid Pixel Value';
          $0105: info := 'Largest Valid Pixel Value';
          $0106: info := 'Smallest Image Pixel Value';
          $0107: info := 'Largest Image Pixel Value';
          $120: info := 'Pixel Padding Value';
          $200: info := 'Image Location [ret]';
          $1040: begin t := _string; info := 'Pixel Intensity Relationship'; end;
          $1050: begin
              //t := _string;
              info := 'Window Center';
             readfloats (fp, remaining, TmpStr, lfloat1, lfloat2, lROK);
              if not lrOK then goto 666;
e_len := 0;      remaining := 0;
             lDICOMdata.WindowCenter := round(lfloat1);

              end;{float}
          $1051: begin info := 'Window Width';
          //t := _string;
             readfloats (fp, remaining, TmpStr, lfloat1, lfloat2, lROK);
              if not lrOK then goto 666;
e_len := 0;      remaining := 0;
             lDICOMdata.WindowWidth := round(lfloat1);
  end;
          $1052: begin t := _string;info :='Rescale Intercept'; end;  {float}
          $1053:begin t := _string; info :=  'Rescale Slope'; end; {float}
          $1054:begin t := _string; info := 'Rescale Type';end;
          $1100: info := 'Gray Lookup Table [ret]';
          $1101: begin  info := 'Red Palette Descriptor'; TmpStr := ReadStr(fp, remaining,lrOK);
                     if not lrOK then goto 666;
e_len := 0; remaining := 0; end;
          $1102: begin info := 'Green Palette Descriptor'; TmpStr := ReadStr(fp, remaining,lrOK);
                     if not lrOK then goto 666;
e_len := 0; remaining := 0; end;
          $1103: begin info := 'Blue Palette Descriptor'; TmpStr := ReadStr(fp, remaining,lrOK);
                     if not lrOK then goto 666;
e_len := 0; remaining := 0; end;
         $1199: info := 'Palette Color Lookup Table UID';
          $1200: info := 'Gray Lookup Data [ret]';
          $1201, $1202,$1203: begin
                 case element of
                      $1201: info := 'Red Table'; {future}
                      $1202: info := 'Green Table'; {future}
                      $1203: info := 'Blue Table'; {future}
                 end;

                 if FilePos(fp) > (filesz-remaining) then
                    goto 666;
                 if not lReadColorTables then begin
                    Seek(fp, FilePos(fp) + remaining);
                 end else begin {load color}
                   width := remaining div 2;
                   if width > 0 then begin
                     getmem(lWordRA,width*2);
                     for i := (width) downto 1 do
                         lWordRA[i] := read16(fp,lrOK);
                     value := lWordRA[1];
	                max16 := value;
  	                min16 := value;
                     for i := (width) downto 1 do begin
                         value := lWordRA[i];
			        if value < min16 then min16 := value;
  	                    if value > max16 then max16 := value;
                     end; //width..1
                     if max16 - min16 = 0 then
                        max16 := min16+1; {avoid divide by 0}
                     GetMem( lColorRA, width );(**)
                     for i := width downto 1 do
                         lColorRA[i] := (lWordRA[i] shr 8) {and 255};
                     FreeMem( lWordRA );
                     case element of
                          $1201: begin
                             red_table_size := width;
                             red_table   :=lColorRA;;
                          end;
                          $1202: begin
                             green_table_size := width;
                             green_table   :=lColorRA;;
                             end;
                          else {x$1203:} begin
                             blue_table_size := width;
                             blue_table   :=lColorRA;;
                          end; {else}
                     end; {case}
                   end; //width > 0;
                   if odd(remaining) then
                      Seek(fp, FilePos(fp) + 1{remaining});
                 end; {load color}
                 tmpstr := 'Custom';
                 remaining := 0;
                 e_len := 0; {show tempstr}
                 end;
     end;
     $54: case element of
          $0: info := 'Nuclear Acquisition Group Length';
          $11: info := 'Number of Energy Windows';
          $21: info := 'Number of Detectors';
          $51: info := 'Number of Rotations';
          $80: begin info :=  'Slice Vector'; TmpStr := ReadStr(fp, remaining,lrOK);           if not lrOK then goto 666;
 e_len := 0; remaining := 0; end;
          $81: info := 'Number of Slices';
          $202: info := 'Type of Detector Motion';
          $400: info := 'Image ID';

          end;
     $2010 :
        case element of
             $0: info := 'Film Box Group Length';
             $100: info := 'Border Density';
        end;
      $4000 : info := 'Text';
      $7FE0 :
        case element of
        	$00 :  begin
           info := 'Pixel Data Group Length'; if not lImageFormatOK then time_to_quit := TRUE; end;
          $10 :  begin info := 'Pixel Data'; time_to_quit := TRUE; lDicomData.ImageSz := e_len; TmpStr := inttostr(e_len);e_len := 0; end;
				end;
      else
      	begin
        	if (group >= $6000) AND (group <= $601e) AND ((group AND 1) = 0)
          	then  info := 'Overlay';
          if element = $0000 then info := 'Group Length';
          if element = $4000 then info := 'Comments';
				end;
    end;
lStr := '';
if (Time_TO_Quit) and (not lImageFormatOK) then begin
   lHdrOK := true; {header was OK}
   goto 666;
end;
    if (NOT time_to_quit) AND (e_len > 0) and (remaining > 0) then begin
     if (e_len + filepos(fp)) > FileSz then begin
        showmessage('Dicom format exceeds file size.');
        goto 666;
     end;
    	GetMem( buff, e_len);
			BlockRead(fp, buff^, e_len, n);
      case t of
       	unknown :
       		case e_len of
           	1 : lStr := ( IntToStr(Integer(buff[0])));
            2 : Begin
                 	if lDicomData.little_endian <> 0
                   	then i := Integer(buff[0]) + 256*Integer(buff[1])
                    else i := Integer(buff[0])*256 + Integer(buff[1]);
                  lStr :=( IntToStr(i));
		  					end;
            4 : Begin
                 	if lDicomData.little_endian <> 0
                   	then i :=               Integer(buff[0])
                              +         256*Integer(buff[1])
                              +     256*256*Integer(buff[2])
                              + 256*256*256*Integer(buff[3])
                    else i :=   Integer(buff[0])*256*256*256
                              + Integer(buff[1])*256*256
                              + Integer(buff[2])*256
                              + Integer(buff[3]);
                  lStr := (IntToStr(i));
                end;
						else
             		begin
									for i := 0 to e_len-1 do
                  begin
                   	if Char(buff[i]) in ['+','-','/','\',' ', '0'..'9','a'..'z','A'..'Z']
                     	then lStr := lStr+(Char(buff[i]))
                      else lStr := lStr+('.');
									end;
                end;
					end;

        i8, i16, i32, ui8, ui16, ui32,
        _string  : for i := 0 to e_len-1 do
                   	if Char(buff[i]) in ['+','-','/','\',' ', '0'..'9','a'..'z','A'..'Z']
                     	then lStr := lStr +(Char(buff[i]))
                      else lStr := lStr +('.');
      end;
      FreeMem(buff);
    end
    else if e_len > 0 then lStr := (IntToStr(tmp))
    else if e_len = 0 then begin
         lStr := TmpStr;
         TmpStr := '';
    end;
 if (lGrp{info = 'identifying group'{})  then if MessageDlg(lStr+'= '+info+' '+IntToHex(where,4)+': ('+IntToHex(group,4)+','+IntToHex(element,4)+')'+IntToStr(e_len)+'. Continue?',
    mtConfirmation, [mbYes, mbNo], 0) = mrNo then  GOTO 666;
// if info = 'UNKNOWN' then showmessage(IntToHex(group,4)+','+IntToHex(element,4));
    lDynStr := lDynStr +IntToHex(group,4)+','+IntToHex(element,4)+','{+inttostr(where)+': '+lGrpStr}+Info+': '+lStr+kCR ;
if length(lDynStr) > 30000 then begin
   showmessage('Unable to display the entire header.');
   goto 666;
end;
  end;	// end for
  lDicomData.ImageStart := filepos(fp);
  if lBigSet then begin
      if LBig then lDicomData.little_endian := 0
      else lDicomData.little_endian := 1;
  end;
  lHdrOK := true;
  666:
  if not lHdrOK then lImageFormatOK := false;
  CloseFile(fp);
  FileMode := 2; //set to read/write
end;


end.
